#include "JLX12864G.h"
#include "ASCII.h"

JLX12864G::JLX12864G(byte rst,byte cd,byte cs,byte sda,byte sck)
{
  _rst = rst;
  _cd = cd;
  _cs = cs;
  _sda = sda;
  _sck = sck;
  pinMode(rst,OUTPUT);
  pinMode(cd,OUTPUT);
  pinMode(cs,OUTPUT);
  pinMode(sda,OUTPUT);
  pinMode(sck,OUTPUT);
}

void JLX12864G::writeCommand(uint8_t command)
{
  digitalWrite(_cs,LOW);
  digitalWrite(_cd,LOW);
  for(uint8_t i=0;i<8;i++)
  {
    digitalWrite(_sck,LOW);
    digitalWrite(_sda,(command&0x80)?HIGH:LOW);
    digitalWrite(_sck,HIGH);
    command<<=1;
  }
}

void JLX12864G::writeData(uint8_t data)
{
  digitalWrite(_cs,LOW);
  digitalWrite(_cd,HIGH);
  for(uint8_t i=0;i<8;i++)
  {
    digitalWrite(_sck,LOW);
    digitalWrite(_sda,(data&0x80)?HIGH:LOW);
    digitalWrite(_sck,HIGH);
    data<<=1;
  }
}

void JLX12864G::init()
{
  digitalWrite(_cd,LOW);
  digitalWrite(_rst,LOW);
  delay(100);
  digitalWrite(_rst,HIGH);
  delay(20);
  writeCommand(0xe2);
  delay(5);
  writeCommand(0x2c);
  delay(5);
  writeCommand(0x2e);
  delay(5);
  writeCommand(0x2f);
  delay(5);
  writeCommand(0x23);
  writeCommand(0x81);
  writeCommand(0x28);
  writeCommand(0xa2);
  writeCommand(0xc8);
  writeCommand(0xa0);
  writeCommand(0x40);
  writeCommand(0xaf);
}

void JLX12864G::address(uint8_t page,uint8_t column)
{
  page-=1;
  column-=1;
  writeCommand(0xb0+page);
  writeCommand(((column>>4)&0x0f)+0x10);
  writeCommand(column&0x0f);
}

void JLX12864G::clear()
{
  for(uint8_t i=0;i<8;i++)
  {
    address(i+1,1);
    for(uint8_t j=0;j<128;j++)
      writeData(0x00);
  }
}

void JLX12864G::fullDisplay()
{
  for(uint8_t i=0;i<8;i++)
  {
    address(i+1,1);
    for(uint8_t j=0;j<128;j++)
      writeData(0xff);
  }
}

void JLX12864G::string_8x16(uint8_t page,uint8_t column,char *text)
{
  uint8_t i=0,j;
  while(text[i]>0x00)
  {
    if((text[i]>=0x20)&&(text[i]<=0x7e))
    {
      j = text[i]-0x20;
      for(uint8_t n=0;n<2;n++)
      {
        address(page+n,column);
        for(uint8_t k=0;k<8;k++)
          writeData((ASCII_8x16[j][k+8*n]));
      }
      i++;
      column+=8;
    }
    else
      i++;
  }
}

void JLX12864G::string_5x7(uint8_t page,uint8_t column,char *text)
{
  uint8_t i=0,j;
  while(text[i]>0x00)
  {
    if((text[i]>=0x20)&&(text[i]<0x7e))
    {
      j=text[i]-0x20;
      address(page,column);
      for(uint8_t k=0;k<5;k++)
        writeData(ASCII_5x7[j][k]);
      i++;
      column+=6;
    }
    else
      i++;
  }
}

void JLX12864G::graphic_32x32(uint8_t page,uint8_t column,char *dp,uint8_t length)
{
  for(uint8_t k=0;k<length;k++)
  {
    for(uint8_t j=0;j<4;j++)
    {
      address(page+j,column);
      for(uint8_t i=0;i<32;i++)
      {
        writeData(*dp);
        dp++;
      }
    }
    column+=32;
    if(column>=98)
    {
      page+=4;
      column = 1;
    }
  }
}


void JLX12864G::graphic_16x16(uint8_t page,uint8_t column,char *dp,uint8_t length)
{
  for(uint8_t k=0;k<length;k++)
  {
    for(uint8_t j=0;j<2;j++)
    {
      address(page+j,column);
      for(uint8_t i=0;i<16;i++)
      {
        writeData(*dp);
        dp++;
      }
    }
    column+=16;
    if(column>=114)
    {
      page+=2;
      column = 1;
    }
  }
}

void JLX12864G::graphic_8x16(uint8_t page,uint8_t column,char *dp,uint8_t length)
{
  for(uint8_t k=0;k<length;k++)
  {
    for(uint8_t j=0;j<2;j++)
    {
      address(page+j,column);
      for(uint8_t i=0;i<8;i++)
      {
        writeData(*dp);
        dp++;
      }
    }
    column+=8;
    if(column>=121)
    {
      page+=2;
      column = 1;
    }
  }
}

void JLX12864G::drawFullScreen(char *image)
{
  for(uint8_t pa=0;pa<8;pa++)
  {
    address(pa+1,1);
    for(uint16_t i=128*pa;i<128*(pa+1);i++)
    {
      writeData(*image);
      image++;
    }
  }
}
