#ifndef JLX12864G_H
#define JLX12864G_H

#if ARDUINO < 100
#include <WProgram.h>
#else
#include <Arduino.h>
#endif


class JLX12864G{
    byte _rst;
    byte _cd;
    byte _cs;
    byte _sda;
    byte _sck;
public:
    JLX12864G(byte rst,byte cd,byte cs,byte sda,byte sck);
    void writeCommand(uint8_t command);
    void writeData(uint8_t data);
    void init();
    void address(uint8_t page,uint8_t column);
    void clear();
    void fullDisplay();
    void string_8x16(uint8_t page,uint8_t column,char *text);
    void string_5x7(uint8_t page,uint8_t column,char *text);
    void graphic_32x32(uint8_t page,uint8_t column,char *dp,uint8_t length);
    void graphic_16x16(uint8_t page,uint8_t column,char *dp,uint8_t length);
    void graphic_8x16(uint8_t page,uint8_t column,char *dp,uint8_t length);
    void drawFullScreen(char *image);
};

#endif // JLX12864G_H
