function(input, output) {
  grades <- eventReactive(input$go, {
    read_csv(input$file$datapath)
  })
  
  output$grades <- DT::renderDataTable({
    grades()
  })
  
  output$variables <- renderUI({
    selectInput('variables', 'Select a Variable', choices = as.character(colnames(grades()[,2:dim(grades())[2]])), selected = 'continuousAssessment')
  })
  
  output$ifBins <- renderUI({
    var <- grades()[,input$variables]
    if(is.character(var[[1]])){
      return()
    }else{
      sliderInput("bins", "Bins",
                  min = 1, max = 130, value = 10)
    }
  })
  
  output$summaryGroup <- renderPrint({
    var <- grades()[,input$variables]
    if(is.character(var[[1]])){
      table(var)
    }else{
      summary(var)
    }
  })
  
  output$plotGroup <- renderPlot({
    var <- grades()[,input$variables]
    if(is.character(var[[1]])){
      barplot(table(var), col='grey50')
    }else{
      barplot(table(var), col='grey50')
      hist(var[[1]], col='grey50', breaks = input$bins)
    }
  })
  
  output$gradesIndividual <- DT::renderDataTable({
    DT::datatable(grades()[grades()[,1]==input$NIU,], options = list(dom = 't'))
  })
  
  output$ranking <- renderText({
    id <- which(grades()[,1] == input$NIU)
    var <- data.matrix(na.omit(grades()[,input$varIndividual]))
    
    p <- round(1-which(sort(var, decreasing = TRUE, index = TRUE)$ix == id)/length(var), digits=2)
    paste('Your are at the following percentile:', p, sep=' ')
  })
  
  output$plotIndividual <- renderPlot({
    var <- na.omit(grades()[,input$varIndividual])
    vioplot(var[[1]], col='grey50')
    if(!is.na(var[[1]][which(grades()[,1]==input$NIU)])){
      points(1, var[[1]][which(grades()[,1]==input$NIU)], col ='red', lwd = 4)
    }
    })
  
  linealModel <- reactive({
    FINAL <- data.matrix(grades()[,7])
    CONTINUOUS <- data.matrix(grades()[,5])
    lm( FINAL ~ CONTINUOUS)
    })
  
  output$summaryLM <- renderPrint({
    summary(linealModel())
  })
  
  output$plotLM <- renderPlot({
    FINAL <- data.matrix(grades()[,7])
    CONTINUOUS <- data.matrix(grades()[,5])
    
    prediction <- predict(linealModel(), data.frame(CONTINUOUS[which(data.matrix(grades()[,1]) == input$NIU)]))
    if(prediction[which(grades()[,1] == input$NIU)]<5){idcol <- 'red'}else{idcol <- 'green'}

    plot(CONTINUOUS, FINAL, ylab = 'Final Grade', xlab = 'Continuous Assessment')
    abline(linealModel())
    abline(h = 5, lty = 2)
    points(CONTINUOUS[which(data.matrix(grades()[,1])==input$NIU)], prediction[which(data.matrix(grades()[,1]) == input$NIU)], col=idcol , lwd=4)
  })
  
  output$plotComparison <- renderPlot({
    replicates <- input$realizations
    samplesize <- input$samplesize
    
    varClass <- na.omit(grades()[!is.na(grades()[,input$varInterest]),input$categorical])
    var <- data.matrix(na.omit(grades()[,input$varInterest]))
    classes <- unique(varClass)
    
    sampling <- matrix(NA, nrow=replicates, ncol=2)
    for(i in c(1:replicates)){
      sampling[i,1] <- mean(var[sample(which(varClass == classes[[1]][1]), samplesize, replace=TRUE)])
      sampling[i,2] <- mean(var[sample(which(varClass == classes[[1]][2]), samplesize, replace=TRUE)])
    }
    
    hist(sampling[,1], ylim=c(0,30), xlim=c(min(c(sampling))-2,max(c(sampling))+2), col='red', xlab = as.character(input$varInterest))
    hist(sampling[,2], col='blue', add = TRUE)
    abline(v = c(mean(sampling[,1])-2.26*sd(sampling[,1])/sqrt(samplesize),mean(sampling[,1])+2.26*sd(sampling[,1])/sqrt(samplesize)), col='red', lwd=3)
    abline(v = c(mean(sampling[,2])-2.26*sd(sampling[,2])/sqrt(samplesize),mean(sampling[,2])+2.26*sd(sampling[,2])/sqrt(samplesize)), col='blue', lwd=3)
    
  })

}
