fluidPage(
  navbarPage(
     theme = "cerulean", 
    "Statistics Grades 2018-2019",
    tabPanel("Group",
             sidebarPanel(
               fileInput('file', 'Choose .CSV', accept = "text/csv",  placeholder = "No file selected"),
               textInput("NIU", "NIU:", "100..."),
               actionButton("go", "Go!")
             ),
             mainPanel(
               tabsetPanel(
                 tabPanel("View",
                          DT::dataTableOutput('grades')
                 ),
                 tabPanel("Summary",
                          uiOutput('variables'),
                          uiOutput('ifBins'),
                          verbatimTextOutput('summaryGroup'),
                          plotOutput(outputId = "plotGroup")
                 )
               )
             )
    ),
    tabPanel("Individual", 
             verticalLayout(DT::dataTableOutput('gradesIndividual')),
             sidebarLayout(
               sidebarPanel(
                 selectInput('varIndividual', 'Select one:', choices =c('continuousAssessment', 'finalExam', 'finalGrade')),
                 textOutput('ranking')
               ),
               mainPanel(
                 plotOutput("plotIndividual")
               )
             )
             ),
    tabPanel("Final Grades Prediction",
             splitLayout(
               verbatimTextOutput('summaryLM'),
               plotOutput('plotLM')
             )
             ),
    tabPanel("Comparison", 
             sidebarPanel(
               radioButtons('varInterest', 'Analisys of:', choices =c('continuousAssessment', 'finalGrade'), selected = 'continuousAssessment'),
               radioButtons('categorical', 'By', choices =c('gender', 'highSchoolTrack'), selected = 'gender'),
               sliderInput('samplesize', 'Sample Size', min = 10, max = 50, value =30),
              numericInput('realizations', 'Number of Samples', value = 50)
             ),
             mainPanel(
               plotOutput('plotComparison')
             )
            )
  )
)
