/*
 * Decompiled with CFR 0.152.
 */
package contraband.clock;

import beast.base.core.Input;
import beast.base.evolution.branchratemodel.BranchRateModel;
import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.inference.CalculationNode;
import java.util.ArrayList;
import java.util.List;

public class TreeToVCVMat
extends CalculationNode {
    public final Input<BranchRateModel.Base> branchRateModelInput = new Input("branchRateModel", "the rate or optimum on each branch", Input.Validate.REQUIRED);
    public final Input<Tree> treeInput = new Input("tree", "Tree object containing tree.", Input.Validate.REQUIRED);
    public final Input<Boolean> coalCorrectionInput = new Input("coalCorrection", "Whether or not to do coalescent correction.", Input.Validate.REQUIRED);
    public final Input<Double> rootEdgeLengthInput = new Input("rootEdgeLength", "root edge length.", (Object)0.0);
    private boolean doCoalCorrection;
    BranchRateModel rccm;
    private int nSpp;
    private int nNodes;
    private double[][] spColorValuesMat;
    private double[] nodeWeightedColorValues;
    private List<Node> leftLeaves;
    private List<Node> rightLeaves;
    private String[] spNamesInASCIIBeticalOrTaxonSetOrder;
    private double rootEdgeVar;
    private double rootEdgeLength;
    double[][] storedSpColorValuesMat;

    public void initAndValidate() {
        Tree tree = (Tree)this.treeInput.get();
        this.doCoalCorrection = (Boolean)this.coalCorrectionInput.get();
        this.coalCorrection();
        this.nSpp = tree.getLeafNodeCount();
        this.nNodes = tree.getNodeCount();
        this.spNamesInASCIIBeticalOrTaxonSetOrder = new String[this.nSpp];
        this.nodeWeightedColorValues = new double[this.nNodes];
        this.spColorValuesMat = new double[this.nSpp][this.nSpp];
        this.leftLeaves = new ArrayList<Node>();
        this.rightLeaves = new ArrayList<Node>();
        this.storedSpColorValuesMat = new double[this.nSpp][this.nSpp];
    }

    private void readInputBeforeGetters() {
        this.coalCorrection();
    }

    private void coalCorrection() {
        if (this.doCoalCorrection) {
            this.rootEdgeLength = (Double)this.rootEdgeLengthInput.get();
            this.rootEdgeVar = ((BranchRateModel.Base)this.branchRateModelInput.get()).getRateForBranch(((Tree)this.treeInput.get()).getRoot()) * this.rootEdgeLength;
        }
    }

    private void populateColorValueMat() {
        Tree tree = (Tree)this.treeInput.get();
        this.fillNodeColorValuesOneTrait(tree.getRoot(), this.spNamesInASCIIBeticalOrTaxonSetOrder);
        if (this.rootEdgeVar != 0.0) {
            for (int i = 0; i < this.spColorValuesMat.length; ++i) {
                int n = 0;
                while (n < this.spColorValuesMat[i].length) {
                    double[] dArray = this.spColorValuesMat[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] + this.rootEdgeVar;
                }
            }
        }
    }

    private void fillNodeColorValuesOneTrait(Node node, String[] stringArray) {
        int n = node.getNr();
        if (node.isLeaf()) {
            this.spColorValuesMat[n][n] = this.nodeWeightedColorValues[n];
            stringArray[n] = node.getID();
            return;
        }
        if (node.isRoot()) {
            this.nodeWeightedColorValues[n] = 0.0;
        }
        Node node2 = node.getChild(0);
        int n2 = node2.getNr();
        double d = ((BranchRateModel.Base)this.branchRateModelInput.get()).getRateForBranch(node2);
        this.nodeWeightedColorValues[n2] = this.nodeWeightedColorValues[n] + node2.getLength() * d;
        Node node3 = node.getChild(1);
        int n3 = node3.getNr();
        double d2 = ((BranchRateModel.Base)this.branchRateModelInput.get()).getRateForBranch(node3);
        this.nodeWeightedColorValues[n3] = this.nodeWeightedColorValues[n] + node3.getLength() * d2;
        if (node2.getAllLeafNodes().size() == 0) {
            this.leftLeaves.clear();
            this.leftLeaves.add(node2);
        } else {
            this.leftLeaves = node2.getAllLeafNodes();
        }
        if (node3.getAllLeafNodes().size() == 0) {
            this.rightLeaves.clear();
            this.rightLeaves.add(node3);
        } else {
            this.rightLeaves = node3.getAllLeafNodes();
        }
        for (Node node4 : this.leftLeaves) {
            for (Node node5 : this.rightLeaves) {
                this.spColorValuesMat[node4.getNr()][node5.getNr()] = this.nodeWeightedColorValues[n];
                this.spColorValuesMat[node5.getNr()][node4.getNr()] = this.nodeWeightedColorValues[n];
            }
        }
        this.fillNodeColorValuesOneTrait(node2, stringArray);
        this.fillNodeColorValuesOneTrait(node3, stringArray);
    }

    public BranchRateModel getClockModel() {
        return (BranchRateModel)this.branchRateModelInput.get();
    }

    public double[][] getSpColorValuesMatOneTrait() {
        this.readInputBeforeGetters();
        this.populateColorValueMat();
        return this.spColorValuesMat;
    }

    public double getNodeColorValue(Node node, int n) {
        this.readInputBeforeGetters();
        return ((BranchRateModel.Base)this.branchRateModelInput.get()).getRateForBranch(node);
    }

    public String[] getSpNamesInVCVMatOrder() {
        this.populateColorValueMat();
        return this.spNamesInASCIIBeticalOrTaxonSetOrder;
    }

    protected boolean requiresRecalculation() {
        return true;
    }

    public void store() {
        for (int i = 0; i < this.spColorValuesMat.length; ++i) {
            for (int j = 0; j < this.spColorValuesMat[i].length; ++j) {
                this.storedSpColorValuesMat[i][j] = this.spColorValuesMat[i][j];
            }
        }
        super.store();
    }

    public void restore() {
        super.restore();
    }
}

