/*
 * Decompiled with CFR 0.152.
 */
package contraband.coalescent;

import org.apache.commons.math.util.MathUtils;
import org.apache.commons.math3.util.FastMath;

public class CoalUtils {
    public static double getFirstCoalExpTime(int n, double d) {
        return d / (double)MathUtils.binomialCoefficient((int)n, (int)2);
    }

    public static double getMeanRootHeight(int n, double d) {
        double d2 = 0.0;
        for (int i = 2; i < n + 1; ++i) {
            d2 += 2.0 * d / (double)(i * (i - 1));
        }
        return d2;
    }

    public static double getProbOfTwo2OneCondOnCoal(double d, double d2) {
        return 1.0 - (d / d2 / Math.exp(d / d2) - 1.0);
    }

    public static double[] foldDistOverNLineages(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n + n2];
        int n3 = 0;
        for (double d : dArray) {
            int n4 = 0;
            for (double d2 : dArray2) {
                dArray3[n3 + n4] = d * d2;
                ++n4;
            }
            ++n3;
        }
        return dArray3;
    }

    public static double getTavareGij(int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = n2; i <= n; ++i) {
            d2 += TavareStuff.insideSummation(d, i, n2, n);
        }
        return d2;
    }

    public static double getHeledGij(int n, int n2, double d, double d2) {
        double[] dArray = new double[n - n2 + 1];
        int n3 = 0;
        for (int i = n2; i < n + 1; ++i) {
            dArray[n3] = (double)i * ((double)i - 1.0) / 2.0;
            ++n3;
        }
        double[] dArray2 = new double[n - n2 + 1];
        dArray2[0] = 1.0;
        int n4 = 1;
        for (int i = 1; i < n - n2 + 1; ++i) {
            double d3 = dArray[i];
            for (int j = 0; j < n4; ++j) {
                int n5 = j;
                dArray2[n5] = dArray2[n5] * (d3 / (d3 - dArray[j]));
            }
            double d4 = 0.0;
            for (double d5 : dArray2) {
                d4 += d5;
            }
            dArray2[n4] = -d4;
            ++n4;
        }
        double d6 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d6 += dArray2[i] * FastMath.exp((double)(-dArray[i] / d2 * d));
        }
        return d6;
    }

    private static class TavareStuff {
        private TavareStuff() {
        }

        private static double geomProgParen(int n, int n2) {
            if (n2 == 0) {
                return 1.0;
            }
            int n3 = 0;
            double d = 1.0;
            while (n + n3 <= n + n2 - 1) {
                d *= (double)(n + n3);
                ++n3;
            }
            return d;
        }

        private static double geomProgBracket(int n, int n2) {
            if (n2 == 0) {
                return 1.0;
            }
            int n3 = 0;
            double d = 1.0;
            while (n - n3 >= n - n2 + 1) {
                d *= (double)(n - n3);
                ++n3;
            }
            return d;
        }

        private static double insideSummation(double d, int n, int n2, int n3) {
            double d2 = Math.exp((double)(-n * (n - 1)) * (d / 2.0)) * ((double)(2 * n - 1) * Math.pow(-1.0, n - n2) * TavareStuff.geomProgParen(n2, n - 1) * TavareStuff.geomProgBracket(n3, n)) / ((double)MathUtils.factorial((int)n2) * ((double)MathUtils.factorial((int)(n - n2)) * TavareStuff.geomProgParen(n3, n)));
            return d2;
        }
    }
}

