/*
 * Decompiled with CFR 0.152.
 */
package contraband.loggers;

import beast.base.core.BEASTObject;
import beast.base.core.Description;
import beast.base.core.Function;
import beast.base.core.Input;
import beast.base.core.Loggable;
import beast.base.evolution.branchratemodel.BranchRateModel;
import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.inference.StateNode;
import beast.base.inference.parameter.Parameter;
import beast.base.inference.parameter.RealParameter;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Description(value="Logs tree annotated with metadata and/or rates")
public class RateAndShiftLogger
extends BEASTObject
implements Loggable {
    public final Input<Tree> treeInput = new Input("tree", "tree to be logged", Input.Validate.REQUIRED);
    public final Input<List<Function>> parameterInput = new Input("metadata", "meta data to be logged with the tree nodes", new ArrayList());
    public final Input<BranchRateModel.Base> clockModelInput = new Input("branchratemodel", "rate to be logged with branches of the tree");
    public final Input<Boolean> substitutionsInput = new Input("substitutions", "report branch lengths as substitutions (branch length times clock rate for the branch)", (Object)false);
    public final Input<Integer> decimalPlacesInput = new Input("dp", "the number of decimal places to use writing branch lengths, rates and real-valued metadata, use -1 for full precision (default = full precision)", (Object)-1);
    boolean someMetaDataNeedsLogging;
    boolean substitutions = false;
    private DecimalFormat df;

    public void initAndValidate() {
        int n = (Integer)this.decimalPlacesInput.get();
        if (n < 0) {
            this.df = null;
        } else {
            this.df = new DecimalFormat("#." + new String(new char[n]).replace('\u0000', '#'));
            this.df.setRoundingMode(RoundingMode.HALF_UP);
        }
        if (((List)this.parameterInput.get()).size() == 0 && this.clockModelInput.get() == null) {
            this.someMetaDataNeedsLogging = false;
            return;
        }
        this.someMetaDataNeedsLogging = true;
        if (this.clockModelInput.get() != null) {
            this.substitutions = (Boolean)this.substitutionsInput.get();
        }
    }

    public void init(PrintStream printStream) {
        ((Tree)this.treeInput.get()).init(printStream);
    }

    public void log(long l, PrintStream printStream) {
        Tree tree = (Tree)((Tree)this.treeInput.get()).getCurrent();
        List list = (List)this.parameterInput.get();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof StateNode)) continue;
            list.set(i, ((StateNode)list.get(i)).getCurrent());
        }
        BranchRateModel.Base base = (BranchRateModel.Base)this.clockModelInput.get();
        printStream.print("tree STATE_" + l + " = ");
        tree.getRoot().sort();
        printStream.print(this.toNewick(tree.getRoot(), list, base));
        printStream.print(";");
    }

    private void appendDouble(StringBuffer stringBuffer, double d) {
        if (this.df == null) {
            stringBuffer.append(d);
        } else {
            stringBuffer.append(this.df.format(d));
        }
    }

    String toNewick(Node node, List<Function> list, BranchRateModel.Base base) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node.getLeft() != null) {
            stringBuffer.append("(");
            stringBuffer.append(this.toNewick(node.getLeft(), list, base));
            if (node.getRight() != null) {
                stringBuffer.append(',');
                stringBuffer.append(this.toNewick(node.getRight(), list, base));
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(node.getNr() + 1);
        }
        if (this.someMetaDataNeedsLogging) {
            stringBuffer.append("[&");
            if (list.size() > 0) {
                for (Function function : list) {
                    stringBuffer.append(((BEASTObject)function).getID());
                    stringBuffer.append('=');
                    if (function instanceof Parameter) {
                        Parameter parameter = (Parameter)function;
                        int n = parameter.getMinorDimension1();
                        if (n > 1) {
                            stringBuffer.append('{');
                            for (int i = 0; i < n; ++i) {
                                if (function instanceof RealParameter) {
                                    RealParameter realParameter = (RealParameter)function;
                                    this.appendDouble(stringBuffer, (Double)realParameter.getMatrixValue(node.getNr(), i));
                                } else {
                                    stringBuffer.append(parameter.getMatrixValue(node.getNr(), i));
                                }
                                if (i >= n - 1) continue;
                                stringBuffer.append(',');
                            }
                            stringBuffer.append('}');
                        } else if (function instanceof RealParameter) {
                            RealParameter realParameter = (RealParameter)function;
                            this.appendDouble(stringBuffer, realParameter.getArrayValue(node.getNr()));
                        } else if (node.getNr() == ((Tree)this.treeInput.get()).getNodeCount() - 1) {
                            stringBuffer.append(0.0);
                        } else {
                            stringBuffer.append(function.getArrayValue(node.getNr()));
                        }
                    } else {
                        stringBuffer.append(function.getArrayValue(node.getNr()));
                    }
                    if (list.indexOf(function) >= list.size() - 1) continue;
                    stringBuffer.append(",");
                }
                if (base != null) {
                    stringBuffer.append(",");
                }
            }
            if (base != null) {
                stringBuffer.append("rate=");
                this.appendDouble(stringBuffer, base.getRateForBranch(node));
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(":");
        if (this.substitutions) {
            this.appendDouble(stringBuffer, node.getLength() * base.getRateForBranch(node));
        } else {
            this.appendDouble(stringBuffer, node.getLength());
        }
        return stringBuffer.toString();
    }

    public void close(PrintStream printStream) {
        ((Tree)this.treeInput.get()).close(printStream);
    }
}

