/*
 * Decompiled with CFR 0.152.
 */
package contraband.math;

import contraband.math.FastMathLiteralArrays;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;

public class FastMath {
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    static final int EXP_INT_TABLE_MAX_INDEX = 750;
    static final int EXP_INT_TABLE_LEN = 1500;
    static final int LN_MANT_LEN = 1024;
    static final int EXP_FRAC_TABLE_LEN = 1025;
    private static final double LOG_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
    private static final boolean RECOMPUTE_TABLES_AT_RUNTIME = false;
    private static final double LN_2_A = 0.6931470632553101;
    private static final double LN_2_B = 1.1730463525082348E-7;
    private static final double[][] LN_QUICK_COEF = new double[][]{{1.0, 5.669184079525E-24}, {-0.25, -0.25}, {0.3333333134651184, 1.986821492305628E-8}, {-0.25, -6.663542893624021E-14}, {0.19999998807907104, 1.1921056801463227E-8}, {-0.1666666567325592, -7.800414592973399E-9}, {0.1428571343421936, 5.650007086920087E-9}, {-0.1250253f, -7.44321345601866E-11}, {0.11113807559013367, 9.219544613762692E-9}};
    private static final double[][] LN_HI_PREC_COEF = new double[][]{{1.0, -6.032174644509064E-23}, {-0.25, -0.25}, {0.3333333134651184, 1.9868161777724352E-8}, {-0.2499999701976776, -2.957007209750105E-8}, {0.19999954104423523, 1.5830993332061267E-10}, {-0.1662488f, -2.6033824355191673E-8}};
    private static final int SINE_TABLE_LEN = 14;
    private static final double[] SINE_TABLE_A = new double[]{0.0, 0.1246747374534607, 0.24740394949913025, 0.366272509098053, 0.4794255495071411, 0.5850973129272461, 0.6816387176513672, 0.7675435543060303, 0.8414709568023682, 0.902267575263977, 0.9489846229553223, 0.980893f, 0.9974949359893799, 0.9985313415527344};
    private static final double[] SINE_TABLE_B = new double[]{0.0, -4.068233003401932E-9, 9.755392680573412E-9, 1.9987994582857286E-8, -1.0902938113007961E-8, -3.9986783938944604E-8, 4.23719669792332E-8, -5.207000323380292E-8, 2.800552834259E-8, 1.883511811213715E-8, -3.5997360512765566E-9, 4.116164446561962E-8, 5.0614674548127384E-8, -1.0129027912496858E-9};
    private static final double[] COSINE_TABLE_A = new double[]{1.0, 0.9921976327896118, 0.9689123630523682, 0.9305076599121094, 0.8775825500488281, 0.8109631538391113, 0.7316888570785522, 0.6409968137741089, 0.5403022766113281, 0.4311765432357788, 0.3153223395347595, 0.19454771280288696, 0.0707372f, -0.05417713522911072};
    private static final double[] COSINE_TABLE_B = new double[]{0.0, 3.4439717236742845E-8, 5.865827662008209E-8, -3.7999795083850525E-8, 1.184154459111628E-8, -3.43338934259355E-8, 1.1795268640216787E-8, 4.438921624363781E-8, 2.925681159240093E-8, -2.6437112632041807E-8, 2.2860509143963117E-8, -4.813899778443457E-9, 3.6725170580355583E-9, 2.0217439756338078E-10};
    private static final double[] TANGENT_TABLE_A = new double[]{0.0, 0.1256551444530487, 0.25534194707870483, 0.3936265707015991, 0.5463024377822876, 0.7214844226837158, 0.9315965175628662, 1.1974215507507324, 1.5574076175689697, 2.092571258544922, 3.0095696449279785, 5.041914939880371, 14.101419448852539, -18.430862426757812};
    private static final double[] TANGENT_TABLE_B = new double[]{0.0, -7.877917738262007E-9, -2.5857668567479893E-8, 5.2240336371356666E-9, 5.206150291559893E-8, 1.8307188599677033E-8, -5.7618793749770706E-8, 7.848361555046424E-8, 1.0708593250394448E-7, 1.7827257129423813E-8, 2.893485277253286E-8, 3.1660099222737955E-7, 4.983191803254889E-7, -3.356118100840571E-7};
    private static final long[] RECIP_2PI = new long[]{2935890503282001226L, 9154082963658192752L, 3952090531849364496L, 9193070505571053912L, 7910884519577875640L, 113236205062349959L, 4577762542105553359L, -5034868814120038111L, 4208363204685324176L, 5648769086999809661L, 2819561105158720014L, -4035746434778044925L, -302932621132653753L, -2644281811660520851L, -3183605296591799669L, 6722166367014452318L, -3512299194304650054L, -7278142539171889152L};
    private static final long[] PI_O_4_BITS = new long[]{-3958705157555305932L, -4267615245585081135L};
    private static final double[] EIGHTHS = new double[]{0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0, 1.125, 1.25, 1.375, 1.5, 1.625};
    private static final double[] CBRTTWO = new double[]{0.6299605249474366, 0.7937005259840998, 1.0, 1.2599210498948732, 1.5874010519681994};
    private static final long HEX_40000000 = 0x40000000L;
    private static final long MASK_30BITS = -1073741824L;
    private static final int MASK_NON_SIGN_INT = Integer.MAX_VALUE;
    private static final long MASK_NON_SIGN_LONG = Long.MAX_VALUE;
    private static final long MASK_DOUBLE_EXPONENT = 0x7FF0000000000000L;
    private static final long MASK_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    private static final long IMPLICIT_HIGH_BIT = 0x10000000000000L;
    private static final double TWO_POWER_52 = 4.503599627370496E15;
    private static final double F_1_3 = 0.3333333333333333;
    private static final double F_1_5 = 0.2;
    private static final double F_1_7 = 0.14285714285714285;
    private static final double F_1_9 = 0.1111111111111111;
    private static final double F_1_11 = 0.09090909090909091;
    private static final double F_1_13 = 0.07692307692307693;
    private static final double F_1_15 = 0.06666666666666667;
    private static final double F_1_17 = 0.058823529411764705;
    private static final double F_3_4 = 0.75;
    private static final double F_15_16 = 0.9375;
    private static final double F_13_14 = 0.9285714285714286;
    private static final double F_11_12 = 0.9166666666666666;
    private static final double F_9_10 = 0.9;
    private static final double F_7_8 = 0.875;
    private static final double F_5_6 = 0.8333333333333334;
    private static final double F_1_2 = 0.5;
    private static final double F_1_4 = 0.25;

    private FastMath() {
    }

    public static double exp(double d) {
        int n = (int)d;
        if (d < 0.0) {
            if (d < -746.0) {
                return 0.0;
            }
            if (n < -709) {
                return FastMath.exp(d + 40.19140625) / 2.8504009514401178E17;
            }
            if (n == -709) {
                return FastMath.exp(d + 1.494140625) / 4.455505956692757;
            }
            --n;
        } else if (n > 709) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = ExpIntTable.EXP_INT_TABLE_A[750 + n];
        double d3 = ExpIntTable.EXP_INT_TABLE_B[750 + n];
        int n2 = (int)((d - (double)n) * 1024.0);
        double d4 = ExpFracTable.EXP_FRAC_TABLE_A[n2];
        double d5 = ExpFracTable.EXP_FRAC_TABLE_B[n2];
        double d6 = d - ((double)n + (double)n2 / 1024.0);
        double d7 = 0.04168701738764507;
        d7 = d7 * d6 + 0.1666666505023083;
        d7 = d7 * d6 + 0.5000000000042687;
        d7 = d7 * d6 + 1.0;
        d7 = d7 * d6 + -3.940510424527919E-20;
        double d8 = d2 * d4;
        double d9 = d2 * d5 + d3 * d4 + d3 * d5;
        double d10 = d9 + d8;
        if (d10 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        double d11 = d10 * d7 + d9 + d8;
        return d11;
    }

    public static double IEEEremainder(double d, double d2) {
        return StrictMath.IEEEremainder(d, d2);
    }

    public static int toIntExact(long l) throws MathArithmeticException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return (int)l;
    }

    public static int incrementExact(int n) throws MathArithmeticException {
        if (n == Integer.MAX_VALUE) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_ADDITION, new Object[]{n, 1});
        }
        return n + 1;
    }

    public static long incrementExact(long l) throws MathArithmeticException {
        if (l == Long.MAX_VALUE) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_ADDITION, new Object[]{l, 1});
        }
        return l + 1L;
    }

    public static int decrementExact(int n) throws MathArithmeticException {
        if (n == Integer.MIN_VALUE) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_SUBTRACTION, new Object[]{n, 1});
        }
        return n - 1;
    }

    public static long decrementExact(long l) throws MathArithmeticException {
        if (l == Long.MIN_VALUE) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_SUBTRACTION, new Object[]{l, 1});
        }
        return l - 1L;
    }

    public static int addExact(int n, int n2) throws MathArithmeticException {
        int n3 = n + n2;
        if ((n ^ n2) >= 0 && (n3 ^ n2) < 0) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_ADDITION, new Object[]{n, n2});
        }
        return n3;
    }

    public static long addExact(long l, long l2) throws MathArithmeticException {
        long l3 = l + l2;
        if ((l ^ l2) >= 0L && (l3 ^ l2) < 0L) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_ADDITION, new Object[]{l, l2});
        }
        return l3;
    }

    public static int subtractExact(int n, int n2) {
        int n3 = n - n2;
        if ((n ^ n2) < 0 && (n3 ^ n2) >= 0) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_SUBTRACTION, new Object[]{n, n2});
        }
        return n3;
    }

    public static long subtractExact(long l, long l2) {
        long l3 = l - l2;
        if ((l ^ l2) < 0L && (l3 ^ l2) >= 0L) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.OVERFLOW_IN_SUBTRACTION, new Object[]{l, l2});
        }
        return l3;
    }

    public static int floorDiv(int n, int n2) throws MathArithmeticException {
        if (n2 == 0) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        int n3 = n % n2;
        if ((n ^ n2) >= 0 || n3 == 0) {
            return n / n2;
        }
        return n / n2 - 1;
    }

    public static long floorDiv(long l, long l2) throws MathArithmeticException {
        if (l2 == 0L) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        long l3 = l % l2;
        if ((l ^ l2) >= 0L || l3 == 0L) {
            return l / l2;
        }
        return l / l2 - 1L;
    }

    public static int floorMod(int n, int n2) throws MathArithmeticException {
        if (n2 == 0) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        int n3 = n % n2;
        if ((n ^ n2) >= 0 || n3 == 0) {
            return n3;
        }
        return n2 + n3;
    }

    public static long floorMod(long l, long l2) {
        if (l2 == 0L) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        long l3 = l % l2;
        if ((l ^ l2) >= 0L || l3 == 0L) {
            return l3;
        }
        return l2 + l3;
    }

    public static double copySign(double d, double d2) {
        long l;
        long l2 = Double.doubleToRawLongBits(d);
        if ((l2 ^ (l = Double.doubleToRawLongBits(d2))) >= 0L) {
            return d;
        }
        return -d;
    }

    public static float copySign(float f, float f2) {
        int n;
        int n2 = Float.floatToRawIntBits(f);
        if ((n2 ^ (n = Float.floatToRawIntBits(f2))) >= 0) {
            return f;
        }
        return -f;
    }

    public static int getExponent(double d) {
        return (int)(Double.doubleToRawLongBits(d) >>> 52 & 0x7FFL) - 1023;
    }

    public static int getExponent(float f) {
        return (Float.floatToRawIntBits(f) >>> 23 & 0xFF) - 127;
    }

    private static class ExpIntTable {
        private static final double[] EXP_INT_TABLE_A = FastMathLiteralArrays.loadExpIntA();
        private static final double[] EXP_INT_TABLE_B = FastMathLiteralArrays.loadExpIntB();

        private ExpIntTable() {
        }
    }

    private static class ExpFracTable {
        private static final double[] EXP_FRAC_TABLE_A = FastMathLiteralArrays.loadExpFracA();
        private static final double[] EXP_FRAC_TABLE_B = FastMathLiteralArrays.loadExpFracB();

        private ExpFracTable() {
        }
    }

    private static class CodyWaite {
        private final int finalK;
        private final double finalRemA;
        private final double finalRemB;

        CodyWaite(double d) {
            double d2;
            double d3;
            int n = (int)(d * 0.6366197723675814);
            while (true) {
                double d4 = (double)(-n) * 1.570796251296997;
                d3 = d + d4;
                d2 = -(d3 - d - d4);
                d4 = (double)(-n) * 7.549789948768648E-8;
                double d5 = d3;
                d3 = d4 + d5;
                d2 += -(d3 - d5 - d4);
                d4 = (double)(-n) * 6.123233995736766E-17;
                d5 = d3;
                d3 = d4 + d5;
                d2 += -(d3 - d5 - d4);
                if (d3 > 0.0) break;
                --n;
            }
            this.finalK = n;
            this.finalRemA = d3;
            this.finalRemB = d2;
        }

        int getK() {
            return this.finalK;
        }

        double getRemA() {
            return this.finalRemA;
        }

        double getRemB() {
            return this.finalRemB;
        }
    }

    private static class lnMant {
        private static final double[][] LN_MANT = FastMathLiteralArrays.loadLnMant();

        private lnMant() {
        }
    }
}

