/*
 * Decompiled with CFR 0.152.
 */
package contraband.math;

import contraband.math.MatrixUtilsContra;
import org.apache.commons.math3.util.FastMath;

public class LUDecompositionForArray {
    private static final double DEFAULT_TOO_SMALL = 1.0E-11;

    public static void ArrayLUDecomposition(double[] dArray, double[] dArray2, int[] nArray, boolean[] blArray, int n) {
        int n2;
        System.arraycopy(dArray, 0, dArray2, 0, n * n);
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n2;
        }
        blArray[0] = true;
        blArray[1] = false;
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            int n4;
            double d;
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                d = MatrixUtilsContra.getMatrixEntry(dArray2, n5, n2, n);
                for (n4 = 0; n4 < n5; ++n4) {
                    d -= MatrixUtilsContra.getMatrixEntry(dArray2, n5, n4, n) * MatrixUtilsContra.getMatrixEntry(dArray2, n4, n2, n);
                }
                MatrixUtilsContra.setMatrixEntry(dArray2, n5, n2, d, n);
            }
            n5 = n2;
            d = Double.NEGATIVE_INFINITY;
            for (n4 = n2; n4 < n; ++n4) {
                double d2 = MatrixUtilsContra.getMatrixEntry(dArray2, n4, n2, n);
                for (int i = 0; i < n2; ++i) {
                    d2 -= MatrixUtilsContra.getMatrixEntry(dArray2, n4, i, n) * MatrixUtilsContra.getMatrixEntry(dArray2, i, n2, n);
                }
                MatrixUtilsContra.setMatrixEntry(dArray2, n4, n2, d2, n);
                if (!(FastMath.abs((double)d2) > d)) continue;
                d = FastMath.abs((double)d2);
                n5 = n4;
            }
            if (FastMath.abs((double)MatrixUtilsContra.getMatrixEntry(dArray2, n5, n2, n)) < 1.0E-11) {
                blArray[1] = true;
            }
            if (n5 != n2) {
                double d3 = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = MatrixUtilsContra.getMatrixEntry(dArray2, n5, n3, n);
                    MatrixUtilsContra.setMatrixEntry(dArray2, n5, n3, MatrixUtilsContra.getMatrixEntry(dArray2, n2, n3, n), n);
                    MatrixUtilsContra.setMatrixEntry(dArray2, n2, n3, d3, n);
                }
                n3 = nArray[n5];
                nArray[n5] = nArray[n2];
                nArray[n2] = n3;
                blArray[0] = !blArray[0];
            }
            double d4 = MatrixUtilsContra.getMatrixEntry(dArray2, n2, n2, n);
            for (n3 = n2 + 1; n3 < n; ++n3) {
                MatrixUtilsContra.setMatrixEntry(dArray2, n3, n2, MatrixUtilsContra.getMatrixEntry(dArray2, n3, n2, n) / d4, n);
            }
        }
    }

    public static double getDeterminant(double[] dArray, int n, boolean[] blArray) {
        boolean bl = blArray[0];
        boolean bl2 = blArray[1];
        if (bl2) {
            return 0.0;
        }
        double d = bl ? 1.0 : -1.0;
        for (int i = 0; i < n; ++i) {
            d *= MatrixUtilsContra.getMatrixEntry(dArray, i, i, n);
        }
        return d;
    }

    public static void populateInverseMatrix(double[] dArray, int[] nArray, double[] dArray2, boolean bl, int n, double[] dArray3) {
        double d;
        int n2;
        int n3;
        if (bl) {
            throw new RuntimeException("Singular matrix!");
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            for (int i = 0; i < n; ++i) {
                MatrixUtilsContra.setMatrixEntry(dArray3, n3, i, MatrixUtilsContra.getMatrixEntry(dArray2, n2, i, n), n);
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                double d2 = MatrixUtilsContra.getMatrixEntry(dArray, n2, n3, n);
                for (int i = 0; i < n; ++i) {
                    double d3 = MatrixUtilsContra.getMatrixEntry(dArray3, n2, i, n);
                    d = MatrixUtilsContra.getMatrixEntry(dArray3, n3, i, n);
                    MatrixUtilsContra.setMatrixEntry(dArray3, n2, i, d3 - d * d2, n);
                }
            }
        }
        for (n3 = n - 1; n3 >= 0; --n3) {
            double d4;
            int n4;
            double d5 = MatrixUtilsContra.getMatrixEntry(dArray, n3, n3, n);
            for (n4 = 0; n4 < n; ++n4) {
                d4 = MatrixUtilsContra.getMatrixEntry(dArray3, n3, n4, n);
                MatrixUtilsContra.setMatrixEntry(dArray3, n3, n4, d4 / d5, n);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                d4 = MatrixUtilsContra.getMatrixEntry(dArray, n4, n3, n);
                for (int i = 0; i < n; ++i) {
                    d = MatrixUtilsContra.getMatrixEntry(dArray3, n4, i, n);
                    double d6 = MatrixUtilsContra.getMatrixEntry(dArray3, n3, i, n);
                    MatrixUtilsContra.setMatrixEntry(dArray3, n4, i, d - d6 * d4, n);
                }
            }
        }
    }
}

