/*
 * Decompiled with CFR 0.152.
 */
package contraband.math;

import beast.base.core.Input;
import beast.base.core.Log;
import beast.base.evolution.tree.Tree;
import beast.base.inference.CalculationNode;
import beast.base.inference.parameter.RealParameter;
import beast.base.inference.util.InputUtil;
import contraband.math.LUDecompositionForArray;
import contraband.math.MatrixUtilsContra;
import contraband.utils.NodeMathUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.util.FastMath;

public class NodeMath
extends CalculationNode {
    public final Input<RealParameter> traitsValuesInput = new Input("traits", "Trait values at tips.", Input.Validate.REQUIRED);
    public final Input<RealParameter> sigmasqInput = new Input("sigmasq", "Evolutionary rates of traits. Diagonal elements in rate matrix.", Input.Validate.REQUIRED);
    public final Input<RealParameter> rhoInput = new Input("correlation", "Correlations of traits. Off-diagonal elements in rate matrix.");
    public final Input<Boolean> oneRateOnlyInput = new Input("oneRateOnly", "TRUE, if all traits share one evolutionary rate.", (Object)false);
    public final Input<Boolean> useUpperMatrixInput = new Input("upperMatrix", "TRUE, if sigmasq and correlations are from upper matrix", (Object)false);
    public final Input<RealParameter> rootValuesInput = new Input("rootValues", "Trait values at the root.");
    public final Input<Boolean> useShrinkageInput = new Input("shrinkage", "TRUE, if shrinkage method is used to estimate the trait correlations.", (Object)false);
    public final Input<RealParameter> covarianceInput = new Input("covariance", "cov_ij = sigma_i * sigma_j * rho_ij.");
    public final Input<Tree> treeInput = new Input("tree", "Tree object containing tree.");
    private Integer nTraits;
    private Integer nSpecies;
    private Boolean oneRateOnly;
    private Boolean useUpperMatrix;
    private Boolean sampleRoot;
    private Boolean coEstimate;
    private int nodeNr;
    private int vecArrayDim;
    private int matDim;
    private double sigmaValue;
    private double[] sigmaValues;
    private double[] rhoValues;
    private double[] lu;
    private int[] pivot;
    private boolean[] evensingular;
    private double[] identityMatrix;
    private boolean singularMatrix;
    private double[] aArray;
    private double[] cArray;
    private double[] eArray;
    private double[] fArray;
    private double[] lArray;
    private double[] mVecArray;
    private double[] rArray;
    private double[] traitRateMatrix;
    private double detTraitRateMat;
    private double[] invTraitRateMatrix;
    private double detInvTraitRateMat;
    private double[] mVecInit;
    private double[] traitsVec;
    private double[] rateMatRow;
    private double[] upperMatrix;
    private double[] transUpperMatrix;
    private double[] mVec;
    private double[] rootValuesVec;
    private double likForSA;
    private double[] traitVecForSA;
    private double[] nodeVariance;
    private double[] nodeExpectation;
    private double[] expect1;
    private double[] expect2;
    private double[] expectp;
    private double storedDetTraitRateMat;
    private double[] storedInvTraitRateMatrix;
    private double storedDetInvTraitRateMat;
    private double[] storedRootValuesVec;
    private double storedSigmaValue;
    private double[] storedSigmaValues;
    private double[] storedRhoValues;
    private double[] storedTraitRateMatrix;
    private Boolean useShrinkage;
    private RealMatrix unbiasedRhoRM;
    private RealMatrix identityRM;
    private RealMatrix traitRateRM;
    private RealMatrix shrinkageRhoRM;
    private double detRhoMatrix;
    private double detInvRhoMatrix;
    private double[] transformedTraitValues;
    private double[] storedTransformedTraitValues;
    private boolean[] speciesToIgnoreMissingData;
    private int[] speciesToIgnoreIndex;
    private boolean[] nodeAsTip;

    public void initAndValidate() {
        RealParameter realParameter = (RealParameter)this.traitsValuesInput.get();
        this.nTraits = realParameter.getMinorDimension1();
        this.nSpecies = this.treeInput.get() != null ? Integer.valueOf(((Tree)this.treeInput.get()).getLeafNodeCount()) : Integer.valueOf(realParameter.getMinorDimension2());
        this.speciesToIgnoreMissingData = new boolean[2 * this.nSpecies - 1];
        this.speciesToIgnoreIndex = new int[2 * this.nSpecies - 1];
        this.nodeAsTip = new boolean[2 * this.nSpecies - 1];
        if (this.covarianceInput.get() == null) {
            this.coEstimate = false;
        } else {
            this.coEstimate = true;
            Log.info((String)"NodeMath::Variance-covariance parameterization is used.");
            if (((RealParameter)this.covarianceInput.get()).getDimension() != this.nTraits * (this.nTraits - 1) / 2) {
                Log.warning.println("NodeMath::Setting dimension of covariance to " + this.nTraits * (this.nTraits - 1) / 2);
                ((RealParameter)this.covarianceInput.get()).setDimension(this.nTraits * (this.nTraits - 1) / 2);
            }
            this.rhoValues = new double[this.nTraits * (this.nTraits - 1) / 2];
            this.storedRhoValues = new double[this.nTraits * (this.nTraits - 1) / 2];
            this.rhoValues = ((RealParameter)this.covarianceInput.get()).getDoubleValues();
        }
        this.identityRM = MatrixUtils.createRealIdentityMatrix((int)this.nTraits);
        this.traitRateRM = new Array2DRowRealMatrix(new double[this.nTraits.intValue()][this.nTraits.intValue()]);
        this.shrinkageRhoRM = new Array2DRowRealMatrix(new double[this.nTraits.intValue()][this.nTraits.intValue()]);
        this.transformedTraitValues = new double[this.nSpecies * this.nTraits];
        this.storedTransformedTraitValues = new double[this.nSpecies * this.nTraits];
        this.oneRateOnly = (Boolean)this.oneRateOnlyInput.get();
        this.useUpperMatrix = (Boolean)this.useUpperMatrixInput.get();
        this.nodeNr = 2 * this.nSpecies - 1;
        this.matDim = this.nTraits * this.nTraits;
        this.vecArrayDim = this.nTraits * this.nodeNr;
        this.initializeAbCdEfArray();
        this.initializeLmrArray();
        this.initializeTraitValueVec();
        this.traitRateMatrix = new double[this.matDim];
        this.invTraitRateMatrix = new double[this.matDim];
        this.storedTraitRateMatrix = new double[this.matDim];
        this.storedInvTraitRateMatrix = new double[this.matDim];
        this.rateMatRow = new double[this.nTraits.intValue()];
        if (this.useUpperMatrix.booleanValue()) {
            this.upperMatrix = new double[this.matDim];
            this.transUpperMatrix = new double[this.matDim];
        }
        this.nodeVariance = new double[this.nodeNr];
        this.nodeExpectation = new double[this.nTraits * this.nodeNr];
        this.expect1 = new double[this.nTraits.intValue()];
        this.expect2 = new double[this.nTraits.intValue()];
        this.expectp = new double[this.nTraits.intValue()];
        this.initializeLUDecomposition();
        this.likForSA = 0.0;
        this.traitVecForSA = new double[this.nTraits.intValue()];
        this.useShrinkage = (Boolean)this.useShrinkageInput.get();
        if (!this.useShrinkage.booleanValue() && !this.coEstimate.booleanValue()) {
            if (this.rhoInput.get() == null) {
                throw new RuntimeException("NodeMath::If shrinkage method is not used, either correlation or covariance is required.");
            }
            Log.warning.println("NodeMath::Setting dimension of rho values to " + this.nTraits * (this.nTraits - 1) / 2);
            ((RealParameter)this.rhoInput.get()).setDimension(this.nTraits * (this.nTraits - 1) / 2);
            this.rhoValues = new double[this.nTraits * (this.nTraits - 1) / 2];
            this.storedRhoValues = new double[this.nTraits * (this.nTraits - 1) / 2];
            this.rhoValues = ((RealParameter)this.rhoInput.get()).getDoubleValues();
        }
        if (this.oneRateOnly.booleanValue()) {
            Log.info.println("NodeMath::1 rate is assigned to " + this.nTraits + " traits.");
            ((RealParameter)this.sigmasqInput.get()).setDimension(1);
            this.sigmaValue = ((RealParameter)this.sigmasqInput.get()).getValue();
            this.populateTraitRateMatrixForOneRate();
        } else {
            Log.warning.println("NodeMath::Setting dimension of trait rate to " + this.nTraits + ".");
            ((RealParameter)this.sigmasqInput.get()).setDimension(this.nTraits.intValue());
            this.sigmaValues = new double[this.nTraits.intValue()];
            this.storedSigmaValues = new double[this.nTraits.intValue()];
            this.sigmaValues = ((RealParameter)this.sigmasqInput.get()).getDoubleValues();
            this.populateTraitRateMatrixForMultipleRates();
        }
        if (this.rootValuesInput.get() != null) {
            if (((RealParameter)this.rootValuesInput.get()).getDimension() != this.nTraits.intValue()) {
                Log.warning.println("NodeMath::Setting dimension of root values to " + this.nTraits);
                ((RealParameter)this.rootValuesInput.get()).setDimension(this.nTraits.intValue());
            }
            this.rootValuesVec = ((RealParameter)this.rootValuesInput.get()).getDoubleValues();
            this.sampleRoot = true;
        } else {
            Log.warning.println("NodeMath::Estimating root state by MLE.");
            this.sampleRoot = false;
        }
    }

    public void initializeNodeStatArrays() {
        this.speciesToIgnoreIndex = new int[2 * this.nSpecies - 1];
        this.nodeAsTip = new boolean[2 * this.nSpecies - 1];
        this.nodeVariance = new double[this.nodeNr];
        this.nodeExpectation = new double[this.nTraits * this.nodeNr];
    }

    public boolean isSingularMatrix() {
        return this.singularMatrix;
    }

    public double getAForNode(int n) {
        return this.aArray[n];
    }

    public double getCForNode(int n) {
        return this.cArray[n];
    }

    public double getEForNode(int n) {
        return this.eArray[n];
    }

    public double getfForNode(int n) {
        return this.fArray[n];
    }

    public double getLForNode(int n) {
        return this.lArray[n];
    }

    public double getRForNode(int n) {
        return this.rArray[n];
    }

    public double[] getMVecForNode(int n) {
        MatrixUtilsContra.getMatrixRow(this.mVecArray, n, this.nTraits, this.mVec);
        return this.mVec;
    }

    public double[] getTraitRateMatrix() {
        return this.traitRateMatrix;
    }

    public RealMatrix getTraitRateRealMatrix() {
        return this.traitRateRM;
    }

    public double getTraitRateMatrixDeterminant() {
        return this.detTraitRateMat;
    }

    public double[] getTraitRateMatrixInverse() {
        return this.invTraitRateMatrix;
    }

    public double getTraitRateMatrixInverseDeterminant() {
        return this.detInvTraitRateMat;
    }

    public double[] getRootValuesArr() {
        return this.rootValuesVec;
    }

    public double getLikelihoodForSampledAncestors() {
        return this.likForSA;
    }

    public double[] getTempVec() {
        return this.mVec;
    }

    public double[] getInitMVec() {
        return this.mVecInit;
    }

    public double[] getTraitsVec() {
        return this.traitsVec;
    }

    public double[] getSampledAncestorTraitsVec() {
        return this.traitVecForSA;
    }

    public double[] getRateMatrixRow() {
        return this.rateMatRow;
    }

    public double[] getTransformedTraitValues() {
        return this.transformedTraitValues;
    }

    public boolean useShrinkage() {
        return this.useShrinkage;
    }

    public RealMatrix getUnbiasedRho() {
        return this.unbiasedRhoRM;
    }

    public RealMatrix getShrinkageRho() {
        return this.shrinkageRhoRM;
    }

    public double getDetShrinkageRho() {
        return this.detRhoMatrix;
    }

    public double getDetInvShrinkageRho() {
        return this.detInvRhoMatrix;
    }

    public double getVarianceForNode(int n) {
        return this.nodeVariance[n];
    }

    public double[] getExpectationForNode(int n) {
        double[] dArray = new double[this.nTraits.intValue()];
        MatrixUtilsContra.getMatrixRow(this.nodeExpectation, n, this.nTraits, dArray);
        return dArray;
    }

    public boolean isSpeciesToIgnore(int n) {
        return this.speciesToIgnoreMissingData[n];
    }

    public int getSpeciesToIgnoreIndex(int n) {
        return this.speciesToIgnoreIndex[n];
    }

    public boolean hasMissingDataSpecies(int n) {
        return this.nodeAsTip[n];
    }

    public void setAForNode(int n, double d) {
        this.aArray[n] = d;
    }

    public void setCForNode(int n, double d) {
        this.cArray[n] = d;
    }

    public void setEForNode(int n, double d) {
        this.eArray[n] = d;
    }

    public void setfForNode(int n, double d) {
        this.fArray[n] = d;
    }

    public void setLForNode(int n, double d) {
        this.lArray[n] = d;
    }

    public void setRForNode(int n, double d) {
        this.rArray[n] = d;
    }

    public void setMVecForNode(int n, double[] dArray) {
        MatrixUtilsContra.setMatrixRow(this.mVecArray, dArray, n, this.nTraits);
    }

    public void setLikelihoodForSampledAncestors(double d) {
        this.likForSA = d;
    }

    public void setTraitsVecForTip(double[] dArray, int n) {
        MatrixUtilsContra.getMatrixRow(dArray, n, this.nTraits, this.traitsVec);
    }

    public void setTraitsVecForSampledAncestor(double[] dArray, int n) {
        MatrixUtilsContra.getMatrixRow(dArray, n, this.nTraits, this.traitVecForSA);
    }

    public void setExpectationForTip(int n) {
        MatrixUtilsContra.setMatrixRow(this.nodeExpectation, this.traitsVec, n, this.nTraits);
    }

    public void setExpectationForIntNode(int n, double[] dArray) {
        MatrixUtilsContra.setMatrixRow(this.nodeExpectation, dArray, n, this.nTraits);
    }

    public void setVarianceForTip(int n, double d) {
        this.nodeVariance[n] = d;
    }

    public void setVarianceForParent(int n, double d, int n2, int n3) {
        double d2 = this.nodeVariance[n2];
        double d3 = this.nodeVariance[n3];
        this.nodeVariance[n] = d + d2 * d3 / (d2 + d3);
    }

    public void setExpectationForParent(int n, int n2, int n3) {
        double d = this.nodeVariance[n2];
        double d2 = this.nodeVariance[n3];
        MatrixUtilsContra.getMatrixRow(this.nodeExpectation, n2, this.nTraits, this.expect1);
        MatrixUtilsContra.getMatrixRow(this.nodeExpectation, n3, this.nTraits, this.expect2);
        MatrixUtilsContra.vectorMapMultiply(this.expect1, d2 / (d + d2), this.expect1);
        MatrixUtilsContra.vectorMapMultiply(this.expect2, d / (d + d2), this.expect2);
        MatrixUtilsContra.vectorAdd(this.expect1, this.expect2, this.expectp);
        MatrixUtilsContra.setMatrixRow(this.nodeExpectation, this.expectp, n, this.nTraits);
    }

    public void setNTraits(int n) {
        this.nTraits = n;
    }

    public void setNSpecies(int n) {
        this.nSpecies = n;
    }

    public void setSpeciesToIgnore(int n) {
        this.speciesToIgnoreMissingData[n] = true;
    }

    public void setSpeciesToIgnoreIndex(int n, int n2) {
        this.speciesToIgnoreIndex[n] = n2;
    }

    public void setNodeHasMissingData(int n) {
        this.nodeAsTip[n] = true;
    }

    private void initializeAbCdEfArray() {
        this.aArray = new double[this.nodeNr];
        this.cArray = new double[this.nodeNr];
        this.eArray = new double[this.nodeNr];
        this.fArray = new double[this.nodeNr];
    }

    private void initializeLmrArray() {
        this.lArray = new double[this.nodeNr];
        this.mVecArray = new double[this.vecArrayDim];
        this.rArray = new double[this.nodeNr];
        this.mVec = new double[this.nTraits.intValue()];
        this.mVecInit = new double[this.nTraits.intValue()];
    }

    private void initializeTraitValueVec() {
        this.rootValuesVec = new double[this.nTraits.intValue()];
        this.storedRootValuesVec = new double[this.nTraits.intValue()];
        this.traitsVec = new double[this.nTraits.intValue()];
    }

    private void initializeLUDecomposition() {
        this.lu = new double[this.matDim];
        this.pivot = new int[this.nTraits.intValue()];
        this.evensingular = new boolean[2];
        this.identityMatrix = new double[this.matDim];
        for (int i = 0; i < this.nTraits; ++i) {
            MatrixUtilsContra.setMatrixEntry(this.identityMatrix, i, i, 1.0, this.nTraits);
        }
    }

    public void populateRootValuesVec(int n) {
        if (this.sampleRoot.booleanValue() && InputUtil.isDirty(this.rootValuesInput)) {
            this.rootValuesVec = ((RealParameter)this.rootValuesInput.get()).getDoubleValues();
        }
        if (!this.sampleRoot.booleanValue()) {
            MatrixUtilsContra.getMatrixRow(this.nodeExpectation, n, this.nTraits, this.rootValuesVec);
        }
    }

    public void performMatrixOperations() {
        this.operateOnTraitRateMatrix();
        this.operateOnInvTraitRateMatrix();
    }

    private void operateOnTraitRateMatrix() {
        this.singularMatrix = false;
        LUDecompositionForArray.ArrayLUDecomposition(this.traitRateMatrix, this.lu, this.pivot, this.evensingular, this.nTraits);
        try {
            LUDecompositionForArray.populateInverseMatrix(this.lu, this.pivot, this.identityMatrix, this.evensingular[1], this.nTraits, this.invTraitRateMatrix);
        }
        catch (RuntimeException runtimeException) {
            this.singularMatrix = true;
        }
        double d = LUDecompositionForArray.getDeterminant(this.lu, this.nTraits, this.evensingular);
        if (d == 0.0) {
            this.singularMatrix = true;
        }
        this.detTraitRateMat = FastMath.log((double)d);
    }

    private void operateOnInvTraitRateMatrix() {
        LUDecompositionForArray.ArrayLUDecomposition(this.invTraitRateMatrix, this.lu, this.pivot, this.evensingular, this.nTraits);
        this.detInvTraitRateMat = LUDecompositionForArray.getDeterminant(this.lu, this.nTraits, this.evensingular);
    }

    public void populateTraitRateMatrix() {
        if (this.oneRateOnly.booleanValue()) {
            this.populateTraitRateMatrixForOneRate();
        } else {
            this.populateTraitRateMatrixForMultipleRates();
        }
    }

    public void populateTraitRateMatrixForOneRate() {
        if (this.useShrinkage.booleanValue()) {
            this.traitRateRM = this.shrinkageRhoRM.scalarMultiply(this.sigmaValue);
        } else if (this.useUpperMatrix.booleanValue()) {
            NodeMathUtils.populateTraitRateMatrix(this.sigmaValue, this.rhoValues, this.upperMatrix, this.transUpperMatrix, this.nTraits, this.traitRateMatrix);
        } else {
            NodeMathUtils.populateTraitRateMatrixDirectly(this.sigmaValue, this.rhoValues, (int)this.nTraits, this.traitRateMatrix);
        }
    }

    public void populateTraitRateMatrixForMultipleRates() {
        if (this.useShrinkage.booleanValue()) {
            for (int i = 0; i < this.nTraits; ++i) {
                this.traitRateRM.setEntry(i, i, this.sigmaValues[i]);
                for (int j = i + 1; j < this.nTraits; ++j) {
                    double d = FastMath.sqrt((double)this.sigmaValues[i]) * FastMath.sqrt((double)this.sigmaValues[j]) * this.shrinkageRhoRM.getEntry(i, j);
                    this.traitRateRM.setEntry(i, j, d);
                }
            }
        } else if (this.useUpperMatrix.booleanValue()) {
            NodeMathUtils.populateTraitRateMatrix(this.sigmaValues, this.rhoValues, this.upperMatrix, this.transUpperMatrix, this.nTraits, this.traitRateMatrix, this.coEstimate);
        } else {
            NodeMathUtils.populateTraitRateMatrixDirectly(this.sigmaValues, this.rhoValues, (int)this.nTraits, this.traitRateMatrix);
        }
    }

    public boolean updateParameters() {
        boolean bl = false;
        boolean bl2 = false;
        if (InputUtil.isDirty(this.rhoInput)) {
            this.rhoValues = ((RealParameter)this.rhoInput.get()).getDoubleValues();
            bl = true;
        }
        if (InputUtil.isDirty(this.covarianceInput)) {
            this.rhoValues = ((RealParameter)this.covarianceInput.get()).getDoubleValues();
            bl = true;
        }
        if (InputUtil.isDirty(this.sigmasqInput)) {
            if (this.oneRateOnly.booleanValue()) {
                this.sigmaValue = ((RealParameter)this.sigmasqInput.get()).getValue();
            } else {
                this.sigmaValues = ((RealParameter)this.sigmasqInput.get()).getDoubleValues();
            }
            bl2 = true;
        }
        return bl || bl2;
    }

    public void estimateCorrelations(RealMatrix realMatrix) {
        PearsonsCorrelation pearsonsCorrelation = new PearsonsCorrelation(realMatrix);
        this.unbiasedRhoRM = pearsonsCorrelation.getCorrelationMatrix();
    }

    public void populateShrinkageEstimation(double d) {
        this.shrinkageRhoRM = this.identityRM.scalarMultiply(d).add(this.unbiasedRhoRM.scalarMultiply(1.0 - d));
        LUDecomposition lUDecomposition = new LUDecomposition(this.shrinkageRhoRM);
        RealMatrix realMatrix = lUDecomposition.getSolver().getInverse();
        this.detRhoMatrix = lUDecomposition.getDeterminant();
        LUDecomposition lUDecomposition2 = new LUDecomposition(realMatrix);
        this.detInvRhoMatrix = lUDecomposition2.getDeterminant();
    }

    public void populateInverseTraitRateMatrix() {
        double d = ((RealParameter)this.sigmasqInput.get()).getValue();
        this.detTraitRateMat = Math.log(this.detRhoMatrix) + (double)this.nTraits.intValue() * FastMath.log((double)d);
        this.detInvTraitRateMat = Math.log(this.detInvRhoMatrix) + (double)this.nTraits.intValue() * FastMath.log((double)(1.0 / d));
    }

    public void populateTransformedTraitValues(RealMatrix realMatrix) {
        CholeskyDecomposition choleskyDecomposition = new CholeskyDecomposition(this.traitRateRM);
        RealMatrix realMatrix2 = choleskyDecomposition.getLT();
        LUDecomposition lUDecomposition = new LUDecomposition(realMatrix2);
        RealMatrix realMatrix3 = lUDecomposition.getSolver().getInverse();
        RealMatrix realMatrix4 = realMatrix.multiply(realMatrix3);
        int n = 0;
        for (int i = 0; i < this.nSpecies; ++i) {
            if (this.speciesToIgnoreMissingData[i]) continue;
            System.arraycopy(realMatrix4.getRow(n), 0, this.transformedTraitValues, i * this.nTraits, this.nTraits);
            ++n;
        }
    }

    protected boolean requiresRecalculation() {
        return true;
    }

    public void store() {
        super.store();
        this.storedDetTraitRateMat = this.detTraitRateMat;
        this.storedDetInvTraitRateMat = this.detInvTraitRateMat;
        if (this.oneRateOnly.booleanValue()) {
            this.storedSigmaValue = this.sigmaValue;
        } else {
            System.arraycopy(this.sigmaValues, 0, this.storedSigmaValues, 0, this.nTraits);
        }
        if (!this.useShrinkage.booleanValue()) {
            System.arraycopy(this.rhoValues, 0, this.storedRhoValues, 0, this.nTraits * (this.nTraits - 1) / 2);
        }
        System.arraycopy(this.traitRateMatrix, 0, this.storedTraitRateMatrix, 0, this.matDim);
        System.arraycopy(this.invTraitRateMatrix, 0, this.storedInvTraitRateMatrix, 0, this.matDim);
        System.arraycopy(this.rootValuesVec, 0, this.storedRootValuesVec, 0, this.nTraits);
        System.arraycopy(this.transformedTraitValues, 0, this.storedTransformedTraitValues, 0, this.nSpecies * this.nTraits);
    }

    public void restore() {
        super.restore();
        double d = this.detTraitRateMat;
        this.detTraitRateMat = this.storedDetTraitRateMat;
        this.storedDetTraitRateMat = d;
        double d2 = this.detInvTraitRateMat;
        this.detInvTraitRateMat = this.storedDetInvTraitRateMat;
        this.storedDetInvTraitRateMat = d2;
        double[] dArray = this.traitRateMatrix;
        this.traitRateMatrix = this.storedTraitRateMatrix;
        this.storedTraitRateMatrix = dArray;
        double[] dArray2 = this.invTraitRateMatrix;
        this.invTraitRateMatrix = this.storedInvTraitRateMatrix;
        this.storedInvTraitRateMatrix = dArray2;
        double[] dArray3 = this.rootValuesVec;
        this.rootValuesVec = this.storedRootValuesVec;
        this.storedRootValuesVec = dArray3;
        if (this.oneRateOnly.booleanValue()) {
            double d3 = this.sigmaValue;
            this.sigmaValue = this.storedSigmaValue;
            this.storedSigmaValue = d3;
        } else {
            double[] dArray4 = this.sigmaValues;
            this.sigmaValues = this.storedSigmaValues;
            this.storedSigmaValues = dArray4;
        }
        double[] dArray5 = this.rhoValues;
        this.rhoValues = this.storedRhoValues;
        this.storedRhoValues = dArray5;
        double[] dArray6 = this.transformedTraitValues;
        this.transformedTraitValues = this.storedTransformedTraitValues;
        this.storedTransformedTraitValues = dArray6;
    }
}

