/*
 * Decompiled with CFR 0.152.
 */
package contraband.math;

import beast.base.core.BEASTObject;
import beast.base.core.Description;
import beast.base.core.Function;
import beast.base.core.Input;
import beast.base.core.Loggable;
import beast.base.inference.CalculationNode;
import beast.base.inference.parameter.RealParameter;
import java.io.PrintStream;

@Description(value="calculates sum of a valuable")
public class Square
extends CalculationNode
implements Function,
Loggable {
    public final Input<RealParameter> variableInput = new Input("arg", "argument to be summed", Input.Validate.REQUIRED);
    boolean needsRecompute = true;
    double square = 0.0;
    double storedSquare = 0.0;

    public void initAndValidate() {
        RealParameter realParameter = (RealParameter)this.variableInput.get();
    }

    public int getDimension() {
        return 1;
    }

    public double getArrayValue() {
        if (this.needsRecompute) {
            this.compute();
        }
        return this.square;
    }

    void compute() {
        this.square = ((RealParameter)this.variableInput.get()).getValue() * ((RealParameter)this.variableInput.get()).getValue();
        this.needsRecompute = false;
    }

    public double getArrayValue(int n) {
        if (n == 0) {
            return this.getArrayValue();
        }
        return Double.NaN;
    }

    public void store() {
        this.storedSquare = this.square;
        super.store();
    }

    public void restore() {
        this.square = this.storedSquare;
        super.restore();
    }

    public boolean requiresRecalculation() {
        this.needsRecompute = true;
        return true;
    }

    public void init(PrintStream printStream) {
        printStream.print("square(" + ((BEASTObject)this.variableInput.get()).getID() + ")\t");
    }

    public void log(long l, PrintStream printStream) {
        double d = ((RealParameter)this.variableInput.get()).getValue() * ((RealParameter)this.variableInput.get()).getValue();
        printStream.print(d + "\t");
    }

    public void close(PrintStream printStream) {
    }
}

