/*
 * Decompiled with CFR 0.152.
 */
package contraband.math;

import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.inference.distribution.ParametricDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math3.util.FastMath;

@Description(value="Uniform distribution over a given interval (including lower and upper values)")
public class UniformSoftBounds
extends ParametricDistribution {
    public final Input<Double> lowerInput = new Input("lower", "lower bound on the interval, default 0", (Object)0.0);
    public final Input<Double> upperInput = new Input("upper", "lower bound on the interval, default 1", (Object)1.0);
    UniformImpl distr = new UniformImpl();
    double _lower;
    double _upper;
    double density;
    private double theta1;
    private double theta2;
    private double constant1;
    private double constant2;
    private double constant3;
    private boolean infiniteSupport;

    public void initAndValidate() {
        this._lower = (Double)this.lowerInput.get();
        this._upper = (Double)this.upperInput.get();
        if (this._lower >= this._upper) {
            throw new IllegalArgumentException("Upper value should be higher than lower value");
        }
        double d = this._upper - this._lower;
        this.theta1 = 0.95 * this._lower / (0.025 * d);
        this.theta2 = 0.95 / (0.025 * d);
        this.constant1 = this.theta1 / this._lower;
        this.constant2 = this.theta1 - 1.0;
        this.constant3 = this.theta2 * this._upper;
        this.distr.setBounds(this._lower, this._upper);
        this.infiniteSupport = Double.isInfinite(this._lower) || Double.isInfinite(this._upper);
        this.density = this.infiniteSupport ? 1.0 : 0.95 / (this._upper - this._lower);
    }

    public Distribution getDistribution() {
        return this.distr;
    }

    public double density(double d) {
        return this.density;
    }

    class UniformImpl
    implements ContinuousDistribution {
        private double lower;
        private double upper;

        UniformImpl() {
        }

        public void setBounds(double d, double d2) {
            this.lower = d;
            this.upper = d2;
        }

        public double cumulativeProbability(double d) throws MathException {
            if (d <= this.lower) {
                return 0.025 * UniformSoftBounds.this.constant1 * Math.pow(1.0 / this.lower, UniformSoftBounds.this.theta1 - 1.0) * Math.pow(d, UniformSoftBounds.this.theta1) / UniformSoftBounds.this.theta1;
            }
            if (d > this.upper) {
                return -0.025 * UniformSoftBounds.this.theta2 * Math.exp(-UniformSoftBounds.this.theta2 * d + UniformSoftBounds.this.constant3);
            }
            return (0.95 * d - this.lower) / (this.upper - this.lower);
        }

        public double cumulativeProbability(double d, double d2) throws MathException {
            d = Math.max(d, this.lower);
            if ((d2 = Math.min(d2, this.upper)) < this.lower || d2 > this.upper) {
                throw new RuntimeException("Value x (" + d2 + ") out of bounds (" + this.lower + "," + this.upper + ").");
            }
            return (d2 - d) / (this.upper - this.lower);
        }

        public double inverseCumulativeProbability(double d) throws MathException {
            if (d < 0.0 || d > 1.0) {
                throw new RuntimeException("inverseCumulativeProbability::argument out of range [0...1]");
            }
            if (d == 0.0) {
                return UniformSoftBounds.this._lower;
            }
            if (d == 1.0) {
                return UniformSoftBounds.this._upper;
            }
            if (UniformSoftBounds.this.infiniteSupport) {
                throw new RuntimeException("Inverse Cumulative Probability for 0 < p < 1 and infinite support");
            }
            return (this.upper - this.lower) * d + this.lower;
        }

        public double density(double d) {
            if (d <= this.lower) {
                return 0.025 * UniformSoftBounds.this.constant1 * FastMath.pow((double)(d / this.lower), (double)UniformSoftBounds.this.constant2);
            }
            if (d > this.upper) {
                return 0.025 * UniformSoftBounds.this.theta2 * FastMath.exp((double)(-UniformSoftBounds.this.theta2 * d + UniformSoftBounds.this.constant3));
            }
            return 0.95 / (this.upper - this.lower);
        }

        public double logDensity(double d) {
            return Math.log(this.density(d));
        }
    }
}

