/*
 * Decompiled with CFR 0.152.
 */
package contraband.mvnlikelihood;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.inference.State;
import beast.base.inference.parameter.RealParameter;
import beast.base.inference.util.InputUtil;
import contraband.mvnlikelihood.MVNProcessOneTrait;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

@Description(value="Brownian motion model (matrix algebra implementation) for analyses of continuous trait evolution.")
@Citation(value="Felsenstein, J (1985). Maximum-likelihood estimation of evolutionary trees from continuous characters. Am. J. Hum. Genet. 25, 471-492.", DOI="PMCID: PMC1762641", year=1985, firstAuthorSurname="Felsenstein")
public class BMMVNLikelihoodOneTrait
extends MVNProcessOneTrait {
    public final Input<RealParameter> sigmasqInput = new Input("sigmaSq", "Sigma^2, the variance of the process.", Input.Validate.REQUIRED);
    public final Input<RealParameter> rootValueInput = new Input("rootValue", "rootValue, or y_0, the root value and the expected value at the tips.", Input.Validate.REQUIRED);
    public final Input<RealParameter> oneTraitInput = new Input("oneTraitData", "continuous data values for one trait.", Input.Validate.REQUIRED);
    private boolean dirty;
    private int nSpp;
    private RealVector bmExpAtTipVector;
    private RealVector bmWVector;
    private RealMatrix bmVCVMat;
    private RealMatrix bmInvVCVMat;
    private RealMatrix bmAncNodeVCVMat;
    private LUDecomposition bmVCVMatLUDec;
    private RealVector oneTraitDataVec;
    private RealVector storedExpAtTipVec;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.nSpp = this.getNSpp();
        this.bmExpAtTipVector = new ArrayRealVector(this.nSpp);
        this.bmWVector = new ArrayRealVector(this.nSpp);
        this.oneTraitDataVec = new ArrayRealVector(this.nSpp);
        this.storedExpAtTipVec = new ArrayRealVector(this.nSpp);
        this.populateInstanceVars(true, true, true, false, true);
        this.populateParentInstanceVars(true, true, false);
    }

    protected void populateInstanceVars(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl) {
            super.populatePhyloTMatrix();
        }
        if (bl3) {
            this.populateExpAtTipVector();
        }
        if (bl2) {
            this.populateVCVMatrix();
            this.populateInvVCVMatrix();
        }
        if (bl5) {
            this.populateOneTraitDataVector();
        }
        if (bl4) {
            super.populateAncNodePhyloTMatrix();
            this.populateAncNodeVCVMatrix();
        }
    }

    protected void populateParentInstanceVars(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.setProcessMeanVec(this.bmExpAtTipVector);
        }
        if (bl) {
            this.setProcessLUDec(this.bmVCVMatLUDec);
            this.setProcessInvVCVMat(this.bmInvVCVMat);
        }
        this.setProcessOneTraitDataVec(this.oneTraitDataVec);
        if (bl3) {
            this.setProcessAncNodeVCVMatrix(this.bmAncNodeVCVMat);
        }
    }

    @Override
    protected void populateExpAtTipVector() {
        Double d = ((RealParameter)this.rootValueInput.get()).getValue();
        this.bmExpAtTipVector.set(d.doubleValue());
    }

    @Override
    protected void populateVCVMatrix() {
        Double d = ((RealParameter)this.sigmasqInput.get()).getValue();
        this.bmVCVMat = this.getPhyloTMat().scalarMultiply(d.doubleValue());
    }

    @Override
    protected void populateInvVCVMatrix() {
        this.bmVCVMatLUDec = new LUDecomposition(this.bmVCVMat);
        try {
            this.bmInvVCVMat = this.bmVCVMatLUDec.getSolver().getInverse();
            this.setMatrixIsSingular(false);
        }
        catch (SingularMatrixException singularMatrixException) {
            this.setMatrixIsSingular(true);
        }
    }

    @Override
    protected void populateOneTraitDataVector() {
        String[] stringArray = this.getSpNamesInPhyloTMatOrder();
        RealParameter realParameter = (RealParameter)this.oneTraitInput.get();
        int n = 0;
        for (String string : stringArray) {
            this.oneTraitDataVec.setEntry(n, ((Double)realParameter.getValue(string)).doubleValue());
            ++n;
        }
    }

    @Override
    protected void populateWMatrix() {
        this.bmWVector.set(1.0);
    }

    @Override
    protected void populateAncNodeVCVMatrix() {
    }

    public double calculateLogP() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (InputUtil.isDirty((Input)this.treeInput) || ((Boolean)this.doCoalCorrectionInput.get()).booleanValue() && InputUtil.isDirty((Input)this.coalCorrectionInput)) {
            bl = true;
            bl2 = true;
        }
        if (InputUtil.isDirty(this.sigmasqInput)) {
            bl2 = true;
        }
        if (InputUtil.isDirty(this.rootValueInput)) {
            bl3 = true;
        }
        if (InputUtil.isDirty(this.oneTraitInput)) {
            bl4 = true;
        }
        this.populateInstanceVars(bl, bl2, bl3, bl5, bl4);
        this.populateParentInstanceVars(bl2, bl3, bl5);
        super.populateLogP();
        return this.getLogP();
    }

    @Override
    public boolean requiresRecalculation() {
        this.dirty = true;
        return this.dirty;
    }

    @Override
    public void store() {
        for (int i = 0; i < this.nSpp; ++i) {
            this.storedExpAtTipVec.setEntry(i, this.bmExpAtTipVector.getEntry(i));
        }
        super.store();
    }

    @Override
    public void restore() {
        RealVector realVector = this.bmExpAtTipVector;
        this.bmExpAtTipVector = this.storedExpAtTipVec;
        this.storedExpAtTipVec = realVector;
        super.restore();
    }

    public List<String> getArguments() {
        return null;
    }

    public List<String> getConditions() {
        return null;
    }

    public void sample(State state, Random random) {
    }
}

