/*
 * Decompiled with CFR 0.152.
 */
package contraband.mvnlikelihood;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.inference.parameter.RealParameter;
import beast.base.inference.util.InputUtil;
import contraband.clock.TreeToVCVMat;
import contraband.mvnlikelihood.MVNShiftProcessOneTrait;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

@Description(value="Brownian motion model (matrix algebra implementation) for analyses of continuous trait evolution. Rates are allowed to shift.")
@Citation(value="O'Meara B, et al. (2006). Testing for different rates of continuous trait evolution using likelihood. Evolution 60(4), 922-933.", DOI="10.1111/j.0014-3820.2006.tb01171.x", year=2006, firstAuthorSurname="O'Meara")
public class BMMVNShiftLikelihoodOneTrait
extends MVNShiftProcessOneTrait {
    public final Input<RealParameter> rootValueInput = new Input("rootValue", "rootValue, or y_0, the root value and the expected value at the tips.", Input.Validate.REQUIRED);
    public final Input<TreeToVCVMat> rateManagerInput = new Input("rateManager", "color manager object that paints branches with their own rates.", Input.Validate.REQUIRED);
    public final Input<RealParameter> oneTraitInput = new Input("oneTraitData", "continuous data values for one trait.", Input.Validate.REQUIRED);
    private boolean dirty;
    private int nSpp;
    private RealVector bmExpAtTipVec;
    private TreeToVCVMat rateManager;
    private RealMatrix bmVCVMat;
    private RealMatrix bmInvVCVMat;
    private LUDecomposition bmVCVMatLUD;
    private RealVector oneTraitDataVec;
    private RealVector storedExpAtTipVec;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.nSpp = this.getNSpp();
        this.bmExpAtTipVec = new ArrayRealVector(this.nSpp);
        this.oneTraitDataVec = new ArrayRealVector(this.nSpp);
        this.bmVCVMat = MatrixUtils.createRealMatrix((int)this.nSpp, (int)this.nSpp);
        this.rateManager = (TreeToVCVMat)((Object)this.rateManagerInput.get());
        this.storedExpAtTipVec = new ArrayRealVector(this.nSpp);
        this.populateInstanceVars(true, true, true);
        this.populateParentInstanceVars(true, true);
    }

    protected void populateInstanceVars(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.populateExpAtTipVector();
        }
        if (bl) {
            this.populateVCVMatrix();
            this.populateInvVCVMatrix();
        }
        if (bl3) {
            this.populateOneTraitDataVector();
        }
    }

    protected void populateParentInstanceVars(boolean bl, boolean bl2) {
        if (bl2) {
            this.setProcessMeanVec(this.bmExpAtTipVec);
        }
        if (bl) {
            this.setProcessVCVMat(this.bmVCVMat);
            this.setProcessInvVCVMat(this.bmInvVCVMat);
        }
        this.setProcessOneTraitDataVec(this.oneTraitDataVec);
    }

    @Override
    protected void populateExpAtTipVector() {
        Double d = ((RealParameter)this.rootValueInput.get()).getValue();
        this.bmExpAtTipVec.set(d.doubleValue());
    }

    @Override
    protected void populateVCVMatrix() {
        double[][] dArray = this.rateManager.getSpColorValuesMatOneTrait();
        for (int i = 0; i < this.nSpp; ++i) {
            for (int j = 0; j < this.nSpp; ++j) {
                this.bmVCVMat.setEntry(i, j, dArray[i][j]);
            }
        }
    }

    @Override
    protected void populateInvVCVMatrix() {
        this.bmVCVMatLUD = new LUDecomposition(this.bmVCVMat);
        try {
            this.bmInvVCVMat = this.bmVCVMatLUD.getSolver().getInverse();
            this.setMatrixIsSingular(false);
        }
        catch (SingularMatrixException singularMatrixException) {
            this.setMatrixIsSingular(true);
        }
    }

    @Override
    protected void populateOneTraitDataVector() {
        this.rateManager = (TreeToVCVMat)((Object)this.rateManagerInput.get());
        String[] stringArray = this.rateManager.getSpNamesInVCVMatOrder();
        RealParameter realParameter = (RealParameter)this.oneTraitInput.get();
        int n = 0;
        for (String string : stringArray) {
            this.oneTraitDataVec.setEntry(n, ((Double)realParameter.getValue(string)).doubleValue());
            ++n;
        }
    }

    public double calculateLogP() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (InputUtil.isDirty((Input)this.treeInput) || InputUtil.isDirty(this.rateManagerInput)) {
            bl = true;
        }
        if (InputUtil.isDirty(this.rootValueInput)) {
            bl2 = true;
        }
        if (InputUtil.isDirty(this.oneTraitInput)) {
            bl3 = true;
        }
        this.populateInstanceVars(bl, bl2, bl3);
        this.populateParentInstanceVars(bl, bl2);
        super.populateLogP();
        return this.getLogP();
    }

    @Override
    public void store() {
        for (int i = 0; i < this.nSpp; ++i) {
            this.storedExpAtTipVec.setEntry(i, this.bmExpAtTipVec.getEntry(i));
        }
        super.store();
    }

    @Override
    public void restore() {
        RealVector realVector = this.bmExpAtTipVec;
        this.bmExpAtTipVec = this.storedExpAtTipVec;
        this.storedExpAtTipVec = realVector;
        super.restore();
    }

    @Override
    public boolean requiresRecalculation() {
        this.dirty = true;
        return this.dirty;
    }
}

