/*
 * Decompiled with CFR 0.152.
 */
package contraband.mvnlikelihood;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.inference.Distribution;
import beast.base.inference.State;
import beast.base.inference.util.InputUtil;
import contraband.utils.MVNUtils;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

@Description(value="Matrix algebra engine for continuous trait evolutionary models,  with rates allowed to shift. Used by Brownian motion classes.")
@Citation(value="O'Meara B, et al. (2006). Testing for different rates of continuous trait evolution using likelihood. Evolution 60(4), 922-933.", DOI="10.1111/j.0014-3820.2006.tb01171.x", year=2006, firstAuthorSurname="O'Meara")
public class MVNShiftProcessOneTrait
extends Distribution {
    public final Input<Tree> treeInput = new Input("tree", "Tree object containing tree.", Input.Validate.REQUIRED);
    private boolean dirty;
    private boolean matrixWasSingularCantInvertBarf;
    private int nSpp;
    private RealVector expAtTipVec;
    private RealMatrix vcvMat;
    private RealMatrix invVCVMat;
    private LUDecomposition vcvMatLUDecomposition;
    private double detVCVMat;
    private RealVector oneTraitDataVec;
    private RealVector storedExpAtTipVec;
    private RealMatrix storedInvVCVMat;
    private double storedDetVCVMat;

    public void initAndValidate() {
        Tree tree = (Tree)this.treeInput.get();
        this.nSpp = tree.getLeafNodeCount();
        this.storedExpAtTipVec = new ArrayRealVector(this.nSpp);
        this.storedInvVCVMat = MatrixUtils.createRealMatrix((int)this.nSpp, (int)this.nSpp);
    }

    protected void populateExpAtTipVector() {
    }

    protected void populateVCVMatrix() {
    }

    protected void populateInvVCVMatrix() {
    }

    protected void populateOneTraitDataVector() {
    }

    protected void populateLogP() {
        this.logP = this.matrixWasSingularCantInvertBarf || this.detVCVMat == 0.0 ? Double.NEGATIVE_INFINITY : MVNUtils.getMVNLogLk(this.nSpp, this.expAtTipVec, this.oneTraitDataVec, this.invVCVMat, this.detVCVMat);
    }

    protected Tree getTree() {
        return (Tree)this.treeInput.get();
    }

    protected int getNSpp() {
        return this.nSpp;
    }

    protected Node getRootNode() {
        Tree tree = (Tree)this.treeInput.get();
        return tree.getRoot();
    }

    protected double getLogP() {
        return this.logP;
    }

    protected void setProcessVCVMat(RealMatrix realMatrix) {
        this.vcvMat = realMatrix;
        this.vcvMatLUDecomposition = new LUDecomposition(this.vcvMat);
        this.detVCVMat = this.vcvMatLUDecomposition.getDeterminant();
        if (Double.isInfinite(this.detVCVMat)) {
            this.matrixWasSingularCantInvertBarf = true;
        }
    }

    protected void setProcessInvVCVMat(RealMatrix realMatrix) {
        this.invVCVMat = realMatrix;
    }

    protected void setProcessMeanVec(RealVector realVector) {
        this.expAtTipVec = realVector;
    }

    protected void setProcessOneTraitDataVec(RealVector realVector) {
        this.oneTraitDataVec = realVector;
    }

    protected void setMatrixIsSingular(boolean bl) {
        this.matrixWasSingularCantInvertBarf = bl;
    }

    public boolean requiresRecalculation() {
        this.dirty = false;
        if (InputUtil.isDirty(this.treeInput)) {
            this.dirty = true;
        }
        return this.dirty;
    }

    public void store() {
        for (int i = 0; i < this.nSpp; ++i) {
            this.storedExpAtTipVec.setEntry(i, this.expAtTipVec.getEntry(i));
            for (int j = 0; j < this.nSpp; ++j) {
                this.storedInvVCVMat.setEntry(i, j, this.invVCVMat.getEntry(i, j));
            }
        }
        this.storedDetVCVMat = this.detVCVMat;
    }

    public void restore() {
        RealVector realVector = this.expAtTipVec;
        this.expAtTipVec = this.storedExpAtTipVec;
        this.storedExpAtTipVec = realVector;
        RealMatrix realMatrix = this.invVCVMat;
        this.invVCVMat = this.storedInvVCVMat;
        this.storedInvVCVMat = realMatrix;
        this.detVCVMat = this.storedDetVCVMat;
    }

    public List<String> getArguments() {
        return null;
    }

    public List<String> getConditions() {
        return null;
    }

    public void sample(State state, Random random) {
    }
}

