/*
 * Decompiled with CFR 0.152.
 */
package contraband.mvnlikelihood;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.inference.State;
import beast.base.inference.parameter.RealParameter;
import beast.base.inference.util.InputUtil;
import contraband.clock.TreeToVCVMat;
import contraband.mvnlikelihood.MVNProcessOneTrait;
import contraband.utils.OUUtils;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

@Description(value="Ornstein-Uhlenbeck model (matrix algebra implementation) for analyses of continuous trait evolution. Adaptive optima are allowed to shift.")
@Citation(value="Hansen, TF (1997). Stabilizing selection and the comparative analysis of adaptation. Evolution 51(5), 1341-1351.", DOI=" 10.1111/j.1558-5646.1997.tb01457.x", year=1997, firstAuthorSurname="Hansen")
public class OUMVNLikelihoodOneTrait
extends MVNProcessOneTrait {
    public final Input<RealParameter> sigmasqInput = new Input("sigmaSq", "Sigma^2, the variance of the process.", Input.Validate.REQUIRED);
    public final Input<RealParameter> rootValueInput = new Input("rootValue", "Root trait value, or y_0, also the mean of the stationary distribution at the root if one is assumed.", Input.Validate.REQUIRED);
    public final Input<Boolean> eqDistInput = new Input("eqDist", "Whether or not to assume equilibrium (stationary) distribution at the root. The mean of that distribution will rootValue", Input.Validate.REQUIRED);
    public final Input<Boolean> useRootMetaDataInput = new Input("useRootMetaData", "Whether or not to use root meta data (specified optimum). If set to 'false', root optimum is set to eldest regime (regimes are numbered from the root toward the tips).", Input.Validate.REQUIRED);
    public final Input<TreeToVCVMat> optimumManagerInput = new Input("optimumManager", "color manager object that paints branches with their own optima.", Input.Validate.REQUIRED);
    public final Input<RealParameter> alphaInput = new Input("alpha", "Pull toward optimum or optima.", Input.Validate.REQUIRED);
    public final Input<RealParameter> oneTraitInput = new Input("oneTraitData", "continuous data values for one trait.", Input.Validate.REQUIRED);
    private boolean dirty;
    private boolean eqDistAtRoot;
    private boolean useRootMetaData;
    private int nSpp;
    private int nOptima;
    private TreeToVCVMat optimumManager;
    private RealVector ouMeanVec;
    private RealMatrix ouTMat;
    private RealMatrix ouVCVMat;
    private RealMatrix ouInvVCVMat;
    private LUDecomposition ouVCVMatLUD;
    private RealVector oneTraitDataVec;
    private RealMatrix storedVCVMat;
    private RealVector storedOUMeanVec;
    private RealVector storedOneTraitDataVec;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.nSpp = this.getNSpp();
        this.eqDistAtRoot = (Boolean)this.eqDistInput.get();
        this.useRootMetaData = (Boolean)this.useRootMetaDataInput.get();
        this.optimumManager = (TreeToVCVMat)((Object)this.optimumManagerInput.get());
        this.oneTraitDataVec = new ArrayRealVector(this.nSpp);
        this.ouMeanVec = new ArrayRealVector(this.nSpp);
        this.ouTMat = new Array2DRowRealMatrix(this.nSpp, this.nSpp);
        this.storedOneTraitDataVec = new ArrayRealVector(this.nSpp);
        this.storedVCVMat = MatrixUtils.createRealMatrix((int)this.nSpp, (int)this.nSpp);
        this.storedOUMeanVec = new ArrayRealVector(this.nSpp);
        this.populateInstanceVars(true, true, true, true);
        this.populateParentInstanceVars(true, true, true);
    }

    private void populateInstanceVars(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl3) {
            this.populateExpAtTipVector();
        }
        if (bl) {
            super.populatePhyloTMatrix();
        }
        if (bl2) {
            this.populateVCVMatrix();
            this.populateInvVCVMatrix();
        }
        if (bl4) {
            this.populateOneTraitDataVector();
        }
    }

    private void populateParentInstanceVars(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.setProcessMeanVec(this.ouMeanVec);
        }
        if (bl) {
            this.setProcessLUDec(this.ouVCVMatLUD);
            this.setProcessInvVCVMat(this.ouInvVCVMat);
        }
        if (bl3) {
            this.setProcessOneTraitDataVec(this.oneTraitDataVec);
        }
    }

    private void populateOUTMatrix(boolean bl) {
        double d = ((RealParameter)this.alphaInput.get()).getValue();
        OUUtils.computeOUTMatOneTrait(this.nSpp, d, this.getPhyloTMatDouble(), this.ouTMat, bl);
    }

    @Override
    protected void populateExpAtTipVector() {
        Double d = ((RealParameter)this.rootValueInput.get()).getValue();
        double d2 = ((RealParameter)this.alphaInput.get()).getValue();
        OUUtils.populateOUMeanVector(d2, d, this.getRootNode(), this.getAllLeafNodes(), this.optimumManager.getClockModel(), this.ouMeanVec, this.useRootMetaData);
    }

    @Override
    protected void populateVCVMatrix() {
        this.populateOUTMatrix(this.eqDistAtRoot);
        Double d = ((RealParameter)this.sigmasqInput.get()).getValue();
        this.ouVCVMat = this.ouTMat.scalarMultiply(d.doubleValue());
    }

    @Override
    protected void populateInvVCVMatrix() {
        this.ouVCVMatLUD = new LUDecomposition(this.ouVCVMat);
        try {
            this.ouInvVCVMat = this.ouVCVMatLUD.getSolver().getInverse();
            this.setMatrixIsSingular(false);
        }
        catch (SingularMatrixException singularMatrixException) {
            this.setMatrixIsSingular(true);
        }
    }

    @Override
    protected void populateOneTraitDataVector() {
        String[] stringArray = this.getSpNamesInPhyloTMatOrder();
        RealParameter realParameter = (RealParameter)this.oneTraitInput.get();
        int n = 0;
        for (String string : stringArray) {
            this.oneTraitDataVec.setEntry(n, ((Double)realParameter.getValue(string)).doubleValue());
            ++n;
        }
    }

    public double calculateLogP() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (InputUtil.isDirty(this.alphaInput)) {
            bl2 = true;
            bl3 = true;
        }
        if (InputUtil.isDirty((Input)this.treeInput)) {
            bl = true;
            bl2 = true;
        }
        if (InputUtil.isDirty(this.sigmasqInput) || InputUtil.isDirty(this.alphaInput)) {
            bl2 = true;
        }
        if (InputUtil.isDirty(this.rootValueInput) || InputUtil.isDirty(this.alphaInput) || InputUtil.isDirty(this.optimumManagerInput)) {
            bl3 = true;
        }
        if (InputUtil.isDirty(this.oneTraitInput)) {
            bl4 = true;
        }
        this.populateInstanceVars(bl, bl2, bl3, bl4);
        this.populateParentInstanceVars(bl2, bl3, bl4);
        super.populateLogP();
        return this.getLogP();
    }

    @Override
    public boolean requiresRecalculation() {
        this.dirty = true;
        return this.dirty;
    }

    @Override
    public void store() {
        for (int i = 0; i < this.nSpp; ++i) {
            this.storedOUMeanVec.setEntry(i, this.ouMeanVec.getEntry(i));
            this.storedOneTraitDataVec.setEntry(i, this.oneTraitDataVec.getEntry(i));
            for (int j = 0; j < this.nSpp; ++j) {
                this.storedVCVMat.setEntry(i, j, this.ouVCVMat.getEntry(i, j));
            }
        }
        super.store();
    }

    @Override
    public void restore() {
        RealMatrix realMatrix = this.ouVCVMat;
        this.ouVCVMat = this.storedVCVMat;
        this.storedVCVMat = realMatrix;
        RealVector realVector = this.ouMeanVec;
        this.ouMeanVec = this.storedOUMeanVec;
        this.storedOUMeanVec = realVector;
        realVector = this.oneTraitDataVec;
        this.oneTraitDataVec = this.storedOneTraitDataVec;
        this.storedOneTraitDataVec = realVector;
        super.restore();
    }

    public List<String> getArguments() {
        return null;
    }

    public List<String> getConditions() {
        return null;
    }

    public void sample(State state, Random random) {
    }

    public void resetRealVector(RealVector realVector) {
        for (int i = 0; i < realVector.getDimension(); ++i) {
            realVector.setEntry(i, 0.0);
        }
    }

    public void resetRealMatrix(RealMatrix realMatrix) {
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                realMatrix.setEntry(i, j, 0.0);
            }
        }
    }
}

