/*
 * Decompiled with CFR 0.152.
 */
package contraband.operators;

import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.core.Log;
import beast.base.evolution.tree.Tree;
import beast.base.inference.Operator;
import beast.base.inference.parameter.BooleanParameter;
import beast.base.util.Randomizer;
import java.util.ArrayList;
import java.util.List;

@Description(value="Move k 'on' bits in an array of boolean bits. The number of 'on' bits remains constant under this operation.")
public class BitMoveOperator
extends Operator {
    public final Input<Integer> kInput = new Input("k", "the number of 'on' bits to shift", (Object)1);
    public final Input<BooleanParameter> parameterInput = new Input("parameter", "the parameter to operate a bit move on.", Input.Validate.REQUIRED);
    public final Input<Tree> treeInput = new Input("tree", "Tree object containing tree.", Input.Validate.REQUIRED);
    public final Input<Boolean> includeSampledAncestorsInput = new Input("includeSampledAncestors", "true if allowed to move to sampled ancestors (i.e, nodes whose subtending branches have length zero).", (Object)false, Input.Validate.OPTIONAL);
    Tree tree;
    List<Integer> onPositions = new ArrayList<Integer>();
    List<Integer> offPositions = new ArrayList<Integer>();

    public void initAndValidate() {
        this.tree = (Tree)this.treeInput.get();
    }

    public double proposal() {
        int n;
        BooleanParameter booleanParameter = (BooleanParameter)this.parameterInput.get();
        int n2 = booleanParameter.getDimension();
        this.onPositions.clear();
        this.offPositions.clear();
        for (n = 0; n < n2; ++n) {
            if (((Boolean)booleanParameter.getValue(n)).booleanValue()) {
                this.onPositions.add(n);
                continue;
            }
            this.offPositions.add(n);
        }
        if (this.onPositions.size() == 0 || this.offPositions.size() == 0) {
            Log.warning((String)"BitMoveOperator has no valid moves. Rejecting.");
            return Double.NEGATIVE_INFINITY;
        }
        for (n = 0; n < (Integer)this.kInput.get(); ++n) {
            int n3 = -1;
            while (this.tree.getNode(n3 = Randomizer.nextInt((int)this.onPositions.size())).isDirectAncestor()) {
            }
            Integer n4 = this.onPositions.get(n3);
            int n5 = Randomizer.nextInt((int)this.offPositions.size());
            Integer n6 = this.offPositions.get(n5);
            booleanParameter.setValue(n4.intValue(), (Object)false);
            booleanParameter.setValue(n6.intValue(), (Object)true);
            this.onPositions.remove(n3);
            this.onPositions.add(n6);
            this.offPositions.remove(n5);
            this.offPositions.add(n4);
        }
        return 0.0;
    }
}

