/*
 * Decompiled with CFR 0.152.
 */
package contraband.otherlikelihood;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.inference.Distribution;
import beast.base.inference.State;
import beast.base.inference.parameter.RealParameter;
import contraband.utils.MVNUtils;
import contraband.valuewrappers.ManyValuesOneContTrait;
import java.util.List;
import java.util.Random;

@Description(value="JIVE model (Joint inter- and Intraspecific Variance Evolution) implementation,for analyses of continuous trait evolution in multiple individualsand multiple species.")
@Citation(value="Gaboriau, T. et al. (2020). A multi-platform package forthe analysis of intra- and interspecific trait evolution. Method. Ecol. Evol., 1-9", DOI="10.1111/2041-210X.13458", year=2020, firstAuthorSurname="Gaboriau")
public class JiveLikelihoodOneTrait
extends Distribution {
    public final Input<ManyValuesOneContTrait> oneTraitInput = new Input("sampleData", "TWO OR MORE continuous data values for ONE trait, from many species.", Input.Validate.REQUIRED);
    public final Input<RealParameter> logSigmaSqsInput = new Input("logSigmaSqs", "log-sigma^2s, the log-variances of the normal densities, one per species.", Input.Validate.REQUIRED);
    public final Input<RealParameter> meansInput = new Input("mus", "mus, the means of the normal densities, one per species.", Input.Validate.REQUIRED);
    private ManyValuesOneContTrait sampleData;
    private int nSpp;
    private String[] spNames;

    public void initAndValidate() {
        this.sampleData = (ManyValuesOneContTrait)((Object)this.oneTraitInput.get());
        this.nSpp = this.sampleData.getNSpp();
        this.spNames = this.sampleData.getSpNames().toArray(new String[this.nSpp]);
    }

    public double calculateLogP() {
        Double[] doubleArray = (Double[])((RealParameter)this.logSigmaSqsInput.get()).getValues();
        Double[] doubleArray2 = (Double[])((RealParameter)this.meansInput.get()).getValues();
        this.logP = 0.0;
        int n = 0;
        for (String string : this.spNames) {
            double d = MVNUtils.getSampleNormalLogLk(this.sampleData.getSample(string), doubleArray2[n], doubleArray[n]);
            this.logP += d;
            ++n;
        }
        return this.logP;
    }

    protected boolean requiresRecalculation() {
        return super.requiresRecalculation();
    }

    public List<String> getArguments() {
        return null;
    }

    public List<String> getConditions() {
        return null;
    }

    public void sample(State state, Random random) {
    }
}

