/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import beast.base.evolution.tree.TreeParser;
import beast.base.inference.parameter.RealParameter;
import contraband.coalescent.CoalCorrection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoalCorrectionTest {
    static final double EPSILON = 1.0E-8;
    double[] expected1row;
    double[] expected2row;
    double[] expected3row;
    double[] expected4row;
    double[] expected5row;
    double[][] correctedPhyloTMat;

    @Before
    public void setUp() throws Exception {
        String string = "(((sp1:1.0,sp2:1.0):1.0,sp3:2.0):1.0,(sp4:1.0,sp5:1.0):2.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        String[] stringArray = new String[treeParser.getLeafNodeCount()];
        Double[] doubleArray = new Double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.25, 0.75, 1.0, 0.5};
        RealParameter realParameter = new RealParameter(doubleArray);
        CoalCorrection coalCorrection = new CoalCorrection();
        coalCorrection.initByName(new Object[]{"tree", treeParser, "popSizes", realParameter});
        this.correctedPhyloTMat = coalCorrection.getCorrectedPhyloTMat(stringArray);
        this.expected1row = new double[]{3.5638913869461915, 2.3059405550002823, 0.8797906714751229, 0.06389138694619145, 0.06389138694619145};
        this.expected2row = new double[]{2.3059405550002823, 3.5638913869461915, 0.8797906714751229, 0.06389138694619145, 0.06389138694619145};
        this.expected3row = new double[]{0.8797906714751229, 0.8797906714751229, 3.5638913869461915, 0.06389138694619145, 0.06389138694619145};
        this.expected4row = new double[]{0.06389138694619145, 0.06389138694619145, 0.06389138694619145, 3.5638913869461915, 1.631559028564498};
        this.expected5row = new double[]{0.06389138694619145, 0.06389138694619145, 0.06389138694619145, 1.631559028564498, 3.5638913869461915};
    }

    @Test
    public void testLnLk() {
        Assert.assertArrayEquals((double[])this.expected1row, (double[])this.correctedPhyloTMat[0], (double)1.0E-8);
        Assert.assertArrayEquals((double[])this.expected2row, (double[])this.correctedPhyloTMat[1], (double)1.0E-8);
        Assert.assertArrayEquals((double[])this.expected3row, (double[])this.correctedPhyloTMat[2], (double)1.0E-8);
        Assert.assertArrayEquals((double[])this.expected4row, (double[])this.correctedPhyloTMat[3], (double)1.0E-8);
        Assert.assertArrayEquals((double[])this.expected5row, (double[])this.correctedPhyloTMat[4], (double)1.0E-8);
    }
}

