/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import contraband.math.MatrixUtilsContra;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.junit.Assert;
import org.junit.Test;

public class MatrixUtilsContraTest {
    static final double EPSILON = 1.0E-4;

    @Test
    public void test1() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{2.0}});
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix((double[][])new double[][]{{3.0}});
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(new double[1][1]);
        array2DRowRealMatrix3 = MatrixUtilsContra.matrixAdd((RealMatrix)array2DRowRealMatrix, (RealMatrix)array2DRowRealMatrix2, (RealMatrix)array2DRowRealMatrix3);
        Assert.assertEquals((double)5.0, (double)array2DRowRealMatrix3.getEntry(0, 0), (double)1.0E-4);
    }

    @Test
    public void test2() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{2.0, 3.0, 4.0}, {4.0, 5.0, 6.0}, {-1.0, -2.0, -5.0}, {10.1, 9.2, -3.7}});
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix((double[][])new double[][]{{-1.667465, -1.626329, -2.46277}, {-2.329203, -1.973644, -1.833235}, {-2.558182, -1.872955, -2.110709}, {-2.274074, -2.245545, -2.314201}});
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(new double[4][3]);
        array2DRowRealMatrix3 = MatrixUtilsContra.matrixAdd((RealMatrix)array2DRowRealMatrix, (RealMatrix)array2DRowRealMatrix2, (RealMatrix)array2DRowRealMatrix3);
        Assert.assertEquals((double)-6.014201, (double)array2DRowRealMatrix3.getEntry(3, 2), (double)1.0E-4);
    }

    @Test
    public void test3() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{-1.994546, -2.114393, -1.599438, -2.122436}, {-1.735437, -1.670169, -1.780834, -2.245477}, {-1.735442, -2.009275, -1.983139, -1.892316}, {-1.692127, -1.942898, -1.601208, -1.982385}});
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix((double[][])new double[][]{{3.930563, 2.3388, 2.682493, 3.316776}, {3.615184, 5.165212, 4.65543, 5.121321}, {3.125677, 2.930338, 3.339628, 4.388551}, {5.196331, 4.908884, 4.991581, 3.849233}});
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(new double[4][4]);
        array2DRowRealMatrix3 = MatrixUtilsContra.matrixSubtract((RealMatrix)array2DRowRealMatrix, (RealMatrix)array2DRowRealMatrix2, (RealMatrix)array2DRowRealMatrix3);
        Assert.assertEquals((double)-4.939613, (double)array2DRowRealMatrix3.getEntry(2, 1), (double)1.0E-4);
    }

    @Test
    public void test4() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{1.767012, 2.96095, 1.681112, 2.720202, 1.891744}, {1.319742, 2.048568, 1.982075, 3.104222, 1.966111}, {1.985207, 2.04611, 2.056098, 1.015987, 2.133164}, {1.879616, 2.09427, 2.60547, 2.279227, 2.642912}});
        double d = -2.0;
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(new double[4][5]);
        array2DRowRealMatrix2 = MatrixUtilsContra.matrixScalarMultiply((RealMatrix)array2DRowRealMatrix, d, (RealMatrix)array2DRowRealMatrix2);
        Assert.assertEquals((double)-5.285823, (double)array2DRowRealMatrix2.getEntry(3, 4), (double)1.0E-4);
    }

    @Test
    public void test5() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{2.550531, 2.35046, 1.242473, 1.534543}, {1.702243, 2.455985, 2.423319, 1.267112}, {2.077579, 2.054758, 2.86143, 2.958108}, {2.274022, 1.945004, 1.524684, 1.960117}, {1.887197, 1.782756, 1.224774, 1.812466}, {2.608558, 2.27552, 1.703467, 2.37717}});
        double d = 3.2;
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(new double[6][4]);
        array2DRowRealMatrix2 = MatrixUtilsContra.matrixScalarAdd((RealMatrix)array2DRowRealMatrix, d, (RealMatrix)array2DRowRealMatrix2);
        Assert.assertEquals((double)5.55046, (double)array2DRowRealMatrix2.getEntry(0, 1), (double)1.0E-4);
    }

    @Test
    public void test6() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{5.555278, 3.637867, 3.826537, 5.580623, 4.233251, 4.265012, 5.668205, 5.960273}, {7.102671, 3.008732, 3.668539, 7.797644, 7.149419, 4.708736, 6.938855, 6.028421}, {8.244949, 2.804517, 5.590706, 4.507473, 3.285521, 5.566429, 1.413961, 6.178505}, {6.623658, 7.34027, 2.815117, 5.165536, 6.636394, 8.104003, 4.286587, 3.882813}, {5.732623, 1.996666, 6.853803, 5.431592, 1.740781, 7.074177, 6.466281, 2.540964}, {6.371464, 8.338275, 4.371867, 8.827669, 7.309662, 5.661179, 8.103298, 2.239197}, {1.422262, 1.983072, 4.297063, 4.046804, 5.934354, 7.656025, 5.650181, 2.041209}});
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(new double[8][7]);
        array2DRowRealMatrix2 = MatrixUtilsContra.matrixTranspose((RealMatrix)array2DRowRealMatrix, (RealMatrix)array2DRowRealMatrix2);
        Assert.assertEquals((double)5.431592, (double)array2DRowRealMatrix2.getEntry(3, 4), (double)1.0E-4);
    }

    @Test
    public void test7() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{2.380636, 2.433278, 3.357671}, {3.346462, 2.153579, 3.418715}, {1.607831, 3.758575, 2.292255}, {2.131158, 3.11073, 2.237507}});
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix((double[][])new double[][]{{0.7944735, 0.3748316, 0.225552, 0.9200768, 0.9144262}, {2.6796039, 0.859179, 2.216772, 3.0319734, 2.7087573}, {0.833109, 2.0754329, 2.853639, 1.6177571, 1.1335097}});
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(new double[4][5]);
        array2DRowRealMatrix3 = MatrixUtilsContra.matrixMultiply((RealMatrix)array2DRowRealMatrix, (RealMatrix)array2DRowRealMatrix2, (RealMatrix)array2DRowRealMatrix3);
        Assert.assertEquals((double)15.23582, (double)array2DRowRealMatrix3.getEntry(2, 2), (double)1.0E-4);
    }

    @Test
    public void testTVecDotMatrixDotVec() {
        double[] dArray = new double[]{1.0, 2.0, 3.0};
        double[] dArray2 = new double[]{1.0, 4.0, 7.0, 2.0, 5.0, 8.0, 3.0, 6.0, 9.0};
        int n = 3;
        double d = MatrixUtilsContra.tVecDotMatrixDotVec(dArray, dArray2, n);
        Assert.assertEquals((double)228.0, (double)d, (double)0.0);
    }

    @Test
    public void testMatrixPreMultiply() {
        double[] dArray = new double[]{1.0, 2.0, 3.0};
        double[] dArray2 = new double[]{1.0, 4.0, 7.0, 2.0, 5.0, 8.0, 3.0, 6.0, 9.0};
        double[] dArray3 = new double[3];
        int n = 3;
        int n2 = 3;
        Object[] objectArray = ArrayUtils.toObject((double[])MatrixUtilsContra.matrixPreMultiply(dArray, dArray2, n, n2, dArray3));
        Assert.assertArrayEquals((Object[])objectArray, (Object[])new Double[]{14.0, 32.0, 50.0});
    }

    @Test
    public void testVectorPreMultiply() {
        double[] dArray = new double[]{1.0, 2.0, 3.0};
        double d = 13.0;
        double[] dArray2 = new double[3];
        Object[] objectArray = ArrayUtils.toObject((double[])MatrixUtilsContra.vectorMapMultiply(dArray, d, dArray2));
        Assert.assertArrayEquals((Object[])objectArray, (Object[])new Double[]{13.0, 26.0, 39.0});
    }

    @Test
    public void testMatrixMultiply() {
        int n = 4;
        int n2 = 4;
        int n3 = n * n2;
        double[] dArray = new double[]{1.0, 5.0, 9.0, 13.0, 2.0, 6.0, 10.0, 14.0, 3.0, 7.0, 11.0, 15.0, 4.0, 8.0, 12.0, 16.0};
        double[] dArray2 = new double[]{17.0, 21.0, 25.0, 29.0, 18.0, 22.0, 26.0, 30.0, 19.0, 23.0, 27.0, 31.0, 20.0, 24.0, 28.0, 32.0};
        double[] dArray3 = new double[n3];
        Object[] objectArray = ArrayUtils.toObject((double[])MatrixUtilsContra.matrixMultiply(dArray, dArray2, n, n2, dArray3));
        Assert.assertArrayEquals((Object[])new Double[]{538.0, 650.0, 762.0, 874.0, 612.0, 740.0, 868.0, 996.0, 686.0, 830.0, 974.0, 1118.0, 760.0, 920.0, 1080.0, 1240.0}, (Object[])objectArray);
    }

    @Test
    public void testVectorTranspose() {
        int n = 4;
        double[] dArray = new double[]{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451, 3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344, 4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159, 3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091};
        double[] dArray2 = new double[n * n];
        Object[] objectArray = ArrayUtils.toObject((double[])MatrixUtilsContra.matrixTranspose(dArray, n, dArray2));
        Assert.assertArrayEquals((Object[])new Double[]{3.92476468143533, 3.62535769121946, 4.32677785441579, 3.73658224109536, 2.95493862847269, 3.72081122250077, 3.77038177701209, 4.00675227771716, 5.47315682161247, 3.70889115977579, 3.31385684718126, 3.23330588599873, 2.85610318223451, 3.64833976126344, 3.67462891649159, 3.80698366724091}, (Object[])objectArray);
    }

    @Test
    public void testVectorDotMultiply() {
        double[] dArray = new double[]{2.0, -5.0, 3.0, -4.0};
        double[] dArray2 = new double[]{3.95493862847269, 4.72081122250077, 4.77038177701209, 5.00675227771716};
        double d = MatrixUtilsContra.vectorDotMultiply(dArray, dArray2);
        Assert.assertEquals((double)-21.410042635390845, (double)d, (double)0.0);
    }

    @Test
    public void testVecTransScalarMultiply() {
        double[] dArray = new double[]{-0.206399781564555, 1.28555407499791, 1.0553689032024, 1.49801714307272, 1.20285942488946};
        double d = 0.2;
        double d2 = MatrixUtilsContra.vecTransScalarMultiply(dArray, d, 5);
        Assert.assertEquals((double)1.2999959656810844, (double)d2, (double)0.0);
    }

    @Test
    public void testVectorAdd() {
        int n = 4;
        double[] dArray = new double[]{2.1, -5.2, 3.3, -4.4};
        double[] dArray2 = new double[]{3.95493862847269, 4.72081122250077, 4.77038177701209, 5.00675227771716};
        double[] dArray3 = new double[n];
        Object[] objectArray = ArrayUtils.toObject((double[])MatrixUtilsContra.vectorAdd(dArray, dArray2, dArray3));
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        ArrayRealVector arrayRealVector2 = new ArrayRealVector(dArray2);
        RealVector realVector = arrayRealVector.add((RealVector)arrayRealVector2);
        Assert.assertArrayEquals((Object[])new Double[]{realVector.getEntry(0), realVector.getEntry(1), realVector.getEntry(2), realVector.getEntry(3)}, (Object[])objectArray);
    }

    @Test
    public void testGetMatrixEntry() {
        int n = 4;
        double[] dArray = new double[]{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451, 3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344, 4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159, 3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091};
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451}, {3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344}, {4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159}, {3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091}});
        Assert.assertEquals((double)array2DRowRealMatrix.getEntry(2, 3), (double)MatrixUtilsContra.getMatrixEntry(dArray, 2, 3, n), (double)0.0);
    }

    @Test
    public void testSetMatrixEntry() {
        int n = 4;
        double[] dArray = new double[]{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451, 3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344, 4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159, 3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091};
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451}, {3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344}, {4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159}, {3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091}});
        double d = 6.8;
        MatrixUtilsContra.setMatrixEntry(dArray, 2, 3, d, n);
        array2DRowRealMatrix.setEntry(2, 3, d);
        Assert.assertEquals((double)array2DRowRealMatrix.getEntry(2, 3), (double)MatrixUtilsContra.getMatrixEntry(dArray, 2, 3, n), (double)0.0);
    }

    @Test
    public void testGetMatrixRow() {
        int n = 4;
        double[] dArray = new double[]{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451, 3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344, 4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159, 3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091};
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451}, {3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344}, {4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159}, {3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091}});
        double[] dArray2 = new double[n];
        MatrixUtilsContra.getMatrixRow(dArray, 2, n, dArray2);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((double[])array2DRowRealMatrix.getRow(2)), (Object[])ArrayUtils.toObject((double[])dArray2));
    }

    @Test
    public void testSetMatrixRow() {
        int n = 4;
        double[] dArray = new double[]{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451, 3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344, 4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159, 3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091};
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{3.92476468143533, 2.95493862847269, 5.47315682161247, 2.85610318223451}, {3.62535769121946, 3.72081122250077, 3.70889115977579, 3.64833976126344}, {4.32677785441579, 3.77038177701209, 3.31385684718126, 3.67462891649159}, {3.73658224109536, 4.00675227771716, 3.23330588599873, 3.80698366724091}});
        double[] dArray2 = new double[]{5.2, 3.4, 1.0, -3.3};
        MatrixUtilsContra.setMatrixRow(dArray, dArray2, 2, n);
        array2DRowRealMatrix.setRow(2, dArray2);
        double[] dArray3 = new double[n];
        MatrixUtilsContra.getMatrixRow(dArray, 2, n, dArray3);
        Assert.assertArrayEquals((Object[])ArrayUtils.toObject((double[])array2DRowRealMatrix.getRow(2)), (Object[])ArrayUtils.toObject((double[])dArray3));
    }
}

