/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import beast.base.evolution.tree.Tree;
import beast.base.evolution.tree.TreeParser;
import beast.base.inference.parameter.RealParameter;
import contraband.math.NodeMath;
import contraband.utils.PruneLikelihoodUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.junit.Assert;
import org.junit.Test;

public class NodeMathTest {
    private int nTraits;
    private List<Double> data;
    private String spNames;
    private TreeParser tree;
    private String treeStr;
    private final RealParameter traitValues = new RealParameter();
    private final NodeMath nodeMath = new NodeMath();
    private double[] traitValuesArr;
    private RealParameter sigmasq;
    private RealParameter correlation;
    static final double EPSILON = 1.0E-7;

    @Test
    public void testShrinkageOperations() {
        this.treeStr = "((A:12.4420263,B:12.4420263):42.9258211,C:43.5702874);";
        this.spNames = "A B C";
        this.tree = new TreeParser(this.treeStr, false, false, true, 0);
        this.nTraits = 2;
        this.data = Arrays.asList(1.0, 2.0, 3.0, 5.0, 2.0, 4.0);
        this.traitValues.initByName(new Object[]{"value", this.data, "keys", this.spNames, "minordimension", this.nTraits});
        this.traitValuesArr = new double[3 * this.nTraits];
        PruneLikelihoodUtils.populateTraitValuesArr(this.traitValues, (Tree)this.tree, this.nTraits, this.traitValuesArr);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(new double[3][this.nTraits]);
        PruneLikelihoodUtils.populateTraitValuesMatrix(this.traitValues, (Tree)this.tree, this.nTraits, (RealMatrix)array2DRowRealMatrix);
        this.sigmasq = new RealParameter(new Double[]{0.1543038});
        this.nodeMath.initByName(new Object[]{"traits", this.traitValues, "sigmasq", this.sigmasq, "shrinkage", true, "oneRateOnly", true});
        this.nodeMath.estimateCorrelations((RealMatrix)array2DRowRealMatrix);
        RealMatrix realMatrix = this.nodeMath.getUnbiasedRho();
        Assert.assertEquals((double)0.9819805060619656, (double)realMatrix.getEntry(0, 1), (double)0.0);
        this.nodeMath.populateShrinkageEstimation(0.25925925925926);
        RealMatrix realMatrix2 = this.nodeMath.getShrinkageRho();
        Assert.assertEquals((double)0.727392967453307, (double)realMatrix2.getEntry(0, 1), (double)1.0E-7);
        double d = this.nodeMath.getDetShrinkageRho();
        double d2 = this.nodeMath.getDetInvShrinkageRho();
        Assert.assertEquals((double)0.470899470899473, (double)d, (double)1.0E-7);
        Assert.assertEquals((double)2.123595505617968, (double)d2, (double)1.0E-7);
        this.nodeMath.populateTraitRateMatrix();
        RealMatrix realMatrix3 = this.nodeMath.getTraitRateRealMatrix();
        Assert.assertEquals((double)0.1122394989713215, (double)realMatrix3.getEntry(0, 1), (double)1.0E-7);
        this.nodeMath.populateInverseTraitRateMatrix();
        double d3 = this.nodeMath.getTraitRateMatrixDeterminant();
        double d4 = this.nodeMath.getTraitRateMatrixInverseDeterminant();
        Assert.assertEquals((double)-4.4907744304614, (double)d3, (double)1.0E-7);
        Assert.assertEquals((double)4.4907744304614, (double)d4, (double)1.0E-7);
        this.nodeMath.populateTransformedTraitValues((RealMatrix)array2DRowRealMatrix);
        double[] dArray = this.nodeMath.getTransformedTraitValues();
        Assert.assertArrayEquals((Object[])new Double[]{2.5457261826187922, 4.721085948047915, 7.637178547856377, 10.45348269179349, 5.0914523652375845, 9.44217189609583}, (Object[])ArrayUtils.toObject((double[])dArray));
    }

    @Test
    public void testNonShrinkageOperationsOneRateOnly() {
        this.treeStr = "((A:23.0058179,B:23.0058179):14.350951,C:37.3567689);";
        this.spNames = "A B C";
        this.tree = new TreeParser(this.treeStr, false, false, true, 0);
        this.nTraits = 2;
        this.data = Arrays.asList(-2.62762948691895, -1.56292164859448, -1.50846427625826, -1.59482814741543, -0.226074849617958, -2.11000367246907);
        this.traitValues.initByName(new Object[]{"value", this.data, "keys", this.spNames, "minordimension", this.nTraits});
        this.traitValuesArr = new double[3 * this.nTraits];
        PruneLikelihoodUtils.populateTraitValuesArr(this.traitValues, (Tree)this.tree, this.nTraits, this.traitValuesArr);
        this.sigmasq = new RealParameter(new Double[]{0.314574});
        this.correlation = new RealParameter(new Double[]{-0.632620487603683});
        this.nodeMath.initByName(new Object[]{"traits", this.traitValues, "sigmasq", this.sigmasq, "correlation", this.correlation, "oneRateOnly", true});
        this.nodeMath.populateTraitRateMatrixForOneRate();
        double[] dArray = this.nodeMath.getTraitRateMatrix();
        Assert.assertArrayEquals((Object[])new Double[]{0.314574, -0.19900595726744097, -0.19900595726744097, 0.314574}, (Object[])ArrayUtils.toObject((double[])dArray));
        this.nodeMath.performMatrixOperations();
        Assert.assertEquals((double)-2.824245359292377, (double)this.nodeMath.getTraitRateMatrixDeterminant(), (double)1.0E-7);
        Assert.assertEquals((double)16.84822583043347, (double)this.nodeMath.getTraitRateMatrixInverseDeterminant(), (double)1.0E-7);
    }

    @Test
    public void testNonShrinkageOperationsMultipleRates() {
        this.treeStr = "((A:23.0058179,B:23.0058179):14.350951,C:37.3567689);";
        this.tree = new TreeParser(this.treeStr, false, false, true, 0);
        this.nTraits = 2;
        this.data = Arrays.asList(-2.62762948691895, -0.764018322006132, -1.50846427625826, -1.02686498716963, -0.226074849617958, -1.73165056392106);
        this.spNames = "A B C";
        this.traitValues.initByName(new Object[]{"value", this.data, "keys", this.spNames, "minordimension", this.nTraits});
        this.traitValuesArr = new double[3 * this.nTraits];
        PruneLikelihoodUtils.populateTraitValuesArr(this.traitValues, (Tree)this.tree, this.nTraits, this.traitValuesArr);
        this.sigmasq = new RealParameter(new Double[]{0.3, 0.2});
        this.correlation = new RealParameter(new Double[]{-0.720107524122507});
        this.nodeMath.initByName(new Object[]{"traits", this.traitValues, "sigmasq", this.sigmasq, "correlation", this.correlation});
        this.nodeMath.populateTraitRateMatrixForMultipleRates();
        double[] dArray = this.nodeMath.getTraitRateMatrix();
        Assert.assertArrayEquals((Object[])new Double[]{0.3, -0.17638959940390708, -0.17638959940390708, 0.2}, (Object[])ArrayUtils.toObject((double[])dArray));
        this.nodeMath.performMatrixOperations();
        Assert.assertEquals((double)-3.544373678152544, (double)this.nodeMath.getTraitRateMatrixDeterminant(), (double)0.0);
        Assert.assertEquals((double)34.61799654333531, (double)this.nodeMath.getTraitRateMatrixInverseDeterminant(), (double)0.0);
    }
}

