/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import contraband.utils.NodeMathUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class NodeMathUtilsTest {
    @Test
    public void testPopulateUpperTriangularMatForOneRate() {
        int n = 3;
        double d = 2.5;
        double[] dArray = new double[]{0.3, 0.2, -0.1};
        double[] dArray2 = new double[n * n];
        NodeMathUtils.populateUpperTriangularMat(d, dArray, n, dArray2);
        Assert.assertArrayEquals((Object[])new Double[]{2.5, 0.75, 0.5, 0.0, 2.5, -0.25, 0.0, 0.0, 2.5}, (Object[])ArrayUtils.toObject((double[])dArray2));
    }

    @Test
    public void testPopulateUpperTriangularMatForMultipleRates() {
        int n = 3;
        double[] dArray = new double[]{25.0, 9.0, 16.0};
        double[] dArray2 = new double[]{0.3, 0.2, -0.1};
        double[] dArray3 = new double[n * n];
        NodeMathUtils.populateUpperTriangularMat(dArray, dArray2, n, dArray3);
        Assert.assertArrayEquals((Object[])new Double[]{25.0, 4.5, 4.0, 0.0, 9.0, -1.2000000000000002, 0.0, 0.0, 16.0}, (Object[])ArrayUtils.toObject((double[])dArray3));
    }

    @Test
    public void testPopulateTraitRateMatrixDirectlyForOneRate() {
        int n = 3;
        double d = 2.5;
        double[] dArray = new double[]{0.3, 0.2, -0.1};
        double[] dArray2 = new double[n * n];
        NodeMathUtils.populateTraitRateMatrixDirectly(d, dArray, n, dArray2);
        Assert.assertArrayEquals((Object[])new Double[]{2.5, 0.75, 0.5, 0.75, 2.5, -0.25, 0.5, -0.25, 2.5}, (Object[])ArrayUtils.toObject((double[])dArray2));
    }

    @Test
    public void testPopulateTraitRateMatrixDirectlyForMultipleRates() {
        int n = 3;
        double[] dArray = new double[]{25.0, 9.0, 16.0};
        double[] dArray2 = new double[]{0.3, 0.2, -0.1};
        double[] dArray3 = new double[n * n];
        NodeMathUtils.populateTraitRateMatrixDirectly(dArray, dArray2, n, dArray3);
        Assert.assertArrayEquals((Object[])new Double[]{25.0, 4.5, 4.0, 4.5, 9.0, -1.2000000000000002, 4.0, -1.2000000000000002, 16.0}, (Object[])ArrayUtils.toObject((double[])dArray3));
    }

    @Test
    public void testPopulateTraitRateMatrixForOneRate() {
        int n = 3;
        double d = 2.5;
        double[] dArray = new double[]{0.3, 0.2, -0.1};
        double[] dArray2 = new double[n * n];
        double[] dArray3 = new double[n * n];
        double[] dArray4 = new double[n * n];
        NodeMathUtils.populateTraitRateMatrix(d, dArray, dArray3, dArray4, n, dArray2);
        Assert.assertArrayEquals((Object[])new Double[]{7.0625, 1.75, 1.25, 1.75, 6.3125, -0.625, 1.25, -0.625, 6.25}, (Object[])ArrayUtils.toObject((double[])dArray2));
    }

    @Test
    public void testPopulateCoUpperTriangularMat() {
        int n = 3;
        double[] dArray = new double[]{25.0, 9.0, 16.0};
        double[] dArray2 = new double[]{0.3, 0.2, -0.1};
        double[] dArray3 = new double[n * n];
        NodeMathUtils.populateCoUpperTriangularMat(dArray, dArray2, n, dArray3);
        Assert.assertArrayEquals((Object[])new Double[]{25.0, 0.3, 0.2, 0.0, 9.0, -0.1, 0.0, 0.0, 16.0}, (Object[])ArrayUtils.toObject((double[])dArray3));
    }

    @Test
    public void testPopulateTraitRateMatrixForMultipleRates() {
        int n = 3;
        double[] dArray = new double[]{25.0, 9.0, 16.0};
        double[] dArray2 = new double[]{0.3, 0.2, -0.1};
        double[] dArray3 = new double[n * n];
        double[] dArray4 = new double[n * n];
        double[] dArray5 = new double[n * n];
        double[] dArray6 = new double[n * n];
        NodeMathUtils.populateTraitRateMatrix(dArray, dArray2, dArray5, dArray6, n, dArray3, true);
        Assert.assertArrayEquals((Object[])new Double[]{625.13, 2.6799999999999997, 3.2, 2.6799999999999997, 81.01, -1.6, 3.2, -1.6, 256.0}, (Object[])ArrayUtils.toObject((double[])dArray3));
        NodeMathUtils.populateTraitRateMatrix(dArray, dArray2, dArray5, dArray6, n, dArray4, false);
        Assert.assertArrayEquals((Object[])new Double[]{661.25, 35.7, 64.0, 35.7, 82.44, -19.200000000000003, 64.0, -19.200000000000003, 256.0}, (Object[])ArrayUtils.toObject((double[])dArray4));
    }
}

