/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import beast.base.evolution.tree.TreeParser;
import beast.base.inference.parameter.IntegerParameter;
import beast.base.inference.parameter.RealParameter;
import contraband.clock.RateCategoryClockModel;
import contraband.clock.TreeToVCVMat;
import contraband.utils.OUUtils;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.junit.Assert;
import org.junit.Test;

public class OUUtilsComputeWMatOneTraitTest {
    static final double EPSILON = 1.0E-4;
    private static RealMatrix ouWeight1FI;
    private static RealMatrix ouWeight1FM;
    private static RealMatrix ouWeight1RI;
    private static RealMatrix ouWeight1RM;
    private static RealMatrix ouWeight2FI;
    private static RealMatrix ouWeight2FM;
    private static RealMatrix ouWeight2RI;
    private static RealMatrix ouWeight2RM;
    private static RealMatrix ouWeight3FI;
    private static RealMatrix ouWeight3FM;
    private static RealMatrix ouWeight3RI;
    private static RealMatrix ouWeight3RM;

    @Test
    public void testComputeOUWMatSmallTree() {
        String string = "(((sp1:1.0,sp2:1.0):1.0,sp3:2.0):1.0,sp4:3.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        List list = treeParser.getRoot().getAllLeafNodes();
        RealParameter realParameter = new RealParameter(new Double[]{2.228585E-40, -4.047373E-16, 1.0, 1.0});
        IntegerParameter integerParameter = new IntegerParameter(new Integer[]{1, 1, 2, 0, 1, 0, 0});
        RateCategoryClockModel rateCategoryClockModel = new RateCategoryClockModel();
        rateCategoryClockModel.initByName(new Object[]{"nCat", 3, "rateCatAssign", integerParameter, "rates", realParameter, "tree", treeParser});
        TreeToVCVMat treeToVCVMat = new TreeToVCVMat();
        treeToVCVMat.initByName(new Object[]{"branchRateModel", rateCategoryClockModel, "tree", treeParser, "coalCorrection", false});
        double d = 31.20814;
        double d2 = 31.20814;
        double d3 = 43.35287;
        double d4 = 43.35287;
        int n = treeParser.getLeafNodeCount();
        ouWeight1FI = new Array2DRowRealMatrix(n, 4);
        ouWeight1FM = new Array2DRowRealMatrix(n, 3);
        ouWeight1RI = new Array2DRowRealMatrix(n, 4);
        ouWeight1RM = new Array2DRowRealMatrix(n, 3);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 3, d, ouWeight1FI, true);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 3, d2, ouWeight1FM, false);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 3, d3, ouWeight1RI, true);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 3, d4, ouWeight1RM, false);
        Assert.assertEquals((double)7.815427E-28, (double)ouWeight1FI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight1FI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight1FI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)2.184887E-41, (double)ouWeight1FI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight1FM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight1FM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight1FM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)7.815427E-28, (double)ouWeight1FM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)2.208911E-38, (double)ouWeight1RI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight1RI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight1RI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)3.282974E-57, (double)ouWeight1RI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight1RM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight1RM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight1RM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)2.208911E-38, (double)ouWeight1RM.getEntry(1, 0), (double)1.0E-4);
    }

    @Test
    public void testComputeOUWMatSmallTreeNonUltra() {
        String string = "(((sp1:2.0,sp2:1.0):1.0,sp3:4.0):1.0,sp4:3.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        List list = treeParser.getRoot().getAllLeafNodes();
        RealParameter realParameter = new RealParameter(new Double[]{0.1});
        IntegerParameter integerParameter = new IntegerParameter(new Integer[]{0, 0, 0, 0, 0, 0, 0});
        RateCategoryClockModel rateCategoryClockModel = new RateCategoryClockModel();
        rateCategoryClockModel.initByName(new Object[]{"nCat", 3, "rateCatAssign", integerParameter, "rates", realParameter, "tree", treeParser});
        TreeToVCVMat treeToVCVMat = new TreeToVCVMat();
        treeToVCVMat.initByName(new Object[]{"branchRateModel", rateCategoryClockModel, "tree", treeParser, "coalCorrection", false});
        double d = 0.7465763;
        double d2 = 1.40338E-8;
        double d3 = 0.8609833;
        double d4 = 0.7085376;
        int n = treeParser.getLeafNodeCount();
        ouWeight2FI = new Array2DRowRealMatrix(n, 2);
        ouWeight2FM = new Array2DRowRealMatrix(n, 1);
        ouWeight2RI = new Array2DRowRealMatrix(n, 2);
        ouWeight2RM = new Array2DRowRealMatrix(n, 1);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 1, d, ouWeight2FI, true);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 1, d2, ouWeight2FM, false);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 1, d3, ouWeight2RI, true);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 1, d4, ouWeight2RM, false);
        Assert.assertEquals((double)0.9495264, (double)ouWeight2FI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.8935126, (double)ouWeight2FI.getEntry(1, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0239238, (double)ouWeight2FI.getEntry(2, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.10648738, (double)ouWeight2FI.getEntry(3, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2FM.getEntry(0, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2FM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2FM.getEntry(2, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2FM.getEntry(3, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.9680612, (double)ouWeight2RI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.9244492, (double)ouWeight2RI.getEntry(1, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.01350201, (double)ouWeight2RI.getEntry(2, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.07555081, (double)ouWeight2RI.getEntry(3, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2RM.getEntry(0, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2RM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2RM.getEntry(2, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)ouWeight2RM.getEntry(3, 0), (double)1.0E-4);
    }

    @Test
    public void testComputeOUWMatLargerTreeNonUltra() {
        String string = "(((((sp1:1.0,sp2:1.0):1.0,sp3:1.0):2.0,(sp4:1.0,sp5:1.0):3.0):2.0,sp6:6.0):1.0,sp7:3.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        List list = treeParser.getRoot().getAllLeafNodes();
        RealParameter realParameter = new RealParameter(new Double[]{0.1, 0.1, 0.1, 0.1, 0.1});
        IntegerParameter integerParameter = new IntegerParameter(new Integer[]{1, 1, 0, 2, 2, 3, 4, 1, 0, 2, 0, 1, 0});
        RateCategoryClockModel rateCategoryClockModel = new RateCategoryClockModel();
        rateCategoryClockModel.initByName(new Object[]{"nCat", 5, "rateCatAssign", integerParameter, "rates", realParameter, "tree", treeParser});
        TreeToVCVMat treeToVCVMat = new TreeToVCVMat();
        treeToVCVMat.initByName(new Object[]{"branchRateModel", rateCategoryClockModel, "tree", treeParser, "coalCorrection", false});
        double d = 7.142986;
        double d2 = 7.142986;
        double d3 = 7.84511;
        double d4 = 7.84511;
        int n = treeParser.getLeafNodeCount();
        ouWeight3FI = new Array2DRowRealMatrix(n, 6);
        ouWeight3FM = new Array2DRowRealMatrix(n, 5);
        ouWeight3RI = new Array2DRowRealMatrix(n, 6);
        ouWeight3RM = new Array2DRowRealMatrix(n, 5);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 5, d, ouWeight3FI, true);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 5, d2, ouWeight3FM, false);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 5, d3, ouWeight3RI, true);
        OUUtils.computeWMatOneTrait((Integer[])integerParameter.getValues(), treeParser.getRoot(), list, n, 5, d4, ouWeight3RM, false);
        Assert.assertEquals((double)6.247136E-7, (double)ouWeight3FI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight3FI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.9999994, (double)ouWeight3FI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.927008E-22, (double)ouWeight3FI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.9999994, (double)ouWeight3FM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight3FM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight3FM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)6.247136E-7, (double)ouWeight3FM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.533995E-7, (double)ouWeight3RI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight3RI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.9999998, (double)ouWeight3RI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.413785E-24, (double)ouWeight3RI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.9999998, (double)ouWeight3RM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight3RM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)ouWeight3RM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.533995E-7, (double)ouWeight3RM.getEntry(1, 0), (double)1.0E-4);
    }
}

