/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.TreeParser;
import beast.base.inference.parameter.IntegerParameter;
import beast.base.inference.parameter.RealParameter;
import contraband.clock.RateCategoryClockModel;
import contraband.clock.TreeToVCVMat;
import org.junit.Assert;
import org.junit.Test;

public class RegimeManagerTest {
    public static double[][] colorValuesMat;
    public static double[] expected1row;
    public static double[] expected2row;
    public static double[] expected3row;
    public static double[] expected4row;
    public static double[] expected5row;
    public static double sp1;
    public static double sp3;
    public static double sp12;

    @Test
    public void testRegimeManagerValues() {
        String string = "(((sp1:1.0,sp2:1.0):1.0,sp3:2.0):2.0,(sp4:2.5,sp5:2.5):1.5);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        RealParameter realParameter = new RealParameter(new Double[]{0.2, 0.4, 0.6, 0.8, 1.0});
        IntegerParameter integerParameter = new IntegerParameter(new Integer[]{3, 4, 0, 0, 0, 2, 1, 4, 0});
        RateCategoryClockModel rateCategoryClockModel = new RateCategoryClockModel();
        rateCategoryClockModel.initByName(new Object[]{"nCat", 5, "rateCatAssign", integerParameter, "rates", realParameter, "tree", treeParser});
        TreeToVCVMat treeToVCVMat = new TreeToVCVMat();
        treeToVCVMat.initByName(new Object[]{"branchRateModel", rateCategoryClockModel, "tree", treeParser, "coalCorrection", false});
        colorValuesMat = treeToVCVMat.getSpColorValuesMatOneTrait();
        expected1row = new double[]{2.2, 1.4, 0.8, 0.0, 0.0};
        expected2row = new double[]{1.4, 2.4000000000000004, 0.8, 0.0, 0.0};
        expected3row = new double[]{0.8, 0.8, 1.2000000000000002, 0.0, 0.0};
        expected4row = new double[]{0.0, 0.0, 0.0, 2.0, 1.5};
        expected5row = new double[]{0.0, 0.0, 0.0, 1.5, 2.0};
        Node node = treeParser.getNode(0);
        Node node2 = treeParser.getNode(2);
        Node node3 = treeParser.getNode(5);
        sp1 = treeToVCVMat.getNodeColorValue(node, 0);
        sp3 = treeToVCVMat.getNodeColorValue(node2, 0);
        sp12 = treeToVCVMat.getNodeColorValue(node3, 0);
        Assert.assertArrayEquals((double[])expected1row, (double[])colorValuesMat[0], (double)1.0E-10);
        Assert.assertArrayEquals((double[])expected2row, (double[])colorValuesMat[1], (double)1.0E-10);
        Assert.assertArrayEquals((double[])expected3row, (double[])colorValuesMat[2], (double)1.0E-10);
        Assert.assertArrayEquals((double[])expected4row, (double[])colorValuesMat[3], (double)1.0E-10);
        Assert.assertArrayEquals((double[])expected5row, (double[])colorValuesMat[4], (double)1.0E-10);
        Assert.assertEquals((double)0.8, (double)sp1, (double)0.0);
        Assert.assertEquals((double)0.2, (double)sp3, (double)0.0);
        Assert.assertEquals((double)0.6, (double)sp12, (double)0.0);
    }
}

