/*
 * Decompiled with CFR 0.152.
 */
package contraband.utils;

import contraband.math.MatrixUtilsContra;
import org.apache.commons.math3.util.FastMath;

public class NodeMathUtils {
    public static void populateUpperTriangularMat(double d, double[] dArray, int n, double[] dArray2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            MatrixUtilsContra.setMatrixEntry(dArray2, i, i, d, n);
            for (int j = i + 1; j < n; ++j) {
                double d2 = d * dArray[n2];
                MatrixUtilsContra.setMatrixEntry(dArray2, i, j, d2, n);
                ++n2;
            }
        }
    }

    public static void populateTraitRateMatrix(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4) {
        NodeMathUtils.populateUpperTriangularMat(d, dArray, n, dArray2);
        MatrixUtilsContra.matrixTranspose(dArray2, n, dArray3);
        MatrixUtilsContra.matrixMultiply(dArray2, dArray3, n, n, dArray4);
    }

    public static void populateUpperTriangularMat(double[] dArray, double[] dArray2, int n, double[] dArray3) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            MatrixUtilsContra.setMatrixEntry(dArray3, i, i, dArray[i], n);
            for (int j = i + 1; j < n; ++j) {
                double d = FastMath.sqrt((double)dArray[i]) * FastMath.sqrt((double)dArray[j]) * dArray2[n2];
                MatrixUtilsContra.setMatrixEntry(dArray3, i, j, d, n);
                ++n2;
            }
        }
    }

    public static void populateCoUpperTriangularMat(double[] dArray, double[] dArray2, int n, double[] dArray3) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            MatrixUtilsContra.setMatrixEntry(dArray3, i, i, dArray[n3], n);
            ++n3;
            for (int j = i + 1; j < n; ++j) {
                MatrixUtilsContra.setMatrixEntry(dArray3, i, j, dArray2[n2], n);
                ++n2;
            }
        }
    }

    public static void populateTraitRateMatrix(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double[] dArray5, boolean bl) {
        if (bl) {
            NodeMathUtils.populateCoUpperTriangularMat(dArray, dArray2, n, dArray3);
        } else {
            NodeMathUtils.populateUpperTriangularMat(dArray, dArray2, n, dArray3);
        }
        MatrixUtilsContra.matrixTranspose(dArray3, n, dArray4);
        MatrixUtilsContra.matrixMultiply(dArray3, dArray4, n, n, dArray5);
    }

    public static void populateTraitRateMatrixDirectly(double[] dArray, double[] dArray2, int n, double[] dArray3) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            MatrixUtilsContra.setMatrixEntry(dArray3, i, i, d, n);
            for (int j = i + 1; j < n; ++j) {
                double d2 = FastMath.sqrt((double)dArray[i]) * FastMath.sqrt((double)dArray[j]) * dArray2[n2];
                MatrixUtilsContra.setMatrixEntry(dArray3, i, j, d2, n);
                MatrixUtilsContra.setMatrixEntry(dArray3, j, i, d2, n);
                ++n2;
            }
        }
    }

    public static void populateTraitRateMatrixDirectly(double d, double[] dArray, int n, double[] dArray2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            MatrixUtilsContra.setMatrixEntry(dArray2, i, i, d, n);
            for (int j = i + 1; j < n; ++j) {
                double d2 = d * dArray[n2];
                MatrixUtilsContra.setMatrixEntry(dArray2, i, j, d2, n);
                MatrixUtilsContra.setMatrixEntry(dArray2, j, i, d2, n);
                ++n2;
            }
        }
    }
}

