/*
 * Decompiled with CFR 0.152.
 */
package contraband.clock;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Function;
import beast.base.core.Input;
import beast.base.core.Log;
import beast.base.evolution.branchratemodel.BranchRateModel;
import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.inference.parameter.BooleanParameter;
import beast.base.inference.parameter.RealParameter;

@Description(value="Random Local Color Model.")
@Citation(value="Drummond AJ, Suchard MA (2010) Bayesian random local clocks, or one rate to rule them all. BMC biology 8, 114.", DOI="10.1186/1741-7007-8-114", year=2010, firstAuthorSurname="drummond")
public class RandomLocalColorModel
extends BranchRateModel.Base {
    public final Input<BooleanParameter> indicatorParamInput = new Input("indicators", "the indicators associated with nodes in the tree for sampling of individual color changes among branches.", Input.Validate.REQUIRED);
    public final Input<RealParameter> colorParamInput = new Input("colors", "the color (rates, optima, etc.) parameters associated with nodes in the tree for sampling of individual colors among branches.", Input.Validate.REQUIRED);
    public final Input<Tree> treeInput = new Input("tree", "the tree this relaxed clock is associated with.", Input.Validate.REQUIRED);
    public final Input<Boolean> colorsAreMultipliersInput = new Input("colorsAreMultipliers", "true if the colors should be treated as multipliers (default false).", (Object)false);
    public final Input<Boolean> scalingInput = new Input("scaling", "if false, then ignore meanColor input and leave colors unscaled.", (Object)true, Input.Validate.OPTIONAL);
    public final Input<Boolean> includeRootInput = new Input("includeRoot", "if true, then the root can take on an arbitrary color, otherwise the root branch has color 1.0.", (Object)false, Input.Validate.OPTIONAL);
    Tree tree;
    Function meanColor;
    boolean scaling = true;
    private boolean recompute = true;
    double[] unscaledBranchColors;
    double scaleFactor = 1.0;
    boolean colorsAreMultipliers = false;

    public void initAndValidate() {
        this.tree = (Tree)this.treeInput.get();
        this.scaling = (Boolean)this.scalingInput.get();
        BooleanParameter booleanParameter = (BooleanParameter)this.indicatorParamInput.get();
        int n = this.tree.getNodeCount();
        int n2 = this.tree.getNodeCount() - 1;
        if (!((Boolean)this.includeRootInput.get()).booleanValue()) {
            --n;
        }
        if (booleanParameter.getDimension() != n2) {
            Log.warning((String)("RandomLocalColorModel::Setting dimension of indicators to " + n2));
            booleanParameter.setDimension(n2);
        }
        this.unscaledBranchColors = new double[this.tree.getNodeCount()];
        RealParameter realParameter = (RealParameter)this.colorParamInput.get();
        if (realParameter.getDimension() != n) {
            Log.warning((String)("RandomLocalClockModel::Setting dimension of colors to " + n));
            realParameter.setDimension(n);
        }
        this.colorsAreMultipliers = (Boolean)this.colorsAreMultipliersInput.get();
        this.meanColor = (Function)this.meanRateInput.get();
        if (this.meanColor == null) {
            this.meanColor = new RealParameter("1.0");
        }
    }

    private void calculateUnscaledBranchColors(Node node, double d, BooleanParameter booleanParameter, RealParameter realParameter) {
        int n = this.getNr(node);
        if (!node.isRoot() && ((Boolean)booleanParameter.getValue(n)).booleanValue()) {
            d = this.colorsAreMultipliers ? (d *= ((Double)realParameter.getValue(n)).doubleValue()) : (Double)realParameter.getValue(n);
        }
        this.unscaledBranchColors[n] = d;
        if (!node.isLeaf()) {
            this.calculateUnscaledBranchColors(node.getLeft(), d, booleanParameter, realParameter);
            this.calculateUnscaledBranchColors(node.getRight(), d, booleanParameter, realParameter);
        }
    }

    private void recalculateScaleFactor() {
        BooleanParameter booleanParameter = (BooleanParameter)this.indicatorParamInput.get();
        RealParameter realParameter = (RealParameter)this.colorParamInput.get();
        double d = 1.0;
        if (((Boolean)this.includeRootInput.get()).booleanValue()) {
            d = (Double)realParameter.getValue(this.tree.getRoot().getNr());
        }
        this.calculateUnscaledBranchColors(this.tree.getRoot(), d, booleanParameter, realParameter);
        if (this.scaling) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < this.tree.getNodeCount(); ++i) {
                Node node = this.tree.getNode(i);
                if (node.isRoot()) continue;
                double d4 = node.getParent().getHeight() - node.getHeight();
                double d5 = d4 * this.unscaledBranchColors[node.getNr()];
                d2 += d4;
                d3 += d5;
            }
            this.scaleFactor = d2 / d3;
            this.scaleFactor *= this.meanColor.getArrayValue();
        } else {
            this.scaleFactor = 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRateForBranch(Node node) {
        RandomLocalColorModel randomLocalColorModel = this;
        synchronized (randomLocalColorModel) {
            if (this.recompute) {
                this.recalculateScaleFactor();
                this.recompute = false;
            }
        }
        return this.unscaledBranchColors[this.getNr(node)] * this.scaleFactor;
    }

    private int getNr(Node node) {
        int n = node.getNr();
        if (n > this.tree.getRoot().getNr()) {
            --n;
        }
        return n;
    }

    protected boolean requiresRecalculation() {
        this.recompute = true;
        return true;
    }

    protected void store() {
        this.recompute = true;
        super.store();
    }

    protected void restore() {
        this.recompute = true;
        super.restore();
    }
}

