/*
 * Decompiled with CFR 0.152.
 */
package contraband.clock;

import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.core.Log;
import beast.base.evolution.branchratemodel.BranchRateModel;
import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.inference.parameter.IntegerParameter;
import beast.base.inference.parameter.RealParameter;

@Description(value="Local Strict Clock Model. There are nCat clock rate categories, and each branch is assigned to one of the nCat rate categories.")
public class RateCategoryClockModel
extends BranchRateModel.Base {
    public final Input<IntegerParameter> rateCatAssignInput = new Input("rateCatAssign", "the rate category for each node in the tree.", Input.Validate.REQUIRED);
    public final Input<RealParameter> rateValuesInput = new Input("rates", "the rate parameters associated with each category.", Input.Validate.REQUIRED);
    public final Input<Integer> nCatInput = new Input("nCat", "the number of rate categories.", Input.Validate.REQUIRED);
    public final Input<Tree> treeInput = new Input("tree", "the tree this relaxed clock is associated with.", Input.Validate.REQUIRED);
    Tree tree;

    public void initAndValidate() {
        this.tree = (Tree)this.treeInput.get();
        IntegerParameter integerParameter = (IntegerParameter)this.rateCatAssignInput.get();
        if (integerParameter.getDimension() != this.tree.getNodeCount()) {
            Log.warning.println("LocalStrictClockModel::Setting dimension of indicators to " + this.tree.getNodeCount());
            integerParameter.setDimension(this.tree.getNodeCount());
        }
        int n = (Integer)this.nCatInput.get();
        for (int i = 0; i < integerParameter.getDimension(); ++i) {
            if ((Integer)integerParameter.getValue(i) <= n) continue;
            Log.warning.println("Number of rate categories in assignment input exceeds the user-defined number of categories =" + n + " . Will fix that number.");
            n = (Integer)integerParameter.getValue(i) + 1;
        }
        RealParameter realParameter = (RealParameter)this.rateValuesInput.get();
        if (realParameter.lowerValueInput.get() == null || (Double)realParameter.lowerValueInput.get() < 0.0) {
            realParameter.setLower((Object)0.0);
        }
        if (realParameter.upperValueInput.get() == null || (Double)realParameter.upperValueInput.get() < 0.0) {
            realParameter.setUpper((Object)Double.MAX_VALUE);
        }
        if (realParameter.getDimension() != n) {
            Log.warning.println("RandomLocalClockModel::Setting dimension of rates to " + n);
            realParameter.setDimension(n);
        }
    }

    public double getRateForBranch(Node node) {
        int n = (Integer)((IntegerParameter)this.rateCatAssignInput.get()).getValue(node.getNr());
        return ((RealParameter)this.rateValuesInput.get()).getArrayValue(n);
    }

    public int getCatForBranch(Node node) {
        int n = (Integer)((IntegerParameter)this.rateCatAssignInput.get()).getValue(node.getNr());
        return n;
    }
}

