/*
 * Decompiled with CFR 0.152.
 */
package contraband.math;

import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class MatrixUtilsContra {
    public static RealMatrix matrixAdd(RealMatrix realMatrix, RealMatrix realMatrix2, RealMatrix realMatrix3) {
        if (realMatrix.getColumnDimension() == realMatrix2.getColumnDimension() && realMatrix.getRowDimension() == realMatrix2.getRowDimension() && realMatrix.getColumnDimension() == realMatrix3.getColumnDimension() && realMatrix.getRowDimension() == realMatrix3.getRowDimension()) {
            for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
                for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                    realMatrix3.setEntry(i, j, realMatrix.getEntry(i, j) + realMatrix2.getEntry(i, j));
                }
            }
        } else {
            throw new IllegalArgumentException("Dimension does not match in matrix add!");
        }
        return realMatrix3;
    }

    public static RealMatrix matrixSubtract(RealMatrix realMatrix, RealMatrix realMatrix2, RealMatrix realMatrix3) {
        if (realMatrix.getColumnDimension() == realMatrix2.getColumnDimension() && realMatrix.getRowDimension() == realMatrix2.getRowDimension() && realMatrix.getColumnDimension() == realMatrix3.getColumnDimension() && realMatrix.getRowDimension() == realMatrix3.getRowDimension()) {
            for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
                for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                    realMatrix3.setEntry(i, j, realMatrix.getEntry(i, j) - realMatrix2.getEntry(i, j));
                }
            }
        } else {
            throw new IllegalArgumentException("Dimension does not match in matrix subtract!");
        }
        return realMatrix3;
    }

    public static RealMatrix matrixMultiply(RealMatrix realMatrix, RealMatrix realMatrix2, RealMatrix realMatrix3) {
        if (realMatrix.getColumnDimension() == realMatrix2.getRowDimension() && realMatrix.getRowDimension() == realMatrix3.getRowDimension() && realMatrix2.getColumnDimension() == realMatrix3.getColumnDimension()) {
            for (int i = 0; i < realMatrix3.getRowDimension(); ++i) {
                for (int j = 0; j < realMatrix3.getColumnDimension(); ++j) {
                    double d = 0.0;
                    for (int k = 0; k < realMatrix2.getRowDimension(); ++k) {
                        d += realMatrix.getEntry(i, k) * realMatrix2.getEntry(k, j);
                    }
                    realMatrix3.setEntry(i, j, d);
                }
            }
        } else {
            throw new IllegalArgumentException("Dimension does not match in matrix multiply!");
        }
        return realMatrix3;
    }

    public static RealMatrix matrixScalarMultiply(RealMatrix realMatrix, double d, RealMatrix realMatrix2) {
        if (realMatrix.getColumnDimension() == realMatrix2.getColumnDimension() && realMatrix.getRowDimension() == realMatrix2.getRowDimension()) {
            for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
                for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                    realMatrix2.setEntry(i, j, realMatrix.getEntry(i, j) * d);
                }
            }
        } else {
            throw new IllegalArgumentException("Dimension does not match in matrix scalar multiply!");
        }
        return realMatrix2;
    }

    public static RealMatrix matrixScalarAdd(RealMatrix realMatrix, double d, RealMatrix realMatrix2) {
        if (realMatrix.getColumnDimension() == realMatrix2.getColumnDimension() && realMatrix.getRowDimension() == realMatrix2.getRowDimension()) {
            for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
                for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                    realMatrix2.setEntry(i, j, realMatrix.getEntry(i, j) + d);
                }
            }
        } else {
            throw new IllegalArgumentException("Dimension does not match in matrix scalar add!");
        }
        return realMatrix2;
    }

    public static RealMatrix matrixTranspose(RealMatrix realMatrix, RealMatrix realMatrix2) {
        if (realMatrix.getColumnDimension() == realMatrix2.getRowDimension() && realMatrix.getRowDimension() == realMatrix2.getColumnDimension()) {
            for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
                for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                    realMatrix2.setEntry(j, i, realMatrix.getEntry(i, j));
                }
            }
        } else {
            throw new IllegalArgumentException("Dimension does not match in matrix transpose!");
        }
        return realMatrix2;
    }

    public static double tVecDotMatrixDotVec(RealVector realVector, RealMatrix realMatrix) {
        double d = 0.0;
        for (int i = 0; i < realMatrix.getColumnDimension(); ++i) {
            double d2 = 0.0;
            for (int j = 0; j < realMatrix.getRowDimension(); ++j) {
                d2 += realVector.getEntry(j) * realMatrix.getEntry(i, j);
            }
            d += d2 * realVector.getEntry(i);
        }
        return d;
    }

    public static double tVecDotMatrixDotVec(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d2 += dArray[j] * dArray2[i * n + j];
            }
            d += d2 * dArray[i];
        }
        return d;
    }

    public static RealVector matrixPreMultiply(RealVector realVector, RealMatrix realMatrix, RealVector realVector2) {
        for (int i = 0; i < realMatrix.getColumnDimension(); ++i) {
            double d = 0.0;
            for (int j = 0; j < realMatrix.getRowDimension(); ++j) {
                d += realVector.getEntry(j) * realMatrix.getEntry(i, j);
            }
            realVector2.setEntry(i, d);
        }
        return realVector2;
    }

    public static double[] matrixPreMultiply(double[] dArray, double[] dArray2, int n, int n2, double[] dArray3) {
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += dArray[j] * dArray2[j * n + i];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    public static RealVector vectorMapMultiply(RealVector realVector, double d, RealVector realVector2) {
        for (int i = 0; i < realVector.getDimension(); ++i) {
            realVector2.setEntry(i, realVector.getEntry(i) * d);
        }
        return realVector2;
    }

    public static double[] vectorMapMultiply(double[] dArray, double d, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public static RealVector vectorAdd(RealVector realVector, RealVector realVector2, RealVector realVector3) {
        for (int i = 0; i < realVector.getDimension(); ++i) {
            realVector3.setEntry(i, realVector.getEntry(i) + realVector2.getEntry(i));
        }
        return realVector3;
    }

    public static void elementWiseProduct(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[i][j] = dArray[i][j] * dArray2[i][j];
            }
        }
    }

    public static void kronecker(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        dArray3[i * n3 + k][j * n4 + i2] = dArray[i][j] * dArray2[k][i2];
                    }
                }
            }
        }
    }

    public static void scalarByRealMatrix(RealMatrix realMatrix, double d) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                realMatrix.multiplyEntry(i, j, d);
            }
        }
    }

    public static int[] forLoopRange(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n++;
        }
        return nArray;
    }

    public static void setBlocksInMatrix(double[][] dArray, int n, int n2, int n3, double[][] dArray2) {
        int n4 = 0;
        int n5 = 0;
        int[] nArray = MatrixUtilsContra.forLoopRange(n2 * n, n);
        System.out.println(" Numero de filas filas " + nArray.length);
        int[] nArray2 = MatrixUtilsContra.forLoopRange(n3 * n, n);
        System.out.println(" Numero de columnas " + nArray2.length);
        for (int n6 : nArray) {
            for (int n7 : nArray2) {
                System.out.println(n7);
                dArray2[n6][n7] = dArray[n4][n5];
                System.out.println("row = " + n6 + ",col = " + n7);
                ++n5;
            }
            n5 = 0;
            ++n4;
        }
    }

    public static void setMatrixRow(double[] dArray, double[] dArray2, int n, int n2) {
        System.arraycopy(dArray2, 0, dArray, n * n2, n2);
    }

    public static void getMatrixRow(double[] dArray, int n, int n2, double[] dArray2) {
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = MatrixUtilsContra.getMatrixEntry(dArray, n, i, n2);
        }
    }

    public static double getMatrixEntry(double[] dArray, int n, int n2, int n3) {
        return dArray[n * n3 + n2];
    }

    public static double[] vectorAdd(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static void setMatrixEntry(double[] dArray, int n, int n2, double d, int n3) {
        dArray[n * n3 + n2] = d;
    }

    public static double vecTransScalarMultiply(double[] dArray, double d, int n) {
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += dArray[i] * dArray[i];
        }
        return d2 * d;
    }

    public static double vectorDotMultiply(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] matrixTranspose(double[] dArray, int n, double[] dArray2) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                MatrixUtilsContra.setMatrixEntry(dArray2, j, i, MatrixUtilsContra.getMatrixEntry(dArray, i, j, n), n);
            }
        }
        return dArray2;
    }

    public static double[] matrixMultiply(double[] dArray, double[] dArray2, int n, int n2, double[] dArray3) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d += MatrixUtilsContra.getMatrixEntry(dArray, i, k, n2) * MatrixUtilsContra.getMatrixEntry(dArray2, k, j, n2);
                }
                MatrixUtilsContra.setMatrixEntry(dArray3, i, j, d, n2);
            }
        }
        return dArray3;
    }
}

