/*
 * Decompiled with CFR 0.152.
 */
package contraband.mvnlikelihood;

import beast.base.core.Citation;
import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.inference.Distribution;
import beast.base.inference.util.InputUtil;
import contraband.coalescent.CoalCorrection;
import contraband.utils.MVNUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

@Description(value="Matrix algebra engine for continuous trait evolutionary models.  Used by Brownian motion and Ornstein-Uhlenbeck classes.")
@Citation(value="Felsenstein, J (1985). Maximum-likelihood estimation of evolutionary trees from continuous characters. Am. J. Hum. Genet. 25, 471-492.", DOI="PMCID: PMC1762641", year=1985, firstAuthorSurname="Felsenstein")
public abstract class MVNProcessOneTrait
extends Distribution {
    public final Input<Tree> treeInput = new Input("tree", "Tree object containing tree.", Input.Validate.REQUIRED);
    public final Input<Double> rootEdgeLengthInput = new Input("rootEdgeLength", "Root edge length.", (Object)0.0, Input.Validate.OPTIONAL);
    public final Input<Boolean> doCoalCorrectionInput = new Input("doCoalCorrection", "Whether or not to perform coalescent correction.", (Object)false, Input.Validate.REQUIRED);
    public final Input<CoalCorrection> coalCorrectionInput = new Input("coalCorrector", "Calculation node that produces a phylogenetic T matrix from tree and (constant) population sizes of its branches.", Input.Validate.OPTIONAL);
    private boolean dirty;
    private boolean matrixWasSingularCantInvertBarf;
    private Tree tree;
    private int nSpp;
    private CoalCorrection coal;
    private double[] nodeToRootPaths;
    private List<Node> leftLeaves;
    private List<Node> rightLeaves;
    private String[] spNamesInPhyloTMatOrder;
    private double[][] phyloTMatDouble;
    private RealMatrix phyloTMat;
    private RealMatrix phyloWTMat;
    private RealVector expAtTipVec;
    private RealMatrix invVCVMat;
    private double detVCVMat;
    private RealMatrix ancNodeVCVMat;
    private RealVector oneTraitDataVector;
    private String[] storedSpNamesInPhyloTMatOrder;
    private RealVector storedOneTraitDataVector = new ArrayRealVector(this.nSpp);
    private RealVector storedExpAtTipVec;
    private RealMatrix storedPhyloTMat;
    private double[][] storedPhyloTMatDouble;
    private RealMatrix storedInvVCVMat;
    private double storedDetVCVMat;

    public void initAndValidate() {
        this.tree = (Tree)this.treeInput.get();
        this.nSpp = this.tree.getLeafNodeCount();
        this.nodeToRootPaths = new double[this.tree.getNodeCount()];
        this.leftLeaves = new ArrayList<Node>();
        this.rightLeaves = new ArrayList<Node>();
        this.spNamesInPhyloTMatOrder = new String[this.nSpp];
        this.phyloTMatDouble = new double[this.nSpp][this.nSpp];
        this.phyloTMat = MatrixUtils.createRealMatrix((double[][])this.phyloTMatDouble);
        this.phyloWTMat = MatrixUtils.createRealMatrix((int)this.tree.getInternalNodeCount(), (int)this.nSpp);
        this.coal = null;
        if (((Boolean)this.doCoalCorrectionInput.get()).booleanValue()) {
            this.coal = (CoalCorrection)((Object)this.coalCorrectionInput.get());
        }
        this.storedSpNamesInPhyloTMatOrder = new String[this.nSpp];
        this.storedOneTraitDataVector = new ArrayRealVector(this.nSpp);
        this.storedExpAtTipVec = new ArrayRealVector(this.nSpp);
        this.storedPhyloTMat = MatrixUtils.createRealMatrix((int)this.nSpp, (int)this.nSpp);
        this.storedInvVCVMat = MatrixUtils.createRealMatrix((int)this.nSpp, (int)this.nSpp);
        this.storedPhyloTMatDouble = new double[this.nSpp][this.nSpp];
    }

    protected void populatePhyloTMatrix() {
        Double d = (Double)this.rootEdgeLengthInput.get();
        if (((Boolean)this.doCoalCorrectionInput.get()).booleanValue()) {
            this.phyloTMatDouble = this.coal.getCorrectedPhyloTMat(this.spNamesInPhyloTMatOrder);
        } else {
            MVNUtils.populateTMatrix(this.tree, this.nodeToRootPaths, this.phyloTMatDouble, this.leftLeaves, this.rightLeaves, this.spNamesInPhyloTMatOrder);
        }
        for (int i = 0; i < this.nSpp; ++i) {
            for (int j = 0; j < this.nSpp; ++j) {
                this.phyloTMat.setEntry(i, j, this.phyloTMatDouble[i][j]);
                if (d == 0.0) continue;
                this.phyloTMat.addToEntry(i, j, d.doubleValue());
            }
        }
    }

    protected void populateAncNodePhyloTMatrix() {
        MVNUtils.populateAncNodePhyloTMatrix(this.tree, this.phyloWTMat);
    }

    protected void populateExpAtTipVector() {
    }

    protected void populateVCVMatrix() {
    }

    protected void populateInvVCVMatrix() {
    }

    protected void populateOneTraitDataVector() {
    }

    protected void populateWMatrix() {
    }

    protected void populateAncNodeVCVMatrix() {
    }

    protected void populateLogP() {
        this.logP = this.matrixWasSingularCantInvertBarf || this.detVCVMat == 0.0 ? Double.NEGATIVE_INFINITY : MVNUtils.getMVNLogLk(this.nSpp, this.expAtTipVec, this.oneTraitDataVector, this.invVCVMat, this.detVCVMat);
    }

    protected Tree getTree() {
        return this.tree;
    }

    protected int getNSpp() {
        return this.nSpp;
    }

    protected Node getRootNode() {
        return this.tree.getRoot();
    }

    protected List<Node> getAllLeafNodes() {
        return ((Tree)this.treeInput.get()).getRoot().getAllLeafNodes();
    }

    protected String[] getSpNamesInPhyloTMatOrder() {
        return this.spNamesInPhyloTMatOrder;
    }

    protected double[][] getPhyloTMatDouble() {
        return this.phyloTMatDouble;
    }

    protected RealMatrix getPhyloTMat() {
        return this.phyloTMat;
    }

    protected double getLogP() {
        return this.logP;
    }

    protected void setProcessLUDec(LUDecomposition lUDecomposition) {
        this.detVCVMat = lUDecomposition.getDeterminant();
    }

    protected void setProcessInvVCVMat(RealMatrix realMatrix) {
        this.invVCVMat = realMatrix;
    }

    protected void setProcessMeanVec(RealVector realVector) {
        this.expAtTipVec = realVector;
    }

    protected void setProcessOneTraitDataVec(RealVector realVector) {
        this.oneTraitDataVector = realVector;
    }

    protected void setProcessAncNodeVCVMatrix(RealMatrix realMatrix) {
        this.ancNodeVCVMat = realMatrix;
    }

    protected void setMatrixIsSingular(boolean bl) {
        this.matrixWasSingularCantInvertBarf = bl;
    }

    public boolean requiresRecalculation() {
        this.dirty = false;
        if (InputUtil.isDirty(this.treeInput) || InputUtil.isDirty(this.rootEdgeLengthInput) || ((Boolean)this.doCoalCorrectionInput.get()).booleanValue() && InputUtil.isDirty(this.coalCorrectionInput)) {
            this.dirty = true;
        }
        return true;
    }

    public void store() {
        System.arraycopy(this.spNamesInPhyloTMatOrder, 0, this.storedSpNamesInPhyloTMatOrder, 0, this.spNamesInPhyloTMatOrder.length);
        for (int i = 0; i < this.nSpp; ++i) {
            this.storedOneTraitDataVector.setEntry(i, this.oneTraitDataVector.getEntry(i));
            this.storedExpAtTipVec.setEntry(i, this.expAtTipVec.getEntry(i));
            System.arraycopy(this.phyloTMatDouble[i], 0, this.storedPhyloTMatDouble[i], 0, this.phyloTMatDouble[i].length);
            for (int j = 0; j < this.nSpp; ++j) {
                this.storedPhyloTMat.setEntry(i, j, this.phyloTMat.getEntry(i, j));
                this.storedInvVCVMat.setEntry(i, j, this.invVCVMat.getEntry(i, j));
            }
        }
        this.storedDetVCVMat = this.detVCVMat;
        this.storedLogP = this.logP;
    }

    public void restore() {
        RealVector realVector = this.oneTraitDataVector;
        this.oneTraitDataVector = this.storedOneTraitDataVector;
        this.storedOneTraitDataVector = realVector;
        realVector = this.expAtTipVec;
        this.expAtTipVec = this.storedExpAtTipVec;
        this.storedExpAtTipVec = realVector;
        RealMatrix realMatrix = this.phyloTMat;
        this.phyloTMat = this.storedPhyloTMat;
        this.storedPhyloTMat = realMatrix;
        realMatrix = this.invVCVMat;
        this.invVCVMat = this.storedInvVCVMat;
        this.storedInvVCVMat = realMatrix;
        double[][] dArray = this.phyloTMatDouble;
        this.phyloTMatDouble = this.storedPhyloTMatDouble;
        this.storedPhyloTMatDouble = dArray;
        this.detVCVMat = this.storedDetVCVMat;
        String[] stringArray = this.spNamesInPhyloTMatOrder;
        this.spNamesInPhyloTMatOrder = this.storedSpNamesInPhyloTMatOrder;
        this.storedSpNamesInPhyloTMatOrder = stringArray;
        this.logP = this.storedLogP;
    }
}

