/*
 * Decompiled with CFR 0.152.
 */
package contraband.operators;

import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.evolution.tree.Tree;
import beast.base.inference.Operator;
import beast.base.inference.parameter.BooleanParameter;
import beast.base.inference.parameter.RealParameter;
import beast.base.util.Randomizer;
import contraband.clock.RandomLocalColorModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Description(value="Selects a trait to operate on with a random walk. With probability p it will choose a trait associated with an indicator of 1, otherwise it will choose a trait associated with an indicator of 0.")
public class RandomLocalTraitOperator
extends Operator {
    public final Input<BooleanParameter> shiftIndicatorsInput = new Input("shiftIndicators", "the boolean indicator parameter, with one boolean per node (without root).", Input.Validate.REQUIRED);
    public final Input<RealParameter> traitsInput = new Input("traits", "the trait (rate, optimum, etc.) associated with each tree node (including root).", Input.Validate.REQUIRED);
    public final Input<RandomLocalColorModel> randomColorModelInput = new Input("randomColorModel", "the random color model on whose parameters to operate.", Input.Validate.REQUIRED);
    public final Input<Double> pInput = new Input("p", "The probability of choosing a trait with an associated 1 (including the root trait when applicable).", (Object)0.5, Input.Validate.OPTIONAL);
    public final Input<Double> windowSizeInput = new Input("windowSize", "the size of the window both up and down.", Input.Validate.REQUIRED);
    List<Integer> onPositions = new ArrayList<Integer>();
    List<Integer> offPositions = new ArrayList<Integer>();
    RandomLocalColorModel rlcModel;
    BooleanParameter indicatorParam;
    RealParameter traitParam;
    double windowSize = 1.0;

    public void initAndValidate() {
        this.rlcModel = (RandomLocalColorModel)((Object)this.randomColorModelInput.get());
        this.indicatorParam = (BooleanParameter)this.shiftIndicatorsInput.get();
        this.traitParam = (RealParameter)this.traitsInput.get();
        this.windowSize = (Double)this.windowSizeInput.get();
    }

    public double proposal() {
        this.populateOnOffPositions();
        if (Randomizer.nextDouble() < (Double)this.pInput.get()) {
            int n = Randomizer.nextInt((int)this.onPositions.size());
            return this.proposeNewTrait(this.onPositions.get(n));
        }
        int n = Randomizer.nextInt((int)this.offPositions.size());
        return this.proposeNewTrait(this.offPositions.get(n));
    }

    private double proposeNewTrait(int n) {
        double d = (Double)this.traitParam.getValue(n);
        double d2 = d + Randomizer.nextDouble() * 2.0 * this.windowSize - this.windowSize;
        if (d2 < (Double)this.traitParam.getLower() || d2 > (Double)this.traitParam.getUpper()) {
            return Double.NEGATIVE_INFINITY;
        }
        this.traitParam.setValue(n, (Object)d2);
        return 0.0;
    }

    private void populateOnOffPositions() {
        this.onPositions.clear();
        this.offPositions.clear();
        if (((Boolean)this.rlcModel.includeRootInput.get()).booleanValue()) {
            this.onPositions.add(((Tree)this.rlcModel.treeInput.get()).getRoot().getNr());
        }
        for (int i = 0; i < this.indicatorParam.getDimension(); ++i) {
            if (((Boolean)this.indicatorParam.getValue(i)).booleanValue()) {
                this.onPositions.add(i);
                continue;
            }
            this.offPositions.add(i);
        }
    }

    public double getCoercableParameterValue() {
        return this.windowSize;
    }

    public void setCoercableParameterValue(double d) {
        this.windowSize = d;
    }

    public void optimize(double d) {
        double d2 = this.calcDelta(d);
        this.windowSize = Math.exp(d2 += Math.log(this.windowSize));
    }

    public final String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = this.windowSize * d3;
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting window size to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting window size to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

