/*
 * Decompiled with CFR 0.152.
 */
package contraband.otherlikelihood;

import beast.base.core.Description;
import beast.base.core.Input;
import beast.base.inference.Distribution;
import beast.base.inference.State;
import beast.base.inference.parameter.IntegerParameter;
import beast.base.inference.parameter.RealParameter;
import beast.base.inference.util.InputUtil;
import contraband.utils.MVNUtils;
import java.util.List;
import java.util.Random;

@Description(value="This is the likelihood for the white noise (WN) model.This model assumes that the each species data comes from a normal distribution.The normal distribution can be set to be the same for all species, or different for all species.Note that under WN, we are basically saying that the trait data does not evolve along a tree(or, if we want to think it in tree terms, it evolves along a star tree).")
public class WNLikelihoodOneTrait
extends Distribution {
    public final Input<RealParameter> sigmaSqsInput = new Input("sigmaSqs", "Sigma^2 of each species' normal density.", Input.Validate.REQUIRED);
    public final Input<RealParameter> meansInput = new Input("mus", "Means of each species' normal density.", Input.Validate.REQUIRED);
    public final Input<IntegerParameter> normalAssignmentsInput = new Input("normalAssignments", "Which normal density each species has.", Input.Validate.REQUIRED);
    public final Input<RealParameter> oneTraitInput = new Input("oneTraitData", "continuous data values for one trait.", Input.Validate.REQUIRED);
    private Double[] oneTraitDataArr;
    private Double[] mus;
    private Double[] sigmaSqs;
    private Double[] storedOneTraitDataArr;

    public void initAndValidate() {
        super.initAndValidate();
        RealParameter realParameter = (RealParameter)this.oneTraitInput.get();
        this.oneTraitDataArr = (Double[])realParameter.getValues();
        int n = realParameter.getMinorDimension2();
        this.mus = new Double[n];
        this.sigmaSqs = new Double[n];
        this.storedOneTraitDataArr = new Double[n];
    }

    public double calculateLogP() {
        boolean bl = false;
        if (InputUtil.isDirty(this.oneTraitInput)) {
            bl = true;
        }
        this.populateSampleData(bl);
        Integer[] integerArray = (Integer[])((IntegerParameter)this.normalAssignmentsInput.get()).getValues();
        Double[] doubleArray = (Double[])((RealParameter)this.sigmaSqsInput.get()).getValues();
        Double[] doubleArray2 = (Double[])((RealParameter)this.meansInput.get()).getValues();
        int n = 0;
        for (Integer n2 : integerArray) {
            this.mus[n] = doubleArray2[n2];
            this.sigmaSqs[n] = doubleArray[n2];
            ++n;
        }
        this.logP = MVNUtils.getSampleMultipleNormalLogLk(this.oneTraitDataArr, this.mus, this.sigmaSqs);
        return this.logP;
    }

    private void populateSampleData(boolean bl) {
        if (bl) {
            RealParameter realParameter = (RealParameter)this.oneTraitInput.get();
            this.oneTraitDataArr = (Double[])realParameter.getValues();
        }
    }

    public boolean requiresRecalculation() {
        boolean bl = true;
        return bl;
    }

    public void store() {
        System.arraycopy(this.oneTraitDataArr, 0, this.storedOneTraitDataArr, 0, this.oneTraitDataArr.length);
    }

    public void restore() {
        Double[] doubleArray = this.oneTraitDataArr;
        this.oneTraitDataArr = this.storedOneTraitDataArr;
        this.storedOneTraitDataArr = doubleArray;
    }

    public List<String> getArguments() {
        return null;
    }

    public List<String> getConditions() {
        return null;
    }

    public void sample(State state, Random random) {
    }
}

