/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.evolution.tree.TreeParser;
import contraband.utils.MVNUtils;
import contraband.utils.OUUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.junit.Assert;
import org.junit.Test;

public class OUMVNLikelihoodOneTraitFromUtilsTest {
    static final double EPSILON = 1.0E-4;
    private static double ouLik1FI;
    private static double ouLik1FM;
    private static double ouLik1RI;
    private static double ouLik1RM;
    private static double ouLik2FI;
    private static double ouLik2FM;
    private static double ouLik2RI;
    private static double ouLik2RM;
    private static double ouLik3FI;
    private static double ouLik3FM;
    private static double ouLik3RI;
    private static double ouLik3RM;

    @Test
    public void testComputeOULikSmallTreeThreeOpt() {
        String string = "(((sp1:1.0,sp2:1.0):1.0,sp3:2.0):1.0,sp4:3.0);";
        Integer[] integerArray = new Integer[]{1, 1, 2, 0, 1, 0, 0, 0};
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        List list = treeParser.getRoot().getAllLeafNodes();
        double[] dArray = new double[]{4.1, 4.5, 5.9, 0.0};
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        double d = 31.20814;
        double d2 = 31.20814;
        double d3 = 43.35287;
        double d4 = 43.35287;
        double d5 = 1.248328;
        double d6 = 1.248328;
        double d7 = 1.734117;
        double d8 = 1.734117;
        double[] dArray2 = new double[]{2.228585E-40, -4.047373E-16, 4.3, 5.9};
        double[] dArray3 = new double[]{8.128044E-27, 4.3, 5.9};
        double[] dArray4 = new double[]{3.348633E-56, -1.90333E-16, 4.3, 5.9};
        double[] dArray5 = new double[]{2.297268E-37, 4.3, 5.9};
        int n = treeParser.getLeafNodeCount();
        double[][] dArray6 = new double[n][n];
        double[] dArray7 = new double[treeParser.getNodeCount()];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        String[] stringArray = new String[n];
        MVNUtils.populateTMatrix((Tree)treeParser, dArray7, dArray6, arrayList, arrayList2, stringArray);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix4 = new Array2DRowRealMatrix(n, n);
        OUUtils.computeOUTMatOneTrait(n, d, dArray6, (RealMatrix)array2DRowRealMatrix, true);
        OUUtils.computeOUTMatOneTrait(n, d2, dArray6, (RealMatrix)array2DRowRealMatrix2, true);
        OUUtils.computeOUTMatOneTrait(n, d3, dArray6, (RealMatrix)array2DRowRealMatrix3, false);
        OUUtils.computeOUTMatOneTrait(n, d4, dArray6, (RealMatrix)array2DRowRealMatrix4, false);
        Array2DRowRealMatrix array2DRowRealMatrix5 = new Array2DRowRealMatrix(n, 4);
        Array2DRowRealMatrix array2DRowRealMatrix6 = new Array2DRowRealMatrix(n, 3);
        Array2DRowRealMatrix array2DRowRealMatrix7 = new Array2DRowRealMatrix(n, 4);
        Array2DRowRealMatrix array2DRowRealMatrix8 = new Array2DRowRealMatrix(n, 3);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 3, d, (RealMatrix)array2DRowRealMatrix5, true);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 3, d2, (RealMatrix)array2DRowRealMatrix6, false);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 3, d3, (RealMatrix)array2DRowRealMatrix7, true);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 3, d4, (RealMatrix)array2DRowRealMatrix8, false);
        LUDecomposition lUDecomposition = new LUDecomposition((RealMatrix)array2DRowRealMatrix);
        RealMatrix realMatrix = lUDecomposition.getSolver().getInverse();
        RealMatrix realMatrix2 = realMatrix.scalarMultiply(1.0 / d5);
        double d9 = Math.pow(d5, n) * lUDecomposition.getDeterminant();
        LUDecomposition lUDecomposition2 = new LUDecomposition((RealMatrix)array2DRowRealMatrix2);
        RealMatrix realMatrix3 = lUDecomposition2.getSolver().getInverse();
        RealMatrix realMatrix4 = realMatrix3.scalarMultiply(1.0 / d6);
        double d10 = Math.pow(d6, n) * lUDecomposition2.getDeterminant();
        LUDecomposition lUDecomposition3 = new LUDecomposition((RealMatrix)array2DRowRealMatrix3);
        RealMatrix realMatrix5 = lUDecomposition3.getSolver().getInverse();
        RealMatrix realMatrix6 = realMatrix5.scalarMultiply(1.0 / d7);
        double d11 = Math.pow(d7, n) * lUDecomposition3.getDeterminant();
        LUDecomposition lUDecomposition4 = new LUDecomposition((RealMatrix)array2DRowRealMatrix4);
        RealMatrix realMatrix7 = lUDecomposition4.getSolver().getInverse();
        RealMatrix realMatrix8 = realMatrix7.scalarMultiply(1.0 / d8);
        double d12 = Math.pow(d8, n) * lUDecomposition4.getDeterminant();
        ArrayRealVector arrayRealVector2 = new ArrayRealVector(dArray2);
        ArrayRealVector arrayRealVector3 = new ArrayRealVector(dArray3);
        ArrayRealVector arrayRealVector4 = new ArrayRealVector(dArray4);
        ArrayRealVector arrayRealVector5 = new ArrayRealVector(dArray5);
        ouLik1FI = MVNUtils.getMVNLk(n, array2DRowRealMatrix5.operate((RealVector)arrayRealVector2), (RealVector)arrayRealVector, realMatrix2, d9);
        ouLik1FM = MVNUtils.getMVNLk(n, array2DRowRealMatrix6.operate((RealVector)arrayRealVector3), (RealVector)arrayRealVector, realMatrix4, d10);
        ouLik1RI = MVNUtils.getMVNLk(n, array2DRowRealMatrix7.operate((RealVector)arrayRealVector4), (RealVector)arrayRealVector, realMatrix6, d11);
        ouLik1RM = MVNUtils.getMVNLk(n, array2DRowRealMatrix8.operate((RealVector)arrayRealVector5), (RealVector)arrayRealVector, realMatrix8, d12);
        Assert.assertEquals((double)2.148292, (double)Math.log(ouLik1FI), (double)1.0E-4);
        Assert.assertEquals((double)2.148292, (double)Math.log(ouLik1FM), (double)1.0E-4);
        Assert.assertEquals((double)2.148292, (double)Math.log(ouLik1RI), (double)1.0E-4);
        Assert.assertEquals((double)2.148292, (double)Math.log(ouLik1RM), (double)1.0E-4);
    }

    @Test
    public void testComputeOULikSmallTreeNonUltraOneOpt() {
        String string = "(((sp1:2.0,sp2:1.0):1.0,sp3:4.0):1.0,sp4:3.0);";
        Integer[] integerArray = new Integer[]{0, 0, 0, 0, 0, 0, 0, 0};
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        List list = treeParser.getRoot().getAllLeafNodes();
        double[] dArray = new double[]{4.1, 4.5, 5.9, 0.0};
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        double d = 0.7465763;
        double d2 = 1.40338E-8;
        double d3 = 0.8609833;
        double d4 = 0.7085376;
        double d5 = 4.003551;
        double d6 = 1.237864;
        double d7 = 4.601164;
        double d8 = 6.841867;
        double[] dArray2 = new double[]{-33.591241, 6.449917};
        double[] dArray3 = new double[]{2.792045};
        double[] dArray4 = new double[]{-46.965464, 6.201598};
        double[] dArray5 = new double[]{3.586504};
        int n = treeParser.getLeafNodeCount();
        double[][] dArray6 = new double[n][n];
        double[] dArray7 = new double[treeParser.getNodeCount()];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        String[] stringArray = new String[n];
        MVNUtils.populateTMatrix((Tree)treeParser, dArray7, dArray6, arrayList, arrayList2, stringArray);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix4 = new Array2DRowRealMatrix(n, n);
        OUUtils.computeOUTMatOneTrait(n, d, dArray6, (RealMatrix)array2DRowRealMatrix, false);
        OUUtils.computeOUTMatOneTrait(n, d2, dArray6, (RealMatrix)array2DRowRealMatrix2, false);
        OUUtils.computeOUTMatOneTrait(n, d3, dArray6, (RealMatrix)array2DRowRealMatrix3, true);
        OUUtils.computeOUTMatOneTrait(n, d4, dArray6, (RealMatrix)array2DRowRealMatrix4, true);
        Array2DRowRealMatrix array2DRowRealMatrix5 = new Array2DRowRealMatrix(n, 2);
        Array2DRowRealMatrix array2DRowRealMatrix6 = new Array2DRowRealMatrix(n, 1);
        Array2DRowRealMatrix array2DRowRealMatrix7 = new Array2DRowRealMatrix(n, 2);
        Array2DRowRealMatrix array2DRowRealMatrix8 = new Array2DRowRealMatrix(n, 1);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 1, d, (RealMatrix)array2DRowRealMatrix5, true);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 1, d2, (RealMatrix)array2DRowRealMatrix6, false);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 1, d3, (RealMatrix)array2DRowRealMatrix7, true);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 1, d4, (RealMatrix)array2DRowRealMatrix8, false);
        LUDecomposition lUDecomposition = new LUDecomposition((RealMatrix)array2DRowRealMatrix);
        RealMatrix realMatrix = lUDecomposition.getSolver().getInverse();
        RealMatrix realMatrix2 = realMatrix.scalarMultiply(1.0 / d5);
        double d9 = Math.pow(d5, n) * lUDecomposition.getDeterminant();
        LUDecomposition lUDecomposition2 = new LUDecomposition((RealMatrix)array2DRowRealMatrix2);
        RealMatrix realMatrix3 = lUDecomposition2.getSolver().getInverse();
        RealMatrix realMatrix4 = realMatrix3.scalarMultiply(1.0 / d6);
        double d10 = Math.pow(d6, n) * lUDecomposition2.getDeterminant();
        LUDecomposition lUDecomposition3 = new LUDecomposition((RealMatrix)array2DRowRealMatrix3);
        RealMatrix realMatrix5 = lUDecomposition3.getSolver().getInverse();
        RealMatrix realMatrix6 = realMatrix5.scalarMultiply(1.0 / d7);
        double d11 = Math.pow(d7, n) * lUDecomposition3.getDeterminant();
        LUDecomposition lUDecomposition4 = new LUDecomposition((RealMatrix)array2DRowRealMatrix4);
        RealMatrix realMatrix7 = lUDecomposition4.getSolver().getInverse();
        RealMatrix realMatrix8 = realMatrix7.scalarMultiply(1.0 / d8);
        double d12 = Math.pow(d8, n) * lUDecomposition4.getDeterminant();
        ArrayRealVector arrayRealVector2 = new ArrayRealVector(dArray2);
        ArrayRealVector arrayRealVector3 = new ArrayRealVector(dArray3);
        ArrayRealVector arrayRealVector4 = new ArrayRealVector(dArray4);
        ArrayRealVector arrayRealVector5 = new ArrayRealVector(dArray5);
        ouLik2FI = MVNUtils.getMVNLk(n, array2DRowRealMatrix5.operate((RealVector)arrayRealVector2), (RealVector)arrayRealVector, realMatrix2, d9);
        ouLik2FM = MVNUtils.getMVNLk(n, array2DRowRealMatrix6.operate((RealVector)arrayRealVector3), (RealVector)arrayRealVector, realMatrix4, d10);
        ouLik2RI = MVNUtils.getMVNLk(n, array2DRowRealMatrix7.operate((RealVector)arrayRealVector4), (RealVector)arrayRealVector, realMatrix6, d11);
        ouLik2RM = MVNUtils.getMVNLk(n, array2DRowRealMatrix8.operate((RealVector)arrayRealVector5), (RealVector)arrayRealVector, realMatrix8, d12);
        Assert.assertEquals((double)-7.630117, (double)Math.log(ouLik2FI), (double)1.0E-4);
        Assert.assertEquals((double)-8.457486, (double)Math.log(ouLik2FM), (double)1.0E-4);
        Assert.assertEquals((double)-7.63854, (double)Math.log(ouLik2RI), (double)1.0E-4);
        Assert.assertEquals((double)-8.817273, (double)Math.log(ouLik2RM), (double)1.0E-4);
    }

    @Test
    public void testComputeOULikLargeTreeNonUltraFiveOpt() {
        String string = "(((((sp1[&Regime=1]:1.0, sp2[&Regime=1]:1.0)[&Regime=1]:1.0, sp3[&Regime=0]:1.0)[&Regime=0]:2.0, (sp4[&Regime=2]:1.0, sp5[&Regime=2]:1.0)[&Regime=2]:3.0)[&Regime=0]:2.0, sp6[&Regime=3]:6.0)[&Regime=0]:1.0, sp7[&Regime=4]:3.0)[&Regime=0];";
        Integer[] integerArray = new Integer[]{1, 1, 0, 2, 2, 3, 4, 0, 1, 0, 2, 0, 0, 0};
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        List list = treeParser.getRoot().getAllLeafNodes();
        double[] dArray = new double[]{4.1, 4.5, 5.9, 0.0, 3.2, 2.5, 5.4};
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        double d = 7.142986;
        double d2 = 7.142986;
        double d3 = 7.84511;
        double d4 = 7.84511;
        double d5 = 10.61289;
        double d6 = 10.61289;
        double d7 = 11.65586;
        double d8 = 11.65586;
        double[] dArray2 = new double[]{2.666338E-9, 5.9, 4.299999, 1.6, 2.5, 5.4};
        double[] dArray3 = new double[]{5.9, 4.299999, 1.6, 2.5, 5.4};
        double[] dArray4 = new double[]{3.244364E-10, 5.9, 4.3, 1.6, 2.5, 5.4};
        double[] dArray5 = new double[]{5.9, 4.3, 1.6, 2.5, 5.4};
        int n = treeParser.getLeafNodeCount();
        double[][] dArray6 = new double[n][n];
        double[] dArray7 = new double[treeParser.getNodeCount()];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        String[] stringArray = new String[n];
        MVNUtils.populateTMatrix((Tree)treeParser, dArray7, dArray6, arrayList, arrayList2, stringArray);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix3 = new Array2DRowRealMatrix(n, n);
        Array2DRowRealMatrix array2DRowRealMatrix4 = new Array2DRowRealMatrix(n, n);
        OUUtils.computeOUTMatOneTrait(n, d, dArray6, (RealMatrix)array2DRowRealMatrix, true);
        OUUtils.computeOUTMatOneTrait(n, d2, dArray6, (RealMatrix)array2DRowRealMatrix2, true);
        OUUtils.computeOUTMatOneTrait(n, d3, dArray6, (RealMatrix)array2DRowRealMatrix3, false);
        OUUtils.computeOUTMatOneTrait(n, d4, dArray6, (RealMatrix)array2DRowRealMatrix4, false);
        Array2DRowRealMatrix array2DRowRealMatrix5 = new Array2DRowRealMatrix(n, 6);
        Array2DRowRealMatrix array2DRowRealMatrix6 = new Array2DRowRealMatrix(n, 5);
        Array2DRowRealMatrix array2DRowRealMatrix7 = new Array2DRowRealMatrix(n, 6);
        Array2DRowRealMatrix array2DRowRealMatrix8 = new Array2DRowRealMatrix(n, 5);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 5, d, (RealMatrix)array2DRowRealMatrix5, true);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 5, d2, (RealMatrix)array2DRowRealMatrix6, false);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 5, d3, (RealMatrix)array2DRowRealMatrix7, true);
        OUUtils.computeWMatOneTrait(integerArray, treeParser.getRoot(), list, n, 5, d4, (RealMatrix)array2DRowRealMatrix8, false);
        LUDecomposition lUDecomposition = new LUDecomposition((RealMatrix)array2DRowRealMatrix);
        RealMatrix realMatrix = lUDecomposition.getSolver().getInverse();
        RealMatrix realMatrix2 = realMatrix.scalarMultiply(1.0 / d5);
        double d9 = Math.pow(d5, n) * lUDecomposition.getDeterminant();
        LUDecomposition lUDecomposition2 = new LUDecomposition((RealMatrix)array2DRowRealMatrix2);
        RealMatrix realMatrix3 = lUDecomposition2.getSolver().getInverse();
        RealMatrix realMatrix4 = realMatrix3.scalarMultiply(1.0 / d6);
        double d10 = Math.pow(d6, n) * lUDecomposition2.getDeterminant();
        LUDecomposition lUDecomposition3 = new LUDecomposition((RealMatrix)array2DRowRealMatrix3);
        RealMatrix realMatrix5 = lUDecomposition3.getSolver().getInverse();
        RealMatrix realMatrix6 = realMatrix5.scalarMultiply(1.0 / d7);
        double d11 = Math.pow(d7, n) * lUDecomposition3.getDeterminant();
        LUDecomposition lUDecomposition4 = new LUDecomposition((RealMatrix)array2DRowRealMatrix4);
        RealMatrix realMatrix7 = lUDecomposition4.getSolver().getInverse();
        RealMatrix realMatrix8 = realMatrix7.scalarMultiply(1.0 / d8);
        double d12 = Math.pow(d8, n) * lUDecomposition4.getDeterminant();
        ArrayRealVector arrayRealVector2 = new ArrayRealVector(dArray2);
        ArrayRealVector arrayRealVector3 = new ArrayRealVector(dArray3);
        ArrayRealVector arrayRealVector4 = new ArrayRealVector(dArray4);
        ArrayRealVector arrayRealVector5 = new ArrayRealVector(dArray5);
        ouLik3FI = MVNUtils.getMVNLk(n, array2DRowRealMatrix5.operate((RealVector)arrayRealVector2), (RealVector)arrayRealVector, realMatrix2, d9);
        ouLik3FM = MVNUtils.getMVNLk(n, array2DRowRealMatrix6.operate((RealVector)arrayRealVector3), (RealVector)arrayRealVector, realMatrix4, d10);
        ouLik3RI = MVNUtils.getMVNLk(n, array2DRowRealMatrix7.operate((RealVector)arrayRealVector4), (RealVector)arrayRealVector, realMatrix6, d11);
        ouLik3RM = MVNUtils.getMVNLk(n, array2DRowRealMatrix8.operate((RealVector)arrayRealVector5), (RealVector)arrayRealVector, realMatrix8, d12);
        Assert.assertEquals((double)-8.892192, (double)Math.log(ouLik3FI), (double)1.0E-4);
        Assert.assertEquals((double)-8.892192, (double)Math.log(ouLik3FM), (double)1.0E-4);
        Assert.assertEquals((double)-8.89219, (double)Math.log(ouLik3RI), (double)1.0E-4);
        Assert.assertEquals((double)-8.89219, (double)Math.log(ouLik3RM), (double)1.0E-4);
    }
}

