/*
 * Decompiled with CFR 0.152.
 */
package contraband.test;

import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import beast.base.evolution.tree.TreeParser;
import contraband.math.MatrixUtilsContra;
import contraband.utils.MVNUtils;
import contraband.utils.OUUtils;
import java.util.ArrayList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.junit.Assert;
import org.junit.Test;

public class OUUtilsComputeOUTMatOneTraitTest {
    static final double EPSILON = 1.0E-4;
    private static RealMatrix ouTMat1FI;
    private static RealMatrix ouTMat1FM;
    private static RealMatrix ouTMat1RI;
    private static RealMatrix ouTMat1RM;
    private static RealMatrix ouTMat2FI;
    private static RealMatrix ouTMat2FM;
    private static RealMatrix ouTMat2RI;
    private static RealMatrix ouTMat2RM;
    private static RealMatrix ouTMat3FI;
    private static RealMatrix ouTMat3FM;
    private static RealMatrix ouTMat3RI;
    private static RealMatrix ouTMat3RM;

    @Test
    public void testComputeOUTMatSmallTree() {
        String string = "(((sp1:1.0,sp2:1.0):1.0,sp3:2.0):1.0,sp4:3.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        double d = 31.20814;
        double d2 = 31.20814;
        double d3 = 43.35287;
        double d4 = 43.35287;
        double d5 = 1.248328;
        double d6 = 1.248328;
        double d7 = 1.734117;
        double d8 = 1.734117;
        int n = treeParser.getLeafNodeCount();
        double[][] dArray = new double[n][n];
        double[] dArray2 = new double[treeParser.getNodeCount()];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        String[] stringArray = new String[n];
        MVNUtils.populateTMatrix((Tree)treeParser, dArray2, dArray, arrayList, arrayList2, stringArray);
        ouTMat1FI = new Array2DRowRealMatrix(n, n);
        ouTMat1FM = new Array2DRowRealMatrix(n, n);
        ouTMat1RI = new Array2DRowRealMatrix(n, n);
        ouTMat1RM = new Array2DRowRealMatrix(n, n);
        OUUtils.computeOUTMatOneTrait(n, d, dArray, ouTMat1FI, false);
        OUUtils.computeOUTMatOneTrait(n, d2, dArray, ouTMat1FM, false);
        OUUtils.computeOUTMatOneTrait(n, d3, dArray, ouTMat1RI, true);
        OUUtils.computeOUTMatOneTrait(n, d4, dArray, ouTMat1RM, true);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat1FI, d5);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat1FM, d6);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat1RI, d7);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat1RM, d8);
        Assert.assertEquals((double)1.563088E-29, (double)ouTMat1FI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.02000003, (double)ouTMat1FI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.22162E-56, (double)ouTMat1FI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.563088E-29, (double)ouTMat1FI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.563088E-29, (double)ouTMat1FM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.02000003, (double)ouTMat1FM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.22162E-56, (double)ouTMat1FM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.563088E-29, (double)ouTMat1FM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)4.417827E-40, (double)ouTMat1RI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.02000003, (double)ouTMat1RI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)9.758589E-78, (double)ouTMat1RI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)4.417827E-40, (double)ouTMat1RI.getEntry(1, 0), (double)1.0E-4);
    }

    @Test
    public void testComputeOUTMatSmallTreeNonUltra() {
        String string = "(((sp1:2.0,sp2:1.0):1.0,sp3:4.0):1.0,sp4:3.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        double d = 0.7465763;
        double d2 = 1.40338E-8;
        double d3 = 0.8609833;
        double d4 = 0.7085376;
        double d5 = 4.003551;
        double d6 = 1.237864;
        double d7 = 4.601164;
        double d8 = 6.841867;
        int n = treeParser.getLeafNodeCount();
        double[][] dArray = new double[n][n];
        double[] dArray2 = new double[treeParser.getNodeCount()];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        String[] stringArray = new String[n];
        MVNUtils.populateTMatrix((Tree)treeParser, dArray2, dArray, arrayList, arrayList2, stringArray);
        ouTMat2FI = new Array2DRowRealMatrix(n, n);
        ouTMat2FM = new Array2DRowRealMatrix(n, n);
        ouTMat2RI = new Array2DRowRealMatrix(n, n);
        ouTMat2RM = new Array2DRowRealMatrix(n, n);
        OUUtils.computeOUTMatOneTrait(n, d, dArray, ouTMat2FI, false);
        OUUtils.computeOUTMatOneTrait(n, d2, dArray, ouTMat2FM, false);
        OUUtils.computeOUTMatOneTrait(n, d3, dArray, ouTMat2RI, true);
        OUUtils.computeOUTMatOneTrait(n, d4, dArray, ouTMat2RM, true);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat2FI, d5);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat2FM, d6);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat2RI, d7);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat2RM, d8);
        Assert.assertEquals((double)0.2711105, (double)ouTMat2FI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)2.67973939, (double)ouTMat2FI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.0235737, (double)ouTMat2FI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.27111053, (double)ouTMat2FI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)2.475727, (double)ouTMat2FM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)6.189318, (double)ouTMat2FM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.237863, (double)ouTMat2FM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)2.475727, (double)ouTMat2FM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.2018748, (double)ouTMat2RI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)2.672040045, (double)ouTMat2RI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.015251805, (double)ouTMat2RI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.2018748, (double)ouTMat2RI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)0.57628838, (double)ouTMat2RM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)4.82816083, (double)ouTMat2RM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.06878567, (double)ouTMat2RM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)0.57628838, (double)ouTMat2RM.getEntry(1, 0), (double)1.0E-4);
    }

    @Test
    public void testComputeOUTMatLargeTreeNonUltra() {
        String string = "(((((sp1:1.0,sp2:1.0):1.0,sp3:1.0):2.0,(sp4:1.0,sp5:1.0):3.0):2.0, sp6:6.0):1.0,sp7:3.0);";
        TreeParser treeParser = new TreeParser(string, false, false, true, 0);
        double d = 7.142986;
        double d2 = 7.142986;
        double d3 = 7.84511;
        double d4 = 7.84511;
        double d5 = 10.61289;
        double d6 = 10.61289;
        double d7 = 11.65586;
        double d8 = 11.65586;
        int n = treeParser.getLeafNodeCount();
        double[][] dArray = new double[n][n];
        double[] dArray2 = new double[treeParser.getNodeCount()];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        String[] stringArray = new String[n];
        MVNUtils.populateTMatrix((Tree)treeParser, dArray2, dArray, arrayList, arrayList2, stringArray);
        ouTMat3FI = new Array2DRowRealMatrix(n, n);
        ouTMat3FM = new Array2DRowRealMatrix(n, n);
        ouTMat3RI = new Array2DRowRealMatrix(n, n);
        ouTMat3RM = new Array2DRowRealMatrix(n, n);
        OUUtils.computeOUTMatOneTrait(n, d, dArray, ouTMat3FI, false);
        OUUtils.computeOUTMatOneTrait(n, d2, dArray, ouTMat3FM, false);
        OUUtils.computeOUTMatOneTrait(n, d3, dArray, ouTMat3RI, true);
        OUUtils.computeOUTMatOneTrait(n, d4, dArray, ouTMat3RM, true);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat3FI, d5);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat3FM, d6);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat3RI, d7);
        MatrixUtilsContra.scalarByRealMatrix(ouTMat3RM, d8);
        Assert.assertEquals((double)4.640928E-7, (double)ouTMat3FI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.7428888, (double)ouTMat3FI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)3.668135E-10, (double)ouTMat3FI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)4.640928E-7, (double)ouTMat3FI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)4.640928E-7, (double)ouTMat3FM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.7428888, (double)ouTMat3FM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)3.668135E-10, (double)ouTMat3FM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)4.640928E-7, (double)ouTMat3FM.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.139565E-7, (double)ouTMat3RI.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.7428742, (double)ouTMat3RI.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)4.463248E-11, (double)ouTMat3RI.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.139565E-7, (double)ouTMat3RI.getEntry(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)1.139565E-7, (double)ouTMat3RM.getEntry(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)0.7428742, (double)ouTMat3RM.getEntry(2, 2), (double)1.0E-4);
        Assert.assertEquals((double)4.463248E-11, (double)ouTMat3RM.getEntry(1, 2), (double)1.0E-4);
        Assert.assertEquals((double)1.139565E-7, (double)ouTMat3RM.getEntry(1, 0), (double)1.0E-4);
    }
}

