/*
 * Decompiled with CFR 0.152.
 */
package contraband.utils;

import beast.base.evolution.tree.Node;
import beast.base.evolution.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class MVNUtils {
    public static void fillNodeLeftRightLeaves(Node node, double[] dArray, double[][] dArray2, List<Node> list, List<Node> list2, String[] stringArray) {
        int n = node.getNr();
        if (node.isLeaf()) {
            dArray2[n][n] = dArray[n];
            stringArray[n] = node.getID();
            return;
        }
        if (node.isRoot()) {
            dArray[n] = 0.0;
        }
        Node node2 = node.getChild(0);
        int n2 = node2.getNr();
        dArray[n2] = dArray[n] + node2.getLength();
        Node node3 = node.getChild(1);
        int n3 = node3.getNr();
        dArray[n3] = dArray[n] + node3.getLength();
        if (node2.getAllLeafNodes().size() == 0) {
            list.clear();
            list.add(node2);
        } else {
            list = node2.getAllLeafNodes();
        }
        if (node3.getAllLeafNodes().size() == 0) {
            list2.clear();
            list2.add(node3);
        } else {
            list2 = node3.getAllLeafNodes();
        }
        for (Node node4 : list) {
            for (Node node5 : list2) {
                dArray2[node4.getNr()][node5.getNr()] = dArray[n];
                dArray2[node5.getNr()][node4.getNr()] = dArray[n];
            }
        }
        MVNUtils.fillNodeLeftRightLeaves(node2, dArray, dArray2, list, list2, stringArray);
        MVNUtils.fillNodeLeftRightLeaves(node3, dArray, dArray2, list, list2, stringArray);
    }

    public static void populateTMatrix(Tree tree, double[] dArray, double[][] dArray2, List<Node> list, List<Node> list2, String[] stringArray) {
        MVNUtils.fillNodeLeftRightLeaves(tree.getRoot(), dArray, dArray2, list, list2, stringArray);
    }

    public static void populateAncNodePhyloTMatrix(Tree tree, RealMatrix realMatrix) {
        double d = tree.getRoot().getHeight();
        int n = tree.getLeafNodeCount();
        for (Node node : tree.getRoot().getAllLeafNodes()) {
            block1: for (Node node2 : tree.getInternalNodes()) {
                if (node2.isRoot()) continue;
                int n2 = node.getNr();
                int n3 = node2.getNr();
                if (node2.getAllLeafNodes().contains(node)) {
                    realMatrix.setEntry(n3 - n, n2, d - node2.getHeight());
                    continue;
                }
                Node node3 = node2.getParent();
                while (!node3.isRoot()) {
                    if (node3.getAllLeafNodes().contains(node) && node3.getChildren().contains(node2)) {
                        realMatrix.setEntry(n3 - n, n2, d - node3.getHeight());
                        continue block1;
                    }
                    node3 = node3.getParent();
                }
            }
        }
    }

    public static void populateNodeRateMatrix(Node node, Double[] doubleArray, RealMatrix realMatrix) {
        int n = node.getNr();
        double d = doubleArray[n];
        if (node.isLeaf()) {
            realMatrix.setEntry(n, n, d);
            return;
        }
        Node node2 = node.getChild(0);
        List list = new ArrayList<Node>();
        if (!node2.isLeaf()) {
            list = node2.getAllLeafNodes();
        } else {
            list.add(node2);
        }
        MVNUtils.populateNodeRateMatrix(node2, doubleArray, realMatrix);
        Node node3 = node.getChild(1);
        List list2 = new ArrayList<Node>();
        if (!node3.isLeaf()) {
            list2 = node3.getAllLeafNodes();
        } else {
            list2.add(node3);
        }
        MVNUtils.populateNodeRateMatrix(node3, doubleArray, realMatrix);
        if (!node.isRoot()) {
            for (Node node4 : list) {
                int n2 = node4.getNr();
                for (Node node5 : list2) {
                    int n3 = node5.getNr();
                    realMatrix.setEntry(n2, n3, d);
                    realMatrix.setEntry(n3, n2, d);
                }
            }
        } else {
            int n4 = realMatrix.getRowDimension();
            for (int i = 0; i < n4 - 1; ++i) {
                realMatrix.setEntry(n4 - 1, i, d);
                realMatrix.setEntry(i, n4 - 1, d);
            }
        }
    }

    public static void populateRateMatrix(Tree tree, Double[] doubleArray, RealMatrix realMatrix) {
        Node node = tree.getRoot();
        MVNUtils.populateNodeRateMatrix(node, doubleArray, realMatrix);
    }

    public static double getMVNLk(int n, RealVector realVector, RealVector realVector2, RealMatrix realMatrix, double d) {
        double d2 = 1.0 / (Math.pow(Math.PI * 2, (double)n / 2.0) * Math.pow(d, 0.5));
        return d2 *= Math.exp(realMatrix.preMultiply(realVector2.subtract(realVector)).mapMultiply(-0.5).dotProduct(realVector2.subtract(realVector)));
    }

    public static double getMVNLogLk(int n, RealVector realVector, RealVector realVector2, RealMatrix realMatrix, double d) {
        double d2 = -0.5 * (Math.log(d) + (double)n * Math.log(Math.PI * 2));
        return d2 += realMatrix.preMultiply(realVector2.subtract(realVector)).mapMultiply(-0.5).dotProduct(realVector2.subtract(realVector));
    }

    public static double getNormalLk(double d, double d2, double d3) {
        return 1.0 / Math.sqrt(Math.PI * 2 * d3) * Math.exp(-Math.pow(d - d2, 2.0) / (2.0 * d3));
    }

    public static double getSampleNormalLogLk(Double[] doubleArray, Double d, Double d2) {
        double d3 = doubleArray.length;
        double d4 = 0.0;
        int n = 0;
        while ((double)n < d3) {
            d4 += Math.pow(doubleArray[n] - d, 2.0);
            ++n;
        }
        return -(d3 / 2.0 * Math.log(Math.PI * 2)) + -(d3 / 2.0 * d2) + -(1.0 / (2.0 * Math.exp(d2))) * d4;
    }

    public static double getSampleMultipleNormalLogLk(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3) {
        double d = doubleArray.length;
        double d2 = d / 2.0 * Math.log(Math.PI * 2);
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while ((double)n < d) {
            d3 += 0.5 * Math.log(doubleArray3[n]);
            d4 += 1.0 / (2.0 * doubleArray3[n]) * Math.pow(doubleArray[n] - doubleArray2[n], 2.0);
            ++n;
        }
        double d5 = -d2 - d3 - d4;
        return d5;
    }

    public static double getOneTraitAncState(RealMatrix realMatrix, RealMatrix realMatrix2, RealVector realVector, Double[] doubleArray) {
        double d = 0.0;
        return d;
    }
}

