/*
 * Decompiled with CFR 0.152.
 */
package contraband.utils;

import beast.base.evolution.branchratemodel.BranchRateModel;
import beast.base.evolution.tree.Node;
import contraband.math.MatrixUtilsContra;
import contraband.utils.GeneralUtils;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class OUUtils {
    public static void computeOUTMatOneTrait(int n, double d, double[][] dArray, RealMatrix realMatrix, boolean bl) {
        double d2 = 1.0 / (2.0 * d);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d3 = d2 * Math.exp(-d * (dArray[i][i] + dArray[j][j] - 2.0 * dArray[i][j]));
                if (!bl) {
                    d3 *= 1.0 - Math.exp(-2.0 * d * dArray[i][j]);
                }
                realMatrix.setEntry(i, j, d3);
            }
        }
    }

    public static void computeWMatOneTrait(Integer[] integerArray, Node node, List<Node> list, int n, int n2, double d, RealMatrix realMatrix, boolean bl) {
        int n3;
        int n4;
        if (bl) {
            n4 = 1;
            n3 = integerArray[node.getNr()];
        } else {
            n4 = 0;
            n3 = 0;
        }
        for (Node node2 : list) {
            int n5 = node2.getNr();
            double d2 = node2.getHeight();
            double d3 = Math.exp(-d * (node.getHeight() - d2));
            realMatrix.addToEntry(n5, n3, d3);
            while (!node2.isRoot()) {
                int n6 = integerArray[node2.getNr()] + n4;
                d3 = Math.exp(-d * (node2.getHeight() - d2)) - Math.exp(-d * (node2.getParent().getHeight() - d2));
                realMatrix.addToEntry(n5, n6, d3);
                node2 = node2.getParent();
            }
        }
    }

    public static void populateOUMeanVector(double d, double d2, Node node, List<Node> list, BranchRateModel branchRateModel, RealVector realVector, boolean bl) {
        for (Node node2 : list) {
            double d3 = 0.0;
            int n = node2.getNr();
            double d4 = node2.getHeight();
            double d5 = node.getHeight() - d4;
            d3 = bl ? Math.exp(-d * d5) * d2 : Math.exp(-d * d5) * branchRateModel.getRateForBranch(node);
            while (!node2.isRoot()) {
                double d6 = node2.getHeight() - d4;
                double d7 = node2.getParent().getHeight() - d4;
                d3 += (Math.exp(-d * d6) - Math.exp(-d * d7)) * branchRateModel.getRateForBranch(node2);
                node2 = node2.getParent();
            }
            realVector.setEntry(n, d3);
        }
    }

    public static RealMatrix getExpAlphaMat(int n, RealMatrix realMatrix, RealMatrix realMatrix2, double d) {
        RealMatrix realMatrix3 = realMatrix.createMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            realMatrix3.setEntry(i, i, Math.exp(-d * realMatrix.getEntry(i, i)));
        }
        return realMatrix3.preMultiply(realMatrix2).multiply(realMatrix2.transpose());
    }

    public static void treeAlphaChunkMat(int n, double[] dArray, double d, double d2, double d3, boolean bl, double[][] dArray2) {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[i][j] = (1.0 - Math.exp(-(dArray[i] + dArray[j]) * d3)) / (dArray[i] + dArray[j]);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[i][j] = Math.exp(-dArray[i] * (d - d3)) * Math.exp(-dArray[j] * (d2 - d3)) / (dArray[i] + dArray[j]);
                }
            }
        }
    }

    public static RealMatrix eigencholChunk(RealMatrix realMatrix, RealMatrix realMatrix2) {
        return realMatrix2.transpose().multiply(realMatrix).multiply(realMatrix.transpose()).multiply(realMatrix2);
    }

    public static RealMatrix multiTraitCovMat2Species(int n, double[][] dArray, EigenDecomposition eigenDecomposition, double d, double d2, double d3, boolean bl) {
        Array2DRowRealMatrix array2DRowRealMatrix;
        double[][] dArray2 = new double[n][n];
        GeneralUtils.displayRealMatrix(eigenDecomposition.getD());
        if (bl) {
            OUUtils.treeAlphaChunkMat(n, eigenDecomposition.getRealEigenvalues(), d, d2, d3, bl, dArray2);
            MatrixUtilsContra.elementWiseProduct(dArray2, dArray, dArray2);
            array2DRowRealMatrix = new Array2DRowRealMatrix(dArray2);
            array2DRowRealMatrix = OUUtils.getExpAlphaMat(n, eigenDecomposition.getD(), eigenDecomposition.getV(), d - d3).multiply(eigenDecomposition.getV()).multiply((RealMatrix)array2DRowRealMatrix).multiply(eigenDecomposition.getVT()).multiply(OUUtils.getExpAlphaMat(n, eigenDecomposition.getD(), eigenDecomposition.getV(), d2 - d3));
        } else {
            OUUtils.treeAlphaChunkMat(n, eigenDecomposition.getRealEigenvalues(), d, d2, d3, false, dArray2);
            MatrixUtilsContra.elementWiseProduct(dArray2, dArray, dArray2);
            array2DRowRealMatrix = new Array2DRowRealMatrix(dArray2);
            array2DRowRealMatrix = eigenDecomposition.getV().multiply((RealMatrix)array2DRowRealMatrix).multiply(eigenDecomposition.getVT());
        }
        return array2DRowRealMatrix;
    }

    public static RealMatrix multiTraitWeightMatSpVsRegime(int n, Node node, int n2, Node node2, Double[] doubleArray, EigenDecomposition eigenDecomposition, boolean bl) {
        RealMatrix realMatrix = eigenDecomposition.getD().createMatrix(n, n);
        double d = node.getHeight();
        if (bl && n2 == 0) {
            RealMatrix realMatrix2 = OUUtils.getExpAlphaMat(n, eigenDecomposition.getD(), eigenDecomposition.getV(), node2.getHeight() - d);
            realMatrix = realMatrix.add(realMatrix2);
        }
        while (!node.isRoot()) {
            int n3 = doubleArray[node.getNr()].intValue();
            System.out.println("regime of species " + n3);
            if (n3 == n2) {
                RealMatrix realMatrix3 = OUUtils.getExpAlphaMat(n, eigenDecomposition.getD(), eigenDecomposition.getV(), node.getHeight() - d).subtract(OUUtils.getExpAlphaMat(n, eigenDecomposition.getD(), eigenDecomposition.getV(), node.getParent().getHeight() - d));
                realMatrix = realMatrix.add(realMatrix3);
            }
            node = node.getParent();
        }
        return realMatrix;
    }

    public static void multiTraitFullWeightMat(int n, Node node, Double[] doubleArray, int n2, EigenDecomposition eigenDecomposition, boolean bl, double[][] dArray) {
        List list = node.getAllLeafNodes();
        RealMatrix realMatrix = eigenDecomposition.getD().createMatrix(n, n);
        if (bl) {
            for (Node node2 : list) {
                for (int i = 0; i < n2; ++i) {
                    realMatrix = OUUtils.multiTraitWeightMatSpVsRegime(n, node2, i, node, doubleArray, eigenDecomposition, true);
                    MatrixUtilsContra.setBlocksInMatrix(realMatrix.getData(), n, node2.getNr(), i, dArray);
                }
            }
        } else {
            for (Node node3 : list) {
                double d = node3.getHeight();
                RealMatrix realMatrix2 = OUUtils.getExpAlphaMat(n, eigenDecomposition.getD(), eigenDecomposition.getV(), node.getHeight() - d);
                MatrixUtilsContra.setBlocksInMatrix(realMatrix2.getData(), n, node3.getNr(), 0, dArray);
                for (int i = 0; i < n2; ++i) {
                    realMatrix = OUUtils.multiTraitWeightMatSpVsRegime(n, node3, i, node, doubleArray, eigenDecomposition, false);
                    MatrixUtilsContra.setBlocksInMatrix(realMatrix.getData(), n, node3.getNr(), i + 1, dArray);
                }
            }
        }
    }
}

