/*
 * Decompiled with CFR 0.152.
 */
package contraband.valuewrappers;

import beast.base.core.Input;
import beast.base.inference.CalculationNode;
import beast.base.inference.parameter.RealParameter;
import beast.base.inference.util.InputUtil;
import java.util.HashMap;
import java.util.Map;

public class OneValueContTraits
extends CalculationNode {
    public final Input<Integer> nTraitsInput = new Input("nTraits", "contains number of traits.", Input.Validate.REQUIRED);
    public final Input<String> spNamesInput = new Input("spNames", "specifies species names separated by comma (e.g., sp1,sp2,sp3), while specifying which real parameter refers to which species in traitValues.", Input.Validate.REQUIRED);
    public final Input<RealParameter> traitInput = new Input("traitValues", "quantitative trait values, one per species (if fixed, then don't operate on them).", Input.Validate.REQUIRED);
    Integer nTraits;
    Integer nSpp;
    String[] spNames;
    Double[] traitValues;
    Double[] thisSpTraitValues;
    Map<String, Double[]> spValuesMap;
    Map<String, Double[]> storedSpValuesMap;

    public void initAndValidate() {
        this.nTraits = (Integer)this.nTraitsInput.get();
        this.thisSpTraitValues = new Double[this.nTraits.intValue()];
        this.spNames = ((String)this.spNamesInput.get()).replace("\\s+", "").split(",");
        this.nSpp = this.spNames.length;
        this.spValuesMap = new HashMap<String, Double[]>();
        this.populateSpValuesMap();
        this.checkAllSpHaveValues();
        this.storedSpValuesMap = new HashMap<String, Double[]>();
    }

    private void checkAllSpHaveValues() {
    }

    private void populateSpValuesMap() {
        this.traitValues = (Double[])((RealParameter)this.traitInput.get()).getValues();
        for (int i = 0; i < this.nTraits; ++i) {
            int n = 0;
            for (String string : this.spNames) {
                if (!this.spValuesMap.containsKey(string)) {
                    this.spValuesMap.put(string, new Double[this.nTraits.intValue()]);
                }
                this.spValuesMap.get((Object)string)[i] = this.traitValues[i * this.nSpp + n];
                ++n;
            }
        }
    }

    public int getNSpp() {
        return this.nSpp;
    }

    public String[] getSpNames() {
        return this.spNames;
    }

    public Double getSpValue(String string, int n) {
        Double d = this.spValuesMap.get(string)[n];
        return d;
    }

    public Double[] getSpValues(String string) {
        return this.spValuesMap.get(string);
    }

    public Double[] getTraitValues(int n, String[] stringArray) {
        if (InputUtil.isDirty(this.traitInput)) {
            this.populateSpValuesMap();
        }
        Double[] doubleArray = new Double[this.nSpp.intValue()];
        int n2 = 0;
        for (String string : stringArray) {
            doubleArray[n2] = this.getSpValues(string)[n];
            ++n2;
        }
        return doubleArray;
    }

    public Integer getNTraits() {
        return this.nTraits;
    }

    protected boolean requiresRecalculation() {
        return true;
    }

    public void store() {
        for (String string : this.spValuesMap.keySet()) {
            this.storedSpValuesMap.put(string, (Double[])this.spValuesMap.get(string).clone());
        }
        super.store();
    }

    public void restore() {
        Map<String, Double[]> map = this.spValuesMap;
        this.spValuesMap = this.storedSpValuesMap;
        this.storedSpValuesMap = map;
        super.restore();
    }
}

