package contraband.test;

import contraband.math.LUDecompositionForArray;
import contraband.math.MatrixUtilsContra;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class contains unit tests for LUDecompositionForArray.class
 * which implements matrix inversion and determinant calculation
 * for a matrix using array.
 */

public class LUDecompositionForArrayTest {
    private final static double EPSILON = 1e-10;
    private double[] matrix;
    private int dim;
    private double [] inverseMatrix;
    private double determinant;
    private int [] pivot;
    private double [] lu;
    private double [] identity;
    private double [] expectInverseMatrix;

    private final boolean[] evensingular = new boolean[2];

    /*
     * test 3 by 3 matrix
     */
    @Test
    public void testLUDecompositionFor3by3Matrix () {
        dim = 3;
        matrix = new double[]{
                3.70889115977579, 2.85610318223451, 3.80698366724091,
                3.31385684718126, 3.64833976126344, 3.63083965005815,
                3.23330588599873, 3.67462891649159, 3.40754295288853
        };
        lu = new double[dim * dim];
        pivot = new int[dim];
        inverseMatrix = new double[dim * dim];
        identity = new double[dim * dim];
        for (int i = 0; i < dim; i++) {
            MatrixUtilsContra.setMatrixEntry(identity, i, i, 1, dim);
        }

        // calculate matrix determinant
        LUDecompositionForArray.ArrayLUDecomposition(matrix, lu, pivot, evensingular, dim);
        determinant = LUDecompositionForArray.getDeterminant(lu, dim, evensingular);
        Assert.assertEquals(-0.646946460674129, determinant, EPSILON);

        // calculate inverse matrix
        LUDecompositionForArray.populateInverseMatrix(lu, pivot, identity, evensingular[1], dim, inverseMatrix);
        expectInverseMatrix = new double[] {1.40678399424781,-6.58007772771974,5.43958027267702,-0.691719782639185,-0.508640599085404,1.31477678536837,-0.58891391283386,6.79212846935561,-6.28580299746449};
        Assert.assertArrayEquals(expectInverseMatrix, inverseMatrix, EPSILON);
    }

    /*
     * test 5 by 5 matrix
     */
    @Test
    public void testLUDecompositionFor5by5Matrix () {
        dim = 5;
        matrix = new double[]{
                0.115101355304469, 1.95143868853466, 1.06526779835517, 2.84917607228521, 0.167548836885018,
                2.63186421379037, 1.86053440268995, 1.37993056215569, 0.808365421322008, 1.29243583140217,
                3.94711763195838, 1.672029426274, 2.05213728933188, -0.0697898508481694, -0.0466803696608133,
                2.31274680266109, 0.927766479546548, 1.23461578370186, 1.04195091243845, 3.38263000405587,
                1.90036829957206, 3.35260906252338, 1.32702928839128, 2.49058822891853, 3.09213750627371
        };
        lu = new double[dim * dim];
        pivot = new int[dim];
        inverseMatrix = new double[dim * dim];
        identity = new double[dim * dim];
        for (int i = 0; i < dim; i++) {
            MatrixUtilsContra.setMatrixEntry(identity, i, i, 1, dim);
        }

        // calculate matrix determinant
        LUDecompositionForArray.ArrayLUDecomposition(matrix, lu, pivot, evensingular, dim);
        determinant = LUDecompositionForArray.getDeterminant(lu, dim, evensingular);
        Assert.assertEquals(-4.88323624162058, determinant, EPSILON);

        // calculate inverse matrix
        LUDecompositionForArray.populateInverseMatrix(lu, pivot, identity, evensingular[1], dim, inverseMatrix);
        expectInverseMatrix = new double[] {0.236378182015901,7.07839493924347,-2.98895589797068,-0.540172466908834,-2.4256030318266,-0.374653177379533,-1.86018600768821,0.882305080861905,-0.364042648780526,1.20937431138699,-0.131822020333492,-11.9483879904531,5.44423524178133,1.33518195043064,3.6228414024335,0.659906188722313,5.554200095136,-2.55444292268774,-0.248871800781471,-2.12358436136934,-0.214014696522989,-1.67924144450559,0.601363580855029,0.354133972898454,0.658553312676024};
        Assert.assertArrayEquals(expectInverseMatrix, inverseMatrix, EPSILON);
    }

    /*
     * test 10 by 10 matrix
     */
    @Test
    public void testLUDecompositionFor10by10Matrix () {
        dim = 10;
        matrix = new double[]{
                0.287865339573146,0.603018098851489,0.775608991843542,1.59797797758675,1.61885554464859,1.09597100424676,1.21153029335587,0.722194113977166,1.60548408209245,0.685701906683121,
                0.606662981178428,0.115812597746156,0.271721745038749,0.72220257974913,0.10184689431596,0.526033866862375,0.0955528065124085,1.05201604739182,1.11127659450294,1.00750231439348,
                1.30893639469729,1.70663715721342,1.35714311639341,0.472297245461072,0.660663237315085,0.521977917529999,1.4757574996697,0.687443700604134,1.05713156676575,0.209301525420503,
                1.16797302655892,1.6506559461428,0.829430860382409,1.94256059947779,0.952894496705678,1.37096923655077,1.01462416418531,1.38337158274154,0.680582011448106,0.743387370888354,
                0.349522669634829,-0.0798954257531888,1.17447297029663,0.909571885862174,1.40255885159904,0.487679891688221,1.45664897924801,0.115529449433638,1.07507874901152,1.12010778006555,
                1.21870053151044,1.26828363279089,0.967850442264924,1.43975899637093,0.119908013945132,0.810415126453327,0.894807688558739,0.607161751124303,1.35318105241461,1.70573163399132,
                0.725701370165317,0.708413134141067,0.949317723106605,1.48443319457833,1.17286854215232,0.428518978817218,0.958399091785082,1.78429613763516,1.44878530227444,1.46021620389606,
                0.798244505535118,0.971270650231238,1.7164178364745,1.05561264922296,0.28576222032701,0.203024028079538,0.415051028429816,1.55889793644695,1.43719092013856,0.80066493971711,
                1.55850304066804,1.06007157370252,1.93465764725211,0.790348890320161,1.07047147518265,0.00157997599426274,0.653444061433821,0.0692897072800194,0.999133641871811,0.951050865177791,
                1.52358390885293,1.3555957513983,0.53081388308462,0.766047756710676,1.09787795143487,1.04383248211778,0.848167282637724,0.0506111143995522,1.33082205574405,0.428641063389338
        };
        lu = new double [dim * dim];
        pivot = new int [dim];
        inverseMatrix = new double [dim * dim];
        identity = new double[dim * dim];
        for (int i = 0; i < dim; i++) {
            MatrixUtilsContra.setMatrixEntry(identity, i, i, 1, dim);
        }

        // calculate matrix determinant
        LUDecompositionForArray.ArrayLUDecomposition(matrix, lu, pivot, evensingular, dim);
        determinant = LUDecompositionForArray.getDeterminant(lu, dim, evensingular);
        Assert.assertEquals(-0.6664215744962, determinant, EPSILON);

        // calculate inverse matrix
        LUDecompositionForArray.populateInverseMatrix(lu, pivot, identity, evensingular[1], dim, inverseMatrix);
        expectInverseMatrix = new double[] {6.85923882152452,9.21766966674103,5.9267848244114,-0.309361331362526,-5.7102373551916,-0.609829061027596,-2.39898709968338,-8.34545212901634,6.66083104368029,-8.66524263034722,-5.97375849641348,-8.08175683109919,-4.85520477196719,0.233085339381953,4.28171854403704,0.682842774993697,2.44524125487066,6.76602604937579,-5.39955012885407,7.6244414115936,-3.47829260836236,-3.72684215770412,-2.72827885854313,0.527233751245185,3.13934196871679,-0.0978836479052768,0.356244480589156,4.25644829203189,-2.7392776233889,3.84130097372256,10.4363706213254,10.9851371499863,7.48488219838812,-0.587861776351576,-8.2327249736611,0.0245023221796998,-3.14623118869418,-10.817098758957,8.76327096742759,-12.2547769334758,-4.39579779911131,-5.34546392181102,-3.7500335493125,0.348369651941157,3.46494017263604,-0.297844891766549,1.92454567951826,4.6191254166606,-3.55445902534833,5.65618260912114,-8.11719308574069,-8.2285784399325,-6.30290690719461,1.20967042014729,6.93776028184666,-0.0650295507606919,1.45175203045733,8.87032318684371,-7.10693272683746,9.68911022276759,5.14566660670186,6.0043101920278,4.807587476435,-0.458080142330471,-3.80552572878961,-0.00704254207399219,-1.54279883920582,-6.06963739429028,4.19525680060468,-6.64000648854022,-1.22243429361121,-0.647538979543184,-0.494803338761072,0.284858726250157,0.781453937183638,-0.413963534052589,0.583158264243899,1.05628178760514,-0.957862052783956,0.996017299395791,2.83328827614047,2.6267929902271,1.84799618949056,-0.860759711542387,-2.16010449964267,0.137393836601948,-0.705746237336532,-2.22205990918766,1.80599213778898,-2.47043923478469,-7.64074507697463,-8.45214045187511,-5.94791307161544,0.467301459929204,5.95590720725906,0.642985500439903,2.68597921962804,7.67877895298811,-6.25280993543621,8.7738395924609};
        Assert.assertArrayEquals(expectInverseMatrix, inverseMatrix, EPSILON);
    }

}

