package contraband.test;

import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.Test;

import contraband.utils.MVNUtils;

/**
 * @author Fabio K. Mendes
 */

public class SampleNormalLogLkTest {
	double logLik;
	
	@Before
	public void setUp() throws Exception {
		Double[] samples = new Double[] { -1.6728255054923,-1.47670302543644,0.296060188104316,-0.688681395303425,-1.02650691348732,-1.22461492084065,0.426534438466782,-1.1444970697377,-0.656272550504614,0.846923744910082,1.00458137886268,0.899738697815723,0.465531205866213,0.237873824311592,0.784901684467423,-0.213854959898138,1.98307020577749,0.294350806933855,0.420965082972301,0.522381241184788,-0.111682768289069,1.05804453216889,0.374499260872829,0.149329001055972,1.296609240663,1.39818662698086,0.992689446255767,0.869091139419575,1.10137969477034,-0.35918156851998,1.17891227633039,0.560639588942097,-0.928347412910144,1.16634041691946,-0.166322780256855,0.176889092217215,-1.11117137691676,1.31665016262739,0.585424425087103,-0.346056121908481,0.853849266043241,-0.178969439365062,1.35624540062904,-0.230531460879969,-0.995297469377439,-1.13361533118848,-0.930292266244003,-1.49666243291004,0.065300721695697,-0.495448158590699,-0.121399686907524,-0.208366391860712,1.10124819963141,-0.256686009461781,-1.0116916181728,1.65240533876972,0.256487093726559,-0.744599868503791,0.562603655795113,1.25526453022213,-0.945868818663454,0.00220811759651972,0.0264593457492177,-1.09663323816123,2.78510462934592,0.189960543079228,-1.77718436210727,-0.414616013182532,-1.20069081326124,-1.82907393086381,0.504582714883702,-2.16627991062444,-0.385214539479042,-0.897033583822918,0.789239528812291,-0.116387214623207,-0.204416830901781,0.455579687439326,-0.324676034347408,1.2798759354455,0.0715842133976122,0.579160585558501,0.443716747934262,0.0731129914588985,0.958581359796163,-0.705625765172818,-0.0401641124887771,-0.646510428150312,0.701770901434699,0.500886096278222,-0.871222968474564,-1.04257236725202,1.43924856788767,0.710556195233464,-0.498520939493227,-0.446174320564027,0.206809937144619,-1.39270582030932,-0.501695798571696,0.284585285513399 };
		logLik = MVNUtils.getSampleNormalLogLk(samples, 0.1, 0.1);
	}

	@Test
	public void test() {
		assertEquals(-136.0298, logLik, 1E-4); // in R, remember to sqrt(exp(log-variance))!
	}
}
