/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els;

import com.corionis.els.Context;
import com.corionis.els.Main;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.MainFrame;
import com.corionis.els.gui.Preferences;
import com.corionis.els.repository.Repository;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.sshd.common.util.io.IoUtils;

public class Configuration {
    public static final String APPLICATION_NAME = "ELS";
    public static final int BUILD_CHANGES_URL = 5;
    public static final int BUILD_DATE = 2;
    public static final int BUILD_ELS_DISTRO = 3;
    public static final int BUILD_FLAGS = 6;
    public static final int BUILD_NUMBER = 1;
    public static final int BUILD_UPDATER_DISTRO = 4;
    public static final int BUILD_VERSION_NAME = 0;
    public static final String ELS_ICON = "els-logo-98px";
    public static final String ELS_JAR = "ELS.jar";
    public static final int JOB_PROCESS = 8;
    public static final String LOGGER_NAME = "ELS Logger";
    public static final String NAVIGATOR_NAME = "ELS Navigator";
    public static final int NOT_REMOTE = 0;
    public static final int NOT_SET = -1;
    public static final String PROGRAM_NAME = "Corionis ELS : Entertainment Library Synchronizer";
    public static final int PUBLISHER_LISTENER = 4;
    public static final int PUBLISHER_MANUAL = 3;
    public static final int PUBLISH_REMOTE = 1;
    public static final int STATUS_SERVER = 6;
    public static final int STATUS_SERVER_FORCE_QUIT = 7;
    public static final int SUBSCRIBER_LISTENER = 2;
    public static final int SUBSCRIBER_LISTENER_FORCE_QUIT = 9;
    public static final int SUBSCRIBER_TERMINAL = 5;
    public static final String URL_PREFIX = "https://raw.githubusercontent.com/Corionis/ELS/Version-4.0.0/deploy";
    public static final int VERSION_SIZE = 6;
    public static final String[] availableLocales = new String[]{"en_US"};
    private boolean defaultNavigator = false;
    private String authKeysFile = "";
    private String authorizedPassword = "";
    private String blacklist = "";
    private boolean checkForUpdate = false;
    private String consoleLevel = "Info";
    private boolean consoleSet = false;
    private Context context;
    private int crossCheck = -1;
    private ResourceBundle currentBundle = null;
    private String debugLevel = "Info";
    private boolean debugSet = false;
    private int dryRun = -1;
    private int duplicateCheck = -1;
    private String emailServer = "";
    private int emptyDirectoryCheck = -1;
    private String exportCollectionFilename = "";
    private String exportTextFilename = "";
    private int forceCollection = -1;
    private int forceTargets = -1;
    private String hintKeysFile = "";
    private int hintSkipMainProcess = -1;
    private String hintTrackerFilename = "";
    private String hintsDaemonFilename = "";
    private int ignoredReported = -1;
    private boolean installUpdate = false;
    private String iplist = "";
    private String jobName = "";
    private int keepGoing = -1;
    private String logFileFullPath = "";
    private String logFileName = "";
    private String logFilePath = "";
    private int logOverwrite = 1;
    private boolean loggerView = false;
    private double longScale = 1024.0;
    private String marker = "";
    private String mismatchFilename = "";
    private int navigator = -1;
    private int noBackFill = -1;
    private int operation = -1;
    private String[] originalArgs;
    private int overrideHintHost = -1;
    private String overrideSubscriberHost = "";
    private int overwrite = -1;
    private int preserveDates = -1;
    private String publisherCollectionFilename = "";
    private String publisherLibrariesFileName = "";
    private int quitStatusServer = -1;
    private int quitSubscriberListener = -1;
    private String remoteArg = "";
    private int requestCollection = -1;
    private int requestTargets = -1;
    private ArrayList<String> selectedLibraryExcludes = new ArrayList();
    private ArrayList<String> selectedLibraryNames = new ArrayList();
    private int specificExclude = -1;
    private int specificLibrary = -1;
    private String subscriberCollectionFilename = "";
    private String subscriberLibrariesFileName = "";
    private int targetsEnabled = -1;
    private String targetsFilename = "";
    private boolean updateFailed = false;
    private boolean updateSuccessful = false;
    private int validation = -1;
    private int whatsNewAll = -1;
    private String whatsNewFilename = "";
    private String workingDirectory = "";
    private String workingDirectorySubscriber = "";

    public Configuration(Context ctxt) {
        this.context = ctxt;
        this.context.cfg = this;
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String filePart = lang + "_" + country;
        this.context.cfg.loadLocale(filePart);
        if (this.context.cfg.gs("Transfer.received.subscriber.commands").length() == 0) {
            this.context.cfg.loadLocale("-");
            System.out.println(this.context.cfg.gs("Process.local.locale.not.supported.loading.default"));
        } else if (this.context.main != null) {
            this.context.main.localeAbbrev = filePart;
        }
    }

    public void addExcludedLibraryName(String publisherLibraryName) {
        this.selectedLibraryExcludes.add(publisherLibraryName);
    }

    public void addPublisherLibraryName(String publisherLibraryName) {
        this.selectedLibraryNames.add(publisherLibraryName);
    }

    public ResourceBundle bundle() {
        return this.currentBundle;
    }

    public Object clone() {
        Configuration clone = new Configuration(this.context);
        clone.defaultNavigator = this.defaultNavigator;
        clone.authKeysFile = this.authKeysFile;
        clone.authorizedPassword = this.authorizedPassword;
        clone.blacklist = this.blacklist;
        clone.consoleLevel = this.consoleLevel;
        clone.consoleSet = this.consoleSet;
        clone.context = this.context;
        clone.crossCheck = this.crossCheck;
        clone.currentBundle = this.currentBundle;
        clone.debugLevel = this.debugLevel;
        clone.debugSet = this.debugSet;
        clone.dryRun = this.dryRun;
        clone.duplicateCheck = this.duplicateCheck;
        clone.emptyDirectoryCheck = this.emptyDirectoryCheck;
        clone.exportCollectionFilename = this.exportCollectionFilename;
        clone.exportTextFilename = this.exportTextFilename;
        clone.forceCollection = this.forceCollection;
        clone.forceTargets = this.forceTargets;
        clone.hintKeysFile = this.hintKeysFile;
        clone.hintSkipMainProcess = this.hintSkipMainProcess;
        clone.hintTrackerFilename = this.hintTrackerFilename;
        clone.hintsDaemonFilename = this.hintsDaemonFilename;
        clone.ignoredReported = this.ignoredReported;
        clone.iplist = this.iplist;
        clone.jobName = this.jobName;
        clone.keepGoing = this.keepGoing;
        clone.logFileFullPath = this.logFileFullPath;
        clone.logFileName = this.logFileName;
        clone.logFilePath = this.logFilePath;
        clone.loggerView = this.loggerView;
        clone.logOverwrite = this.logOverwrite;
        clone.longScale = this.longScale;
        clone.marker = this.marker;
        clone.mismatchFilename = this.mismatchFilename;
        clone.navigator = this.navigator;
        clone.noBackFill = this.noBackFill;
        clone.operation = this.operation;
        clone.originalArgs = this.originalArgs;
        clone.overrideHintHost = this.overrideHintHost;
        clone.overrideSubscriberHost = this.overrideSubscriberHost;
        clone.overwrite = this.overwrite;
        clone.preserveDates = this.preserveDates;
        clone.publisherCollectionFilename = this.publisherCollectionFilename;
        clone.publisherLibrariesFileName = this.publisherLibrariesFileName;
        clone.quitStatusServer = this.quitStatusServer;
        clone.quitSubscriberListener = this.quitSubscriberListener;
        clone.requestCollection = this.requestCollection;
        clone.requestTargets = this.requestTargets;
        clone.selectedLibraryExcludes = (ArrayList)this.selectedLibraryExcludes.clone();
        clone.selectedLibraryNames = (ArrayList)this.selectedLibraryNames.clone();
        clone.specificExclude = this.specificExclude;
        clone.specificLibrary = this.specificLibrary;
        clone.subscriberCollectionFilename = this.subscriberCollectionFilename;
        clone.subscriberLibrariesFileName = this.subscriberLibrariesFileName;
        clone.targetsEnabled = this.targetsEnabled;
        clone.targetsFilename = this.targetsFilename;
        clone.updateFailed = this.updateFailed;
        clone.updateSuccessful = this.updateSuccessful;
        clone.validation = this.validation;
        clone.whatsNewAll = this.whatsNewAll;
        clone.whatsNewFilename = this.whatsNewFilename;
        clone.workingDirectory = this.workingDirectory;
        clone.workingDirectorySubscriber = this.workingDirectorySubscriber;
        return clone;
    }

    public void configureLoggerPath() throws Exception {
        if (this.getLogFileName() != null && this.getLogFileName().length() > 0) {
            Object prefix = "";
            String relative = "";
            String lfn = this.getLogFileName();
            this.setLogFilePath("");
            if (!(lfn.matches("^[a-zA-Z]:.*") || lfn.startsWith("/") || lfn.startsWith("\\"))) {
                int i;
                prefix = this.getWorkingDirectory() + System.getProperty("file.separator");
                String separator = "";
                if (lfn.contains("\\")) {
                    separator = "\\";
                } else if (lfn.contains("/")) {
                    separator = "/";
                }
                int n = i = separator.length() > 0 ? lfn.lastIndexOf(separator) : -1;
                if (i >= 0) {
                    relative = lfn.substring(0, i + 1);
                    this.setLogFilePath(relative);
                }
            }
            this.setLogFileFullPath((String)prefix + lfn);
        } else {
            this.setLogFileName("ELS-Navigator.log");
            this.setLogFileFullPath(this.workingDirectory + System.getProperty("file.separator") + "output/ELS-Navigator.log");
        }
    }

    public void configureWorkingDirectory() throws Exception {
        File wd;
        if (this.workingDirectory == null || this.workingDirectory.length() == 0) {
            this.setWorkingDirectory(this.getDefaultWorkingDirectory());
        }
        if (!(wd = new File(this.getWorkingDirectory())).exists()) {
            wd.mkdirs();
        } else if (!wd.isDirectory()) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Cfg.configuration.directory.is.not.a.directory"), wd.getCanonicalPath()));
        }
        this.setWorkingDirectory(wd.getCanonicalPath());
        System.setProperty("user.dir", this.getWorkingDirectory());
        this.setWorkingDirectorySubscriber(this.getWorkingDirectory());
    }

    public void disableHintTracking() {
        this.hintTrackerFilename = "";
        this.hintsDaemonFilename = "";
    }

    public void dump() {
        Logger logger = LogManager.getLogger("applog");
        Marker SHORT = MarkerManager.getMarker("SHORT");
        Object msg = "Arguments: ";
        for (int index = 0; index < this.originalArgs.length; ++index) {
            if (!StringUtils.isAsciiPrintable(this.originalArgs[index])) continue;
            msg = (String)msg + this.originalArgs[index] + " ";
        }
        logger.info(SHORT, (String)msg);
        if (this.getAuthKeysFile().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.a.authentication.keys.filename"), this.getAuthKeysFile()));
        }
        if (this.getAuthorizedPassword().length() > 0) {
            logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.a.authorize.mode.password.has.been.specified"));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.b.no.back.fill"), this.noBackFill);
        if (this.blacklist.length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.b.blacklist.filename"), this.blacklist));
        }
        if (this.consoleSet) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.c.console.logging.level"), this.getConsoleLevel()));
        }
        if (this.workingDirectory.length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.c.configuration.directory"), this.getWorkingDirectory()));
        }
        if (this.debugSet) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.d.debug.logging.level"), this.getDebugLevel()));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.d.dry.run"), this.dryRun);
        if (this.getExportTextFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.e.export.text.filename"), this.getExportTextFilename()));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.e.empty.directories"), this.emptyDirectoryCheck);
        if (this.getLogFileName().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.choice.f.log.filename"), this.isLogOverwrite() ? 0 : 1, this.getLogFileName()));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.g.listener.keep.going"), this.keepGoing);
        if (this.isQuitSubscriberListener()) {
            logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.g.subscriber.listener.force.quit.now"));
        }
        if (this.hintTrackerFilename != null && this.hintTrackerFilename.length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.h.hint.tracker"), this.getHintTrackerFilename()));
        }
        if (this.hintsDaemonFilename != null && this.hintsDaemonFilename.length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.h.hint.status.server"), this.getHintsDaemonFilename()));
        }
        if (this.getExportCollectionFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.i.export.collection.json.filename"), this.getExportCollectionFilename()));
        }
        if (this.getIpWhitelist().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.i.ip.whitelist.filename"), this.getIpWhitelist()));
        }
        if (this.getOperation() == 8 && this.getJobName().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.j.job"), this.getJobName()));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.j.override.hint.server"), this.overrideHintHost);
        if (this.getHintKeysFile().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.choice.k.hint.keys.filename"), this.isHintSkipMainProcess() ? 0 : 1, this.getHintKeysFile()));
        }
        if (!this.getSelectedLibraryNames().isEmpty()) {
            logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.l.publisher.library.name.s"));
            for (String ln : this.getSelectedLibraryNames()) {
                logger.info(SHORT, "          " + ln);
            }
        }
        if (!this.getExcludedLibraryNames().isEmpty()) {
            logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.l.excluded.library.name.s"));
            for (String ln : this.getExcludedLibraryNames()) {
                logger.info(SHORT, "          " + ln);
            }
        }
        if (!this.getEmailServer().isEmpty()) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.m.email.server"), this.getEmailServer()));
        }
        if (this.getMismatchFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.m.mismatches.output.filename"), this.getMismatchFilename()));
        }
        if (this.marker.length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.marker"), this.marker));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.n.navigator"), this.navigator);
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.n.ignored.files.reported"), this.ignoredReported);
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.o.overwrite"), this.overwrite);
        if (!this.overrideSubscriberHost.isEmpty()) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.o.override.subscriber.server"), this.overrideSubscriberHost));
        }
        if (this.getPublisherLibrariesFileName().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.p.publisher.library.filename"), this.getPublisherLibrariesFileName()));
        }
        if (this.getPublisherCollectionFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.p.publisher.collection.filename"), this.getPublisherCollectionFilename()));
        }
        if (this.isQuitStatusServer()) {
            if (this.getOperation() == 7) {
                logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.q.status.server.force.quit.now"));
            } else {
                logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.q.status.server.quit"));
            }
        }
        if (!this.getRemoteType().equalsIgnoreCase("-")) {
            logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.r.remote.session.type") + this.getRemoteType() + " " + this.getRemoteTypeName(this.getOperation()));
        }
        if (this.getSubscriberLibrariesFileName().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.s.subscriber.library.filename"), this.getSubscriberLibrariesFileName()));
        }
        if (this.getSubscriberCollectionFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.s.subscriber.collection.filename"), this.getSubscriberCollectionFilename()));
        }
        if (this.isForceCollection() || this.getTargetsFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.choice.t.targets.filename"), this.isForceTargets() ? 0 : 1, this.getTargetsFilename()));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.u.duplicates"), this.duplicateCheck);
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.v.validate"), this.validation);
        if (this.getWhatsNewFilename().length() > 0) {
            logger.info(SHORT, MessageFormat.format(this.context.cfg.gs("Cfg.cfg.choice.w.what.s.new.output.filename"), this.isWhatsNewAll() ? 0 : 1) + this.getWhatsNewFilename() + (this.isWhatsNewAll() ? this.context.cfg.gs("Cfg.show.all.items") : ""));
        }
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.x.cross.check"), this.crossCheck);
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.y.preserve.dates"), this.preserveDates);
        this.indicator(logger, SHORT, this.context.cfg.gs("Cfg.cfg.z.decimal.scale"), this.getLongScale() == 1024.0 ? -1 : 1);
        if (this.loggerView) {
            logger.info(SHORT, this.context.cfg.gs("Cfg.cfg.logger.display.mode"));
        }
    }

    public String generateCommandLine(String consoleLevel, String debugLevel, boolean overwriteLog, String log) {
        String exec = this.context.cfg.getExecutablePath();
        String jar = "";
        Configuration cc = this.context.cfg;
        Preferences pr = this.context.preferences;
        boolean glo = this.context.preferences != null ? this.context.preferences.isGenerateLongOptions() : false;
        StringBuilder sb = new StringBuilder();
        String conf = (glo ? "--config \"" : "-C \"") + this.context.cfg.getWorkingDirectory() + "\"";
        if (this.context.cfg.isInstallUpdate()) {
            sb.append(" -Y");
        }
        if (this.context.navigator != null) {
            sb.append(" " + (glo ? "--navigator" : "-n"));
        }
        if (cc.isDryRun() != cc.isDryRun()) {
            sb.append(" " + (glo ? "--dry-run" : "-D"));
        }
        if (!cc.isHintSkipMainProcess() && pr.getLastHintKeysOpenFile().length() > 0 && pr.isLastHintKeysIsOpen()) {
            sb.append(" " + (glo ? "--keys" : "-k") + " \"" + Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), pr.getLastHintKeysOpenFile() + "\""));
        }
        if (cc.isHintSkipMainProcess() && pr.getLastHintKeysOpenFile().length() > 0 && pr.isLastHintKeysIsOpen()) {
            sb.append(" " + (glo ? "--keys-only" : "-K") + " \"" + Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), pr.getLastHintKeysOpenFile() + "\""));
        }
        if (pr.getLastHintTrackingOpenFile().length() > 0 && pr.isLastHintTrackingIsOpen()) {
            String hf = Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), pr.getLastHintTrackingOpenFile());
            if (pr.isLastHintTrackingIsRemote()) {
                if (pr.isLastOverrideHintHost()) {
                    sb.append(" " + (glo ? "--override-hints-host" : "-J"));
                }
                sb.append(" " + (glo ? "--hint-server" : "-H") + " \"" + hf + "\"");
            } else {
                sb.append(" " + (glo ? "--hints" : "-h") + " \"" + hf + "\"");
            }
        }
        if (cc.isRemoteOperation()) {
            sb.append(" " + (glo ? "--remote" : "-r") + " P");
        }
        if (this.context.publisherRepo != null && pr.getLastPublisherOpenFile().length() > 0 && pr.isLastPublisherIsOpen()) {
            sb.append(" " + (glo ? "--publisher-libraries" : (this.context.preferences.isLastPublisherIsWorkstation() ? "-p" : "-P")) + " \"" + Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), pr.getLastPublisherOpenFile()) + "\"");
        }
        if (this.context.subscriberRepo != null && pr.getLastSubscriberOpenFile().length() > 0 && pr.isLastSubscriberIsOpen()) {
            if (!pr.getLastOverrideSubscriber().isEmpty()) {
                sb.append(" " + (glo ? "--override-host" : "-O ") + this.overrideSubscriberHost);
            }
            sb.append(" " + (glo ? "--subscriber-libraries" : "-s") + " \"" + Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), pr.getLastSubscriberOpenFile()) + "\"");
        }
        if (!cc.getEmailServer().isEmpty()) {
            String emailPath = Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), cc.getEmailServer());
            sb.append(" " + (glo ? "--email" : "-M") + " \"" + emailPath + "\"");
        }
        if (!cc.isBinaryScale() != !cc.isBinaryScale()) {
            sb.append(" " + (glo ? "--decimal-scale" : "-z"));
        }
        if (cc.isQuitSubscriberListener() != cc.isQuitSubscriberListener()) {
            sb.append(" " + (glo ? "--listener-quit" : "-G"));
        }
        if (cc.isKeepGoing() != cc.isKeepGoing()) {
            sb.append(" " + (glo ? "--listener-keep-going" : "-g"));
        }
        if (cc.isPreserveDates() != cc.isPreserveDates()) {
            sb.append(" " + (glo ? "--preserve-dates" : "-y"));
        }
        String opts = sb.toString().trim();
        String overOpt = overwriteLog ? (glo ? "--log-overwrite" : "-F") : (glo ? "--log-file" : "-f");
        String cmd = exec + (String)(jar.length() > 0 ? " -jar \"" + jar + "\"" : "") + " " + conf + " " + opts + (glo ? " --console-level " : " -c ") + consoleLevel + (glo ? " --debug-level " : " -d ") + debugLevel + " " + overOpt + " \"" + log + "\"";
        return cmd;
    }

    public String getAuthKeysFile() {
        return this.authKeysFile;
    }

    public String getAuthorizedPassword() {
        return this.authorizedPassword;
    }

    public String getBlacklist() {
        return this.blacklist;
    }

    public static String getBuildChangesUrl() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() >= 5) {
                text = lines.get(5);
            }
        }
        catch (Exception e) {
            text = "unknown";
        }
        return text;
    }

    public static String getBuildDate() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() >= 2) {
                text = lines.get(2);
            }
        }
        catch (Exception e) {
            text = "unknown";
        }
        return text;
    }

    public static String getBuildElsDistro() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() >= 3) {
                text = lines.get(3);
            }
        }
        catch (Exception e) {
            text = "unknown";
        }
        return text;
    }

    public static String getBuildFlags() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() >= 6) {
                text = lines.get(6);
            }
        }
        catch (Exception e) {
            text = "";
        }
        return text;
    }

    public static String getBuildNumber() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() >= 1) {
                text = lines.get(1);
            }
        }
        catch (Exception e) {
            text = "unknown";
        }
        return text;
    }

    public static String getBuildUpdaterDistro() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() >= 4) {
                text = lines.get(4);
            }
        }
        catch (Exception e) {
            text = "unknown";
        }
        return text;
    }

    public static String getBuildVersionName() {
        String text = "";
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/corionis/els/resources/version.info");
            List<String> lines = IoUtils.readAllLines(url);
            if (lines.size() > 0) {
                text = lines.get(0);
            }
        }
        catch (Exception e) {
            text = "unknown";
        }
        return text;
    }

    public String getConsoleLevel() {
        return this.consoleLevel;
    }

    public Context getContext() {
        return this.context;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public String getDefaultWorkingDirectory() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + ".els";
    }

    public String getElsJar() {
        Configuration cfr_ignored_0 = this.context.cfg;
        String path = this.getElsJarPath() + System.getProperty("file.separator") + ELS_JAR;
        return path;
    }

    public String getElsJarPath() {
        Object jarPath = "";
        try {
            jarPath = new File(MainFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            Configuration cfr_ignored_0 = this.context.cfg;
            if (((String)jarPath).endsWith(ELS_JAR)) {
                Configuration cfr_ignored_1 = this.context.cfg;
                jarPath = ((String)jarPath).substring(0, ((String)jarPath).length() - ELS_JAR.length());
            } else {
                String dev = "out" + System.getProperty("file.separator") + "production" + System.getProperty("file.separator") + APPLICATION_NAME;
                if (((String)jarPath).endsWith(dev)) {
                    jarPath = ((String)jarPath).substring(0, ((String)jarPath).length() - dev.length());
                    jarPath = (String)jarPath + "mock/bin";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jarPath;
    }

    public String getEmailServer() {
        return this.emailServer;
    }

    public ArrayList<String> getExcludedLibraryNames() {
        return this.selectedLibraryExcludes;
    }

    public String getExecutablePath() {
        String exePath = this.getInstalledPath() + System.getProperty("file.separator");
        exePath = Utils.isOsWindows() ? exePath + "ELS-Navigator.exe" : (Utils.isOsMac() ? (this.context.preferences.isMacosLauncher() ? "open -F -W -n -a " + this.getInstalledPath() + "/ELS-Navigator.app --args" : exePath + "ELS-Navigator.sh") : exePath + "ELS-Navigator.sh");
        return exePath;
    }

    public String getExportCollectionFilename() {
        return this.exportCollectionFilename;
    }

    public String getExportTextFilename() {
        return this.exportTextFilename;
    }

    public String getFullPathSubscriber(String filename) {
        Object path = this.isRelativePath(filename) ? this.getWorkingDirectorySubscriber() + this.context.subscriberRepo.getSeparator() + filename : filename;
        if (((String)path).matches("^[a-zA-Z]:.*")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public String getHintHandlerFilename() {
        if (this.getHintsDaemonFilename().length() > 0) {
            return this.getHintsDaemonFilename();
        }
        return this.getHintTrackerFilename();
    }

    public String getHintKeysFile() {
        return this.hintKeysFile;
    }

    public String getHintTrackerFilename() {
        return this.hintTrackerFilename;
    }

    public String getHintsDaemonFilename() {
        return this.hintsDaemonFilename;
    }

    public String getIconPath() {
        Object path = "";
        String jarPath = this.getElsJarPath();
        String ext = Utils.getOS().equalsIgnoreCase("Windows") ? ".ico" : ".png";
        path = jarPath + System.getProperty("file.separator") + ELS_ICON + ext;
        return path;
    }

    public String getInstalledPath() {
        Object path = Main.class.getResource("Main.class").toExternalForm();
        if (((String)path).startsWith("jar")) {
            try {
                path = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
                path = FilenameUtils.getPath((String)path);
                if (((String)path).endsWith("bin" + System.getProperty("file.separator"))) {
                    path = ((String)path).substring(0, ((String)path).length() - 5);
                }
                if (((String)path).endsWith(System.getProperty("file.separator"))) {
                    path = ((String)path).substring(0, ((String)path).length() - 1);
                }
                path = System.getProperty("file.separator") + (String)path;
            }
            catch (Exception exception) {}
        } else {
            path = this.getWorkingDirectory();
        }
        return path;
    }

    public String getIpWhitelist() {
        return this.iplist;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getLogFileFullPath() {
        return this.logFileFullPath;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public double getLongScale() {
        return this.longScale;
    }

    public String getMismatchFilename() {
        return this.mismatchFilename;
    }

    public String getNavigatorName() {
        return NAVIGATOR_NAME;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getOriginalCommandline() {
        Object cmd = "";
        for (int index = 0; index < this.originalArgs.length; ++index) {
            if (!StringUtils.isAsciiPrintable(this.originalArgs[index])) continue;
            cmd = (String)cmd + this.originalArgs[index] + " ";
        }
        return cmd;
    }

    public String getOverrideSubscriberHost() {
        return this.overrideSubscriberHost;
    }

    public String getPattern() {
        String withMethod = "%-5p %d{MM/dd/yyyy HH:mm:ss.SSS} %m [%t]:%C.%M:%L%n";
        String withoutMethod = "%-5p %d{MM/dd/yyyy HH:mm:ss.SSS} %m%n";
        if (this.getDebugLevel().trim().equalsIgnoreCase("info")) {
            return withoutMethod;
        }
        return withMethod;
    }

    public String getPublisherCollectionFilename() {
        return this.publisherCollectionFilename;
    }

    public String getPublisherFilename() {
        if (this.getPublisherCollectionFilename() != null && this.getPublisherCollectionFilename().length() > 0) {
            return this.getPublisherCollectionFilename();
        }
        return this.getPublisherLibrariesFileName();
    }

    public String getPublisherLibrariesFileName() {
        return this.publisherLibrariesFileName;
    }

    public String getRemoteType() {
        return this.getRemoteType(this.operation);
    }

    public String getRemoteType(int operation) {
        String op = "-";
        switch (operation) {
            case 0: {
                op = "-";
                break;
            }
            case 4: {
                op = "L";
                break;
            }
            case 3: {
                op = "M";
                break;
            }
            case 1: {
                op = "P";
                break;
            }
            case 2: {
                op = "S";
                break;
            }
            case 5: {
                op = "T";
            }
        }
        return op;
    }

    public String getRemoteTypeName(int operation) {
        String name = "-";
        switch (operation) {
            case 0: {
                name = "Not remote";
                break;
            }
            case 4: {
                name = "Publisher listener";
                break;
            }
            case 3: {
                name = "Publisher manual";
                break;
            }
            case 1: {
                name = "Publisher remote";
                break;
            }
            case 2: {
                name = "Subscriber listener";
                break;
            }
            case 5: {
                name = "Subscriber terminal";
                break;
            }
            case 6: {
                name = "Status server";
                break;
            }
            case 7: {
                name = "Status server force quit";
                break;
            }
            case 8: {
                name = "Job";
                break;
            }
            case 9: {
                name = "Subscriber listener force quit";
            }
        }
        return name;
    }

    public ArrayList<String> getSelectedLibraryNames() {
        return this.selectedLibraryNames;
    }

    public String getSubscriberCollectionFilename() {
        return this.subscriberCollectionFilename;
    }

    public String getSubscriberFilename() {
        if (this.getSubscriberCollectionFilename() != null && this.getSubscriberCollectionFilename().length() > 0) {
            return this.getSubscriberCollectionFilename();
        }
        return this.getSubscriberLibrariesFileName();
    }

    public String getSubscriberLibrariesFileName() {
        return this.subscriberLibrariesFileName;
    }

    public String getTargetsFilename() {
        return this.targetsFilename;
    }

    public String getUrlPrefix() {
        return URL_PREFIX;
    }

    public String getWhatsNewFilename() {
        return this.whatsNewFilename;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getWorkingDirectorySubscriber() {
        if (this.workingDirectorySubscriber.isEmpty()) {
            return this.workingDirectory;
        }
        return this.workingDirectorySubscriber;
    }

    public String gs(String key) {
        String value = "";
        try {
            value = this.currentBundle == null ? key : this.currentBundle.getString(key);
        }
        catch (MissingResourceException e) {
            value = key;
        }
        return value;
    }

    private void indicator(Logger logger, Marker SHORT, String message, int indicator) {
        if (indicator >= 0) {
            String value = indicator == 0 ? "false" : "true";
            logger.info(SHORT, message + value);
        }
    }

    public boolean isBinaryScale() {
        return this.getLongScale() == 1024.0;
    }

    public boolean isCheckForUpdate() {
        return this.checkForUpdate;
    }

    public boolean isCrossCheck() {
        return this.crossCheck == 1;
    }

    public boolean isDefaultNavigator() {
        return this.defaultNavigator;
    }

    public boolean isDryRun() {
        return this.dryRun == 1;
    }

    public boolean isDuplicateCheck() {
        return this.duplicateCheck == 1;
    }

    public boolean isEmptyDirectoryCheck() {
        return this.emptyDirectoryCheck == 1;
    }

    public boolean isExcludedLibrary(String name) {
        for (String library : this.selectedLibraryExcludes) {
            if (!library.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isForceCollection() {
        return this.forceCollection == 1;
    }

    public boolean isForceTargets() {
        return this.forceTargets == 1;
    }

    public boolean isGui() {
        return this.loggerView || this.navigator == 1;
    }

    public boolean isHintSkipMainProcess() {
        return this.hintSkipMainProcess == 1;
    }

    public boolean isHintTrackingEnabled() {
        return this.hintTrackerFilename.length() > 0 || this.hintsDaemonFilename.length() > 0;
    }

    public boolean isIgnoredReported() {
        return this.ignoredReported == 1;
    }

    public boolean isInstallUpdate() {
        return this.installUpdate;
    }

    public boolean isKeepGoing() {
        return this.keepGoing == 1;
    }

    public boolean isLogOverwrite() {
        return this.logOverwrite == 1;
    }

    public boolean isLoggerView() {
        return this.loggerView;
    }

    public boolean isNavigator() {
        return this.navigator == 1;
    }

    public boolean isNoBackFill() {
        return this.noBackFill == 1;
    }

    public boolean isOverrideHintsHost() {
        return this.overrideHintHost == 1;
    }

    public boolean isOverwrite() {
        return this.overwrite == 1;
    }

    public boolean isPreserveDates() {
        return this.preserveDates == 1;
    }

    public boolean isPublishOperation() {
        return this.operation == 0 || this.operation == 1;
    }

    public boolean isPublisherListener() {
        return this.getOperation() == 4;
    }

    public boolean isPublisherTerminal() {
        return this.getOperation() == 3;
    }

    public boolean isQuitStatusServer() {
        return this.quitStatusServer == 1;
    }

    public boolean isQuitSubscriberListener() {
        return this.quitSubscriberListener == 1;
    }

    public boolean isRelativePath(String path) {
        if (path.matches("^[a-zA-Z]:.*")) {
            return false;
        }
        return !path.startsWith("/") && !path.startsWith("\\") && !path.startsWith("|");
    }

    public boolean isRemoteActive() {
        if (this.isRemoteStatusServer()) {
            return true;
        }
        return this.isRemoteSubscriber();
    }

    public boolean isRemoteOperation() {
        return this.getOperation() != 0 && this.getOperation() != 8;
    }

    public boolean isRemotePublishOperation() {
        return this.getOperation() == 1;
    }

    public boolean isRemoteStatusServer() {
        return this.context.hintsStty != null && this.context.hintsStty.isConnected();
    }

    public boolean isRemoteSubscriber() {
        return this.context.clientStty != null && this.context.clientStty.isConnected();
    }

    public boolean isRequestCollection() {
        return this.requestCollection == 1;
    }

    public boolean isRequestTargets() {
        return this.requestTargets == 1;
    }

    public boolean isSelectedLibrary(String name) {
        for (String library : this.selectedLibraryNames) {
            if (!library.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isSpecificExclude() {
        return this.specificExclude == 1;
    }

    public boolean isSpecificLibrary() {
        return this.specificLibrary == 1;
    }

    public boolean isStatusServer() {
        return this.getOperation() == 6;
    }

    public boolean isSubscriberListener() {
        return this.getOperation() == 2;
    }

    public boolean isSubscriberTerminal() {
        return this.getOperation() == 5;
    }

    public boolean isTargetsEnabled() {
        return this.targetsEnabled == 1;
    }

    public boolean isUpdateFailed() {
        return this.updateFailed;
    }

    public boolean isUpdateSuccessful() {
        return this.updateSuccessful;
    }

    public boolean isValidation() {
        return this.validation == 1;
    }

    public boolean isWhatsNewAll() {
        return this.whatsNewAll == 1;
    }

    public void loadLocale(String filePart) {
        this.loadLocale(filePart, this.context.cfg);
    }

    public void loadLocale(String filePart, Configuration config) {
        if (!Arrays.asList(availableLocales).contains(filePart)) {
            filePart = "en_US";
        }
        config.setCurrentBundle(ResourceBundle.getBundle("com.corionis.els.locales.bundle_" + filePart));
    }

    public String makeFullPath(Repository repo, String filename) {
        Object path = filename;
        if (Utils.isRelativePath(filename)) {
            if (repo.getPurpose() == 1) {
                path = this.getWorkingDirectory();
            } else if (repo.getPurpose() == 2) {
                path = this.getWorkingDirectorySubscriber();
            }
            path = (String)path + repo.getSeparator() + filename;
        }
        return path;
    }

    public String makeRelativePath(String path) {
        if (path != null && path.length() > 0) {
            path = Utils.makeRelativePath(this.getWorkingDirectory(), path);
            path = Utils.pipe(path);
            path = Utils.unpipe(path, "/");
        } else {
            path = "";
        }
        return path;
    }

    public String makeRelativePathSubscriber(String path) {
        path = path != null && path.length() > 0 ? Utils.makeRelativePath(this.getWorkingDirectorySubscriber(), path) : "";
        return path;
    }

    public void parseCommandLine(String[] args) throws MungeException {
        this.originalArgs = args;
        block159: for (int index = 0; index < args.length; ++index) {
            switch (args[index]) {
                case "-A": 
                case "--auth-keys": {
                    if (index <= args.length - 2) {
                        this.setAuthKeysFile(args[index + 1].trim());
                        this.verifyFileExistence(this.getAuthKeysFile());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.a.requires.an.els.authentication.keys.filename"));
                }
                case "-a": 
                case "--authorize": {
                    if (index <= args.length - 2) {
                        this.setAuthorizedPassword(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.a.requires.a.password.value"));
                }
                case "-b": 
                case "--no-back-fill": {
                    this.setNoBackFill(true);
                    continue block159;
                }
                case "-B": 
                case "--blacklist": {
                    if (index <= args.length - 2) {
                        this.setBlacklist(args[index + 1].trim());
                        this.verifyFileExistence(this.getBlacklist());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.b.requires.a.blacklist.filename"));
                }
                case "-c": 
                case "--console-level": {
                    if (index <= args.length - 2) {
                        this.setConsoleLevel(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.c.requires.a.level.trace.debug.info.warn.error.fatal.or.off"));
                }
                case "-C": 
                case "--config": {
                    if (index <= args.length - 2) {
                        this.setWorkingDirectory(args[index + 1].trim());
                        this.verifyFileExistence(this.getWorkingDirectory());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.c.requires.a.directory.path"));
                }
                case "-d": 
                case "--debug-level": {
                    if (index <= args.length - 2) {
                        this.setDebugLevel(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.d.requires.a.level.trace.debug.info.warn.error.fatal.or.off"));
                }
                case "-D": 
                case "--dry-run": {
                    this.setDryRun(true);
                    continue block159;
                }
                case "--dump-system": {
                    System.out.println("ELS version " + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate() + System.getProperty("line.separator"));
                    System.getProperties().list(System.out);
                    System.exit(1);
                    continue block159;
                }
                case "-e": 
                case "--export-text": {
                    if (index <= args.length - 2) {
                        this.setExportTextFilename(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.e.requires.an.export.path.output.filename"));
                }
                case "-E": 
                case "--empty-directories": {
                    this.setEmptyDirectoryCheck(true);
                    continue block159;
                }
                case "-f": 
                case "-F": 
                case "--log-file": 
                case "--log-overwrite": {
                    if (this.getLogFileName().length() > 0) {
                        throw new MungeException(this.context.cfg.gs("Cfg.error.f.and.f.cannot.be.used.at.the.same.time"));
                    }
                    if (args[index].equals("-F") || args[index].equals("--log-overwrite")) {
                        this.setLogOverwrite(true);
                    }
                    if (index <= args.length - 2) {
                        this.setLogFileName(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.f.requires.a.log.filename"));
                }
                case "-g": 
                case "--listener-keep-going": {
                    this.setKeepGoing(true);
                    continue block159;
                }
                case "-G": 
                case "--listener-quit": {
                    this.setQuitSubscriberListener(true);
                    continue block159;
                }
                case "-h": 
                case "--hints": {
                    if (index <= args.length - 2) {
                        this.setHintTrackerFilename(args[index + 1].trim());
                        this.verifyFileExistence(this.getHintTrackerFilename());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.h.requires.a.hint.status.tracker.repository.filename"));
                }
                case "-H": 
                case "--hint-server": {
                    if (index <= args.length - 2) {
                        this.setHintsDaemonFilename(args[index + 1].trim());
                        this.verifyFileExistence(this.getHintsDaemonFilename());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.h.requires.a.hint.status.server.repository.filename"));
                }
                case "-i": 
                case "--export-items": {
                    if (index <= args.length - 2) {
                        this.setExportCollectionFilename(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.i.requires.a.collection.output.filename"));
                }
                case "-I": 
                case "--ip-whitelist": {
                    if (index <= args.length - 2) {
                        this.setIplist(args[index + 1].trim());
                        this.verifyFileExistence(this.getIpWhitelist());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.i.requires.an.ip.whitelist.filename"));
                }
                case "-j": 
                case "--job": {
                    if (index <= args.length - 2) {
                        this.setJobName(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.j.requires.a.job.name"));
                }
                case "-J": 
                case "--override-hints-host": {
                    this.setOverrideHintsHost(true);
                    continue block159;
                }
                case "-k": 
                case "--keys": {
                    if (index <= args.length - 2) {
                        this.setHintKeysFile(args[index + 1].trim());
                        this.verifyFileExistence(this.getHintKeysFile());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.k.requires.an.els.hint.keys.filename"));
                }
                case "-K": 
                case "--keys-only": {
                    if (index <= args.length - 2) {
                        this.setHintKeysFile(args[index + 1].trim());
                        this.verifyFileExistence(this.getHintKeysFile());
                        ++index;
                        this.setHintSkipMainProcess(true);
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.k1.requires.an.els.hint.keys.filename"));
                }
                case "-l": 
                case "--library": {
                    if (index <= args.length - 2) {
                        this.addPublisherLibraryName(args[index + 1].trim());
                        this.setSpecificLibrary(true);
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.l.requires.a.publisher.library.name"));
                }
                case "-L": 
                case "--exclude": {
                    if (index <= args.length - 2) {
                        this.addExcludedLibraryName(args[index + 1].trim());
                        this.setSpecificExclude(true);
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.l.requires.a.publisher.library.name.to.exclude"));
                }
                case "--logger": {
                    this.setLoggerView(true);
                    continue block159;
                }
                case "-m": 
                case "--mismatches": {
                    if (index <= args.length - 2) {
                        this.setMismatchFilename(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.m.requires.a.mismatches.output.filename"));
                }
                case "-M": 
                case "--email": {
                    if (index <= args.length - 2) {
                        this.setEmailServer(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.m.requires.an.email.server"));
                }
                case "--marker": {
                    if (index <= args.length - 2) {
                        this.marker = args[index + 1].trim();
                        ++index;
                        continue block159;
                    }
                    this.marker = this.context.cfg.gs("Cfg.marker.enabled");
                    continue block159;
                }
                case "-n": 
                case "--navigator": {
                    this.setNavigator(true);
                    continue block159;
                }
                case "-N": 
                case "--ignored": {
                    this.setIgnoredReported(true);
                    continue block159;
                }
                case "-o": 
                case "--overwrite": {
                    this.setOverwrite(true);
                    continue block159;
                }
                case "-O": 
                case "--override-subscriber-host": {
                    if (index <= args.length - 2 && !args[index + 1].startsWith("-")) {
                        this.setOverrideSubscriberHost(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    this.setOverrideSubscriberHost("true");
                    continue block159;
                }
                case "-p": 
                case "--publisher-libraries": {
                    if (index <= args.length - 2) {
                        this.setPublisherLibrariesFileName(args[index + 1].trim());
                        this.verifyFileExistence(this.getPublisherLibrariesFileName());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.p.requires.a.publisher.libraries.filename"));
                }
                case "-P": 
                case "--publisher-collection": {
                    if (index <= args.length - 2) {
                        this.setPublisherCollectionFilename(args[index + 1].trim());
                        this.verifyFileExistence(this.getPublisherCollectionFilename());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.p.requires.a.publisher.collection.filename"));
                }
                case "-q": 
                case "--quit-status": {
                    this.setQuitStatusServer(true);
                    continue block159;
                }
                case "-Q": 
                case "--force-quit": {
                    this.setQuitStatusServer(true);
                    continue block159;
                }
                case "-r": 
                case "--remote": {
                    if (index <= args.length - 2) {
                        this.remoteArg = args[index + 1].trim();
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.r.must.be.followed.by.p.l.m.s.t.case.insensitive"));
                }
                case "-s": 
                case "--subscriber-libraries": {
                    if (index <= args.length - 2) {
                        this.setForceCollection(false);
                        this.setRequestCollection(true);
                        this.setSubscriberLibrariesFileName(args[index + 1].trim());
                        this.verifyFileExistence(this.getSubscriberLibrariesFileName());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.s.requires.a.subscriber.libraries.filename"));
                }
                case "-S": 
                case "--subscriber-collection": {
                    if (index <= args.length - 2) {
                        this.setForceCollection(true);
                        this.setRequestCollection(false);
                        this.setSubscriberCollectionFilename(args[index + 1].trim());
                        this.verifyFileExistence(this.getSubscriberCollectionFilename());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.s.requires.an.subscriber.collection.filename"));
                }
                case "-t": 
                case "--targets": {
                    this.setTargetsEnabled(true);
                    this.setForceTargets(false);
                    this.setRequestTargets(true);
                    if (index > args.length - 2 || args[index + 1].startsWith("-")) continue block159;
                    this.setTargetsFilename(args[index + 1].trim());
                    this.verifyFileExistence(this.getTargetsFilename());
                    ++index;
                    continue block159;
                }
                case "-T": 
                case "--force-targets": {
                    this.setTargetsEnabled(true);
                    this.setForceTargets(true);
                    this.setRequestTargets(false);
                    if (index > args.length - 2 || args[index + 1].startsWith("-")) continue block159;
                    this.setTargetsFilename(args[index + 1].trim());
                    this.verifyFileExistence(this.getTargetsFilename());
                    ++index;
                    continue block159;
                }
                case "-u": 
                case "--duplicates": {
                    this.setDuplicateCheck(true);
                    continue block159;
                }
                case "--update-failed": {
                    this.setUpdateFailed(true);
                    continue block159;
                }
                case "--update-successful": {
                    this.setUpdateSuccessful();
                    continue block159;
                }
                case "-v": 
                case "--validate": {
                    this.setValidation(true);
                    continue block159;
                }
                case "-V": 
                case "--check-update": {
                    this.setCheckForUpdate(true);
                    continue block159;
                }
                case "--version": {
                    System.out.println("");
                    System.out.println(PROGRAM_NAME + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                    System.out.println(this.context.cfg.gs("Cfg.see.the.els.wiki.on.github.for.documentation.at"));
                    System.out.println("  https://github.com/Corionis/ELS/wiki");
                    System.out.println("");
                    System.exit(1);
                    continue block159;
                }
                case "-w": 
                case "--whatsnew": {
                    if (index <= args.length - 2) {
                        this.setWhatsNewFilename(args[index + 1].trim());
                        ++index;
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.w.requires.a.what.s.new.output.filename"));
                }
                case "-W": 
                case "--whatsnew-all": {
                    if (index <= args.length - 2) {
                        this.setWhatsNewFilename(args[index + 1].trim());
                        ++index;
                        this.setWhatsNewAll(true);
                        continue block159;
                    }
                    throw new MungeException(this.context.cfg.gs("Cfg.error.w1.requires.a.what.s.new.output.filename"));
                }
                case "-x": 
                case "--cross-check": {
                    this.setCrossCheck(true);
                    continue block159;
                }
                case "-y": 
                case "--preserve-dates": {
                    this.setPreserveDates(true);
                    continue block159;
                }
                case "-Y": 
                case "--install-update": {
                    this.setInstallUpdate(true);
                    continue block159;
                }
                case "-z": 
                case "--decimal-scale": {
                    this.setLongScale(false);
                    continue block159;
                }
                default: {
                    if (!StringUtils.isAsciiPrintable(args[index]) || args[index].endsWith(".exe") || args[index].endsWith(".app")) continue block159;
                    this.context.fault = true;
                    throw new MungeException(this.context.cfg.gs("Cfg.error.unknown.option") + args[index]);
                }
            }
        }
    }

    public void setAuthKeysFile(String authKeysFile) {
        this.authKeysFile = authKeysFile;
    }

    public void setAuthorizedPassword(String password) {
        this.authorizedPassword = password;
    }

    public void setBlacklist(String blacklist) {
        this.blacklist = blacklist;
    }

    public void setCheckForUpdate(boolean checkForUpdate) {
        this.checkForUpdate = checkForUpdate;
    }

    public void setConsoleLevel(String consoleLevel) {
        this.consoleLevel = consoleLevel;
        this.consoleSet = true;
    }

    public void setCrossCheck(boolean crossCheck) {
        this.crossCheck = crossCheck ? 1 : 0;
    }

    public void setCurrentBundle(ResourceBundle bundle) {
        this.currentBundle = bundle;
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
        this.debugSet = true;
    }

    public void setDefaultNavigator(boolean defaultNavigator) {
        this.defaultNavigator = defaultNavigator;
        this.setNavigator(true);
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun ? 1 : 0;
    }

    public void setDuplicateCheck(boolean duplicateCheck) {
        this.duplicateCheck = duplicateCheck ? 1 : 0;
    }

    public void setEmailServer(String emailServer) {
        this.emailServer = emailServer;
    }

    public void setEmptyDirectoryCheck(boolean emptyDirectoryCheck) {
        this.emptyDirectoryCheck = emptyDirectoryCheck ? 1 : 0;
    }

    public void setExportCollectionFilename(String exportCollectionFilename) {
        this.exportCollectionFilename = exportCollectionFilename;
    }

    public void setExportTextFilename(String exportTextFilename) {
        this.exportTextFilename = exportTextFilename;
    }

    public void setForceCollection(boolean forceCollection) {
        this.forceCollection = forceCollection ? 1 : 0;
    }

    public void setForceTargets(boolean forceTargets) {
        this.forceTargets = forceTargets ? 1 : 0;
    }

    public void setHintKeysFile(String hintKeysFile) {
        this.hintKeysFile = hintKeysFile;
    }

    public void setHintSkipMainProcess(boolean hintSkipMainProcess) {
        this.hintSkipMainProcess = hintSkipMainProcess ? 1 : 0;
    }

    public void setHintTrackerFilename(String hintTrackerFilename) {
        this.hintTrackerFilename = hintTrackerFilename;
    }

    public void setHintsDaemonFilename(String hintsDaemonFilename) {
        this.hintsDaemonFilename = hintsDaemonFilename;
    }

    public void setIgnoredReported(boolean ignoredReported) {
        this.ignoredReported = ignoredReported ? 1 : 0;
    }

    public void setInstallUpdate(boolean installUpdate) {
        this.installUpdate = installUpdate;
    }

    public void setIplist(String iplist) {
        this.iplist = iplist;
    }

    public void setJobName(String name) {
        this.jobName = name;
    }

    public void setKeepGoing(boolean keepGoing) {
        this.keepGoing = keepGoing ? 1 : 0;
    }

    public void setLogFileFullPath(String logFileFullPath) {
        this.logFileFullPath = logFileFullPath;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public void setLogOverwrite(boolean logOverwrite) {
        this.logOverwrite = logOverwrite ? 1 : 0;
    }

    public void setLoggerView(boolean loggerView) {
        this.loggerView = loggerView;
    }

    public void setLongScale(boolean binaryScale) {
        this.longScale = binaryScale ? 1024.0 : 1000.0;
    }

    public void setMismatchFilename(String mismatchFilename) {
        this.mismatchFilename = mismatchFilename;
    }

    public void setNavigator(boolean navigator) {
        this.navigator = navigator ? 1 : 0;
    }

    public void setNoBackFill(boolean noBackFill) {
        this.noBackFill = noBackFill ? 1 : 0;
    }

    public void setOperation(String remoteType) {
        this.operation = -1;
        if (remoteType.isEmpty()) {
            remoteType = this.remoteArg;
        }
        if (!remoteType.isEmpty()) {
            if (remoteType.equalsIgnoreCase("P")) {
                this.operation = 1;
            } else if (remoteType.equalsIgnoreCase("S")) {
                this.operation = 2;
            } else if (remoteType.equalsIgnoreCase("M")) {
                this.operation = 3;
            } else if (remoteType.equalsIgnoreCase("L")) {
                this.operation = 4;
            } else if (remoteType.equalsIgnoreCase("T")) {
                this.operation = 5;
            } else if (!remoteType.equals("-")) {
                remoteType = "-";
            }
        }
        if (this.getPublisherFilename().length() == 0 && this.getSubscriberFilename().length() == 0 && this.getHintsDaemonFilename().length() > 0) {
            this.operation = 6;
        }
        if (this.operation == -1) {
            if (!this.getJobName().isEmpty()) {
                this.operation = 8;
            }
            if (this.isQuitStatusServer() && this.operation == -1) {
                this.operation = 7;
            }
            if (this.isQuitSubscriberListener() && this.operation == -1) {
                this.operation = 9;
            }
        }
        if (this.operation == -1) {
            this.operation = 0;
        }
    }

    public void setOverrideHintsHost(boolean overrideHintHost) {
        this.overrideHintHost = overrideHintHost ? 1 : 0;
    }

    public void setOverrideSubscriberHost(String overrideSubscriberHost) {
        this.overrideSubscriberHost = overrideSubscriberHost;
    }

    public void setOverwrite(boolean sense) {
        this.overwrite = sense ? 1 : 0;
    }

    public void setPreserveDates(boolean preserveDates) {
        this.preserveDates = preserveDates ? 1 : 0;
    }

    public void setPublisherCollectionFilename(String publisherCollectionFilename) {
        this.publisherCollectionFilename = publisherCollectionFilename;
    }

    public void setPublisherLibrariesFileName(String publisherLibrariesFileName) {
        this.publisherLibrariesFileName = publisherLibrariesFileName;
    }

    public void setQuitStatusServer(boolean quitStatusServer) {
        this.quitStatusServer = quitStatusServer ? 1 : 0;
    }

    public void setQuitSubscriberListener(boolean quitSubscriberListener) {
        this.quitSubscriberListener = quitSubscriberListener ? 1 : 0;
    }

    public void setRequestCollection(boolean requestCollection) {
        this.requestCollection = requestCollection ? 1 : 0;
    }

    public void setRequestTargets(boolean requestTargets) {
        this.requestTargets = requestTargets ? 1 : 0;
    }

    public void setSelectedLibraryNames(ArrayList<String> includedLibraries) {
        this.selectedLibraryNames = includedLibraries;
    }

    public void setSpecificExclude(boolean sense) {
        this.specificExclude = sense ? 1 : 0;
    }

    public void setSpecificLibrary(boolean sense) {
        this.specificLibrary = sense ? 1 : 0;
    }

    public void setSubscriberCollectionFilename(String subscriberCollectionFilename) {
        this.subscriberCollectionFilename = subscriberCollectionFilename;
    }

    public void setSubscriberLibrariesFileName(String subscriberLibrariesFileName) {
        this.subscriberLibrariesFileName = subscriberLibrariesFileName;
    }

    public void setTargetsEnabled(boolean sense) {
        this.targetsEnabled = sense ? 1 : 0;
    }

    public void setTargetsFilename(String targetsFilename) {
        this.targetsFilename = targetsFilename;
    }

    public void setUpdateFailed(boolean updateFailed) {
        this.updateFailed = updateFailed;
    }

    public void setUpdateSuccessful() {
        this.updateSuccessful = true;
    }

    public void setValidation(boolean validation) {
        this.validation = validation ? 1 : 0;
    }

    public void setWhatsNewAll(boolean isWhatsNewAll) {
        this.whatsNewAll = isWhatsNewAll ? 1 : 0;
    }

    public void setWhatsNewFilename(String whatsNewFilename) {
        this.whatsNewFilename = whatsNewFilename;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setWorkingDirectorySubscriber(String workingDirectorySubscriber) {
        this.workingDirectorySubscriber = workingDirectorySubscriber;
    }

    private void verifyFileExistence(String file) throws MungeException {
        Object filename;
        boolean isRelative = this.isRelativePath(file);
        if (isRelative) {
            String prefix = this.context.cfg.getWorkingDirectory().length() > 0 ? this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") : "";
            filename = prefix + file;
        } else {
            filename = file;
        }
        File candidate = new File((String)filename);
        if (!candidate.exists() || !candidate.canRead()) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Cfg.file.not.found.or.not.readable"), filename));
        }
    }
}

