/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.browser.BrowserTableModel;
import com.corionis.els.gui.util.RotatedIcon;
import com.corionis.els.gui.util.SmartScroller;
import com.corionis.els.gui.util.TextIcon;
import com.corionis.els.gui.util.VerticalLabel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainFrame
extends JFrame {
    private transient Logger logger = LogManager.getLogger("applog");
    private Context context;
    public JMenuBar menuBarMain;
    public JMenu menuFile;
    public JMenuItem menuItemOpenPublisher;
    public JMenuItem menuItemOpenSubscriber;
    public JMenuItem menuItemOpenHintKeys;
    public JMenuItem menuItemOpenHintTracking;
    public JMenu menuItemClose;
    public JMenuItem menuItemClosePublisher;
    public JMenuItem menuItemCloseSubscriber;
    public JMenuItem menuItemCloseHintKeys;
    public JMenuItem menuItemCloseHintTracking;
    public JMenuItem menuItemGenerate;
    public JMenuItem menuItemSaveLayout;
    public JMenuItem menuItemQuitTerminate;
    public JMenuItem menuItemFileQuit;
    public JMenu menuEdit;
    public JMenuItem menuItemCopy;
    public JMenuItem menuItemCut;
    public JMenuItem menuItemPaste;
    public JMenuItem menuItemDelete;
    public JMenuItem menuItemNewFolder;
    public JMenuItem menuItemRename;
    public JMenuItem menuItemTouch;
    public JMenuItem menuItemFind;
    public JMenuItem menuItemFindNext;
    public JMenu menuView;
    public JMenuItem menuItemProgress;
    public JMenuItem menuItemRefresh;
    public JCheckBoxMenuItem radioButtonAutoRefresh;
    public JCheckBoxMenuItem menuItemShowHidden;
    public JCheckBoxMenuItem menuItemShowNavigation;
    public JCheckBoxMenuItem menuItemShowToolbar;
    public JCheckBoxMenuItem menuItemWordWrap;
    public JMenu menuBookmarks;
    public JMenuItem menuItemAddBookmark;
    public JMenuItem menuItemBookmarksDelete;
    public JMenu menuTools;
    public JMenuItem menuItemDuplicates;
    public JMenuItem menuItemEmptyFinder;
    public JMenuItem menuItemArchiver;
    public JMenuItem menuItemCleanup;
    public JMenuItem menuItemJunk;
    public JMenuItem menuItemOperations;
    public JMenuItem menuItemRenamer;
    public JMenuItem menuItemSleep;
    public JMenuItem menuItemExternalTools;
    public JMenuItem menuItemPlexGenerator;
    public JMenu menuJobs;
    public JMenuItem menuItemJobsManage;
    public JMenu menuSystem;
    public JMenuItem menuItemHints;
    public JMenuItem menuItemAuthKeys;
    public JMenuItem menuItemHintKeys;
    public JMenuItem menuItemBlacklist;
    public JMenuItem menuItemWhitelist;
    public JMenuItem menuItemEmail;
    public JMenuItem menuItemSettings;
    public JMenu menuWindows;
    public JMenuItem menuItemMaximize;
    public JMenuItem menuItemMinimize;
    public JMenuItem menuItemRestore;
    public JMenuItem menuItemSplitHorizontal;
    public JMenuItem menuItemSplitVertical;
    public JMenu menuHelp;
    public JMenuItem menuItemControls;
    public JMenuItem menuItemGettingStarted;
    public JMenuItem menuItemWebSite;
    public JMenuItem menuItemDiscussions;
    public JMenuItem menuItemDocumentation;
    public JMenuItem menuItemGitHubProject;
    public JMenuItem menuItemIssue;
    public JMenuItem menuItemChangelist;
    public JMenuItem menuItemReleaseNotes;
    public JMenuItem menuItemUpdates;
    public JMenuItem menuItemAbout;
    public JPanel panelAlertsMenu;
    public JLabel labelAlertHintsMenu;
    public JLabel labelAlertUpdateMenu;
    public JPanel panelMain;
    public JPanel panelToolbar;
    public JMenuBar menuToolbar;
    public JButton menuTbCopy;
    public JButton menuTbCut;
    public JButton menuTbPaste;
    public JButton menuTbDelete;
    public JButton menuTbNewFolder;
    public JButton menuTbRefresh;
    public JPanel panelAlertsToolbar;
    public JLabel labelAlertHintsToolbar;
    public JLabel labelAlertUpdateToolbar;
    public JPanel vSpacer5;
    public JTabbedPane tabbedPaneMain;
    public JSplitPane splitPaneBrowser;
    public JPanel panelBrowserTop;
    public JPanel panelLocationAndButtons;
    public JPanel panelLocationAndTracker;
    public JPanel vSpacer1;
    public JPanel panelLocation;
    public JPanel panelLocationLeft;
    public JButton buttonBack;
    public JButton buttonForward;
    public JButton buttonUp;
    public JTextField textFieldLocation;
    public JPanel hSpacer1;
    public JPanel panelHintTracking;
    public JButton buttonHintTracking;
    public JPanel hSpacer2;
    public JPanel vSpacer2;
    public JSplitPane splitPaneTwoBrowsers;
    public JTabbedPane tabbedPaneBrowserOne;
    public JPanel panelCollectionOne;
    public JSplitPane splitPaneCollectionOne;
    public JScrollPane scrollPaneTreeCollectionOne;
    public JTree treeCollectionOne;
    public JScrollPane scrollPaneTableCollectionOne;
    public JTable tableCollectionOne;
    public JPanel panelSystemOne;
    public JSplitPane splitPaneSystemOne;
    public JScrollPane scrollPaneTreeSystemOne;
    public JTree treeSystemOne;
    public JScrollPane scrollPaneTableSystemOne;
    public JTable tableSystemOne;
    public JTabbedPane tabbedPaneBrowserTwo;
    public JPanel panelCollectionTwo;
    public JSplitPane splitPaneCollectionTwo;
    public JScrollPane scrollPaneTreeCollectionTwo;
    public JTree treeCollectionTwo;
    public JScrollPane scrollPaneTableCollectionTwo;
    public JTable tableCollectionTwo;
    public JPanel panelSystemTwo;
    public JSplitPane splitPaneSystemTwo;
    public JScrollPane scrollPaneTreeSystemTwo;
    public JTree treeSystemTwo;
    public JScrollPane scrollPaneTableSystemTwo;
    public JTable tableSystemTwo;
    public JTabbedPane tabbedPaneNavigatorBottom;
    public JScrollPane scrollPaneLog;
    public JTextArea textAreaLog;
    public JScrollPane scrollPaneProperties;
    public JEditorPane textAreaProperties;
    public JPanel panelLibraries;
    public JPanel panelLibsTop;
    public JPanel panelTopButtons;
    public JPanel hSpacer7;
    public JButton buttonNew;
    public JButton buttonCopy;
    public JButton buttonDelete;
    public JPanel hSpacer10;
    public JLabel dynamicLabel;
    public JPanel panelHelp;
    public JLabel labelLibrariesHelp;
    public JSplitPane splitPaneLibs;
    public JScrollPane scrollPaneConfig;
    public JTable librariesConfigItems;
    public JPanel panelOptions;
    public JPanel panelControls;
    public JPanel topType;
    public JPanel vSpacer0;
    public JPanel panelLibraryType;
    public JPanel hSpacer3;
    public JLabel labelLibaryType;
    public JPanel panelCardBox;
    public JPanel vSpacer3;
    public JSeparator separator13;
    public JPanel vSpacer4;
    public JTabbedPane tabbedPaneLibrarySpaces;
    public JScrollPane scrollPaneGeneral;
    public JPanel generalOptions;
    public JPanel panelGettingStartedCard;
    public JLabel labelOperationGettingStarted;
    public JPanel panelLibraryCard;
    public JPanel hSpacer4;
    public JPanel hSpacer6;
    public JPanel vSpacer6;
    public JPanel hSpacer5;
    public JLabel label1;
    public JTextField textFieldPath;
    public JLabel labelKey;
    public JTextField textFieldKey;
    public JPanel vSpacer33;
    public JButton buttonLibraryGenerateKey;
    public JLabel labelHost;
    public JTextField textFieldHost;
    public JPanel vSpacer34;
    public JLabel labelListen;
    public JTextField textFieldListen;
    public JPanel vSpacer35;
    public JLabel labelTimeout;
    public JTextField textFieldTimeout;
    public JPanel vSpacer36;
    public JLabel labelFlavor;
    public JComboBox<String> comboBoxFlavor;
    public JPanel vSpacer37;
    public JLabel labelCase;
    public JCheckBox checkBoxCase;
    public JPanel vSpacer38;
    public JLabel labelTempDated;
    public JCheckBox checkBoxTempDated;
    public JPanel vSpacer42;
    public JLabel labelTempLocation;
    public JTextField textFieldTempLocation;
    public JPanel vSpacer39;
    public JButton buttonLibrarySelectTempLocation;
    public JLabel labelTerminalAllosed;
    public JCheckBox checkBoxTerminalAllowed;
    public JPanel vSpacer40;
    public JLabel labelIgnores;
    public JPanel panelLibrariesIgnorePatternsBox;
    public JScrollPane scrollPaneLibrariesIgnorePatterns;
    public JList<String> listLibrariesIgnorePatterns;
    public JPanel panelLibrariesIgnorePatternsButtons;
    public JButton buttonLibrariesAddIgnore;
    public JButton buttonLibrariesRemoveIgnore;
    public JPanel vSpacer41;
    public JLabel labelEmailAddr;
    public JTextField textFieldEmailAddr;
    public JPanel vSpacer44;
    public JLabel labelMismatches;
    public JCheckBox checkBoxMismatches;
    public JLabel labelFormat;
    public JComboBox<String> comboBoxFormat;
    public JPanel vSpacer43;
    public JLabel labelWhatsNew;
    public JCheckBox checkBoxWhatsNew;
    public JLabel labelSkipOffline;
    public JCheckBox checkBoxSkipOffline;
    public JPanel panelXCard;
    public JPanel panelYCard;
    public JPanel locationsTab;
    public JScrollPane scrollPaneLocations;
    public JTable tableLocations;
    public JPanel panelLocButtons;
    public JButton buttonAddLocation;
    public JButton buttonRemoveLocation;
    public JPanel bibliographyTab;
    public JSplitPane splitPanelBiblio;
    public JPanel panelBiblioLibraries;
    public JPanel panelHeader;
    public JLabel labelLibraries;
    public JLabel labelMatchDates;
    public JScrollPane scrollPaneBiblioLibraries;
    public JTable tableBiblioLibraries;
    public JPanel panelSources;
    public JPanel panelSourcesTop;
    public JLabel labelSpacer42;
    public JLabel labelSources;
    public JScrollPane scrollPaneSources;
    public JList listSources;
    public JPanel panelSourceButtons;
    public JButton buttonAddSource;
    public JButton buttonAddMultiSource;
    public JButton buttonUpSource;
    public JButton buttonDownSource;
    public JButton buttonRemoveSource;
    public JPanel panelBiblioButtons;
    public JButton buttonAddLibrary;
    public JButton buttonRemoveLibrary;
    public JPanel buttonBarLibs;
    public JButton saveButton;
    public JButton cancelButton;
    public JPanel hSpacer8;
    public JPanel panelStatus;
    public JLabel labelStatusLeft;
    public JLabel labelStatusMiddle;
    public JLabel labelStatusRight;
    public JPanel hSpacer9;
    public JPopupMenu popupMenuBrowser;
    public JMenuItem popupMenuItemRefresh;
    public JMenuItem popupMenuItemCopy;
    public JMenuItem popupMenuItemCut;
    public JMenuItem popupMenuItemPaste;
    public JMenuItem popupMenuItemDelete;
    public JMenuItem popupMenuItemNewFolder;
    public JMenuItem popupMenuItemRename;
    public JMenuItem popupMenuItemTouch;
    public JPopupMenu popupMenuLog;
    public JMenuItem popupMenuItemFindNext;
    public JMenuItem popupMenuItemFind;
    public JMenuItem popupMenuItemTop;
    public JMenuItem popupMenuItemBottom;
    public JMenuItem popupMenuItemClear;
    public JCheckBoxMenuItem popupCheckBoxMenuItemWordWrap;

    public MainFrame(Context context) {
        context.mainFrame = this;
        this.context = context;
        try {
            this.initComponents();
            if (context.cfg.isLoggerView()) {
                Configuration cfr_ignored_0 = context.cfg;
                this.setTitle(context.cfg.getJobName() + " : " + "ELS Logger");
            } else {
                Configuration cfr_ignored_1 = context.cfg;
                this.setTitle("ELS Navigator");
            }
            this.setBrowserTabs(-1);
            this.panelToolbar.setBackground(this.menuToolbar.getBackground());
            this.tabbedPaneMain.putClientProperty("JTabbedPane.tabType", "card");
            this.tabbedPaneNavigatorBottom.putClientProperty("JTabbedPane.tabType", "card");
            this.adjustTableColumns(this.tableCollectionOne);
            this.adjustTableColumns(this.tableSystemOne);
            this.adjustTableColumns(this.tableCollectionTwo);
            this.adjustTableColumns(this.tableSystemTwo);
            this.buttonBack.setMnemonic(37);
            this.buttonForward.setMnemonic(39);
            TextIcon t1 = new TextIcon(this.buttonUp, ">", TextIcon.Layout.HORIZONTAL);
            this.buttonUp.setText("");
            RotatedIcon r1 = new RotatedIcon((Icon)t1, RotatedIcon.Rotate.UP);
            this.buttonUp.setIcon(r1);
            this.buttonUp.setMnemonic(38);
            if (Utils.isOsLinux()) {
                this.textAreaLog.setFont(new Font("Courier 10 Pitch", 0, 13));
            } else {
                this.textAreaLog.setFont(new Font("Monospaced", 0, 13));
            }
            this.textAreaLog.setDisabledTextColor(this.tabbedPaneMain.getForeground());
            new SmartScroller(this.scrollPaneLog);
            UIManager.put("OptionPane.cancelButtonText", context.cfg.gs("Z.cancel"));
            UIManager.put("FileChooser.openButtonText", context.cfg.gs("Z.open"));
            UIManager.put("FileChooser.cancelButtonText", context.cfg.gs("Z.cancel"));
            UIManager.put("OptionPane.noButtonText", context.cfg.gs("Z.no"));
            UIManager.put("OptionPane.okButtonText", context.cfg.gs("Z.ok"));
            UIManager.put("OptionPane.yesButtonText", context.cfg.gs("Z.yes"));
            if (Utils.isOsMac()) {
                this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 256));
                this.menuItemCut.setAccelerator(KeyStroke.getKeyStroke(88, 256));
                this.menuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, 256));
                this.menuItemFind.setAccelerator(KeyStroke.getKeyStroke(70, 256));
                this.menuItemTouch.setAccelerator(KeyStroke.getKeyStroke(84, 256));
                this.menuItemWordWrap.setAccelerator(KeyStroke.getKeyStroke(82, 256));
            }
        }
        catch (Exception ex) {
            this.logger.error(Utils.getStackTrace(ex));
            context.fault = true;
        }
    }

    private void adjustTableColumns(JTable table) {
        block6: for (int i = 0; i < table.getColumnCount(); ++i) {
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
            TableColumn column = table.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setResizable(false);
                    column.setWidth(22);
                    column.setPreferredWidth(22);
                    column.setMaxWidth(22);
                    column.setMinWidth(22);
                    continue block6;
                }
                case 1: {
                    cellRenderer.setHorizontalAlignment(2);
                    column.setCellRenderer(cellRenderer);
                    column.setResizable(true);
                    continue block6;
                }
                case 2: {
                    cellRenderer.setHorizontalAlignment(4);
                    column.setCellRenderer(cellRenderer);
                    column.setResizable(true);
                    continue block6;
                }
                case 3: {
                    column.setResizable(true);
                    cellRenderer.setHorizontalAlignment(4);
                    column.setCellRenderer(cellRenderer);
                }
            }
        }
    }

    private boolean changesCheckAll() {
        boolean changes = false;
        if (this.context.libraries != null && this.context.libraries.checkForChanges()) {
            changes = true;
        } else if (this.context.navigator.dialogJobs != null && this.context.navigator.dialogJobs.checkForChanges()) {
            changes = true;
        } else if (this.context.navigator.dialogJunkRemover != null && this.context.navigator.dialogJunkRemover.checkForChanges()) {
            changes = true;
        } else if (this.context.navigator.dialogOperations != null && this.context.navigator.dialogOperations.checkForChanges()) {
            changes = true;
        } else if (this.context.navigator.dialogRenamer != null && this.context.navigator.dialogRenamer.checkForChanges()) {
            changes = true;
        } else if (this.context.navigator.dialogSleep != null && this.context.navigator.dialogSleep.checkForChanges()) {
            changes = true;
        }
        return changes;
    }

    private void changesGotoUnsaved() {
        if (this.context.libraries != null && this.context.libraries.checkForChanges()) {
            this.context.mainFrame.tabbedPaneMain.setSelectedIndex(1);
            this.context.mainFrame.saveButton.requestFocus();
        } else if (this.context.navigator.dialogJobs != null && this.context.navigator.dialogJobs.checkForChanges()) {
            this.context.navigator.dialogJobs.setVisible(true);
            this.context.navigator.dialogJobs.toFront();
            this.context.navigator.dialogJobs.requestFocus();
            this.context.navigator.dialogJobs.toFront();
            this.context.navigator.dialogJobs.requestFocus();
            this.context.navigator.dialogJobs.saveButton.requestFocus();
        } else if (this.context.navigator.dialogJunkRemover != null && this.context.navigator.dialogJunkRemover.checkForChanges()) {
            this.context.navigator.dialogJunkRemover.setVisible(true);
            this.context.navigator.dialogJunkRemover.toFront();
            this.context.navigator.dialogJunkRemover.requestFocus();
            this.context.navigator.dialogJunkRemover.toFront();
            this.context.navigator.dialogJunkRemover.requestFocus();
            this.context.navigator.dialogJunkRemover.saveButton.requestFocus();
        } else if (this.context.navigator.dialogOperations != null && this.context.navigator.dialogOperations.checkForChanges()) {
            this.context.navigator.dialogOperations.setVisible(true);
            this.context.navigator.dialogOperations.toFront();
            this.context.navigator.dialogOperations.requestFocus();
            this.context.navigator.dialogOperations.toFront();
            this.context.navigator.dialogOperations.requestFocus();
            this.context.navigator.dialogOperations.buttonOperationSave.requestFocus();
        } else if (this.context.navigator.dialogRenamer != null && this.context.navigator.dialogRenamer.checkForChanges()) {
            this.context.navigator.dialogRenamer.toFront();
            this.context.navigator.dialogRenamer.requestFocus();
            this.context.navigator.dialogRenamer.toFront();
            this.context.navigator.dialogRenamer.requestFocus();
            this.context.navigator.dialogRenamer.saveButton.requestFocus();
        } else if (this.context.navigator.dialogSleep != null && this.context.navigator.dialogSleep.checkForChanges()) {
            this.context.navigator.dialogSleep.toFront();
            this.context.navigator.dialogSleep.requestFocus();
            this.context.navigator.dialogSleep.toFront();
            this.context.navigator.dialogSleep.requestFocus();
            this.context.navigator.dialogSleep.saveButton.requestFocus();
        }
    }

    public void setBrowserTabs(int tabPlacementIndex) {
        int tabPlacement;
        if (tabPlacementIndex < 0) {
            tabPlacement = this.context.preferences.getTabPlacement();
            tabPlacementIndex = this.context.preferences.getTabPlacementIndex();
        } else {
            tabPlacement = this.context.preferences.getTabPlacement(tabPlacementIndex);
        }
        this.tabbedPaneBrowserOne.setTabPlacement(tabPlacement);
        this.tabbedPaneBrowserTwo.setTabPlacement(tabPlacement);
        if (tabPlacementIndex == 1 || tabPlacementIndex == 3) {
            JLabel label = new JLabel(this.context.cfg.gs("Navigator.panel.CollectionOne.tab.title"));
            label.setUI(new VerticalLabel(tabPlacementIndex == 3));
            this.tabbedPaneBrowserOne.setTabComponentAt(0, label);
            label = new JLabel(this.context.cfg.gs("Navigator.panel.SystemOne.tab.title"));
            label.setUI(new VerticalLabel(tabPlacementIndex == 3));
            this.tabbedPaneBrowserOne.setTabComponentAt(1, label);
            label = new JLabel(this.context.cfg.gs("Navigator.panel.CollectionTwo.tab.title"));
            label.setUI(new VerticalLabel(tabPlacementIndex == 3));
            this.tabbedPaneBrowserTwo.setTabComponentAt(0, label);
            label = new JLabel(this.context.cfg.gs("Navigator.panel.SystemTwo.tab.title"));
            label.setUI(new VerticalLabel(tabPlacementIndex == 3));
            this.tabbedPaneBrowserTwo.setTabComponentAt(1, label);
        } else {
            JLabel label = new JLabel(this.context.cfg.gs("Navigator.panel.CollectionOne.tab.title"));
            label.setUI(new BasicLabelUI());
            this.tabbedPaneBrowserOne.setTabComponentAt(0, label);
            label = new JLabel(this.context.cfg.gs("Navigator.panel.SystemOne.tab.title"));
            label.setUI(new BasicLabelUI());
            this.tabbedPaneBrowserOne.setTabComponentAt(1, label);
            label = new JLabel(this.context.cfg.gs("Navigator.panel.CollectionTwo.tab.title"));
            label.setUI(new BasicLabelUI());
            this.tabbedPaneBrowserTwo.setTabComponentAt(0, label);
            label = new JLabel(this.context.cfg.gs("Navigator.panel.SystemTwo.tab.title"));
            label.setUI(new BasicLabelUI());
            this.tabbedPaneBrowserTwo.setTabComponentAt(1, label);
        }
    }

    private void thisWindowClosing(WindowEvent e) {
        if (this.verifyClose()) {
            this.context.navigator.stop();
        }
    }

    public boolean verifyClose() {
        int r;
        if (this.changesCheckAll() && ((r = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("MainFrame.unsaved.changes.are.you.sure"), this.context.cfg.getNavigatorName(), 0)) == 1 || r == 2)) {
            this.changesGotoUnsaved();
            return false;
        }
        if (this.context.browser.navTransferHandler.getTransferWorker() != null && this.context.browser.navTransferHandler.getTransferWorker().isRunning()) {
            r = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("MainFrame.transfers.are.active.are.you.sure"), this.context.cfg.getNavigatorName(), 0);
            if (r == 1 || r == 2) {
                return false;
            }
            this.logger.warn(this.context.cfg.gs("MainFrame.cancelling.transfers.as.requested"));
            this.context.browser.navTransferHandler.getTransferWorker().cancel(true);
            this.context.fault = true;
        }
        return !this.context.navigator.isWorkerRunning() || (r = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("MainFrame.job.running.are.you.sure"), this.context.cfg.getNavigatorName(), 0)) != 1 && r != 2;
    }

    private void cardShown(ComponentEvent e) {
        this.context.libraries.cardShown(e);
    }

    private void tabbedPaneMainStateChanged(ChangeEvent e) {
        this.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
        int index = this.tabbedPaneMain.getSelectedIndex();
        if (index == 0) {
            int size;
            int tab;
            boolean sense = this.context.navigator == null || !this.context.navigator.isWorkerRunning();
            this.context.mainFrame.menuItemCopy.setEnabled(sense);
            this.context.mainFrame.menuItemCut.setEnabled(sense);
            this.context.mainFrame.menuItemPaste.setEnabled(sense);
            this.context.mainFrame.menuItemDelete.setEnabled(sense);
            this.context.mainFrame.menuItemNewFolder.setEnabled(sense);
            this.context.mainFrame.menuItemRename.setEnabled(sense);
            this.context.mainFrame.menuItemTouch.setEnabled(sense);
            this.context.mainFrame.menuItemFind.setEnabled(sense);
            this.context.mainFrame.menuItemFindNext.setEnabled(sense);
            this.context.mainFrame.menuItemRefresh.setEnabled(sense);
            this.context.mainFrame.radioButtonAutoRefresh.setEnabled(sense);
            this.context.mainFrame.menuItemShowHidden.setEnabled(sense);
            this.context.mainFrame.menuItemWordWrap.setEnabled(sense);
            this.context.mainFrame.menuTbCopy.setEnabled(sense);
            this.context.mainFrame.menuTbCut.setEnabled(sense);
            this.context.mainFrame.menuTbPaste.setEnabled(sense);
            this.context.mainFrame.menuTbDelete.setEnabled(sense);
            this.context.mainFrame.menuTbNewFolder.setEnabled(sense);
            this.context.mainFrame.menuTbRefresh.setEnabled(sense);
            if (!this.context.cfg.isLoggerView()) {
                tab = this.tabbedPaneBrowserOne.getSelectedIndex();
                size = tab == 0 ? this.tableCollectionOne.getRowCount() : this.tableSystemOne.getRowCount();
                this.labelStatusLeft.setText(Utils.formatInteger(size) + " " + this.context.cfg.gs("Z.publisher") + (size > 1 ? this.context.cfg.gs("NavTreeNode.items") : this.context.cfg.gs("NavTreeNode.item")));
            } else {
                this.labelStatusLeft.setText("<html><body>&nbsp;</body></html>");
            }
            this.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
            if (!this.context.cfg.isLoggerView()) {
                tab = this.tabbedPaneBrowserTwo.getSelectedIndex();
                size = tab == 0 ? this.tableCollectionTwo.getRowCount() : this.tableSystemTwo.getRowCount();
                this.labelStatusRight.setText(Utils.formatInteger(size) + " " + this.context.cfg.gs("Z.subscriber") + (size > 1 ? this.context.cfg.gs("NavTreeNode.items") : this.context.cfg.gs("NavTreeNode.item")));
            } else {
                this.labelStatusRight.setText("<html><body>&nbsp;</body></html>");
            }
            if (this.context.browser != null && sense) {
                this.context.browser.selectPanelNumber(this.context.browser.lastPanelNumber);
            }
        } else if (index == 1) {
            this.context.libraries.tabbedPaneLibrarySpacesStateChanged(null);
            this.context.mainFrame.menuItemCopy.setEnabled(false);
            this.context.mainFrame.menuItemCut.setEnabled(false);
            this.context.mainFrame.menuItemPaste.setEnabled(false);
            this.context.mainFrame.menuItemDelete.setEnabled(false);
            this.context.mainFrame.menuItemNewFolder.setEnabled(false);
            this.context.mainFrame.menuItemRename.setEnabled(false);
            this.context.mainFrame.menuItemTouch.setEnabled(false);
            this.context.mainFrame.menuItemFind.setEnabled(false);
            this.context.mainFrame.menuItemFindNext.setEnabled(false);
            this.context.mainFrame.menuItemRefresh.setEnabled(false);
            this.context.mainFrame.radioButtonAutoRefresh.setEnabled(false);
            this.context.mainFrame.menuItemShowHidden.setEnabled(false);
            this.context.mainFrame.menuItemWordWrap.setEnabled(false);
            this.context.mainFrame.menuTbCopy.setEnabled(false);
            this.context.mainFrame.menuTbCut.setEnabled(false);
            this.context.mainFrame.menuTbPaste.setEnabled(false);
            this.context.mainFrame.menuTbDelete.setEnabled(false);
            this.context.mainFrame.menuTbNewFolder.setEnabled(false);
            this.context.mainFrame.menuTbRefresh.setEnabled(false);
            this.labelStatusLeft.setText("");
            this.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
            this.labelStatusRight.setText("");
            if (this.context.browser != null) {
                this.context.libraries.selectLastTab();
            }
        }
    }

    private void generalOptionsMouseClicked(MouseEvent e) {
    }

    private void initComponents() {
        this.menuBarMain = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuItemOpenPublisher = new JMenuItem();
        this.menuItemOpenSubscriber = new JMenuItem();
        this.menuItemOpenHintKeys = new JMenuItem();
        this.menuItemOpenHintTracking = new JMenuItem();
        this.menuItemClose = new JMenu();
        this.menuItemClosePublisher = new JMenuItem();
        this.menuItemCloseSubscriber = new JMenuItem();
        this.menuItemCloseHintKeys = new JMenuItem();
        this.menuItemCloseHintTracking = new JMenuItem();
        this.menuItemGenerate = new JMenuItem();
        this.menuItemSaveLayout = new JMenuItem();
        this.menuItemQuitTerminate = new JMenuItem();
        this.menuItemFileQuit = new JMenuItem();
        this.menuEdit = new JMenu();
        this.menuItemCopy = new JMenuItem();
        this.menuItemCut = new JMenuItem();
        this.menuItemPaste = new JMenuItem();
        this.menuItemDelete = new JMenuItem();
        this.menuItemNewFolder = new JMenuItem();
        this.menuItemRename = new JMenuItem();
        this.menuItemTouch = new JMenuItem();
        this.menuItemFind = new JMenuItem();
        this.menuItemFindNext = new JMenuItem();
        this.menuView = new JMenu();
        this.menuItemProgress = new JMenuItem();
        this.menuItemRefresh = new JMenuItem();
        this.radioButtonAutoRefresh = new JCheckBoxMenuItem();
        this.menuItemShowHidden = new JCheckBoxMenuItem();
        this.menuItemShowNavigation = new JCheckBoxMenuItem();
        this.menuItemShowToolbar = new JCheckBoxMenuItem();
        this.menuItemWordWrap = new JCheckBoxMenuItem();
        this.menuBookmarks = new JMenu();
        this.menuItemAddBookmark = new JMenuItem();
        this.menuItemBookmarksDelete = new JMenuItem();
        this.menuTools = new JMenu();
        this.menuItemDuplicates = new JMenuItem();
        this.menuItemEmptyFinder = new JMenuItem();
        this.menuItemArchiver = new JMenuItem();
        this.menuItemCleanup = new JMenuItem();
        this.menuItemJunk = new JMenuItem();
        this.menuItemOperations = new JMenuItem();
        this.menuItemRenamer = new JMenuItem();
        this.menuItemSleep = new JMenuItem();
        this.menuItemExternalTools = new JMenuItem();
        this.menuItemPlexGenerator = new JMenuItem();
        this.menuJobs = new JMenu();
        this.menuItemJobsManage = new JMenuItem();
        this.menuSystem = new JMenu();
        this.menuItemHints = new JMenuItem();
        this.menuItemAuthKeys = new JMenuItem();
        this.menuItemHintKeys = new JMenuItem();
        this.menuItemBlacklist = new JMenuItem();
        this.menuItemWhitelist = new JMenuItem();
        this.menuItemEmail = new JMenuItem();
        this.menuItemSettings = new JMenuItem();
        this.menuWindows = new JMenu();
        this.menuItemMaximize = new JMenuItem();
        this.menuItemMinimize = new JMenuItem();
        this.menuItemRestore = new JMenuItem();
        this.menuItemSplitHorizontal = new JMenuItem();
        this.menuItemSplitVertical = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuItemControls = new JMenuItem();
        this.menuItemGettingStarted = new JMenuItem();
        this.menuItemWebSite = new JMenuItem();
        this.menuItemDiscussions = new JMenuItem();
        this.menuItemDocumentation = new JMenuItem();
        this.menuItemGitHubProject = new JMenuItem();
        this.menuItemIssue = new JMenuItem();
        this.menuItemChangelist = new JMenuItem();
        this.menuItemReleaseNotes = new JMenuItem();
        this.menuItemUpdates = new JMenuItem();
        this.menuItemAbout = new JMenuItem();
        this.panelAlertsMenu = new JPanel();
        this.labelAlertHintsMenu = new JLabel();
        this.labelAlertUpdateMenu = new JLabel();
        this.panelMain = new JPanel();
        this.panelToolbar = new JPanel();
        this.menuToolbar = new JMenuBar();
        this.menuTbCopy = new JButton();
        this.menuTbCut = new JButton();
        this.menuTbPaste = new JButton();
        this.menuTbDelete = new JButton();
        this.menuTbNewFolder = new JButton();
        this.menuTbRefresh = new JButton();
        this.panelAlertsToolbar = new JPanel();
        this.labelAlertHintsToolbar = new JLabel();
        this.labelAlertUpdateToolbar = new JLabel();
        this.vSpacer5 = new JPanel(null);
        this.tabbedPaneMain = new JTabbedPane();
        this.splitPaneBrowser = new JSplitPane();
        this.panelBrowserTop = new JPanel();
        this.panelLocationAndButtons = new JPanel();
        this.panelLocationAndTracker = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.panelLocation = new JPanel();
        this.panelLocationLeft = new JPanel();
        this.buttonBack = new JButton();
        this.buttonForward = new JButton();
        this.buttonUp = new JButton();
        this.textFieldLocation = new JTextField();
        this.hSpacer1 = new JPanel(null);
        this.panelHintTracking = new JPanel();
        this.buttonHintTracking = new JButton();
        this.hSpacer2 = new JPanel(null);
        this.vSpacer2 = new JPanel(null);
        this.splitPaneTwoBrowsers = new JSplitPane();
        this.tabbedPaneBrowserOne = new JTabbedPane();
        this.panelCollectionOne = new JPanel();
        this.splitPaneCollectionOne = new JSplitPane();
        this.scrollPaneTreeCollectionOne = new JScrollPane();
        this.treeCollectionOne = new JTree();
        this.scrollPaneTableCollectionOne = new JScrollPane();
        this.tableCollectionOne = new JTable();
        this.panelSystemOne = new JPanel();
        this.splitPaneSystemOne = new JSplitPane();
        this.scrollPaneTreeSystemOne = new JScrollPane();
        this.treeSystemOne = new JTree();
        this.scrollPaneTableSystemOne = new JScrollPane();
        this.tableSystemOne = new JTable();
        this.tabbedPaneBrowserTwo = new JTabbedPane();
        this.panelCollectionTwo = new JPanel();
        this.splitPaneCollectionTwo = new JSplitPane();
        this.scrollPaneTreeCollectionTwo = new JScrollPane();
        this.treeCollectionTwo = new JTree();
        this.scrollPaneTableCollectionTwo = new JScrollPane();
        this.tableCollectionTwo = new JTable();
        this.panelSystemTwo = new JPanel();
        this.splitPaneSystemTwo = new JSplitPane();
        this.scrollPaneTreeSystemTwo = new JScrollPane();
        this.treeSystemTwo = new JTree();
        this.scrollPaneTableSystemTwo = new JScrollPane();
        this.tableSystemTwo = new JTable();
        this.tabbedPaneNavigatorBottom = new JTabbedPane();
        this.scrollPaneLog = new JScrollPane();
        this.textAreaLog = new JTextArea();
        this.scrollPaneProperties = new JScrollPane();
        this.textAreaProperties = new JEditorPane();
        this.panelLibraries = new JPanel();
        this.panelLibsTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.hSpacer7 = new JPanel(null);
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.hSpacer10 = new JPanel(null);
        this.dynamicLabel = new JLabel();
        this.panelHelp = new JPanel();
        this.labelLibrariesHelp = new JLabel();
        this.splitPaneLibs = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.librariesConfigItems = new JTable();
        this.panelOptions = new JPanel();
        this.panelControls = new JPanel();
        this.topType = new JPanel();
        this.vSpacer0 = new JPanel(null);
        this.panelLibraryType = new JPanel();
        this.hSpacer3 = new JPanel(null);
        this.labelLibaryType = new JLabel();
        this.panelCardBox = new JPanel();
        this.vSpacer3 = new JPanel(null);
        this.separator13 = new JSeparator();
        this.vSpacer4 = new JPanel(null);
        this.tabbedPaneLibrarySpaces = new JTabbedPane();
        this.scrollPaneGeneral = new JScrollPane();
        this.generalOptions = new JPanel();
        this.panelGettingStartedCard = new JPanel();
        this.labelOperationGettingStarted = new JLabel();
        this.panelLibraryCard = new JPanel();
        this.hSpacer4 = new JPanel(null);
        this.hSpacer6 = new JPanel(null);
        this.vSpacer6 = new JPanel(null);
        this.hSpacer5 = new JPanel(null);
        this.label1 = new JLabel();
        this.textFieldPath = new JTextField();
        this.labelKey = new JLabel();
        this.textFieldKey = new JTextField();
        this.vSpacer33 = new JPanel(null);
        this.buttonLibraryGenerateKey = new JButton();
        this.labelHost = new JLabel();
        this.textFieldHost = new JTextField();
        this.vSpacer34 = new JPanel(null);
        this.labelListen = new JLabel();
        this.textFieldListen = new JTextField();
        this.vSpacer35 = new JPanel(null);
        this.labelTimeout = new JLabel();
        this.textFieldTimeout = new JTextField();
        this.vSpacer36 = new JPanel(null);
        this.labelFlavor = new JLabel();
        this.comboBoxFlavor = new JComboBox();
        this.vSpacer37 = new JPanel(null);
        this.labelCase = new JLabel();
        this.checkBoxCase = new JCheckBox();
        this.vSpacer38 = new JPanel(null);
        this.labelTempDated = new JLabel();
        this.checkBoxTempDated = new JCheckBox();
        this.vSpacer42 = new JPanel(null);
        this.labelTempLocation = new JLabel();
        this.textFieldTempLocation = new JTextField();
        this.vSpacer39 = new JPanel(null);
        this.buttonLibrarySelectTempLocation = new JButton();
        this.labelTerminalAllosed = new JLabel();
        this.checkBoxTerminalAllowed = new JCheckBox();
        this.vSpacer40 = new JPanel(null);
        this.labelIgnores = new JLabel();
        this.panelLibrariesIgnorePatternsBox = new JPanel();
        this.scrollPaneLibrariesIgnorePatterns = new JScrollPane();
        this.listLibrariesIgnorePatterns = new JList();
        this.panelLibrariesIgnorePatternsButtons = new JPanel();
        this.buttonLibrariesAddIgnore = new JButton();
        this.buttonLibrariesRemoveIgnore = new JButton();
        this.vSpacer41 = new JPanel(null);
        this.labelEmailAddr = new JLabel();
        this.textFieldEmailAddr = new JTextField();
        this.vSpacer44 = new JPanel(null);
        this.labelMismatches = new JLabel();
        this.checkBoxMismatches = new JCheckBox();
        this.labelFormat = new JLabel();
        this.comboBoxFormat = new JComboBox();
        this.vSpacer43 = new JPanel(null);
        this.labelWhatsNew = new JLabel();
        this.checkBoxWhatsNew = new JCheckBox();
        this.labelSkipOffline = new JLabel();
        this.checkBoxSkipOffline = new JCheckBox();
        this.panelXCard = new JPanel();
        this.panelYCard = new JPanel();
        this.locationsTab = new JPanel();
        this.scrollPaneLocations = new JScrollPane();
        this.tableLocations = new JTable();
        this.panelLocButtons = new JPanel();
        this.buttonAddLocation = new JButton();
        this.buttonRemoveLocation = new JButton();
        this.bibliographyTab = new JPanel();
        this.splitPanelBiblio = new JSplitPane();
        this.panelBiblioLibraries = new JPanel();
        this.panelHeader = new JPanel();
        this.labelLibraries = new JLabel();
        this.labelMatchDates = new JLabel();
        this.scrollPaneBiblioLibraries = new JScrollPane();
        this.tableBiblioLibraries = new JTable();
        this.panelSources = new JPanel();
        this.panelSourcesTop = new JPanel();
        this.labelSpacer42 = new JLabel();
        this.labelSources = new JLabel();
        this.scrollPaneSources = new JScrollPane();
        this.listSources = new JList();
        this.panelSourceButtons = new JPanel();
        this.buttonAddSource = new JButton();
        this.buttonAddMultiSource = new JButton();
        this.buttonUpSource = new JButton();
        this.buttonDownSource = new JButton();
        this.buttonRemoveSource = new JButton();
        this.panelBiblioButtons = new JPanel();
        this.buttonAddLibrary = new JButton();
        this.buttonRemoveLibrary = new JButton();
        this.buttonBarLibs = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.hSpacer8 = new JPanel(null);
        this.panelStatus = new JPanel();
        this.labelStatusLeft = new JLabel();
        this.labelStatusMiddle = new JLabel();
        this.labelStatusRight = new JLabel();
        this.hSpacer9 = new JPanel(null);
        this.popupMenuBrowser = new JPopupMenu();
        this.popupMenuItemRefresh = new JMenuItem();
        this.popupMenuItemCopy = new JMenuItem();
        this.popupMenuItemCut = new JMenuItem();
        this.popupMenuItemPaste = new JMenuItem();
        this.popupMenuItemDelete = new JMenuItem();
        this.popupMenuItemNewFolder = new JMenuItem();
        this.popupMenuItemRename = new JMenuItem();
        this.popupMenuItemTouch = new JMenuItem();
        this.popupMenuLog = new JPopupMenu();
        this.popupMenuItemFindNext = new JMenuItem();
        this.popupMenuItemFind = new JMenuItem();
        this.popupMenuItemTop = new JMenuItem();
        this.popupMenuItemBottom = new JMenuItem();
        this.popupMenuItemClear = new JMenuItem();
        this.popupCheckBoxMenuItemWordWrap = new JCheckBoxMenuItem();
        this.tableCollectionOne.setModel(new BrowserTableModel(this.context));
        this.tableSystemOne.setModel(new BrowserTableModel(this.context));
        this.tableCollectionTwo.setModel(new BrowserTableModel(this.context));
        this.tableSystemTwo.setModel(new BrowserTableModel(this.context));
        this.setMinimumSize(new Dimension(100, 100));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/els-logo-98px.png")).getImage());
        this.setDefaultCloseOperation(0);
        this.setLocationByPlatform(true);
        this.setTitle("Corionis ELS Navigator");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.thisWindowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 2));
        this.menuFile.setText(this.context.cfg.gs("Navigator.menu.File.text"));
        this.menuFile.setMnemonic(this.context.cfg.gs("Navigator.menu.File.mnemonic").charAt(0));
        this.menuItemOpenPublisher.setText(this.context.cfg.gs("Navigator.menu.OpenPublisher.text"));
        this.menuItemOpenPublisher.setMnemonic(this.context.cfg.gs("Navigator.menu.OpenPublisher.mnemonic").charAt(0));
        this.menuItemOpenPublisher.setDisplayedMnemonicIndex(5);
        this.menuItemOpenPublisher.setIcon(new ImageIcon(this.getClass().getResource("/open-publisher.png")));
        this.menuFile.add(this.menuItemOpenPublisher);
        this.menuItemOpenSubscriber.setText(this.context.cfg.gs("Navigator.menu.OpenSubscriber.text"));
        this.menuItemOpenSubscriber.setMnemonic(this.context.cfg.gs("Navigator.menu.OpenSubscriber.mnemonic").charAt(0));
        this.menuItemOpenSubscriber.setIcon(new ImageIcon(this.getClass().getResource("/open-subscriber.png")));
        this.menuFile.add(this.menuItemOpenSubscriber);
        this.menuItemOpenHintKeys.setText(this.context.cfg.gs("Navigator.menu.OpenHintKeys.text"));
        this.menuItemOpenHintKeys.setMnemonic(this.context.cfg.gs("Navigator.menu.OpenHintKeys.mnemonic").charAt(0));
        this.menuItemOpenHintKeys.setIcon(new ImageIcon(this.getClass().getResource("/open-hint-keys.png")));
        this.menuFile.add(this.menuItemOpenHintKeys);
        this.menuItemOpenHintTracking.setText(this.context.cfg.gs("Navigator.menuItemOpenHintTracking.text"));
        this.menuItemOpenHintTracking.setMnemonic(this.context.cfg.gs("Navigator.menuItemOpenHintTracking.mnemonic_2").charAt(0));
        this.menuItemOpenHintTracking.setDisplayedMnemonicIndex(Integer.parseInt(this.context.cfg.gs("Navigator.menuItemOpenHintTracking.displayedMnemonicIndex")));
        this.menuItemOpenHintTracking.setIcon(new ImageIcon(this.getClass().getResource("/open-hint-tracking.png")));
        this.menuFile.add(this.menuItemOpenHintTracking);
        this.menuFile.addSeparator();
        this.menuItemClose.setText(this.context.cfg.gs("Navigator.menuItemClose.text"));
        this.menuItemClose.setIcon(new ImageIcon(this.getClass().getResource("/close.png")));
        this.menuItemClose.setMnemonic(this.context.cfg.gs("Navigator.menuItemClose.mnemonic").charAt(0));
        this.menuItemClosePublisher.setText(this.context.cfg.gs("Navigator.menuItemClosePublisher.text"));
        this.menuItemClosePublisher.setMnemonic(this.context.cfg.gs("Navigator.menuItemClosePublisher.mnemonic").charAt(0));
        this.menuItemClose.add(this.menuItemClosePublisher);
        this.menuItemCloseSubscriber.setText(this.context.cfg.gs("Navigator.menuItemCloseSubscriber.text"));
        this.menuItemCloseSubscriber.setMnemonic(this.context.cfg.gs("Navigator.menuItemCloseSubscriber.mnemonic").charAt(0));
        this.menuItemClose.add(this.menuItemCloseSubscriber);
        this.menuItemCloseHintKeys.setText(this.context.cfg.gs("Navigator.menuItemCloseHintKeys.text"));
        this.menuItemCloseHintKeys.setMnemonic(this.context.cfg.gs("Navigator.menuItemCloseHintKeys.mnemonic").charAt(0));
        this.menuItemClose.add(this.menuItemCloseHintKeys);
        this.menuItemCloseHintTracking.setText(this.context.cfg.gs("Navigator.menuItemCloseHintTracking.text"));
        this.menuItemCloseHintTracking.setMnemonic(this.context.cfg.gs("Navigator.menuItemCloseHintTracking.mnemonic").charAt(0));
        this.menuItemCloseHintTracking.setDisplayedMnemonicIndex(Integer.parseInt(this.context.cfg.gs("Navigator.menuItemCloseHintTracking.displayedMnemonicIndex")));
        this.menuItemClose.add(this.menuItemCloseHintTracking);
        this.menuFile.add(this.menuItemClose);
        this.menuFile.addSeparator();
        this.menuItemGenerate.setText(this.context.cfg.gs("Navigator.menuItemGenerate.text"));
        this.menuItemGenerate.setMnemonic(this.context.cfg.gs("Navigator.menuItemGenerate.mnemonic").charAt(0));
        this.menuItemGenerate.setIcon(new ImageIcon(this.getClass().getResource("/generate.png")));
        this.menuFile.add(this.menuItemGenerate);
        this.menuItemSaveLayout.setText(this.context.cfg.gs("Navigator.menu.SaveLayout.text"));
        this.menuItemSaveLayout.setMnemonic(this.context.cfg.gs("Navigator.menu.SaveLayout.mnemonic_3").charAt(0));
        this.menuItemSaveLayout.setIcon(new ImageIcon(this.getClass().getResource("/save-layout.png")));
        this.menuFile.add(this.menuItemSaveLayout);
        this.menuFile.addSeparator();
        this.menuItemQuitTerminate.setText(this.context.cfg.gs("Navigator.menu.QuitTerminate.text"));
        this.menuItemQuitTerminate.setMnemonic(this.context.cfg.gs("Navigator.menuItemQuitTerminate.mnemonic").charAt(0));
        this.menuItemQuitTerminate.setDisplayedMnemonicIndex(12);
        this.menuItemQuitTerminate.setIcon(new ImageIcon(this.getClass().getResource("/quit-and-stop.png")));
        this.menuFile.add(this.menuItemQuitTerminate);
        this.menuItemFileQuit.setText(this.context.cfg.gs("Navigator.menu.Quit.text"));
        this.menuItemFileQuit.setMnemonic(this.context.cfg.gs("Navigator.menu.Quit.mnemonic").charAt(0));
        this.menuItemFileQuit.setIcon(new ImageIcon(this.getClass().getResource("/quit.png")));
        this.menuFile.add(this.menuItemFileQuit);
        this.menuBarMain.add(this.menuFile);
        this.menuEdit.setText(this.context.cfg.gs("Navigator.menu.Edit.text"));
        this.menuEdit.setMnemonic(this.context.cfg.gs("Navigator.menu.Edit.mnemonic").charAt(0));
        this.menuItemCopy.setText(this.context.cfg.gs("Navigator.menu.Copy.text"));
        this.menuItemCopy.setMnemonic(this.context.cfg.gs("Navigator.menu.Copy.mnemonic").charAt(0));
        this.menuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/copy.png")));
        this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.menuEdit.add(this.menuItemCopy);
        this.menuItemCut.setText(this.context.cfg.gs("Navigator.menu.Cut.text"));
        this.menuItemCut.setMnemonic(this.context.cfg.gs("Navigator.menu.Cut.mnemonic").charAt(0));
        this.menuItemCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.menuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/cut.png")));
        this.menuEdit.add(this.menuItemCut);
        this.menuItemPaste.setText(this.context.cfg.gs("Navigator.menu.Paste.text"));
        this.menuItemPaste.setMnemonic(this.context.cfg.gs("Navigator.menu.Paste.mnemonic").charAt(0));
        this.menuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.menuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/paste.png")));
        this.menuEdit.add(this.menuItemPaste);
        this.menuEdit.addSeparator();
        this.menuItemDelete.setText(this.context.cfg.gs("Navigator.menu.Delete.text"));
        this.menuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemDelete.setMnemonic(this.context.cfg.gs("Navigator.menu.Delete.mnemonic").charAt(0));
        this.menuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/delete-x.png")));
        this.menuEdit.add(this.menuItemDelete);
        this.menuEdit.addSeparator();
        this.menuItemNewFolder.setText(this.context.cfg.gs("Navigator.menu.New.folder.text"));
        this.menuItemNewFolder.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.menuItemNewFolder.setMnemonic(this.context.cfg.gs("Navigator.menu.New.folder.mnemonic").charAt(0));
        this.menuItemNewFolder.setIcon(new ImageIcon(this.getClass().getResource("/new-folder.png")));
        this.menuEdit.add(this.menuItemNewFolder);
        this.menuItemRename.setText(this.context.cfg.gs("Navigator.menu.Rename.text"));
        this.menuItemRename.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.menuItemRename.setMnemonic(this.context.cfg.gs("Navigator.menu.Rename.mnemonic").charAt(0));
        this.menuItemRename.setIcon(new ImageIcon(this.getClass().getResource("/rename.png")));
        this.menuEdit.add(this.menuItemRename);
        this.menuItemTouch.setText(this.context.cfg.gs("Navigator.menu.Touch.text"));
        this.menuItemTouch.setMnemonic(this.context.cfg.gs("Navigator.menu.Touch.mnemonic").charAt(0));
        this.menuItemTouch.setIcon(new ImageIcon(this.getClass().getResource("/touch.png")));
        this.menuItemTouch.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.menuEdit.add(this.menuItemTouch);
        this.menuEdit.addSeparator();
        this.menuItemFind.setText(this.context.cfg.gs("Navigator.menu.Find.text"));
        this.menuItemFind.setMnemonic(this.context.cfg.gs("Navigator.menu.Find.mnemonic").charAt(0));
        this.menuItemFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.menuItemFind.setIcon(new ImageIcon(this.getClass().getResource("/find.png")));
        this.menuEdit.add(this.menuItemFind);
        this.menuItemFindNext.setText(this.context.cfg.gs("Navigator.menuItemFindNext.text"));
        this.menuItemFindNext.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.menuItemFindNext.setMnemonic(this.context.cfg.gs("Navigator.menuItemFindNext.mnemonic").charAt(0));
        this.menuItemFindNext.setIcon(new ImageIcon(this.getClass().getResource("/find-next.png")));
        this.menuEdit.add(this.menuItemFindNext);
        this.menuBarMain.add(this.menuEdit);
        this.menuView.setText(this.context.cfg.gs("Navigator.menu.View.text"));
        this.menuView.setMnemonic(this.context.cfg.gs("Navigator.menu.View.mnemonic").charAt(0));
        this.menuItemProgress.setText(this.context.cfg.gs("Navigator.menu.Progress.text"));
        this.menuItemProgress.setMnemonic(this.context.cfg.gs("Navigator.menu.Progress.mnemonic").charAt(0));
        this.menuItemProgress.setIcon(new ImageIcon(this.getClass().getResource("/progress.png")));
        this.menuView.add(this.menuItemProgress);
        this.menuItemRefresh.setText(this.context.cfg.gs("Navigator.menu.Refresh.text"));
        this.menuItemRefresh.setMnemonic(this.context.cfg.gs("Navigator.menuItemRefresh.mnemonic").charAt(0));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.menuItemRefresh.setIcon(new ImageIcon(this.getClass().getResource("/refresh.png")));
        this.menuView.add(this.menuItemRefresh);
        this.menuView.addSeparator();
        this.radioButtonAutoRefresh.setText(this.context.cfg.gs("Navigator.radioButtonAutoRefresh.text"));
        this.radioButtonAutoRefresh.setMnemonic(this.context.cfg.gs("Navigator.radioButtonAutoRefresh.mnemonic").charAt(0));
        this.menuView.add(this.radioButtonAutoRefresh);
        this.menuItemShowHidden.setText(this.context.cfg.gs("Navigator.menu.ShowHidden.text"));
        this.menuItemShowHidden.setMnemonic(this.context.cfg.gs("Navigator.menu.ShowHidden.mnemonic").charAt(0));
        this.menuItemShowHidden.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        this.menuItemShowHidden.setDisplayedMnemonicIndex(5);
        this.menuItemShowHidden.setIcon(null);
        this.menuView.add(this.menuItemShowHidden);
        this.menuItemShowNavigation.setText(this.context.cfg.gs("Navigator.menuItemShowNavigation.text"));
        this.menuItemShowNavigation.setMnemonic(this.context.cfg.gs("Navigator.menuItemShowNavigation.mnemonic").charAt(0));
        this.menuView.add(this.menuItemShowNavigation);
        this.menuItemShowToolbar.setText(this.context.cfg.gs("Navigator.menuItemShowToolbar.text"));
        this.menuItemShowToolbar.setMnemonic(this.context.cfg.gs("Navigator.menuItemShowToolbar.mnemonic").charAt(0));
        this.menuView.add(this.menuItemShowToolbar);
        this.menuItemWordWrap.setText(this.context.cfg.gs("Navigator.menuItemWordWrap.text"));
        this.menuItemWordWrap.setMnemonic(this.context.cfg.gs("Navigator.menuItemWordWrap.mnemonic").charAt(0));
        this.menuItemWordWrap.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.menuView.add(this.menuItemWordWrap);
        this.menuBarMain.add(this.menuView);
        this.menuBookmarks.setText(this.context.cfg.gs("Navigator.menu.Bookmarks.text"));
        this.menuBookmarks.setMnemonic(this.context.cfg.gs("Navigator.menu.Bookmarks.mnemonic").charAt(0));
        this.menuItemAddBookmark.setText(this.context.cfg.gs("Navigator.menu.AddBookmark.text"));
        this.menuItemAddBookmark.setMnemonic(this.context.cfg.gs("Navigator.menu.AddBookmark.mnemonic").charAt(0));
        this.menuItemAddBookmark.setIcon(new ImageIcon(this.getClass().getResource("/bookmark.png")));
        this.menuBookmarks.add(this.menuItemAddBookmark);
        this.menuItemBookmarksDelete.setText(this.context.cfg.gs("Navigator.menu.BookmarksManage.text"));
        this.menuItemBookmarksDelete.setMnemonic(this.context.cfg.gs("Navigator.menuItemBookmarksDelete.mnemonic").charAt(0));
        this.menuItemBookmarksDelete.setIcon(new ImageIcon(this.getClass().getResource("/bookmark-delete.png")));
        this.menuBookmarks.add(this.menuItemBookmarksDelete);
        this.menuBookmarks.addSeparator();
        this.menuBarMain.add(this.menuBookmarks);
        this.menuTools.setText(this.context.cfg.gs("Navigator.menu.Tools.text"));
        this.menuTools.setMnemonic(this.context.cfg.gs("Navigator.menu.Tools.mnemonic").charAt(0));
        this.menuItemDuplicates.setText(this.context.cfg.gs("Navigator.menu.Duplicates.text"));
        this.menuItemDuplicates.setMnemonic(this.context.cfg.gs("Navigator.menu.Duplicates.mnemonic").charAt(0));
        this.menuItemDuplicates.setIcon(new ImageIcon(this.getClass().getResource("/duplicates.png")));
        this.menuTools.add(this.menuItemDuplicates);
        this.menuItemEmptyFinder.setText(this.context.cfg.gs("Navigator.menuItemEmptyFinder.text"));
        this.menuItemEmptyFinder.setMnemonic(this.context.cfg.gs("Navigator.menuItemEmptyFinder.mnemonic").charAt(0));
        this.menuItemEmptyFinder.setIcon(new ImageIcon(this.getClass().getResource("/empties.png")));
        this.menuTools.add(this.menuItemEmptyFinder);
        this.menuTools.addSeparator();
        this.menuItemArchiver.setText(this.context.cfg.gs("Navigator.menuItemArchiver.text"));
        this.menuItemArchiver.setMnemonic(this.context.cfg.gs("Navigator.menuItemArchiver.mnemonic").charAt(0));
        this.menuItemArchiver.setIcon(new ImageIcon(this.getClass().getResource("/archiver.png")));
        this.menuTools.add(this.menuItemArchiver);
        this.menuItemCleanup.setText(this.context.cfg.gs("Navigator.menuItemCleanup.text"));
        this.menuItemCleanup.setMnemonic(this.context.cfg.gs("Navigator.menuItemCleanup.mnemonic").charAt(0));
        this.menuItemCleanup.setIcon(new ImageIcon(this.getClass().getResource("/cleanup.png")));
        this.menuTools.add(this.menuItemCleanup);
        this.menuItemJunk.setText(this.context.cfg.gs("Navigator.menu.Junk.text"));
        this.menuItemJunk.setMnemonic(this.context.cfg.gs("Navigator.menu.Junk.mnemonic").charAt(0));
        this.menuItemJunk.setIcon(new ImageIcon(this.getClass().getResource("/junk.png")));
        this.menuTools.add(this.menuItemJunk);
        this.menuItemOperations.setText(this.context.cfg.gs("Navigator.menuItemOperations.text"));
        this.menuItemOperations.setMnemonic(this.context.cfg.gs("Navigator.menuItemOperations.mnemonic").charAt(0));
        this.menuItemOperations.setIcon(new ImageIcon(this.getClass().getResource("/operations.png")));
        this.menuTools.add(this.menuItemOperations);
        this.menuItemRenamer.setText(this.context.cfg.gs("Navigator.menu.Renamer.text"));
        this.menuItemRenamer.setMnemonic(this.context.cfg.gs("Navigator.menu.Renamer.mnemonic").charAt(0));
        this.menuItemRenamer.setIcon(new ImageIcon(this.getClass().getResource("/renamer.png")));
        this.menuTools.add(this.menuItemRenamer);
        this.menuItemSleep.setText(this.context.cfg.gs("Navigator.menuItemSleep.text"));
        this.menuItemSleep.setMnemonic(this.context.cfg.gs("Navigator.menuItemSleep.mnemonic").charAt(0));
        this.menuItemSleep.setIcon(new ImageIcon(this.getClass().getResource("/sleep.png")));
        this.menuTools.add(this.menuItemSleep);
        this.menuItemExternalTools.setText(this.context.cfg.gs("Navigator.menu.ExternalTools.text"));
        this.menuItemExternalTools.setMnemonic(this.context.cfg.gs("Navigator.menuItemExternalTools.mnemonic").charAt(0));
        this.menuItemExternalTools.setEnabled(false);
        this.menuItemExternalTools.setDisplayedMnemonicIndex(Integer.parseInt(this.context.cfg.gs("Navigator.menuItemExternalTools.displayedMnemonicIndex")));
        this.menuItemExternalTools.setToolTipText(this.context.cfg.gs("Z.not.implemented.yet"));
        this.menuItemExternalTools.setIcon(new ImageIcon(this.getClass().getResource("/external-manage.png")));
        this.menuItemExternalTools.setVisible(false);
        this.menuTools.add(this.menuItemExternalTools);
        this.menuItemPlexGenerator.setText(this.context.cfg.gs("Navigator.menu.PlexGenerator.text"));
        this.menuItemPlexGenerator.setEnabled(false);
        this.menuItemPlexGenerator.setMargin(new Insets(2, 18, 2, 2));
        this.menuItemPlexGenerator.setToolTipText(this.context.cfg.gs("Z.not.implemented.yet"));
        this.menuItemPlexGenerator.setVisible(false);
        this.menuTools.add(this.menuItemPlexGenerator);
        this.menuBarMain.add(this.menuTools);
        this.menuJobs.setText(this.context.cfg.gs("Navigator.menu.Jobs.text"));
        this.menuJobs.setMnemonic(this.context.cfg.gs("Navigator.menu.Jobs.mnemonic").charAt(0));
        this.menuJobs.setIcon(null);
        this.menuItemJobsManage.setText(this.context.cfg.gs("Navigator.menu.JobsManage.text"));
        this.menuItemJobsManage.setMnemonic(this.context.cfg.gs("Navigator.menu.JobsManage.mnemonic").charAt(0));
        this.menuItemJobsManage.setIcon(new ImageIcon(this.getClass().getResource("/jobs-manage.png")));
        this.menuJobs.add(this.menuItemJobsManage);
        this.menuJobs.addSeparator();
        this.menuBarMain.add(this.menuJobs);
        this.menuSystem.setText("System");
        this.menuSystem.setMnemonic(this.context.cfg.gs("Navigator.menuSystem.mnemonic").charAt(0));
        this.menuItemHints.setText(this.context.cfg.gs("Navigator.menuItemHints.text"));
        this.menuItemHints.setMnemonic(this.context.cfg.gs("Navigator.menuItemHints.mnemonic").charAt(0));
        this.menuItemHints.setIcon(new ImageIcon(this.getClass().getResource("/hints.png")));
        this.menuItemHints.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.menuSystem.add(this.menuItemHints);
        this.menuSystem.addSeparator();
        this.menuItemAuthKeys.setText(this.context.cfg.gs("Navigator.menuItemAuthKeys.text"));
        this.menuItemAuthKeys.setMnemonic(this.context.cfg.gs("Navigator.menuItemAuthKeys.mnemonic").charAt(0));
        this.menuItemAuthKeys.setIcon(new ImageIcon(this.getClass().getResource("/auth-keys.png")));
        this.menuSystem.add(this.menuItemAuthKeys);
        this.menuItemHintKeys.setText(this.context.cfg.gs("Navigator.menuItemHintKeys.text"));
        this.menuItemHintKeys.setMnemonic(this.context.cfg.gs("Navigator.menuItemHintKeys.mnemonic_2").charAt(0));
        this.menuItemHintKeys.setIcon(new ImageIcon(this.getClass().getResource("/hint-keys.png")));
        this.menuSystem.add(this.menuItemHintKeys);
        this.menuSystem.addSeparator();
        this.menuItemBlacklist.setText(this.context.cfg.gs("Navigator.menuItemBlacklist.text"));
        this.menuItemBlacklist.setMnemonic(this.context.cfg.gs("Navigator.menuItemBlacklist.mnemonic").charAt(0));
        this.menuItemBlacklist.setIcon(new ImageIcon(this.getClass().getResource("/blacklist.png")));
        this.menuSystem.add(this.menuItemBlacklist);
        this.menuItemWhitelist.setText(this.context.cfg.gs("Navigator.menuItemWhitelist.text"));
        this.menuItemWhitelist.setMnemonic(this.context.cfg.gs("Navigator.menuItemWhitelist.mnemonic").charAt(0));
        this.menuItemWhitelist.setIcon(new ImageIcon(this.getClass().getResource("/whitelist.png")));
        this.menuSystem.add(this.menuItemWhitelist);
        this.menuSystem.addSeparator();
        this.menuItemEmail.setText(this.context.cfg.gs("Navigator.menu.Email.text"));
        this.menuItemEmail.setMnemonic(this.context.cfg.gs("Navigator.menuItemEmail.mnemonic").charAt(0));
        this.menuItemEmail.setIcon(new ImageIcon(this.getClass().getResource("/email.png")));
        this.menuSystem.add(this.menuItemEmail);
        this.menuSystem.addSeparator();
        this.menuItemSettings.setText(this.context.cfg.gs("Navigator.menu.Preferences.text"));
        this.menuItemSettings.setMnemonic(this.context.cfg.gs("Navigator.menuItemPreferences.mnemonic").charAt(0));
        this.menuItemSettings.setIcon(new ImageIcon(this.getClass().getResource("/settings.png")));
        this.menuSystem.add(this.menuItemSettings);
        this.menuBarMain.add(this.menuSystem);
        this.menuWindows.setText(this.context.cfg.gs("Navigator.menu.Windows.text"));
        this.menuWindows.setMnemonic(this.context.cfg.gs("Navigator.menu.Windows.mnemonic").charAt(0));
        this.menuItemMaximize.setText(this.context.cfg.gs("Navigator.menu.Maximize.text"));
        this.menuItemMaximize.setMnemonic(this.context.cfg.gs("Navigator.menu.Maximize.mnemonic").charAt(0));
        this.menuItemMaximize.setIcon(new ImageIcon(this.getClass().getResource("/maximize.png")));
        this.menuWindows.add(this.menuItemMaximize);
        this.menuItemMinimize.setText(this.context.cfg.gs("Navigator.menu.Minimize.text"));
        this.menuItemMinimize.setMnemonic(this.context.cfg.gs("Navigator.menu.Minimize.mnemonic").charAt(0));
        this.menuItemMinimize.setIcon(new ImageIcon(this.getClass().getResource("/minimize.png")));
        this.menuWindows.add(this.menuItemMinimize);
        this.menuItemRestore.setText(this.context.cfg.gs("Navigator.menu.Restore.text"));
        this.menuItemRestore.setMnemonic(this.context.cfg.gs("Navigator.menu.Restore.mnemonic").charAt(0));
        this.menuItemRestore.setIcon(new ImageIcon(this.getClass().getResource("/restore.png")));
        this.menuWindows.add(this.menuItemRestore);
        this.menuWindows.addSeparator();
        this.menuItemSplitHorizontal.setText(this.context.cfg.gs("Navigator.menu.SplitHorizontal.text"));
        this.menuItemSplitHorizontal.setMnemonic(this.context.cfg.gs("Navigator.menu.SplitHorizontal.mnemonic").charAt(0));
        this.menuItemSplitHorizontal.setIcon(new ImageIcon(this.getClass().getResource("/horizontal.png")));
        this.menuWindows.add(this.menuItemSplitHorizontal);
        this.menuItemSplitVertical.setText(this.context.cfg.gs("Navigator.menu.SplitVertical.text"));
        this.menuItemSplitVertical.setMnemonic(this.context.cfg.gs("Navigator.menu.SplitVertical.mnemonic").charAt(0));
        this.menuItemSplitVertical.setIcon(new ImageIcon(this.getClass().getResource("/vertical.png")));
        this.menuWindows.add(this.menuItemSplitVertical);
        this.menuBarMain.add(this.menuWindows);
        this.menuHelp.setText(this.context.cfg.gs("Navigator.menu.Help.text"));
        this.menuHelp.setMnemonic(this.context.cfg.gs("Navigator.menu.Help.mnemonic").charAt(0));
        this.menuItemControls.setText(this.context.cfg.gs("Navigator.menu.Controls.text"));
        this.menuItemControls.setMnemonic(this.context.cfg.gs("Navigator.menu.Controls.mnemonic").charAt(0));
        this.menuItemControls.setIcon(new ImageIcon(this.getClass().getResource("/controls.png")));
        this.menuHelp.add(this.menuItemControls);
        this.menuItemGettingStarted.setText(this.context.cfg.gs("Navigator.menuItemGettingStarted.text"));
        this.menuItemGettingStarted.setIcon(new ImageIcon(this.getClass().getResource("/getting-started.png")));
        this.menuItemGettingStarted.setMnemonic(this.context.cfg.gs("Navigator.menuItemGettingStarted.mnemonic_2").charAt(0));
        this.menuHelp.add(this.menuItemGettingStarted);
        this.menuHelp.addSeparator();
        this.menuItemWebSite.setText(this.context.cfg.gs("Navigator.menuItemWebSite.text"));
        this.menuItemWebSite.setIcon(new ImageIcon(this.getClass().getResource("/website.png")));
        this.menuItemWebSite.setMnemonic(this.context.cfg.gs("Navigator.menuItemWebSite.mnemonic").charAt(0));
        this.menuHelp.add(this.menuItemWebSite);
        this.menuItemDiscussions.setText(this.context.cfg.gs("Navigator.menuItemDiscussions.text"));
        this.menuItemDiscussions.setMnemonic(this.context.cfg.gs("Navigator.menuItemDiscussions.mnemonic").charAt(0));
        this.menuItemDiscussions.setIcon(new ImageIcon(this.getClass().getResource("/discuss.png")));
        this.menuHelp.add(this.menuItemDiscussions);
        this.menuItemDocumentation.setText(this.context.cfg.gs("Navigator.menu.Documentation.text"));
        this.menuItemDocumentation.setMnemonic(this.context.cfg.gs("Navigator.menu.Documentation.mnemonic").charAt(0));
        this.menuItemDocumentation.setIcon(new ImageIcon(this.getClass().getResource("/external-link.png")));
        this.menuHelp.add(this.menuItemDocumentation);
        this.menuItemGitHubProject.setText(this.context.cfg.gs("Navigator.menu.GitHubProject.text"));
        this.menuItemGitHubProject.setMnemonic(this.context.cfg.gs("Navigator.menuItemGitHubProject.mnemonic").charAt(0));
        this.menuItemGitHubProject.setIcon(new ImageIcon(this.getClass().getResource("/github.png")));
        this.menuHelp.add(this.menuItemGitHubProject);
        this.menuItemIssue.setText(this.context.cfg.gs("Navigator.menuItemIssue.text"));
        this.menuItemIssue.setMnemonic(this.context.cfg.gs("Navigator.menuItemIssue.mnemonic").charAt(0));
        this.menuItemIssue.setIcon(new ImageIcon(this.getClass().getResource("/issue.png")));
        this.menuItemIssue.setDisplayedMnemonicIndex(Integer.parseInt(this.context.cfg.gs("Navigator.menuItemIssue.displayedMnemonicIndex")));
        this.menuHelp.add(this.menuItemIssue);
        this.menuHelp.addSeparator();
        this.menuItemChangelist.setText(this.context.cfg.gs("Navigator.menuItemChangelist.text"));
        this.menuItemChangelist.setMnemonic(this.context.cfg.gs("Navigator.menuItemChangelist.mnemonic").charAt(0));
        this.menuItemChangelist.setIcon(new ImageIcon(this.getClass().getResource("/changes.png")));
        this.menuHelp.add(this.menuItemChangelist);
        this.menuItemReleaseNotes.setText(this.context.cfg.gs("Navigator.menuItemReleaseNotes.text"));
        this.menuItemReleaseNotes.setIcon(new ImageIcon(this.getClass().getResource("/release-notes.png")));
        this.menuItemReleaseNotes.setMnemonic(this.context.cfg.gs("Navigator.menuItemReleaseNotes.mnemonic").charAt(0));
        this.menuHelp.add(this.menuItemReleaseNotes);
        this.menuHelp.addSeparator();
        this.menuItemUpdates.setText(this.context.cfg.gs("Navigator.menuItemUpdates.text"));
        this.menuItemUpdates.setMnemonic(this.context.cfg.gs("Navigator.menuItemUpdates.mnemonic").charAt(0));
        this.menuItemUpdates.setIcon(new ImageIcon(this.getClass().getResource("/updates.png")));
        this.menuHelp.add(this.menuItemUpdates);
        this.menuItemAbout.setText(this.context.cfg.gs("Navigator.menu.About.text"));
        this.menuItemAbout.setMnemonic(this.context.cfg.gs("Navigator.menu.About.mnemonic").charAt(0));
        this.menuItemAbout.setIcon(new ImageIcon(this.getClass().getResource("/about.png")));
        this.menuHelp.add(this.menuItemAbout);
        this.menuBarMain.add(this.menuHelp);
        this.panelAlertsMenu.setOpaque(false);
        this.panelAlertsMenu.setPreferredSize(new Dimension(58, 21));
        this.panelAlertsMenu.setMinimumSize(new Dimension(58, 21));
        this.panelAlertsMenu.setMaximumSize(new Dimension(Short.MAX_VALUE, 21));
        this.panelAlertsMenu.setLayout(new FlowLayout(2, 10, 0));
        this.labelAlertHintsMenu.setIcon(new ImageIcon(this.getClass().getResource("/hints.png")));
        this.labelAlertHintsMenu.setHorizontalAlignment(0);
        this.labelAlertHintsMenu.setIconTextGap(0);
        this.labelAlertHintsMenu.setToolTipText(this.context.cfg.gs("Navigator.hints.available"));
        this.labelAlertHintsMenu.setAlignmentY(0.0f);
        this.labelAlertHintsMenu.setPreferredSize(new Dimension(14, 21));
        this.labelAlertHintsMenu.setMinimumSize(new Dimension(14, 21));
        this.labelAlertHintsMenu.setMaximumSize(new Dimension(14, 21));
        this.labelAlertHintsMenu.setCursor(Cursor.getPredefinedCursor(12));
        this.panelAlertsMenu.add(this.labelAlertHintsMenu);
        this.labelAlertUpdateMenu.setIcon(new ImageIcon(this.getClass().getResource("/updates.png")));
        this.labelAlertUpdateMenu.setHorizontalAlignment(0);
        this.labelAlertUpdateMenu.setIconTextGap(0);
        this.labelAlertUpdateMenu.setAlignmentY(0.0f);
        this.labelAlertUpdateMenu.setToolTipText(this.context.cfg.gs("Navigator.update.available"));
        this.labelAlertUpdateMenu.setPreferredSize(new Dimension(14, 21));
        this.labelAlertUpdateMenu.setMinimumSize(new Dimension(14, 21));
        this.labelAlertUpdateMenu.setMaximumSize(new Dimension(14, 21));
        this.labelAlertUpdateMenu.setCursor(Cursor.getPredefinedCursor(12));
        this.panelAlertsMenu.add(this.labelAlertUpdateMenu);
        this.menuBarMain.add(this.panelAlertsMenu);
        this.setJMenuBar(this.menuBarMain);
        this.panelMain.setPreferredSize(new Dimension(1162, 26));
        this.panelMain.setMaximumSize(new Dimension(Integer.MAX_VALUE, 26));
        this.panelMain.setMinimumSize(new Dimension(256, 26));
        this.panelMain.setLayout(new BoxLayout(this.panelMain, 3));
        this.panelToolbar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
        this.panelToolbar.setLayout(new BorderLayout());
        this.menuToolbar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.menuToolbar.setFont(this.menuToolbar.getFont().deriveFont((float)this.menuToolbar.getFont().getSize() - 2.0f));
        this.menuToolbar.setBorderPainted(false);
        this.menuToolbar.setAlignmentX(1.0f);
        this.menuToolbar.setMargin(new Insets(1, 0, 0, 0));
        this.menuTbCopy.setText(this.context.cfg.gs("Navigator.menuTbCopy.text"));
        this.menuTbCopy.setIcon(new ImageIcon(this.getClass().getResource("/copy.png")));
        this.menuTbCopy.setHorizontalAlignment(0);
        this.menuTbCopy.setToolTipText(this.context.cfg.gs("Navigator.menuTbCopy.toolTipText"));
        this.menuTbCopy.setFont(this.menuTbCopy.getFont().deriveFont((float)this.menuTbCopy.getFont().getSize() - 2.0f));
        this.menuTbCopy.setAlignmentX(0.0f);
        this.menuToolbar.add(this.menuTbCopy);
        this.menuTbCut.setText(this.context.cfg.gs("Navigator.menuTbCut.text"));
        this.menuTbCut.setIcon(new ImageIcon(this.getClass().getResource("/cut.png")));
        this.menuTbCut.setHorizontalAlignment(0);
        this.menuTbCut.setToolTipText(this.context.cfg.gs("Navigator.menuTbCut.toolTipText"));
        this.menuTbCut.setFont(this.menuTbCut.getFont().deriveFont((float)this.menuTbCut.getFont().getSize() - 2.0f));
        this.menuTbCut.setAlignmentX(0.0f);
        this.menuToolbar.add(this.menuTbCut);
        this.menuTbPaste.setText(this.context.cfg.gs("Navigator.menuTbPaste.text"));
        this.menuTbPaste.setIcon(new ImageIcon(this.getClass().getResource("/paste.png")));
        this.menuTbPaste.setHorizontalAlignment(0);
        this.menuTbPaste.setToolTipText(this.context.cfg.gs("Navigator.menuTbPaste.toolTipText"));
        this.menuTbPaste.setFont(this.menuTbPaste.getFont().deriveFont((float)this.menuTbPaste.getFont().getSize() - 2.0f));
        this.menuTbPaste.setAlignmentX(0.0f);
        this.menuToolbar.add(this.menuTbPaste);
        this.menuTbDelete.setText(this.context.cfg.gs("Navigator.menuTbDelete.text"));
        this.menuTbDelete.setIcon(new ImageIcon(this.getClass().getResource("/delete-x.png")));
        this.menuTbDelete.setHorizontalAlignment(0);
        this.menuTbDelete.setToolTipText(this.context.cfg.gs("Navigator.menuTbDelete.toolTipText"));
        this.menuTbDelete.setFont(this.menuTbDelete.getFont().deriveFont((float)this.menuTbDelete.getFont().getSize() - 2.0f));
        this.menuTbDelete.setAlignmentX(0.0f);
        this.menuToolbar.add(this.menuTbDelete);
        this.menuTbNewFolder.setText(this.context.cfg.gs("Navigator.menuTbNewFolder.text"));
        this.menuTbNewFolder.setIcon(new ImageIcon(this.getClass().getResource("/new-folder.png")));
        this.menuTbNewFolder.setHorizontalAlignment(0);
        this.menuTbNewFolder.setToolTipText(this.context.cfg.gs("Navigator.menuTbNewFolder.toolTipText"));
        this.menuTbNewFolder.setFont(this.menuTbNewFolder.getFont().deriveFont((float)this.menuTbNewFolder.getFont().getSize() - 2.0f));
        this.menuTbNewFolder.setAlignmentX(0.0f);
        this.menuToolbar.add(this.menuTbNewFolder);
        this.menuTbRefresh.setText(this.context.cfg.gs("Navigator.menuTbRefresh.text"));
        this.menuTbRefresh.setIcon(new ImageIcon(this.getClass().getResource("/refresh.png")));
        this.menuTbRefresh.setHorizontalAlignment(0);
        this.menuTbRefresh.setToolTipText(this.context.cfg.gs("Navigator.menuTbRefresh.toolTipText"));
        this.menuTbRefresh.setFont(this.menuTbRefresh.getFont().deriveFont((float)this.menuTbRefresh.getFont().getSize() - 2.0f));
        this.menuTbRefresh.setAlignmentX(0.0f);
        this.menuToolbar.add(this.menuTbRefresh);
        this.panelToolbar.add((Component)this.menuToolbar, "West");
        this.panelAlertsToolbar.setOpaque(false);
        this.panelAlertsToolbar.setAlignmentX(-1.0f);
        this.panelAlertsToolbar.setLayout(new FlowLayout(2, 10, 0));
        this.labelAlertHintsToolbar.setIcon(new ImageIcon(this.getClass().getResource("/hints.png")));
        this.labelAlertHintsToolbar.setHorizontalAlignment(0);
        this.labelAlertHintsToolbar.setIconTextGap(0);
        this.labelAlertHintsToolbar.setToolTipText(this.context.cfg.gs("Navigator.hints.available"));
        this.labelAlertHintsToolbar.setAlignmentY(0.0f);
        this.labelAlertHintsToolbar.setPreferredSize(new Dimension(14, 26));
        this.labelAlertHintsToolbar.setMinimumSize(new Dimension(14, 26));
        this.labelAlertHintsToolbar.setMaximumSize(new Dimension(14, 26));
        this.labelAlertHintsToolbar.setCursor(Cursor.getPredefinedCursor(12));
        this.panelAlertsToolbar.add(this.labelAlertHintsToolbar);
        this.labelAlertUpdateToolbar.setIcon(new ImageIcon(this.getClass().getResource("/updates.png")));
        this.labelAlertUpdateToolbar.setHorizontalAlignment(0);
        this.labelAlertUpdateToolbar.setIconTextGap(0);
        this.labelAlertUpdateToolbar.setAlignmentY(0.0f);
        this.labelAlertUpdateToolbar.setToolTipText(this.context.cfg.gs("Navigator.update.available"));
        this.labelAlertUpdateToolbar.setPreferredSize(new Dimension(14, 26));
        this.labelAlertUpdateToolbar.setMinimumSize(new Dimension(14, 26));
        this.labelAlertUpdateToolbar.setMaximumSize(new Dimension(14, 26));
        this.labelAlertUpdateToolbar.setCursor(Cursor.getPredefinedCursor(12));
        this.panelAlertsToolbar.add(this.labelAlertUpdateToolbar);
        this.panelToolbar.add((Component)this.panelAlertsToolbar, "East");
        this.panelMain.add(this.panelToolbar);
        this.vSpacer5.setPreferredSize(new Dimension(2, 2));
        this.vSpacer5.setMinimumSize(new Dimension(2, 2));
        this.vSpacer5.setMaximumSize(new Dimension(2, 2));
        this.panelMain.add(this.vSpacer5);
        this.tabbedPaneMain.setFocusable(false);
        this.tabbedPaneMain.setName("main");
        this.tabbedPaneMain.addChangeListener(e -> this.tabbedPaneMainStateChanged(e));
        this.splitPaneBrowser.setOrientation(0);
        this.splitPaneBrowser.setLastDividerLocation(400);
        this.splitPaneBrowser.setMinimumSize(new Dimension(0, 0));
        this.splitPaneBrowser.setContinuousLayout(true);
        this.splitPaneBrowser.setDividerLocation(400);
        this.panelBrowserTop.setLayout(new BorderLayout());
        this.panelLocationAndButtons.setFocusable(false);
        this.panelLocationAndButtons.setMinimumSize(new Dimension(219, 36));
        this.panelLocationAndButtons.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.panelLocationAndButtons.setPreferredSize(new Dimension(1088, 36));
        this.panelLocationAndButtons.setLayout(new BorderLayout());
        this.panelLocationAndTracker.setPreferredSize(new Dimension(1088, 38));
        this.panelLocationAndTracker.setMinimumSize(new Dimension(327, 38));
        this.panelLocationAndTracker.setLayout(new BorderLayout());
        this.vSpacer1.setPreferredSize(new Dimension(10, 4));
        this.vSpacer1.setMinimumSize(new Dimension(12, 4));
        this.vSpacer1.setMaximumSize(new Dimension(Short.MAX_VALUE, 4));
        this.panelLocationAndTracker.add((Component)this.vSpacer1, "North");
        this.panelLocation.setFocusable(false);
        this.panelLocation.setPreferredSize(new Dimension(952, 30));
        this.panelLocation.setMinimumSize(new Dimension(191, 30));
        this.panelLocation.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.panelLocation.setLayout(new BorderLayout());
        this.panelLocationLeft.setPreferredSize(new Dimension(142, 30));
        this.panelLocationLeft.setMinimumSize(new Dimension(142, 30));
        this.panelLocationLeft.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.panelLocationLeft.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelLocationLeft.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelLocationLeft.getLayout()).columnWeights = new double[]{1.0, 1.0, 1.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panelLocationLeft.getLayout()).rowWeights = new double[]{1.0};
        this.buttonBack.setText("<html>&lt;</html>");
        this.buttonBack.setMaximumSize(new Dimension(24, 24));
        this.buttonBack.setMinimumSize(new Dimension(24, 24));
        this.buttonBack.setPreferredSize(new Dimension(24, 24));
        this.buttonBack.setToolTipText(this.context.cfg.gs("Navigator.buttonBack.toolTipText"));
        this.buttonBack.setActionCommand("navBack");
        this.buttonBack.setFocusable(false);
        this.buttonBack.setDefaultCapable(false);
        this.buttonBack.setHorizontalTextPosition(0);
        this.panelLocationLeft.add((Component)this.buttonBack, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.buttonForward.setText("<html>&gt;</html>");
        this.buttonForward.setMaximumSize(new Dimension(24, 24));
        this.buttonForward.setMinimumSize(new Dimension(24, 24));
        this.buttonForward.setPreferredSize(new Dimension(24, 24));
        this.buttonForward.setToolTipText(this.context.cfg.gs("Navigator.buttonForward.toolTipText"));
        this.buttonForward.setActionCommand("NavForward");
        this.buttonForward.setFocusable(false);
        this.buttonForward.setDefaultCapable(false);
        this.buttonForward.setHorizontalTextPosition(0);
        this.panelLocationLeft.add((Component)this.buttonForward, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.buttonUp.setText("^");
        this.buttonUp.setMaximumSize(new Dimension(24, 24));
        this.buttonUp.setMinimumSize(new Dimension(24, 24));
        this.buttonUp.setPreferredSize(new Dimension(24, 24));
        this.buttonUp.setToolTipText(this.context.cfg.gs("Navigator.buttonUp.toolTipText"));
        this.buttonUp.setActionCommand("NavUp");
        this.buttonUp.setFocusable(false);
        this.buttonUp.setDefaultCapable(false);
        this.buttonUp.setHorizontalTextPosition(0);
        this.panelLocationLeft.add((Component)this.buttonUp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.panelLocation.add((Component)this.panelLocationLeft, "West");
        this.textFieldLocation.setPreferredSize(new Dimension(810, 30));
        this.textFieldLocation.setHorizontalAlignment(2);
        this.textFieldLocation.setToolTipText(this.context.cfg.gs("Navigator.textFieldLocation.toolTipText"));
        this.textFieldLocation.setName("location");
        this.textFieldLocation.setEditable(false);
        this.textFieldLocation.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.textFieldLocation.setMargin(new Insets(0, 6, 0, 6));
        this.textFieldLocation.setMinimumSize(new Dimension(49, 30));
        this.panelLocation.add((Component)this.textFieldLocation, "Center");
        this.hSpacer1.setPreferredSize(new Dimension(4, 30));
        this.hSpacer1.setMinimumSize(new Dimension(4, 30));
        this.hSpacer1.setMaximumSize(new Dimension(4, 30));
        this.panelLocation.add((Component)this.hSpacer1, "East");
        this.panelLocationAndTracker.add((Component)this.panelLocation, "Center");
        this.panelHintTracking.setMaximumSize(new Dimension(136, 30));
        this.panelHintTracking.setMinimumSize(new Dimension(136, 30));
        this.panelHintTracking.setPreferredSize(new Dimension(136, 30));
        this.panelHintTracking.setLayout(new BorderLayout());
        this.buttonHintTracking.setText(this.context.cfg.gs("Navigator.buttonHintTracking.text"));
        this.buttonHintTracking.setMnemonic(this.context.cfg.gs("Navigator.buttonHintTracking.mnemonic").charAt(0));
        this.buttonHintTracking.setFocusable(false);
        this.buttonHintTracking.setPreferredSize(new Dimension(124, 30));
        this.buttonHintTracking.setMinimumSize(new Dimension(124, 30));
        this.buttonHintTracking.setMaximumSize(new Dimension(124, 30));
        this.buttonHintTracking.setIcon(new ImageIcon(this.getClass().getResource("/hint-green.png")));
        this.buttonHintTracking.setActionCommand("hints");
        this.buttonHintTracking.setToolTipText(this.context.cfg.gs("Navigator.buttonHintTracking.toolTipText"));
        this.panelHintTracking.add((Component)this.buttonHintTracking, "Center");
        this.hSpacer2.setPreferredSize(new Dimension(6, 30));
        this.hSpacer2.setMinimumSize(new Dimension(6, 30));
        this.hSpacer2.setMaximumSize(new Dimension(6, 30));
        this.panelHintTracking.add((Component)this.hSpacer2, "East");
        this.panelLocationAndTracker.add((Component)this.panelHintTracking, "East");
        this.vSpacer2.setPreferredSize(new Dimension(10, 2));
        this.vSpacer2.setMinimumSize(new Dimension(10, 2));
        this.vSpacer2.setMaximumSize(new Dimension(10, 2));
        this.panelLocationAndTracker.add((Component)this.vSpacer2, "South");
        this.panelLocationAndButtons.add((Component)this.panelLocationAndTracker, "Center");
        this.panelBrowserTop.add((Component)this.panelLocationAndButtons, "North");
        this.splitPaneTwoBrowsers.setDividerLocation(506);
        this.splitPaneTwoBrowsers.setLastDividerLocation(516);
        this.splitPaneTwoBrowsers.setPreferredSize(new Dimension(812, 390));
        this.splitPaneTwoBrowsers.setResizeWeight(0.5);
        this.splitPaneTwoBrowsers.setContinuousLayout(true);
        this.splitPaneTwoBrowsers.setMinimumSize(new Dimension(0, 0));
        this.splitPaneTwoBrowsers.setFocusable(false);
        this.tabbedPaneBrowserOne.setTabPlacement(2);
        this.tabbedPaneBrowserOne.setFocusable(false);
        this.tabbedPaneBrowserOne.setMinimumSize(new Dimension(0, 0));
        this.tabbedPaneBrowserOne.setName("browserOne");
        this.panelCollectionOne.setFocusable(false);
        this.panelCollectionOne.setMinimumSize(new Dimension(0, 0));
        this.panelCollectionOne.setLayout(new BoxLayout(this.panelCollectionOne, 0));
        this.splitPaneCollectionOne.setDividerLocation(150);
        this.splitPaneCollectionOne.setFocusable(false);
        this.splitPaneCollectionOne.setBorder(null);
        this.splitPaneCollectionOne.setResizeWeight(0.5);
        this.splitPaneCollectionOne.setContinuousLayout(true);
        this.splitPaneCollectionOne.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneTreeCollectionOne.setFocusable(false);
        this.scrollPaneTreeCollectionOne.setPreferredSize(new Dimension(103, 384));
        this.scrollPaneTreeCollectionOne.setMinimumSize(new Dimension(0, 0));
        this.treeCollectionOne.setAutoscrolls(true);
        this.treeCollectionOne.setDragEnabled(true);
        this.treeCollectionOne.setDropMode(DropMode.ON_OR_INSERT);
        this.treeCollectionOne.setComponentPopupMenu(this.popupMenuBrowser);
        this.treeCollectionOne.setMaximumSize(new Dimension(Short.MAX_VALUE, 72));
        this.scrollPaneTreeCollectionOne.setViewportView(this.treeCollectionOne);
        this.splitPaneCollectionOne.setLeftComponent(this.scrollPaneTreeCollectionOne);
        this.scrollPaneTableCollectionOne.setFocusable(false);
        this.scrollPaneTableCollectionOne.setPreferredSize(new Dimension(756, 384));
        this.scrollPaneTableCollectionOne.setMinimumSize(new Dimension(0, 0));
        this.tableCollectionOne.setPreferredScrollableViewportSize(new Dimension(754, 400));
        this.tableCollectionOne.setFillsViewportHeight(true);
        this.tableCollectionOne.setDragEnabled(true);
        this.tableCollectionOne.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.tableCollectionOne.setComponentPopupMenu(this.popupMenuBrowser);
        this.tableCollectionOne.setShowHorizontalLines(false);
        this.tableCollectionOne.setShowVerticalLines(false);
        this.tableCollectionOne.setAutoResizeMode(1);
        this.tableCollectionOne.setName("tableCollectionOne");
        this.tableCollectionOne.setAutoCreateRowSorter(true);
        this.scrollPaneTableCollectionOne.setViewportView(this.tableCollectionOne);
        this.splitPaneCollectionOne.setRightComponent(this.scrollPaneTableCollectionOne);
        this.panelCollectionOne.add(this.splitPaneCollectionOne);
        this.tabbedPaneBrowserOne.addTab(this.context.cfg.gs("Navigator.panel.CollectionOne.tab.title"), this.panelCollectionOne);
        this.tabbedPaneBrowserOne.setMnemonicAt(0, this.context.cfg.gs("Navigator.panel.CollectionOne.tab.mnemonic").charAt(0));
        this.panelSystemOne.setFocusable(false);
        this.panelSystemOne.setMinimumSize(new Dimension(0, 0));
        this.panelSystemOne.setLayout(new BoxLayout(this.panelSystemOne, 0));
        this.splitPaneSystemOne.setBorder(null);
        this.splitPaneSystemOne.setDividerLocation(150);
        this.splitPaneSystemOne.setResizeWeight(0.5);
        this.splitPaneSystemOne.setContinuousLayout(true);
        this.splitPaneSystemOne.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneTreeSystemOne.setMinimumSize(new Dimension(0, 0));
        this.treeSystemOne.setAutoscrolls(true);
        this.treeSystemOne.setDragEnabled(true);
        this.treeSystemOne.setDropMode(DropMode.ON_OR_INSERT);
        this.treeSystemOne.setComponentPopupMenu(this.popupMenuBrowser);
        this.scrollPaneTreeSystemOne.setViewportView(this.treeSystemOne);
        this.splitPaneSystemOne.setLeftComponent(this.scrollPaneTreeSystemOne);
        this.scrollPaneTableSystemOne.setMinimumSize(new Dimension(0, 0));
        this.tableSystemOne.setPreferredScrollableViewportSize(new Dimension(754, 400));
        this.tableSystemOne.setFillsViewportHeight(true);
        this.tableSystemOne.setDragEnabled(true);
        this.tableSystemOne.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.tableSystemOne.setComponentPopupMenu(this.popupMenuBrowser);
        this.tableSystemOne.setShowHorizontalLines(false);
        this.tableSystemOne.setShowVerticalLines(false);
        this.tableSystemOne.setAutoResizeMode(1);
        this.tableSystemOne.setName("tableSystemOne");
        this.tableSystemOne.setAutoCreateRowSorter(true);
        this.scrollPaneTableSystemOne.setViewportView(this.tableSystemOne);
        this.splitPaneSystemOne.setRightComponent(this.scrollPaneTableSystemOne);
        this.panelSystemOne.add(this.splitPaneSystemOne);
        this.tabbedPaneBrowserOne.addTab(this.context.cfg.gs("Navigator.panel.SystemOne.tab.title"), this.panelSystemOne);
        this.tabbedPaneBrowserOne.setMnemonicAt(1, this.context.cfg.gs("Navigator.panel.SystemOne.tab.mnemonic").charAt(0));
        this.splitPaneTwoBrowsers.setLeftComponent(this.tabbedPaneBrowserOne);
        this.tabbedPaneBrowserTwo.setTabPlacement(2);
        this.tabbedPaneBrowserTwo.setPreferredSize(new Dimension(950, 427));
        this.tabbedPaneBrowserTwo.setMinimumSize(new Dimension(0, 0));
        this.tabbedPaneBrowserTwo.setAutoscrolls(true);
        this.tabbedPaneBrowserTwo.setFocusable(false);
        this.tabbedPaneBrowserTwo.setComponentPopupMenu(this.popupMenuBrowser);
        this.tabbedPaneBrowserTwo.setName("browserTwo");
        this.panelCollectionTwo.setMinimumSize(new Dimension(0, 0));
        this.panelCollectionTwo.setFocusable(false);
        this.panelCollectionTwo.setLayout(new BoxLayout(this.panelCollectionTwo, 0));
        this.splitPaneCollectionTwo.setBorder(null);
        this.splitPaneCollectionTwo.setDividerLocation(150);
        this.splitPaneCollectionTwo.setResizeWeight(0.5);
        this.splitPaneCollectionTwo.setContinuousLayout(true);
        this.splitPaneCollectionTwo.setMinimumSize(new Dimension(0, 0));
        this.splitPaneCollectionTwo.setFocusable(false);
        this.scrollPaneTreeCollectionTwo.setPreferredSize(new Dimension(103, 384));
        this.scrollPaneTreeCollectionTwo.setMinimumSize(new Dimension(0, 0));
        this.treeCollectionTwo.setDragEnabled(true);
        this.treeCollectionTwo.setDropMode(DropMode.ON_OR_INSERT);
        this.treeCollectionTwo.setComponentPopupMenu(this.popupMenuBrowser);
        this.scrollPaneTreeCollectionTwo.setViewportView(this.treeCollectionTwo);
        this.splitPaneCollectionTwo.setLeftComponent(this.scrollPaneTreeCollectionTwo);
        this.scrollPaneTableCollectionTwo.setPreferredSize(new Dimension(756, 384));
        this.scrollPaneTableCollectionTwo.setMinimumSize(new Dimension(0, 0));
        this.tableCollectionTwo.setPreferredScrollableViewportSize(new Dimension(754, 400));
        this.tableCollectionTwo.setFillsViewportHeight(true);
        this.tableCollectionTwo.setDragEnabled(true);
        this.tableCollectionTwo.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.tableCollectionTwo.setComponentPopupMenu(this.popupMenuBrowser);
        this.tableCollectionTwo.setShowHorizontalLines(false);
        this.tableCollectionTwo.setShowVerticalLines(false);
        this.tableCollectionTwo.setAutoResizeMode(1);
        this.tableCollectionTwo.setName("tableCollectionTwo");
        this.tableCollectionTwo.setAutoCreateRowSorter(true);
        this.scrollPaneTableCollectionTwo.setViewportView(this.tableCollectionTwo);
        this.splitPaneCollectionTwo.setRightComponent(this.scrollPaneTableCollectionTwo);
        this.panelCollectionTwo.add(this.splitPaneCollectionTwo);
        this.tabbedPaneBrowserTwo.addTab(this.context.cfg.gs("Navigator.panel.CollectionTwo.tab.title"), this.panelCollectionTwo);
        this.tabbedPaneBrowserTwo.setMnemonicAt(0, this.context.cfg.gs("Navigator.panel.CollectionTwo.tab.mnemonic").charAt(0));
        this.panelSystemTwo.setMinimumSize(new Dimension(0, 0));
        this.panelSystemTwo.setLayout(new BoxLayout(this.panelSystemTwo, 0));
        this.splitPaneSystemTwo.setBorder(null);
        this.splitPaneSystemTwo.setDividerLocation(150);
        this.splitPaneSystemTwo.setResizeWeight(0.5);
        this.splitPaneSystemTwo.setContinuousLayout(true);
        this.splitPaneSystemTwo.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneTreeSystemTwo.setMinimumSize(new Dimension(0, 0));
        this.treeSystemTwo.setAutoscrolls(true);
        this.treeSystemTwo.setDragEnabled(true);
        this.treeSystemTwo.setDropMode(DropMode.ON_OR_INSERT);
        this.treeSystemTwo.setComponentPopupMenu(this.popupMenuBrowser);
        this.scrollPaneTreeSystemTwo.setViewportView(this.treeSystemTwo);
        this.splitPaneSystemTwo.setLeftComponent(this.scrollPaneTreeSystemTwo);
        this.scrollPaneTableSystemTwo.setMinimumSize(new Dimension(0, 0));
        this.tableSystemTwo.setPreferredScrollableViewportSize(new Dimension(754, 400));
        this.tableSystemTwo.setFillsViewportHeight(true);
        this.tableSystemTwo.setDragEnabled(true);
        this.tableSystemTwo.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.tableSystemTwo.setComponentPopupMenu(this.popupMenuBrowser);
        this.tableSystemTwo.setShowHorizontalLines(false);
        this.tableSystemTwo.setShowVerticalLines(false);
        this.tableSystemTwo.setAutoResizeMode(1);
        this.tableSystemTwo.setName("tableSystemTwo");
        this.tableSystemTwo.setAutoCreateRowSorter(true);
        this.scrollPaneTableSystemTwo.setViewportView(this.tableSystemTwo);
        this.splitPaneSystemTwo.setRightComponent(this.scrollPaneTableSystemTwo);
        this.panelSystemTwo.add(this.splitPaneSystemTwo);
        this.tabbedPaneBrowserTwo.addTab(this.context.cfg.gs("Navigator.panel.SystemTwo.tab.title"), this.panelSystemTwo);
        this.tabbedPaneBrowserTwo.setMnemonicAt(1, this.context.cfg.gs("Navigator.panel.SystemTwo.tab.mnemonic").charAt(0));
        this.splitPaneTwoBrowsers.setRightComponent(this.tabbedPaneBrowserTwo);
        this.panelBrowserTop.add((Component)this.splitPaneTwoBrowsers, "Center");
        this.splitPaneBrowser.setTopComponent(this.panelBrowserTop);
        this.tabbedPaneNavigatorBottom.setTabPlacement(3);
        this.tabbedPaneNavigatorBottom.setPreferredSize(new Dimension(1160, 90));
        this.tabbedPaneNavigatorBottom.setFocusable(false);
        this.tabbedPaneNavigatorBottom.setMinimumSize(new Dimension(0, 0));
        this.tabbedPaneNavigatorBottom.setAutoscrolls(true);
        this.scrollPaneLog.setFocusable(false);
        this.scrollPaneLog.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneLog.setAutoscrolls(true);
        this.textAreaLog.setEditable(false);
        this.textAreaLog.setTabSize(4);
        this.textAreaLog.setLineWrap(true);
        this.textAreaLog.setMinimumSize(new Dimension(0, 0));
        this.textAreaLog.setComponentPopupMenu(this.popupMenuLog);
        this.textAreaLog.setVerifyInputWhenFocusTarget(false);
        this.textAreaLog.setFont(new Font("Courier 10 Pitch", 0, 12));
        this.textAreaLog.setWrapStyleWord(true);
        this.textAreaLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainFrame.this.generalOptionsMouseClicked(e);
            }
        });
        this.scrollPaneLog.setViewportView(this.textAreaLog);
        this.tabbedPaneNavigatorBottom.addTab(this.context.cfg.gs("Navigator.scrollPane.Log.tab.title"), this.scrollPaneLog);
        this.tabbedPaneNavigatorBottom.setMnemonicAt(0, this.context.cfg.gs("Navigator.scrollPaneLog.tab.mnemonic_2").charAt(0));
        this.scrollPaneProperties.setFocusable(false);
        this.scrollPaneProperties.setMinimumSize(new Dimension(0, 0));
        this.textAreaProperties.setEditable(false);
        this.textAreaProperties.setMinimumSize(new Dimension(0, 0));
        this.textAreaProperties.setContentType("text/html");
        this.textAreaProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainFrame.this.generalOptionsMouseClicked(e);
            }
        });
        this.scrollPaneProperties.setViewportView(this.textAreaProperties);
        this.tabbedPaneNavigatorBottom.addTab(this.context.cfg.gs("Navigator.scrollPane.Properties.tab.title"), this.scrollPaneProperties);
        this.tabbedPaneNavigatorBottom.setMnemonicAt(1, this.context.cfg.gs("Navigator.scrollPaneProperties.tab.mnemonic_2").charAt(0));
        this.splitPaneBrowser.setBottomComponent(this.tabbedPaneNavigatorBottom);
        this.tabbedPaneMain.addTab(this.context.cfg.gs("Navigator.splitPane.Browser.tab.title"), this.splitPaneBrowser);
        this.tabbedPaneMain.setMnemonicAt(0, this.context.cfg.gs("Navigator.splitPane.Browser.tab.mnemonic").charAt(0));
        this.panelLibraries.setFocusCycleRoot(true);
        this.panelLibraries.setLayout(new BorderLayout());
        this.panelLibsTop.setMinimumSize(new Dimension(140, 38));
        this.panelLibsTop.setPreferredSize(new Dimension(614, 38));
        this.panelLibsTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.hSpacer7.setPreferredSize(new Dimension(1, 10));
        this.hSpacer7.setMinimumSize(new Dimension(1, 10));
        this.panelTopButtons.add(this.hSpacer7);
        this.buttonNew.setText(this.context.cfg.gs("Navigator.buttonNew.text"));
        this.buttonNew.setMnemonic(this.context.cfg.gs("Navigator.buttonNew.mnemonic").charAt(0));
        this.buttonNew.setToolTipText(this.context.cfg.gs("Navigator.buttonNew.toolTipText"));
        this.buttonNew.setPreferredSize(new Dimension(78, 31));
        this.buttonNew.setMinimumSize(new Dimension(78, 31));
        this.buttonNew.setMaximumSize(new Dimension(78, 31));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("Navigator.buttonCopy.text"));
        this.buttonCopy.setMnemonic(this.context.cfg.gs("Navigator.buttonCopy.mnemonic").charAt(0));
        this.buttonCopy.setToolTipText(this.context.cfg.gs("Navigator.buttonCopy.toolTipText"));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("Navigator.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("Navigator.buttonDelete.mnemonic").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("Navigator.buttonDelete.toolTipText"));
        this.panelTopButtons.add(this.buttonDelete);
        this.hSpacer10.setPreferredSize(new Dimension(4, 10));
        this.hSpacer10.setMinimumSize(new Dimension(4, 10));
        this.panelTopButtons.add(this.hSpacer10);
        this.dynamicLabel.setText(this.context.cfg.gs("Libraries.dynamic"));
        this.panelTopButtons.add(this.dynamicLabel);
        this.panelLibsTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelLibrariesHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelLibrariesHelp.setPreferredSize(new Dimension(32, 30));
        this.labelLibrariesHelp.setMinimumSize(new Dimension(32, 30));
        this.labelLibrariesHelp.setMaximumSize(new Dimension(32, 30));
        this.labelLibrariesHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelLibrariesHelp.setIconTextGap(0);
        this.labelLibrariesHelp.setToolTipText(this.context.cfg.gs("Navigator.labelLibrariesHelp.toolTipText"));
        this.panelHelp.add(this.labelLibrariesHelp);
        this.panelLibsTop.add((Component)this.panelHelp, "East");
        this.panelLibraries.add((Component)this.panelLibsTop, "North");
        this.splitPaneLibs.setDividerLocation(142);
        this.splitPaneLibs.setLastDividerLocation(142);
        this.splitPaneLibs.setResizeWeight(1.0);
        this.splitPaneLibs.setMinimumSize(new Dimension(10, 80));
        this.scrollPaneConfig.setMinimumSize(new Dimension(42, 16));
        this.scrollPaneConfig.setPreferredSize(new Dimension(142, 146));
        this.scrollPaneConfig.setName("librariesConfigScroll");
        this.librariesConfigItems.setSelectionMode(0);
        this.librariesConfigItems.setShowVerticalLines(false);
        this.librariesConfigItems.setFillsViewportHeight(true);
        this.librariesConfigItems.setShowHorizontalLines(false);
        this.librariesConfigItems.setName("librariesConfig");
        this.librariesConfigItems.setMinimumSize(new Dimension(42, 40));
        this.scrollPaneConfig.setViewportView(this.librariesConfigItems);
        this.splitPaneLibs.setLeftComponent(this.scrollPaneConfig);
        this.panelOptions.setMinimumSize(new Dimension(0, 78));
        this.panelOptions.setLayout(new BorderLayout());
        this.panelControls.setLayout(new BorderLayout());
        this.topType.setEnabled(false);
        this.topType.setVisible(false);
        this.topType.setLayout(new BorderLayout());
        this.vSpacer0.setPreferredSize(new Dimension(10, 2));
        this.vSpacer0.setMinimumSize(new Dimension(10, 2));
        this.vSpacer0.setMaximumSize(new Dimension(10, 2));
        this.topType.add((Component)this.vSpacer0, "North");
        this.panelLibraryType.setLayout(new BoxLayout(this.panelLibraryType, 0));
        this.hSpacer3.setPreferredSize(new Dimension(4, 10));
        this.hSpacer3.setMinimumSize(new Dimension(4, 12));
        this.hSpacer3.setMaximumSize(new Dimension(4, Short.MAX_VALUE));
        this.panelLibraryType.add(this.hSpacer3);
        this.labelLibaryType.setText("Library");
        this.labelLibaryType.setMaximumSize(new Dimension(110, 16));
        this.labelLibaryType.setFont(this.labelLibaryType.getFont().deriveFont(this.labelLibaryType.getFont().getStyle() | 1, (float)this.labelLibaryType.getFont().getSize() + 1.0f));
        this.labelLibaryType.setPreferredSize(new Dimension(110, 16));
        this.labelLibaryType.setMinimumSize(new Dimension(110, 16));
        this.panelLibraryType.add(this.labelLibaryType);
        this.topType.add((Component)this.panelLibraryType, "West");
        this.panelCardBox.setLayout(new BoxLayout(this.panelCardBox, 1));
        this.vSpacer3.setMinimumSize(new Dimension(12, 2));
        this.vSpacer3.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.vSpacer3.setPreferredSize(new Dimension(10, 2));
        this.panelCardBox.add(this.vSpacer3);
        this.panelCardBox.add(this.separator13);
        this.vSpacer4.setMinimumSize(new Dimension(12, 2));
        this.vSpacer4.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.vSpacer4.setPreferredSize(new Dimension(10, 2));
        this.panelCardBox.add(this.vSpacer4);
        this.topType.add((Component)this.panelCardBox, "South");
        this.panelControls.add((Component)this.topType, "North");
        this.panelOptions.add((Component)this.panelControls, "North");
        this.generalOptions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainFrame.this.generalOptionsMouseClicked(e);
            }
        });
        this.generalOptions.setLayout(new CardLayout());
        this.panelGettingStartedCard.setLayout(new BorderLayout());
        this.labelOperationGettingStarted.setText(this.context.cfg.gs("Navigator.labelOperationGettingStarted.text"));
        this.labelOperationGettingStarted.setFont(this.labelOperationGettingStarted.getFont().deriveFont(this.labelOperationGettingStarted.getFont().getStyle() | 1));
        this.labelOperationGettingStarted.setHorizontalAlignment(0);
        this.panelGettingStartedCard.add((Component)this.labelOperationGettingStarted, "Center");
        this.generalOptions.add((Component)this.panelGettingStartedCard, "cardGettingStarted");
        this.panelLibraryCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelLibraryCard.getLayout()).columnWidths = new int[]{0, 190, 16, 0, 24};
        ((GridBagLayout)this.panelLibraryCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelLibraryCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.hSpacer4.setMinimumSize(new Dimension(0, 0));
        this.hSpacer4.setPreferredSize(new Dimension(154, 10));
        this.panelLibraryCard.add((Component)this.hSpacer4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.hSpacer6.setMinimumSize(new Dimension(0, 0));
        this.hSpacer6.setPreferredSize(new Dimension(240, 10));
        this.panelLibraryCard.add((Component)this.hSpacer6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer6.setPreferredSize(new Dimension(10, 8));
        this.vSpacer6.setMinimumSize(new Dimension(2, 1));
        this.vSpacer6.setMaximumSize(new Dimension(Short.MAX_VALUE, 8));
        this.panelLibraryCard.add((Component)this.vSpacer6, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.hSpacer5.setMinimumSize(new Dimension(0, 0));
        this.hSpacer5.setPreferredSize(new Dimension(154, 10));
        this.panelLibraryCard.add((Component)this.hSpacer5, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.label1.setText(this.context.cfg.gs("Navigator.labelPath.text"));
        this.panelLibraryCard.add((Component)this.label1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldPath.setEditable(false);
        this.panelLibraryCard.add((Component)this.textFieldPath, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelKey.setText(this.context.cfg.gs("Navigator.labelKey.text"));
        this.panelLibraryCard.add((Component)this.labelKey, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldKey.setPreferredSize(new Dimension(240, 30));
        this.textFieldKey.setName("key");
        this.textFieldKey.setToolTipText(this.context.cfg.gs("Navigator.textFieldKey.toolTipText"));
        this.panelLibraryCard.add((Component)this.textFieldKey, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer33.setMinimumSize(new Dimension(10, 30));
        this.vSpacer33.setPreferredSize(new Dimension(20, 30));
        this.vSpacer33.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer33, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonLibraryGenerateKey.setText("...");
        this.buttonLibraryGenerateKey.setFont(this.buttonLibraryGenerateKey.getFont().deriveFont(this.buttonLibraryGenerateKey.getFont().getStyle() | 1));
        this.buttonLibraryGenerateKey.setMaximumSize(new Dimension(32, 24));
        this.buttonLibraryGenerateKey.setMinimumSize(new Dimension(32, 24));
        this.buttonLibraryGenerateKey.setPreferredSize(new Dimension(32, 24));
        this.buttonLibraryGenerateKey.setVerticalTextPosition(1);
        this.buttonLibraryGenerateKey.setIconTextGap(0);
        this.buttonLibraryGenerateKey.setHorizontalTextPosition(10);
        this.buttonLibraryGenerateKey.setActionCommand("generateUUID");
        this.buttonLibraryGenerateKey.setToolTipText(this.context.cfg.gs("Navigator.buttonLibraryGenerateKey.toolTipText"));
        this.buttonLibraryGenerateKey.setName("generate");
        this.panelLibraryCard.add((Component)this.buttonLibraryGenerateKey, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelHost.setText(this.context.cfg.gs("Navigator.labelHost.text"));
        this.panelLibraryCard.add((Component)this.labelHost, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldHost.setName("host");
        this.textFieldHost.setToolTipText(this.context.cfg.gs("Navigator.textFieldHost.toolTipText"));
        this.panelLibraryCard.add((Component)this.textFieldHost, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer34.setMinimumSize(new Dimension(10, 30));
        this.vSpacer34.setPreferredSize(new Dimension(20, 30));
        this.vSpacer34.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer34, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelListen.setText(this.context.cfg.gs("Navigator.labelListen.text"));
        this.panelLibraryCard.add((Component)this.labelListen, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldListen.setName("listen");
        this.textFieldListen.setToolTipText(this.context.cfg.gs("Navigator.textFieldListen.toolTipText"));
        this.panelLibraryCard.add((Component)this.textFieldListen, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer35.setMinimumSize(new Dimension(10, 30));
        this.vSpacer35.setPreferredSize(new Dimension(20, 30));
        this.vSpacer35.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer35, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelTimeout.setText(this.context.cfg.gs("Navigator.labelTimeout.text"));
        this.panelLibraryCard.add((Component)this.labelTimeout, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldTimeout.setName("timeout");
        this.textFieldTimeout.setPreferredSize(new Dimension(104, 30));
        this.textFieldTimeout.setMinimumSize(new Dimension(101104, 30));
        this.textFieldTimeout.setToolTipText(this.context.cfg.gs("Navigator.textFieldTimeout.toolTipText"));
        this.panelLibraryCard.add((Component)this.textFieldTimeout, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer36.setMinimumSize(new Dimension(10, 30));
        this.vSpacer36.setPreferredSize(new Dimension(20, 30));
        this.vSpacer36.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer36, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelFlavor.setText(this.context.cfg.gs("Navigator.labelFlavor.text"));
        this.panelLibraryCard.add((Component)this.labelFlavor, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.comboBoxFlavor.setModel(new DefaultComboBoxModel<String>(new String[]{"Linux", "Mac", "Windows"}));
        this.comboBoxFlavor.setName("flavor");
        this.comboBoxFlavor.setMinimumSize(new Dimension(104, 30));
        this.comboBoxFlavor.setPreferredSize(new Dimension(104, 30));
        this.comboBoxFlavor.setToolTipText(this.context.cfg.gs("Navigator.comboBoxFlavor.toolTipText"));
        this.panelLibraryCard.add(this.comboBoxFlavor, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer37.setMinimumSize(new Dimension(10, 30));
        this.vSpacer37.setPreferredSize(new Dimension(20, 30));
        this.vSpacer37.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer37, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelCase.setText(this.context.cfg.gs("Navigator.labelCase.text"));
        this.panelLibraryCard.add((Component)this.labelCase, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxCase.setName("case");
        this.checkBoxCase.setToolTipText(this.context.cfg.gs("Navigator.checkBoxCase.toolTipText"));
        this.panelLibraryCard.add((Component)this.checkBoxCase, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer38.setMinimumSize(new Dimension(10, 30));
        this.vSpacer38.setPreferredSize(new Dimension(20, 30));
        this.vSpacer38.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer38, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelTempDated.setText(this.context.cfg.gs("Navigator.labelTempDated.text"));
        this.panelLibraryCard.add((Component)this.labelTempDated, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxTempDated.setName("tempdated");
        this.checkBoxTempDated.setToolTipText(this.context.cfg.gs("Navigator.checkBoxTempDated.toolTipText"));
        this.panelLibraryCard.add((Component)this.checkBoxTempDated, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer42.setMinimumSize(new Dimension(10, 30));
        this.vSpacer42.setPreferredSize(new Dimension(20, 30));
        this.vSpacer42.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer42, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelTempLocation.setText(this.context.cfg.gs("Navigator.labelTempLocation.text"));
        this.panelLibraryCard.add((Component)this.labelTempLocation, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 8), 0, 0));
        this.textFieldTempLocation.setPreferredSize(new Dimension(240, 30));
        this.textFieldTempLocation.setMaximumSize(new Dimension(240, Integer.MAX_VALUE));
        this.textFieldTempLocation.setName("templocation");
        this.textFieldTempLocation.setToolTipText(this.context.cfg.gs("Navigator.textFieldTempLocation.toolTipText"));
        this.panelLibraryCard.add((Component)this.textFieldTempLocation, new GridBagConstraints(1, 9, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer39.setMinimumSize(new Dimension(10, 30));
        this.vSpacer39.setPreferredSize(new Dimension(20, 30));
        this.vSpacer39.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer39, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonLibrarySelectTempLocation.setText("...");
        this.buttonLibrarySelectTempLocation.setFont(this.buttonLibrarySelectTempLocation.getFont().deriveFont(this.buttonLibrarySelectTempLocation.getFont().getStyle() | 1));
        this.buttonLibrarySelectTempLocation.setMaximumSize(new Dimension(32, 24));
        this.buttonLibrarySelectTempLocation.setMinimumSize(new Dimension(32, 24));
        this.buttonLibrarySelectTempLocation.setPreferredSize(new Dimension(32, 24));
        this.buttonLibrarySelectTempLocation.setVerticalTextPosition(1);
        this.buttonLibrarySelectTempLocation.setIconTextGap(0);
        this.buttonLibrarySelectTempLocation.setHorizontalTextPosition(10);
        this.buttonLibrarySelectTempLocation.setActionCommand("generateUUID");
        this.buttonLibrarySelectTempLocation.setToolTipText(this.context.cfg.gs("Navigator.buttonLibrarySelectTempLocation.toolTipText"));
        this.buttonLibrarySelectTempLocation.setName("tempLocation");
        this.panelLibraryCard.add((Component)this.buttonLibrarySelectTempLocation, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelTerminalAllosed.setText(this.context.cfg.gs("Navigator.labelTerminalAllowed.text"));
        this.panelLibraryCard.add((Component)this.labelTerminalAllosed, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxTerminalAllowed.setName("terminalallowed");
        this.checkBoxTerminalAllowed.setToolTipText(this.context.cfg.gs("Navigator.checkBoxTerminalAllowed.toolTipText"));
        this.panelLibraryCard.add((Component)this.checkBoxTerminalAllowed, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer40.setMinimumSize(new Dimension(10, 30));
        this.vSpacer40.setPreferredSize(new Dimension(20, 30));
        this.vSpacer40.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer40, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelIgnores.setText(this.context.cfg.gs("Navigator.labelIgnores.text"));
        this.panelLibraryCard.add((Component)this.labelIgnores, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.panelLibrariesIgnorePatternsBox.setPreferredSize(new Dimension(120, 126));
        this.panelLibrariesIgnorePatternsBox.setMinimumSize(new Dimension(120, 120));
        this.panelLibrariesIgnorePatternsBox.setLayout(new BoxLayout(this.panelLibrariesIgnorePatternsBox, 1));
        this.scrollPaneLibrariesIgnorePatterns.setPreferredSize(new Dimension(43, 134));
        this.listLibrariesIgnorePatterns.setName("ignorepatterns");
        this.listLibrariesIgnorePatterns.setVisibleRowCount(5);
        this.listLibrariesIgnorePatterns.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] values = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5", "Item 6"};

            @Override
            public int getSize() {
                return this.values.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.values[i];
            }
        });
        this.listLibrariesIgnorePatterns.setToolTipText(this.context.cfg.gs("Navigator.listLibrariesIgnorePatterns.toolTipText"));
        this.listLibrariesIgnorePatterns.setPreferredSize(null);
        this.listLibrariesIgnorePatterns.setMinimumSize(null);
        this.listLibrariesIgnorePatterns.setMaximumSize(null);
        this.scrollPaneLibrariesIgnorePatterns.setViewportView(this.listLibrariesIgnorePatterns);
        this.panelLibrariesIgnorePatternsBox.add(this.scrollPaneLibrariesIgnorePatterns);
        this.panelLibrariesIgnorePatternsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonLibrariesAddIgnore.setText(this.context.cfg.gs("Navigator.buttonLibrariesAddIgnore.text"));
        this.buttonLibrariesAddIgnore.setFont(this.buttonLibrariesAddIgnore.getFont().deriveFont((float)this.buttonLibrariesAddIgnore.getFont().getSize() - 2.0f));
        this.buttonLibrariesAddIgnore.setPreferredSize(new Dimension(78, 24));
        this.buttonLibrariesAddIgnore.setMinimumSize(new Dimension(78, 24));
        this.buttonLibrariesAddIgnore.setMaximumSize(new Dimension(78, 24));
        this.buttonLibrariesAddIgnore.setMnemonic(this.context.cfg.gs("Navigator.buttonLibrariesAddIgnore.mnemonic").charAt(0));
        this.buttonLibrariesAddIgnore.setToolTipText(this.context.cfg.gs("Navigator.buttonLibrariesAddIgnore.toolTipText"));
        this.buttonLibrariesAddIgnore.setName("addincexc");
        this.buttonLibrariesAddIgnore.setMargin(new Insets(0, -10, 0, -10));
        this.panelLibrariesIgnorePatternsButtons.add(this.buttonLibrariesAddIgnore);
        this.buttonLibrariesRemoveIgnore.setText(this.context.cfg.gs("Navigator.buttonLibrariesRemoveIgnore.text"));
        this.buttonLibrariesRemoveIgnore.setFont(this.buttonLibrariesRemoveIgnore.getFont().deriveFont((float)this.buttonLibrariesRemoveIgnore.getFont().getSize() - 2.0f));
        this.buttonLibrariesRemoveIgnore.setPreferredSize(new Dimension(78, 24));
        this.buttonLibrariesRemoveIgnore.setMinimumSize(new Dimension(78, 24));
        this.buttonLibrariesRemoveIgnore.setMaximumSize(new Dimension(78, 24));
        this.buttonLibrariesRemoveIgnore.setMnemonic(this.context.cfg.gs("Navigator.buttonLibrariesRemoveIgnore.mnemonic").charAt(0));
        this.buttonLibrariesRemoveIgnore.setToolTipText(this.context.cfg.gs("Navigator.buttonLibrariesRemoveIgnore.toolTipText"));
        this.buttonLibrariesRemoveIgnore.setName("removeincexc");
        this.buttonLibrariesRemoveIgnore.setMargin(new Insets(0, -10, 0, -10));
        this.panelLibrariesIgnorePatternsButtons.add(this.buttonLibrariesRemoveIgnore);
        this.panelLibrariesIgnorePatternsBox.add(this.panelLibrariesIgnorePatternsButtons);
        this.panelLibraryCard.add((Component)this.panelLibrariesIgnorePatternsBox, new GridBagConstraints(1, 11, 3, 5, 0.0, 0.0, 11, 2, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer41.setMinimumSize(new Dimension(10, 30));
        this.vSpacer41.setPreferredSize(new Dimension(20, 30));
        this.vSpacer41.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer41, new GridBagConstraints(2, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelEmailAddr.setText(this.context.cfg.gs("Navigator.labelEmailAddr.text"));
        this.panelLibraryCard.add((Component)this.labelEmailAddr, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldEmailAddr.setName("email");
        this.textFieldEmailAddr.setToolTipText(this.context.cfg.gs("Navigator.textFieldEmailAddr.toolTipText"));
        this.panelLibraryCard.add((Component)this.textFieldEmailAddr, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer44.setMinimumSize(new Dimension(10, 30));
        this.vSpacer44.setPreferredSize(new Dimension(20, 30));
        this.vSpacer44.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer44, new GridBagConstraints(2, 16, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelMismatches.setText(this.context.cfg.gs("Navigator.labelMismatches.text"));
        this.panelLibraryCard.add((Component)this.labelMismatches, new GridBagConstraints(3, 16, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxMismatches.setToolTipText(this.context.cfg.gs("Navigator.checkBoxMismatches.toolTipText"));
        this.checkBoxMismatches.setName("mismatches");
        this.panelLibraryCard.add((Component)this.checkBoxMismatches, new GridBagConstraints(4, 16, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelFormat.setText(this.context.cfg.gs("Navigator.labelFormat.text"));
        this.panelLibraryCard.add((Component)this.labelFormat, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.comboBoxFormat.setToolTipText(this.context.cfg.gs("Navigator.comboBoxFormat.toolTipText"));
        this.comboBoxFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"HTML", "Text"}));
        this.comboBoxFormat.setName("format");
        this.panelLibraryCard.add(this.comboBoxFormat, new GridBagConstraints(1, 17, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer43.setMinimumSize(new Dimension(10, 30));
        this.vSpacer43.setPreferredSize(new Dimension(20, 30));
        this.vSpacer43.setMaximumSize(new Dimension(20, 30));
        this.panelLibraryCard.add((Component)this.vSpacer43, new GridBagConstraints(2, 17, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelWhatsNew.setText(this.context.cfg.gs("Navigator.labelWhatsNew.text"));
        this.panelLibraryCard.add((Component)this.labelWhatsNew, new GridBagConstraints(3, 17, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxWhatsNew.setToolTipText(this.context.cfg.gs("Navigator.checkBoxWhatsNew.toolTipText"));
        this.checkBoxWhatsNew.setName("whatsnew");
        this.panelLibraryCard.add((Component)this.checkBoxWhatsNew, new GridBagConstraints(4, 17, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelSkipOffline.setText(this.context.cfg.gs("Navigator.labelSkipOffline.text"));
        this.panelLibraryCard.add((Component)this.labelSkipOffline, new GridBagConstraints(0, 18, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxSkipOffline.setName("skipoffline");
        this.checkBoxSkipOffline.setToolTipText(this.context.cfg.gs("Navigator.checkBoxSkipOffline.toolTipText"));
        this.panelLibraryCard.add((Component)this.checkBoxSkipOffline, new GridBagConstraints(1, 18, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.generalOptions.add((Component)this.panelLibraryCard, "Library");
        this.panelXCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainFrame.this.cardShown(e);
            }
        });
        this.panelXCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelXCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelXCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.generalOptions.add((Component)this.panelXCard, "cardX");
        this.panelYCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainFrame.this.cardShown(e);
            }
        });
        this.panelYCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelYCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelYCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.generalOptions.add((Component)this.panelYCard, "cardY");
        this.scrollPaneGeneral.setViewportView(this.generalOptions);
        this.tabbedPaneLibrarySpaces.addTab(this.context.cfg.gs("Navigator.generalTab.title"), this.scrollPaneGeneral);
        this.tabbedPaneLibrarySpaces.setMnemonicAt(0, this.context.cfg.gs("Navigator.generalTab.mnemonic").charAt(0));
        this.locationsTab.setLayout(new BorderLayout());
        this.tableLocations.setFillsViewportHeight(true);
        this.tableLocations.setShowHorizontalLines(false);
        this.tableLocations.setShowVerticalLines(false);
        this.tableLocations.setName("tableLocations");
        this.scrollPaneLocations.setViewportView(this.tableLocations);
        this.locationsTab.add((Component)this.scrollPaneLocations, "Center");
        this.panelLocButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAddLocation.setText(this.context.cfg.gs("Navigator.buttonAddLocation.text"));
        this.buttonAddLocation.setFont(this.buttonAddLocation.getFont().deriveFont((float)this.buttonAddLocation.getFont().getSize() - 2.0f));
        this.buttonAddLocation.setPreferredSize(new Dimension(78, 24));
        this.buttonAddLocation.setMinimumSize(new Dimension(78, 24));
        this.buttonAddLocation.setMaximumSize(new Dimension(78, 24));
        this.buttonAddLocation.setMnemonic(this.context.cfg.gs("Navigator.buttonAddLocation.mnemonic_2").charAt(0));
        this.buttonAddLocation.setToolTipText(this.context.cfg.gs("Navigator.buttonAddLocation.toolTipText"));
        this.buttonAddLocation.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAddLocation.setName("selectlocation");
        this.panelLocButtons.add(this.buttonAddLocation);
        this.buttonRemoveLocation.setText(this.context.cfg.gs("Navigator.buttonRemoveLocation.text"));
        this.buttonRemoveLocation.setFont(this.buttonRemoveLocation.getFont().deriveFont((float)this.buttonRemoveLocation.getFont().getSize() - 2.0f));
        this.buttonRemoveLocation.setPreferredSize(new Dimension(78, 24));
        this.buttonRemoveLocation.setMinimumSize(new Dimension(78, 24));
        this.buttonRemoveLocation.setMaximumSize(new Dimension(78, 24));
        this.buttonRemoveLocation.setMnemonic(this.context.cfg.gs("Navigator.buttonRemoveLocation.mnemonic").charAt(0));
        this.buttonRemoveLocation.setToolTipText(this.context.cfg.gs("Navigator.buttonRemoveLocation.toolTipText"));
        this.buttonRemoveLocation.setMargin(new Insets(0, -10, 0, -10));
        this.panelLocButtons.add(this.buttonRemoveLocation);
        this.locationsTab.add((Component)this.panelLocButtons, "South");
        this.tabbedPaneLibrarySpaces.addTab(this.context.cfg.gs("Navigator.locationsTab.tab.title"), this.locationsTab);
        this.tabbedPaneLibrarySpaces.setMnemonicAt(1, this.context.cfg.gs("Navigator.locationsTab.tab.mnemonic").charAt(0));
        this.bibliographyTab.setLayout(new BorderLayout());
        this.splitPanelBiblio.setDividerLocation(201);
        this.splitPanelBiblio.setMinimumSize(new Dimension(10, 89));
        this.panelBiblioLibraries.setPreferredSize(new Dimension(200, 40));
        this.panelBiblioLibraries.setMinimumSize(new Dimension(42, 40));
        this.panelBiblioLibraries.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelBiblioLibraries.getLayout()).columnWidths = new int[]{200, 0};
        ((GridBagLayout)this.panelBiblioLibraries.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.panelBiblioLibraries.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)this.panelBiblioLibraries.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        this.panelHeader.setLayout(new BorderLayout());
        this.labelLibraries.setText(this.context.cfg.gs("Libraries.labelBiblioLibraries.text"));
        this.labelLibraries.setHorizontalAlignment(2);
        this.labelLibraries.setFont(this.labelLibraries.getFont().deriveFont(this.labelLibraries.getFont().getStyle() | 1, (float)this.labelLibraries.getFont().getSize() + 1.0f));
        this.labelLibraries.setVerticalAlignment(3);
        this.panelHeader.add((Component)this.labelLibraries, "West");
        this.labelMatchDates.setText(this.context.cfg.gs("Navigator.labelMatchDates.text"));
        this.labelMatchDates.setHorizontalAlignment(4);
        this.labelMatchDates.setFont(this.labelMatchDates.getFont().deriveFont((float)this.labelMatchDates.getFont().getSize() - 1.0f));
        this.labelMatchDates.setToolTipText(this.context.cfg.gs("MatchDateCell.checkBox.tooltip"));
        this.labelMatchDates.setVerticalAlignment(3);
        this.panelHeader.add((Component)this.labelMatchDates, "East");
        this.panelBiblioLibraries.add((Component)this.panelHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 4, 0, 2), 0, 0));
        this.scrollPaneBiblioLibraries.setMinimumSize(new Dimension(42, 20));
        this.tableBiblioLibraries.setFillsViewportHeight(true);
        this.tableBiblioLibraries.setShowVerticalLines(false);
        this.tableBiblioLibraries.setShowHorizontalLines(false);
        this.tableBiblioLibraries.setSelectionMode(0);
        this.tableBiblioLibraries.setMinimumSize(new Dimension(42, 40));
        this.scrollPaneBiblioLibraries.setViewportView(this.tableBiblioLibraries);
        this.panelBiblioLibraries.add((Component)this.scrollPaneBiblioLibraries, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPanelBiblio.setLeftComponent(this.panelBiblioLibraries);
        this.panelSources.setLayout(new BorderLayout());
        this.panelSourcesTop.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelSourcesTop.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.panelSourcesTop.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.panelSourcesTop.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)this.panelSourcesTop.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        this.labelSpacer42.setText(" ");
        this.panelSourcesTop.add((Component)this.labelSpacer42, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelSources.setText(this.context.cfg.gs("Navigator.labelSources.text"));
        this.labelSources.setFont(this.labelSources.getFont().deriveFont(this.labelSources.getFont().getStyle() | 1, (float)this.labelSources.getFont().getSize() + 1.0f));
        this.labelSources.setHorizontalAlignment(2);
        this.labelSources.setPreferredSize(new Dimension(200, 16));
        this.labelSources.setMinimumSize(new Dimension(200, 16));
        this.panelSourcesTop.add((Component)this.labelSources, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 4, 0, 0), 0, 0));
        this.panelSources.add((Component)this.panelSourcesTop, "North");
        this.scrollPaneSources.setMinimumSize(new Dimension(408, 20));
        this.scrollPaneSources.setViewportView(this.listSources);
        this.panelSources.add((Component)this.scrollPaneSources, "Center");
        this.panelSourceButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAddSource.setText(this.context.cfg.gs("Navigator.buttonAddSource.text"));
        this.buttonAddSource.setFont(this.buttonAddSource.getFont().deriveFont((float)this.buttonAddSource.getFont().getSize() - 2.0f));
        this.buttonAddSource.setPreferredSize(new Dimension(78, 24));
        this.buttonAddSource.setMinimumSize(new Dimension(78, 24));
        this.buttonAddSource.setMaximumSize(new Dimension(78, 24));
        this.buttonAddSource.setMnemonic(this.context.cfg.gs("Navigator.buttonAddSource.mnemonic").charAt(0));
        this.buttonAddSource.setToolTipText(this.context.cfg.gs("Navigator.buttonAddSource.toolTipText"));
        this.buttonAddSource.setName("addSource");
        this.buttonAddSource.setMargin(new Insets(0, -10, 0, -10));
        this.panelSourceButtons.add(this.buttonAddSource);
        this.buttonAddMultiSource.setText(this.context.cfg.gs("Navigator.buttonAddMultiSource.text"));
        this.buttonAddMultiSource.setFont(this.buttonAddMultiSource.getFont().deriveFont((float)this.buttonAddMultiSource.getFont().getSize() - 2.0f));
        this.buttonAddMultiSource.setPreferredSize(new Dimension(78, 24));
        this.buttonAddMultiSource.setMinimumSize(new Dimension(78, 24));
        this.buttonAddMultiSource.setMaximumSize(new Dimension(78, 24));
        this.buttonAddMultiSource.setMnemonic(this.context.cfg.gs("Navigator.buttonAddMultiSource.mnemonic").charAt(0));
        this.buttonAddMultiSource.setToolTipText(this.context.cfg.gs("Navigator.buttonAddMultiSource.toolTipText"));
        this.buttonAddMultiSource.setName("addMultiSource");
        this.buttonAddMultiSource.setMargin(new Insets(0, -10, 0, -10));
        this.panelSourceButtons.add(this.buttonAddMultiSource);
        this.buttonUpSource.setText("^");
        this.buttonUpSource.setMaximumSize(new Dimension(24, 24));
        this.buttonUpSource.setMinimumSize(new Dimension(24, 24));
        this.buttonUpSource.setPreferredSize(new Dimension(24, 24));
        this.buttonUpSource.setFont(this.buttonUpSource.getFont().deriveFont((float)this.buttonUpSource.getFont().getSize() - 2.0f));
        this.buttonUpSource.setToolTipText(this.context.cfg.gs("Navigator.buttonUpSource.toolTipText"));
        this.panelSourceButtons.add(this.buttonUpSource);
        this.buttonDownSource.setText("v");
        this.buttonDownSource.setFont(this.buttonDownSource.getFont().deriveFont((float)this.buttonDownSource.getFont().getSize() - 2.0f));
        this.buttonDownSource.setMaximumSize(new Dimension(24, 24));
        this.buttonDownSource.setMinimumSize(new Dimension(24, 24));
        this.buttonDownSource.setPreferredSize(new Dimension(24, 24));
        this.buttonDownSource.setToolTipText(this.context.cfg.gs("Navigator.buttonDownSource.toolTipText"));
        this.panelSourceButtons.add(this.buttonDownSource);
        this.buttonRemoveSource.setText(this.context.cfg.gs("Navigator.buttonRemoveSource.text"));
        this.buttonRemoveSource.setFont(this.buttonRemoveSource.getFont().deriveFont((float)this.buttonRemoveSource.getFont().getSize() - 2.0f));
        this.buttonRemoveSource.setPreferredSize(new Dimension(78, 24));
        this.buttonRemoveSource.setMinimumSize(new Dimension(78, 24));
        this.buttonRemoveSource.setMaximumSize(new Dimension(78, 24));
        this.buttonRemoveSource.setMnemonic(this.context.cfg.gs("Navigator.buttonRemoveSource.mnemonic_2").charAt(0));
        this.buttonRemoveSource.setToolTipText(this.context.cfg.gs("Navigator.buttonRemoveSource.toolTipText"));
        this.buttonRemoveSource.setMargin(new Insets(0, -10, 0, -10));
        this.panelSourceButtons.add(this.buttonRemoveSource);
        this.panelSources.add((Component)this.panelSourceButtons, "South");
        this.splitPanelBiblio.setRightComponent(this.panelSources);
        this.bibliographyTab.add((Component)this.splitPanelBiblio, "Center");
        this.panelBiblioButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAddLibrary.setText(this.context.cfg.gs("Navigator.buttonAddLibrary.text"));
        this.buttonAddLibrary.setFont(this.buttonAddLibrary.getFont().deriveFont((float)this.buttonAddLibrary.getFont().getSize() - 2.0f));
        this.buttonAddLibrary.setPreferredSize(new Dimension(78, 24));
        this.buttonAddLibrary.setMinimumSize(new Dimension(78, 24));
        this.buttonAddLibrary.setMaximumSize(new Dimension(78, 24));
        this.buttonAddLibrary.setMnemonic(this.context.cfg.gs("Navigator.buttonAddLibrary.mnemonic_2").charAt(0));
        this.buttonAddLibrary.setToolTipText(this.context.cfg.gs("Navigator.buttonAddLibrary.toolTipText"));
        this.buttonAddLibrary.setMargin(new Insets(0, -10, 0, -10));
        this.panelBiblioButtons.add(this.buttonAddLibrary);
        this.buttonRemoveLibrary.setText(this.context.cfg.gs("Navigator.buttonRemoveLibrary.text"));
        this.buttonRemoveLibrary.setFont(this.buttonRemoveLibrary.getFont().deriveFont((float)this.buttonRemoveLibrary.getFont().getSize() - 2.0f));
        this.buttonRemoveLibrary.setPreferredSize(new Dimension(78, 24));
        this.buttonRemoveLibrary.setMinimumSize(new Dimension(78, 24));
        this.buttonRemoveLibrary.setMaximumSize(new Dimension(78, 24));
        this.buttonRemoveLibrary.setToolTipText(this.context.cfg.gs("Navigator.buttonRemoveLibrary.toolTipText"));
        this.buttonRemoveLibrary.setMargin(new Insets(0, -10, 0, -10));
        this.buttonRemoveLibrary.setMnemonic(this.context.cfg.gs("Navigator.buttonRemoveLibrary.mnemonic").charAt(0));
        this.panelBiblioButtons.add(this.buttonRemoveLibrary);
        this.bibliographyTab.add((Component)this.panelBiblioButtons, "South");
        this.tabbedPaneLibrarySpaces.addTab(this.context.cfg.gs("Navigator.bibliographyTab.tab.title"), this.bibliographyTab);
        this.tabbedPaneLibrarySpaces.setMnemonicAt(2, this.context.cfg.gs("Navigator.bibliographyTab.tab.mnemonic_2").charAt(0));
        this.panelOptions.add((Component)this.tabbedPaneLibrarySpaces, "Center");
        this.splitPaneLibs.setRightComponent(this.panelOptions);
        this.panelLibraries.add((Component)this.splitPaneLibs, "Center");
        this.buttonBarLibs.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBarLibs.setPreferredSize(new Dimension(256, 42));
        this.buttonBarLibs.setMinimumSize(new Dimension(256, 42));
        this.buttonBarLibs.setMaximumSize(new Dimension(Integer.MAX_VALUE, 42));
        this.buttonBarLibs.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBarLibs.getLayout()).columnWidths = new int[]{80, 80};
        this.saveButton.setText(this.context.cfg.gs("Z.ok"));
        this.saveButton.setToolTipText(this.context.cfg.gs("Libraries.save.toolTip.text"));
        this.saveButton.setMnemonic(this.context.cfg.gs("Navigator.saveButton.mnemonic_2").charAt(0));
        this.buttonBarLibs.add((Component)this.saveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("Libraries.undo"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("Libraries.cancel.toolTip.text"));
        this.cancelButton.setMnemonic(this.context.cfg.gs("Navigator.cancelButton.mnemonic_2").charAt(0));
        this.buttonBarLibs.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelLibraries.add((Component)this.buttonBarLibs, "South");
        this.tabbedPaneMain.addTab(this.context.cfg.gs("Navigator.splitPane.Libraries.tab.title"), this.panelLibraries);
        this.tabbedPaneMain.setMnemonicAt(1, this.context.cfg.gs("Navigator.splitPane.Libraries.tab.mnemonic").charAt(0));
        this.panelMain.add(this.tabbedPaneMain);
        contentPane.add((Component)this.panelMain, "Center");
        this.hSpacer8.setPreferredSize(new Dimension(2, 10));
        this.hSpacer8.setMinimumSize(new Dimension(2, 12));
        this.hSpacer8.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        contentPane.add((Component)this.hSpacer8, "West");
        this.panelStatus.setLayout(new GridBagLayout());
        this.labelStatusLeft.setHorizontalAlignment(2);
        this.labelStatusLeft.setIconTextGap(0);
        this.panelStatus.add((Component)this.labelStatusLeft, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 10, 0, 4), 0, 0));
        this.labelStatusMiddle.setHorizontalAlignment(0);
        this.labelStatusMiddle.setHorizontalTextPosition(0);
        this.labelStatusMiddle.setIconTextGap(0);
        this.panelStatus.add((Component)this.labelStatusMiddle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 3, new Insets(0, 0, 0, 4), 0, 0));
        this.labelStatusRight.setHorizontalAlignment(4);
        this.labelStatusRight.setIconTextGap(0);
        this.panelStatus.add((Component)this.labelStatusRight, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 0, 0, 14), 0, 0));
        contentPane.add((Component)this.panelStatus, "South");
        this.hSpacer9.setPreferredSize(new Dimension(2, 10));
        this.hSpacer9.setMinimumSize(new Dimension(2, 12));
        this.hSpacer9.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        contentPane.add((Component)this.hSpacer9, "East");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.popupMenuBrowser.setPreferredSize(new Dimension(212, 194));
        this.popupMenuItemRefresh.setText(this.context.cfg.gs("Navigator.popupMenuItemRefresh.text"));
        this.popupMenuItemRefresh.setMnemonic(this.context.cfg.gs("Navigator.popupMenuItemRefresh.mnemonic").charAt(0));
        this.popupMenuItemRefresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.popupMenuItemRefresh.setIcon(new ImageIcon(this.getClass().getResource("/refresh.png")));
        this.popupMenuBrowser.add(this.popupMenuItemRefresh);
        this.popupMenuBrowser.addSeparator();
        this.popupMenuItemCopy.setText(this.context.cfg.gs("Navigator.popupMenu.Copy.text"));
        this.popupMenuItemCopy.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Copy.mnemonic").charAt(0));
        this.popupMenuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.popupMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/copy.png")));
        this.popupMenuBrowser.add(this.popupMenuItemCopy);
        this.popupMenuItemCut.setText(this.context.cfg.gs("Navigator.popupMenu.Cut.text"));
        this.popupMenuItemCut.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Cut.mnemonic").charAt(0));
        this.popupMenuItemCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.popupMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/cut.png")));
        this.popupMenuBrowser.add(this.popupMenuItemCut);
        this.popupMenuItemPaste.setText(this.context.cfg.gs("Navigator.popupMenu.Paste.text"));
        this.popupMenuItemPaste.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Paste.mnemonic").charAt(0));
        this.popupMenuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.popupMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/paste.png")));
        this.popupMenuBrowser.add(this.popupMenuItemPaste);
        this.popupMenuBrowser.addSeparator();
        this.popupMenuItemDelete.setText(this.context.cfg.gs("Navigator.popupMenu.Delete.text"));
        this.popupMenuItemDelete.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Delete.mnemonic").charAt(0));
        this.popupMenuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.popupMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/delete-x.png")));
        this.popupMenuBrowser.add(this.popupMenuItemDelete);
        this.popupMenuBrowser.addSeparator();
        this.popupMenuItemNewFolder.setText(this.context.cfg.gs("Navigator.popupMenu.NewFolder.text"));
        this.popupMenuItemNewFolder.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.NewFolder.mnemonic").charAt(0));
        this.popupMenuItemNewFolder.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.popupMenuItemNewFolder.setIcon(new ImageIcon(this.getClass().getResource("/new-folder.png")));
        this.popupMenuBrowser.add(this.popupMenuItemNewFolder);
        this.popupMenuItemRename.setText(this.context.cfg.gs("Navigator.popupMenu.Rename.text"));
        this.popupMenuItemRename.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Rename.mnemonic").charAt(0));
        this.popupMenuItemRename.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.popupMenuItemRename.setIcon(new ImageIcon(this.getClass().getResource("/rename.png")));
        this.popupMenuBrowser.add(this.popupMenuItemRename);
        this.popupMenuItemTouch.setText(this.context.cfg.gs("Navigator.popupMenu.Touch.text"));
        this.popupMenuItemTouch.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Touch.mnemonic").charAt(0));
        this.popupMenuItemTouch.setIcon(new ImageIcon(this.getClass().getResource("/touch.png")));
        this.popupMenuItemTouch.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.popupMenuBrowser.add(this.popupMenuItemTouch);
        this.popupMenuLog.setPreferredSize(new Dimension(188, 156));
        this.popupMenuItemFindNext.setText(this.context.cfg.gs("Navigator.popupMenuItemFindNext.text"));
        this.popupMenuItemFindNext.setMnemonic(this.context.cfg.gs("Navigator.popupMenuItemFindNext.mnemonic").charAt(0));
        this.popupMenuItemFindNext.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.popupMenuItemFindNext.setIcon(new ImageIcon(this.getClass().getResource("/find-next.png")));
        this.popupMenuLog.add(this.popupMenuItemFindNext);
        this.popupMenuItemFind.setText(this.context.cfg.gs("Navigator.popupMenuItemFind.text"));
        this.popupMenuItemFind.setMnemonic(this.context.cfg.gs("Navigator.popupMenuItemFind.mnemonic").charAt(0));
        this.popupMenuItemFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.popupMenuItemFind.setIcon(new ImageIcon(this.getClass().getResource("/find.png")));
        this.popupMenuLog.add(this.popupMenuItemFind);
        this.popupMenuLog.addSeparator();
        this.popupMenuItemTop.setText(this.context.cfg.gs("Navigator.popupMenuItemTop.text"));
        this.popupMenuItemTop.setMnemonic(this.context.cfg.gs("Navigator.popupMenuItemTop.mnemonic").charAt(0));
        this.popupMenuItemTop.setAccelerator(KeyStroke.getKeyStroke(36, 128));
        this.popupMenuItemTop.setIcon(new ImageIcon(this.getClass().getResource("/top.png")));
        this.popupMenuLog.add(this.popupMenuItemTop);
        this.popupMenuItemBottom.setText(this.context.cfg.gs("Navigator.popupMenu.Bottom.text"));
        this.popupMenuItemBottom.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Bottom.mnemonic").charAt(0));
        this.popupMenuItemBottom.setAccelerator(KeyStroke.getKeyStroke(35, 128));
        this.popupMenuItemBottom.setIcon(new ImageIcon(this.getClass().getResource("/bottom.png")));
        this.popupMenuLog.add(this.popupMenuItemBottom);
        this.popupMenuLog.addSeparator();
        this.popupMenuItemClear.setText(this.context.cfg.gs("Navigator.popupMenu.Clear.text"));
        this.popupMenuItemClear.setMnemonic(this.context.cfg.gs("Navigator.popupMenu.Clear.mnemonic").charAt(0));
        this.popupMenuItemClear.setIcon(new ImageIcon(this.getClass().getResource("/clear.png")));
        this.popupMenuLog.add(this.popupMenuItemClear);
        this.popupMenuLog.addSeparator();
        this.popupCheckBoxMenuItemWordWrap.setText(this.context.cfg.gs("Navigator.popupCheckBoxMenuItemWordWrap.text"));
        this.popupCheckBoxMenuItemWordWrap.setMnemonic(this.context.cfg.gs("Navigator.popupCheckBoxMenuItemWordWrap.mnemonic").charAt(0));
        this.popupCheckBoxMenuItemWordWrap.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.popupMenuLog.add(this.popupCheckBoxMenuItemWordWrap);
    }
}

