/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.jcraft.jsch.SftpProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Progress
extends JFrame
implements SftpProgressMonitor {
    private long averageBps = 0L;
    private ActionListener cancelAction;
    private boolean cancelled = false;
    private boolean dryRun;
    private int fileNumber = 0;
    private int fixedHeight;
    private boolean forcedState = false;
    private Context context;
    private String lastStatus = "";
    private Logger logger = LogManager.getLogger("applog");
    private String name;
    private boolean prefSaved = false;
    private long progressCurrent = 0L;
    private long progressMax = 0L;
    private long progressMaxDivisor = 0L;
    private boolean noIcon = false;
    private Window owner;
    private long start = 0L;
    private long time = 0L;
    private long totalBytesCopied = 0L;
    private long totalBytesDivisor = 0L;
    private int totalFilesToCopy = 0;
    private long totalFilesBytes = 0L;
    public JPanel panelWidget;
    public JPanel hSpacer1;
    public JLabel labelForIcon;
    public JTextField progressTextField;
    public JPanel panelButton;
    public JPanel hSpacer3;
    public JButton buttonCancel;
    public JPanel hSpacer2;
    public JPanel hSpacer4;
    public JPanel panelProgress;
    public JProgressBar progressBarFile;
    public JProgressBar progressBarTotal;
    public JPanel vSpacer3;
    public JPanel vSpacer5;

    public Progress(Context context, Window owner, ActionListener cancelAction, boolean dryRun) {
        this.context = context;
        this.owner = owner;
        this.cancelAction = cancelAction;
        this.dryRun = dryRun;
        this.context.progress = this;
        this.initComponents();
        this.loadIcon();
        this.progressTextField.setBorder(null);
        this.setLocationByPlatform(false);
        this.setLocationRelativeTo(null);
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Progress.this.cancelClicked(actionEvent);
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
        this.progressBarFile.setMinimum(0);
        this.progressBarFile.setMaximum(100);
        this.progressBarFile.setValue(0);
        this.progressBarTotal.setMinimum(0);
        this.progressBarTotal.setMaximum(100);
        this.progressBarTotal.setValue(0);
        this.start = System.currentTimeMillis();
    }

    private void cancelClicked(ActionEvent e) {
        if (this.context.browser.navTransferHandler.getTransferWorker() != null && this.context.browser.navTransferHandler.getTransferWorker().isRunning()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int r = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.the.current.operation"), this.getTitle(), 0, 2, null, opts, opts[1]);
            if (r == 1 || r == 2) {
                return;
            }
            this.context.browser.navTransferHandler.getTransferWorker().setIsRunning(false);
            this.cancelled = true;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cancelAction.actionPerformed(e);
        }
        this.done();
    }

    public void display() {
        if (this.context.preferences.getProgressXpos() != -1 && Utils.isOnScreen(this.context.preferences.getProgressXpos(), this.context.preferences.getProgressYpos())) {
            this.setLocation(this.context.preferences.getProgressXpos(), this.context.preferences.getProgressYpos());
        } else {
            this.setLocation(Utils.getRelativePosition(this.context.mainFrame, this.context.mainFrame));
        }
        if (this.context.preferences.getProgressWidth() > 0) {
            this.setSize(this.context.preferences.getProgressWidth(), this.context.preferences.getProgressHeight());
        }
        if (!this.dryRun) {
            this.setTitle(this.context.cfg.gs("Progress.title"));
        } else {
            this.setTitle(this.context.cfg.gs("Progress.title.dryrun"));
        }
        if (!this.noIcon) {
            this.labelForIcon.setVisible(true);
        }
        this.setVisible(true);
        this.setState(0);
        this.fixedHeight = this.getHeight();
        this.toFront();
    }

    public void done() {
        this.storePreferences();
        this.setVisible(false);
    }

    @Override
    public void init(int op, String src, String dest, long size) {
        this.progressCurrent = 0L;
        this.progressMax = size;
        this.progressBarFile.setValue(0);
        this.progressMaxDivisor = this.progressMax / 100L;
        if (this.progressMaxDivisor <= 0L) {
            this.progressMaxDivisor = 1L;
        }
        this.time = System.currentTimeMillis();
        String[] actions = new String[]{"put", "get", "copy"};
        String action = actions[op];
        this.logger.trace(action + " " + src + " " + dest + " " + size);
    }

    @Override
    public boolean count(long count) {
        this.progressCurrent += count;
        this.totalBytesCopied += count;
        this.progressBarFile.setValue((int)(this.progressCurrent / this.progressMaxDivisor));
        int pc = (int)((double)this.progressCurrent / (double)this.progressMax * 100.0);
        this.progressBarFile.setString(this.context.cfg.gs("NavTransferHandler.progress.file") + " " + pc + "%");
        this.progressBarTotal.setValue((int)(this.totalBytesCopied / this.totalBytesDivisor));
        pc = (int)((double)this.totalBytesCopied / (double)this.totalFilesBytes * 100.0);
        this.progressBarTotal.setString(this.context.cfg.gs("NavTransferHandler.progress.total") + " " + pc + "%");
        return !this.cancelled;
    }

    @Override
    public void end() {
        long now = System.currentTimeMillis();
        long diff = now - this.time;
        if ((diff /= 1000L) > 0L) {
            long rate = this.progressMax / diff;
            String duration = Utils.formatDuration(diff);
            this.logger.info("Transfer " + (String)(this.cancelled ? "cancelled" : "complete: " + Utils.formatLong(this.progressMax, false, this.context.cfg.getLongScale()) + ", " + duration + ", " + Utils.formatRate(rate, this.context.cfg.getLongScale())));
            this.averageBps = this.averageBps > 0L ? (this.averageBps + rate) / 2L : rate;
        }
    }

    public long getAverageBps() {
        return this.averageBps;
    }

    public long getStartTime() {
        return this.start;
    }

    public long getTotalBytesCopied() {
        return this.totalBytesCopied;
    }

    private void loadIcon() {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/els-logo-98px.png")).getImage());
        try {
            URL url = this.getClass().getResource("/running.gif");
            ImageIcon icon = new ImageIcon(url);
            this.labelForIcon.setIcon(icon);
        }
        catch (Exception e) {
            this.noIcon = true;
            this.labelForIcon.setVisible(false);
        }
    }

    public void redraw() {
        Graphics gfx = this.progressTextField.getGraphics();
        if (gfx != null) {
            this.progressTextField.update(gfx);
        }
        this.progressTextField.repaint();
        this.repaint();
    }

    public void setCountAndBytes(int filesToCopy, long totalFilesBytes) {
        this.totalFilesToCopy = filesToCopy;
        this.totalFilesBytes = totalFilesBytes;
        this.totalBytesDivisor = totalFilesBytes / 100L;
        if (this.totalBytesDivisor <= 0L) {
            this.totalBytesDivisor = 1L;
        }
        this.update(this.fileNumber, this.progressMax, this.name);
    }

    private void storePreferences() {
        this.context.preferences.setProgressWidth(this.getWidth());
        this.context.preferences.setProgressHeight(this.getHeight());
        this.context.preferences.setProgressXpos(this.getX());
        this.context.preferences.setProgressYpos(this.getY());
        this.prefSaved = true;
    }

    private void thisComponentResized(ComponentEvent e) {
        if (!this.forcedState) {
            this.context.preferences.setProgressWidth(this.getWidth());
            this.update(this.lastStatus);
        } else {
            this.forcedState = false;
        }
        this.setSize(this.context.preferences.getProgressWidth(), this.fixedHeight);
    }

    private void thisWindowClosed(WindowEvent e) {
        if (this.owner != null) {
            this.owner.requestFocus();
        }
    }

    private void thisWindowClosing(WindowEvent e) {
        if (!this.prefSaved) {
            this.storePreferences();
        }
        this.setVisible(false);
        if (this.owner != null) {
            this.owner.requestFocus();
            this.owner = null;
        }
    }

    private void thisWindowStateChanged(WindowEvent e) {
        if (e.getNewState() != 0 && e.getNewState() != 1) {
            this.forcedState = true;
            this.setState(0);
            this.setExtendedState(0);
            this.setSize(this.context.preferences.getProgressWidth(), this.fixedHeight);
        }
    }

    public synchronized void update(String status) {
        this.lastStatus = status;
        String ellipse = Utils.ellipseFileString(this.progressTextField, status);
        this.progressTextField.setText(ellipse);
        this.redraw();
    }

    public synchronized void update(int fileNumber, long size, String name) {
        if (fileNumber > 0) {
            this.fileNumber = fileNumber;
            this.progressMax = size;
            this.progressMaxDivisor = this.progressMax / 100L;
            this.name = name;
            String status = " " + this.context.cfg.gs("NavTransferHandler.progress.file") + " " + fileNumber + " (" + Utils.formatLong(size, false, this.context.cfg.getLongScale()) + ") " + this.context.cfg.gs("NavTransferHandler.progress.of") + " " + this.totalFilesToCopy + " (" + Utils.formatLong(this.totalFilesBytes, false, this.context.cfg.getLongScale()) + "): " + name;
            this.progressTextField.setToolTipText(name);
            this.update(status);
        }
    }

    public void view() {
        String ls = this.lastStatus;
        this.display();
        if (this.totalFilesToCopy > 0 || this.totalBytesCopied > 0L) {
            this.update(ls);
        } else {
            this.labelForIcon.setVisible(false);
            this.update(this.context.cfg.gs("Progress.not.active"));
        }
        this.toFront();
    }

    private void initComponents() {
        this.panelWidget = new JPanel();
        this.hSpacer1 = new JPanel(null);
        this.labelForIcon = new JLabel();
        this.progressTextField = new JTextField();
        this.panelButton = new JPanel();
        this.hSpacer3 = new JPanel(null);
        this.buttonCancel = new JButton();
        this.hSpacer2 = new JPanel(null);
        this.hSpacer4 = new JPanel(null);
        this.panelProgress = new JPanel();
        this.progressBarFile = new JProgressBar();
        this.progressBarTotal = new JProgressBar();
        this.vSpacer3 = new JPanel(null);
        this.vSpacer5 = new JPanel(null);
        this.setMinimumSize(new Dimension(184, 128));
        this.setTitle(this.context.cfg.gs("Progress.title"));
        this.setName("ProgressBox");
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(10, 128));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 128));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Progress.this.thisWindowClosed(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Progress.this.thisWindowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Progress.this.thisComponentResized(e);
            }
        });
        this.addWindowStateListener(e -> this.thisWindowStateChanged(e));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(4, 4));
        this.panelWidget.setMaximumSize(new Dimension(40, 36));
        this.panelWidget.setAlignmentY(1.0f);
        this.panelWidget.setMinimumSize(new Dimension(40, 36));
        this.panelWidget.setPreferredSize(new Dimension(40, 36));
        this.panelWidget.setLayout(new BoxLayout(this.panelWidget, 0));
        this.hSpacer1.setPreferredSize(new Dimension(4, 10));
        this.hSpacer1.setMinimumSize(new Dimension(4, 10));
        this.hSpacer1.setMaximumSize(new Dimension(4, 10));
        this.panelWidget.add(this.hSpacer1);
        this.labelForIcon.setPreferredSize(new Dimension(36, 32));
        this.labelForIcon.setMinimumSize(new Dimension(36, 32));
        this.labelForIcon.setMaximumSize(new Dimension(36, 32));
        this.labelForIcon.setHorizontalTextPosition(2);
        this.labelForIcon.setHorizontalAlignment(2);
        this.labelForIcon.setIcon(new ImageIcon(this.getClass().getResource("/running.gif")));
        this.panelWidget.add(this.labelForIcon);
        contentPane.add((Component)this.panelWidget, "West");
        this.progressTextField.setPreferredSize(new Dimension(140, 30));
        this.progressTextField.setMinimumSize(new Dimension(140, 30));
        this.progressTextField.setMaximumSize(new Dimension(5000, 30));
        this.progressTextField.setCursor(Cursor.getPredefinedCursor(0));
        this.progressTextField.setEditable(false);
        this.progressTextField.setHorizontalAlignment(2);
        this.progressTextField.setBorder(null);
        this.progressTextField.setMargin(new Insets(2, 0, 2, 8));
        this.progressTextField.setText(this.context.cfg.gs("Progress.not.active"));
        contentPane.add((Component)this.progressTextField, "Center");
        this.panelButton.setPreferredSize(new Dimension(88, 20));
        this.panelButton.setMinimumSize(new Dimension(88, 20));
        this.panelButton.setMaximumSize(new Dimension(88, 20));
        this.panelButton.setLayout(new BorderLayout());
        this.hSpacer3.setMinimumSize(new Dimension(10, 3));
        this.hSpacer3.setMaximumSize(new Dimension(Short.MAX_VALUE, 3));
        this.hSpacer3.setPreferredSize(new Dimension(10, 3));
        this.panelButton.add((Component)this.hSpacer3, "North");
        this.buttonCancel.setText(this.context.cfg.gs("Progress.buttonCancel.text"));
        this.buttonCancel.setMaximumSize(new Dimension(78, 20));
        this.buttonCancel.setMinimumSize(new Dimension(78, 20));
        this.buttonCancel.setPreferredSize(new Dimension(78, 20));
        this.buttonCancel.setActionCommand(this.context.cfg.gs("Progress.buttonCancel.text"));
        this.buttonCancel.setToolTipText(this.context.cfg.gs("Z.cancel.current.operation"));
        this.buttonCancel.addActionListener(e -> this.cancelClicked(e));
        this.panelButton.add((Component)this.buttonCancel, "Center");
        this.hSpacer2.setPreferredSize(new Dimension(4, 10));
        this.hSpacer2.setMinimumSize(new Dimension(4, 10));
        this.hSpacer2.setMaximumSize(new Dimension(4, 10));
        this.panelButton.add((Component)this.hSpacer2, "East");
        this.hSpacer4.setMinimumSize(new Dimension(10, 3));
        this.hSpacer4.setMaximumSize(new Dimension(Short.MAX_VALUE, 3));
        this.hSpacer4.setPreferredSize(new Dimension(10, 3));
        this.panelButton.add((Component)this.hSpacer4, "South");
        contentPane.add((Component)this.panelButton, "East");
        this.panelProgress.setMaximumSize(new Dimension(Integer.MAX_VALUE, 49));
        this.panelProgress.setMinimumSize(new Dimension(Integer.MAX_VALUE, 49));
        this.panelProgress.setPreferredSize(new Dimension(Integer.MAX_VALUE, 49));
        this.panelProgress.setBorder(new EmptyBorder(0, 4, 4, 4));
        this.panelProgress.setAlignmentY(0.0f);
        this.panelProgress.setLayout(new BorderLayout(8, 4));
        this.progressBarFile.setForeground(Color.lightGray);
        this.progressBarFile.setPreferredSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBarFile.setMinimumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBarFile.setMaximumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBarFile.setMaximum(1000);
        this.progressBarFile.setFocusable(false);
        this.progressBarFile.setToolTipText(this.context.cfg.gs("NavTransferHandler.progressBarFile.toolTipText"));
        this.progressBarFile.setStringPainted(true);
        this.panelProgress.add((Component)this.progressBarFile, "North");
        this.progressBarTotal.setForeground(Color.lightGray);
        this.progressBarTotal.setPreferredSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBarTotal.setMinimumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBarTotal.setMaximumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBarTotal.setMaximum(1000);
        this.progressBarTotal.setFocusable(false);
        this.progressBarTotal.setStringPainted(true);
        this.progressBarTotal.setToolTipText(this.context.cfg.gs("NavTransferHandler.progressBarTotal.toolTipText"));
        this.panelProgress.add((Component)this.progressBarTotal, "Center");
        this.vSpacer3.setPreferredSize(new Dimension(10, 1));
        this.vSpacer3.setMinimumSize(new Dimension(10, 1));
        this.vSpacer3.setMaximumSize(new Dimension(10, 1));
        this.panelProgress.add((Component)this.vSpacer3, "South");
        contentPane.add((Component)this.panelProgress, "South");
        this.vSpacer5.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.vSpacer5.setMinimumSize(new Dimension(12, 2));
        this.vSpacer5.setPreferredSize(new Dimension(10, 2));
        contentPane.add((Component)this.vSpacer5, "North");
        this.pack();
    }
}

