/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.bookmarks;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.bookmarks.Bookmarks;
import com.corionis.els.gui.bookmarks.BookmarksTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarksUI
extends JDialog {
    Bookmarks bookmarks = null;
    Context context;
    private Logger logger = LogManager.getLogger("applog");
    BookmarksTableModel model;
    Bookmarks originals = null;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane;
    private JTable bookmarksTable;
    private JPanel buttonBar;
    private JPanel leftPanel;
    private JButton deleteButton;
    private JButton okButton;
    private JButton cancelButton;

    public BookmarksUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.bookmarks = context.navigator.bookmarks;
        this.originals = (Bookmarks)context.navigator.bookmarks.clone();
        this.bookmarks.sort();
        this.initComponents();
        this.model = new BookmarksTableModel(context, this.bookmarks);
        this.bookmarksTable.setModel(this.model);
        if (context.preferences.getBookmarksXpos() != -1 && Utils.isOnScreen(context.preferences.getBookmarksXpos(), context.preferences.getBookmarksYpos())) {
            this.setLocation(context.preferences.getBookmarksXpos(), context.preferences.getBookmarksYpos());
            Dimension dim = new Dimension(context.preferences.getBookmarksWidth(), context.preferences.getBookmarksHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookmarksUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BookmarksUI.this.windowClosing(e);
            }
        });
        this.setWidths();
        this.model.fireTableDataChanged();
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
        this.setButtons();
        this.setVisible(true);
        this.requestFocus();
    }

    private void actionCancelClicked(ActionEvent e) {
        this.bookmarks = this.originals;
        this.saveBookmarks();
        this.setVisible(false);
    }

    private void actionDeleteClicked(ActionEvent e) {
        int[] selected = this.bookmarksTable.getSelectedRows();
        if (selected != null && selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                int sel = selected[i];
                this.bookmarks.delete(sel);
            }
            this.model.fireTableDataChanged();
        }
    }

    private void actionSaveClicked(ActionEvent event) {
        this.saveBookmarks();
        this.savePreferences();
        this.setVisible(false);
    }

    private void saveBookmarks() {
        try {
            this.bookmarks.write();
            this.context.navigator.loadBookmarksMenu();
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("BookmarksUI.this.title"), 0);
        }
    }

    private void savePreferences() {
        this.context.preferences.setBookmarksHeight(this.getHeight());
        this.context.preferences.setBookmarksWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setBookmarksXpos(location.x);
        this.context.preferences.setBookmarksYpos(location.y);
        this.context.preferences.setBookmarksNameWidth(this.bookmarksTable.getColumnModel().getColumn(1).getWidth());
        this.context.preferences.setBookmarksPathWidth(this.bookmarksTable.getColumnModel().getColumn(2).getWidth());
    }

    public void setButtons() {
        int count = this.bookmarks.size();
        boolean enable = count > 0;
        this.deleteButton.setEnabled(enable);
    }

    private void setWidths() {
        this.bookmarksTable.getColumnModel().getColumn(0).setPreferredWidth(42);
        this.bookmarksTable.getColumnModel().getColumn(0).setWidth(42);
        this.bookmarksTable.getColumnModel().getColumn(0).setMaxWidth(42);
        this.bookmarksTable.getColumnModel().getColumn(0).setMinWidth(42);
        this.bookmarksTable.getColumnModel().getColumn(0).setResizable(false);
        this.bookmarksTable.getColumnModel().getColumn(1).setPreferredWidth(this.context.preferences.getBookmarksNameWidth());
        this.bookmarksTable.getColumnModel().getColumn(1).setWidth(this.context.preferences.getBookmarksNameWidth());
        this.bookmarksTable.getColumnModel().getColumn(2).setPreferredWidth(this.context.preferences.getBookmarksPathWidth());
        this.bookmarksTable.getColumnModel().getColumn(2).setWidth(this.context.preferences.getBookmarksPathWidth());
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.bookmarksTable = new JTable();
        this.buttonBar = new JPanel();
        this.leftPanel = new JPanel();
        this.deleteButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(this.context.cfg.gs("BookmarksUI.this.title"));
        this.setDefaultCloseOperation(0);
        this.setName("dialogBookmarks");
        this.setMinimumSize(new Dimension(150, 126));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.bookmarksTable.setAutoResizeMode(1);
        this.bookmarksTable.setFillsViewportHeight(true);
        this.bookmarksTable.setAutoCreateRowSorter(true);
        this.bookmarksTable.setShowVerticalLines(false);
        this.bookmarksTable.setShowHorizontalLines(false);
        this.scrollPane.setViewportView(this.bookmarksTable);
        this.contentPanel.add((Component)this.scrollPane, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.leftPanel.setLayout(new FlowLayout(0, 0, 0));
        this.deleteButton.setText(this.context.cfg.gs("BookmarksUI.deleteButton.text"));
        this.deleteButton.setToolTipText(this.context.cfg.gs("Navigator.menuTbDelete.toolTipText"));
        this.deleteButton.setMnemonic('D');
        this.deleteButton.addActionListener(e -> this.actionDeleteClicked(e));
        this.leftPanel.add(this.deleteButton);
        this.buttonBar.add((Component)this.leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.okButton.setText(this.context.cfg.gs("Z.save"));
        this.okButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.okButton.setMnemonic('S');
        this.okButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic('L');
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

