/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.bookmarks.Bookmark;
import com.corionis.els.gui.browser.BrowserTableModel;
import com.corionis.els.gui.browser.NavTransferHandler;
import com.corionis.els.gui.browser.NavTreeCellRenderer;
import com.corionis.els.gui.browser.NavTreeModel;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultRowSorter;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Browser {
    private static final int STYLE_COLLECTION_ALL = 0;
    private static final int STYLE_COLLECTION_AZ = 1;
    private static final int STYLE_COLLECTION_SOURCES = 2;
    private static final int STYLE_SYSTEM_ALL = 0;
    static boolean printPropertiesInUse = false;
    private static int styleOne = 0;
    private static int styleTwo = 0;
    private Context context;
    private boolean hintTrackingButtonEnabled = false;
    private boolean inRescan = false;
    private String keyBuffer = "";
    private long keyTime = 0L;
    public JComponent lastComponent = null;
    public int lastPanelNumber = 0;
    public int lastTabStopIndex = 0;
    int lastFocusedCollectionOne = 0;
    int lastFocusedCollectionTwo = 4;
    int lastFocusedSystemOne = 2;
    int lastFocusedSystemTwo = 6;
    private Logger logger = LogManager.getLogger("applog");
    private Stack<NavItem>[] navStack = new Stack[4];
    private int[] navStackIndex = new int[]{-1, -1, -1, -1};
    public NavTransferHandler navTransferHandler;
    private int tabStopIndex = 0;
    private int[] tabStops = new int[]{0, 1, 4, 5};

    public Browser(Context context) {
        this.context = context;
        this.context.browser = this;
        this.initialize();
    }

    private void addGeneraListeners(Component component) {
        MouseAdapter componentMouseListener = new MouseAdapter(){

            @Override
            public synchronized void mouseClicked(MouseEvent mouseEvent) {
                Browser.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
            }
        };
        component.addMouseListener(componentMouseListener);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                String name = "";
                int next = -1;
                Component active = focusEvent.getComponent();
                name = active.getName();
                if (name.length() > 0) {
                    switch (name) {
                        case "treeCollectionOne": {
                            next = 0;
                            Browser.this.lastTabStopIndex = 0;
                            Browser.this.lastFocusedCollectionOne = 0;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.treeCollectionOne;
                            Browser.this.tabStops[0] = 0;
                            Browser.this.tabStops[1] = 1;
                            break;
                        }
                        case "tableCollectionOne": {
                            next = 1;
                            Browser.this.lastTabStopIndex = 1;
                            Browser.this.lastFocusedCollectionOne = 1;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.tableCollectionOne;
                            Browser.this.tabStops[0] = 0;
                            Browser.this.tabStops[1] = 1;
                            break;
                        }
                        case "treeSystemOne": {
                            next = 2;
                            Browser.this.lastTabStopIndex = 0;
                            Browser.this.lastFocusedSystemOne = 2;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.treeSystemOne;
                            Browser.this.tabStops[0] = 2;
                            Browser.this.tabStops[1] = 3;
                            break;
                        }
                        case "tableSystemOne": {
                            next = 3;
                            Browser.this.lastTabStopIndex = 1;
                            Browser.this.lastFocusedSystemOne = 3;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.tableSystemOne;
                            Browser.this.tabStops[0] = 2;
                            Browser.this.tabStops[1] = 3;
                            break;
                        }
                        case "treeCollectionTwo": {
                            next = 4;
                            Browser.this.lastTabStopIndex = 2;
                            Browser.this.lastFocusedCollectionTwo = 4;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.treeCollectionTwo;
                            Browser.this.tabStops[2] = 4;
                            Browser.this.tabStops[3] = 5;
                            break;
                        }
                        case "tableCollectionTwo": {
                            next = 5;
                            Browser.this.lastTabStopIndex = 3;
                            Browser.this.lastFocusedCollectionTwo = 5;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.tableCollectionTwo;
                            Browser.this.tabStops[2] = 4;
                            Browser.this.tabStops[3] = 5;
                            break;
                        }
                        case "treeSystemTwo": {
                            next = 6;
                            Browser.this.lastTabStopIndex = 2;
                            Browser.this.lastFocusedSystemTwo = 6;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.treeSystemTwo;
                            Browser.this.tabStops[2] = 6;
                            Browser.this.tabStops[3] = 7;
                            break;
                        }
                        case "tableSystemTwo": {
                            next = 7;
                            Browser.this.lastTabStopIndex = 3;
                            Browser.this.lastFocusedSystemTwo = 7;
                            Browser.this.lastComponent = Browser.this.context.mainFrame.tableSystemTwo;
                            Browser.this.tabStops[2] = 6;
                            Browser.this.tabStops[3] = 7;
                        }
                    }
                    NavTreeUserObject tuo = Browser.this.getSelectedUserObject(active);
                    if (tuo != null && !Browser.this.context.fault) {
                        Browser.this.context.mainFrame.textFieldLocation.setText(tuo.getDisplayPath());
                        Browser.this.propertiesPrint(tuo);
                    }
                    Browser.this.selectPanelNumber(next);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        };
        component.addFocusListener(focusListener);
        component.setFocusTraversalKeysEnabled(false);
    }

    private void addHandlersToTable(JTable table) {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public synchronized void mouseClicked(MouseEvent mouseEvent) {
                JTable target = (JTable)mouseEvent.getSource();
                NavTreeNode node = ((BrowserTableModel)target.getModel()).getNode();
                target.requestFocus();
                JTree eventTree = null;
                switch (target.getName()) {
                    case "tableCollectionOne": {
                        eventTree = Browser.this.context.mainFrame.treeCollectionOne;
                        break;
                    }
                    case "tableSystemOne": {
                        eventTree = Browser.this.context.mainFrame.treeSystemOne;
                        break;
                    }
                    case "tableCollectionTwo": {
                        eventTree = Browser.this.context.mainFrame.treeCollectionTwo;
                        break;
                    }
                    case "tableSystemTwo": {
                        eventTree = Browser.this.context.mainFrame.treeSystemTwo;
                    }
                }
                int row = target.getSelectedRow();
                if (row >= 0) {
                    NavTreeUserObject tuo = (NavTreeUserObject)target.getValueAt(row, 1);
                    if (tuo != null) {
                        boolean doubleClick = mouseEvent.getClickCount() == 2;
                        Browser.this.context.mainFrame.textFieldLocation.setText(tuo.getDisplayPath());
                        Browser.this.propertiesPrint(tuo);
                        if (doubleClick) {
                            if (tuo.isDir) {
                                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                                node = tuo.node;
                                TreeSelectionEvent evt = new TreeSelectionEvent((Object)node, node.getTreePath(), true, null, null);
                                eventTree.setExpandsSelectedPaths(true);
                                eventTree.setSelectionPath(node.getTreePath());
                                eventTree.scrollPathToVisible(node.getTreePath());
                                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                            } else if (tuo.type == 6 && !tuo.isRemote) {
                                try {
                                    Desktop.getDesktop().open(tuo.file);
                                }
                                catch (Exception e) {
                                    JOptionPane.showMessageDialog(Browser.this.context.mainFrame, Browser.this.context.cfg.gs("Browser.error.launching.item"), Browser.this.context.cfg.getNavigatorName(), 0);
                                }
                            } else {
                                JOptionPane.showMessageDialog(Browser.this.context.mainFrame, Browser.this.context.cfg.gs("Browser.launch.of") + (tuo.isRemote ? Browser.this.context.cfg.gs("Z.remote.lowercase") : "") + Browser.this.context.cfg.gs("Browser.launch.of.items.not.supported"), Browser.this.context.cfg.getNavigatorName(), 1);
                            }
                        }
                    }
                } else {
                    eventTree.setExpandsSelectedPaths(true);
                    if (node != null) {
                        eventTree.setSelectionPath(node.getTreePath());
                        eventTree.scrollPathToVisible(node.getTreePath());
                    }
                }
            }
        };
        table.addMouseListener(tableMouseListener);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    JTree tree = null;
                    NavTreeUserObject tuo = null;
                    Object object = keyEvent.getSource();
                    if (object instanceof JTable) {
                        int[] rows = new int[]{0};
                        tree = Browser.this.navTransferHandler.getTargetTree((JTable)object);
                        rows = ((JTable)object).getSelectedRows();
                        if (rows.length <= 0) {
                            return;
                        }
                        tuo = (NavTreeUserObject)((JTable)object).getValueAt(rows[0], 1);
                        tuo.node.loadProperties();
                    }
                }
            }
        });
        table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        table.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        table.setTransferHandler(this.navTransferHandler);
    }

    private void addKeyListener() {
        KeyListener browserKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 113 && keyEvent.getModifiers() == 0) {
                    for (ActionListener listener : Browser.this.context.mainFrame.menuItemRename.getActionListeners()) {
                        listener.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, null));
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c;
                if (keyEvent.getKeyChar() != '\b' || (keyEvent.getModifiers() & 2) == 0) {
                    if (keyEvent.getKeyChar() == '\u0012' && (keyEvent.getModifiers() & 2) != 0) {
                        Browser.this.refreshByObject(keyEvent.getSource());
                    } else if (keyEvent.getKeyChar() == 'T' && (keyEvent.getModifiers() & 2) != 0) {
                        for (ActionListener listener : Browser.this.context.mainFrame.menuItemUpdates.getActionListeners()) {
                            listener.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, null));
                        }
                    } else if (keyEvent.getKeyChar() == '\t' && keyEvent.getModifiers() == 0) {
                        Browser.this.navTabKey(true);
                    } else if (keyEvent.getKeyChar() == '\t' && (keyEvent.getModifiers() & 1) != 0) {
                        Browser.this.navTabKey(false);
                    }
                }
                if ((keyEvent.getModifiers() & 8) != 0) {
                    int next = -1;
                    if (keyEvent.getKeyChar() == '1') {
                        next = Browser.this.lastFocusedCollectionOne;
                    }
                    if (keyEvent.getKeyChar() == '2') {
                        next = Browser.this.lastFocusedSystemOne;
                    }
                    if (keyEvent.getKeyChar() == '3') {
                        next = Browser.this.lastFocusedCollectionTwo;
                    }
                    if (keyEvent.getKeyChar() == '4') {
                        next = Browser.this.lastFocusedSystemTwo;
                    }
                    if (next >= 0) {
                        Browser.this.selectPanelNumber(next);
                    }
                } else if (keyEvent.getKeyChar() == '\n') {
                    JTree tree = null;
                    NavTreeUserObject tuo = null;
                    Object object = keyEvent.getSource();
                    if (!(object instanceof JTextField)) {
                        if (object instanceof JTree) {
                            tree = (JTree)object;
                            TreePath[] paths = tree.getSelectionPaths();
                            if (paths.length > 0) {
                                NavTreeNode ntn = (NavTreeNode)paths[0].getLastPathComponent();
                                tuo = ntn.getUserObject();
                            } else if (paths.length == 0) {
                                return;
                            }
                        } else if (object instanceof JTable) {
                            int[] rows = new int[]{0};
                            tree = Browser.this.navTransferHandler.getTargetTree((JTable)object);
                            rows = ((JTable)object).getSelectedRows();
                            if (rows.length > 0) {
                                tuo = (NavTreeUserObject)((JTable)object).getValueAt(rows[0], 1);
                            } else if (rows.length == 0) {
                                return;
                            }
                        }
                        if (tuo.isDir) {
                            tree.setExpandsSelectedPaths(true);
                            tree.expandPath(tuo.node.getTreePath());
                            tree.setSelectionPath(tuo.node.getTreePath());
                            tree.scrollPathToVisible(tuo.node.getTreePath());
                        } else if (tuo.type == 6 && !tuo.isRemote) {
                            try {
                                Desktop.getDesktop().open(tuo.file);
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(Browser.this.context.mainFrame, Browser.this.context.cfg.gs("Browser.error.launching.item"), Browser.this.context.cfg.getNavigatorName(), 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(Browser.this.context.mainFrame, Browser.this.context.cfg.gs("Browser.launch.of") + (tuo.isRemote ? Browser.this.context.cfg.gs("Z.remote.lowercase") : "") + Browser.this.context.cfg.gs("Browser.launch.of.items.not.supported"), Browser.this.context.cfg.getNavigatorName(), 1);
                        }
                    }
                } else if ((keyEvent.getModifiers() & 2) == 0 && (keyEvent.getModifiers() & 8) == 0 && (c = keyEvent.getKeyChar()) >= ' ' && c <= '\u007f' && keyEvent.getSource() instanceof JTable) {
                    JTable table = (JTable)keyEvent.getSource();
                    if (Browser.this.keyTime == 0L || keyEvent.getWhen() - Browser.this.keyTime > 2000L) {
                        Browser.this.keyBuffer = "";
                        Browser.this.keyTime = keyEvent.getWhen();
                    }
                    Browser.this.keyBuffer = Browser.this.keyBuffer + c;
                    int index = Browser.this.findRowIndex(table, Browser.this.keyBuffer);
                    if (index >= 0) {
                        table.setRowSelectionInterval(index, index);
                        table.scrollRectToVisible(new Rectangle(table.getCellRect(index, 0, true)));
                    }
                }
            }
        };
        this.context.mainFrame.treeCollectionOne.addKeyListener(browserKeyListener);
        this.context.mainFrame.tableCollectionOne.addKeyListener(browserKeyListener);
        this.context.mainFrame.treeSystemOne.addKeyListener(browserKeyListener);
        this.context.mainFrame.tableSystemOne.addKeyListener(browserKeyListener);
        this.context.mainFrame.treeCollectionTwo.addKeyListener(browserKeyListener);
        this.context.mainFrame.tableCollectionTwo.addKeyListener(browserKeyListener);
        this.context.mainFrame.treeSystemTwo.addKeyListener(browserKeyListener);
        this.context.mainFrame.tableSystemTwo.addKeyListener(browserKeyListener);
    }

    private void bookmarkCreate(NavTreeNode node, String name, String panelName) {
        Object obj;
        Repository repo = node.getUserObject().getRepo();
        if (repo != null && (name = (String)(obj = JOptionPane.showInputDialog(this.context.mainFrame, repo.getLibraryData().libraries.description + " " + this.context.cfg.gs("Browser.bookmark.name"), this.context.cfg.gs("Browser.add.bookmark"), 3, null, null, name))) != null && name.length() > 0) {
            Bookmark bm = new Bookmark();
            bm.name = name;
            bm.panel = panelName;
            TreePath tp = node.getTreePath();
            if (tp.getPathCount() > 0) {
                bm.pathElements = new String[tp.getPathCount()];
                Object[] objs = tp.getPath();
                for (int i = 0; i < tp.getPathCount(); ++i) {
                    node = (NavTreeNode)objs[i];
                    bm.pathElements[i] = node.getUserObject().name;
                }
                this.context.navigator.bookmarks.add(bm);
                try {
                    this.context.navigator.bookmarks.write();
                    this.context.navigator.loadBookmarksMenu();
                }
                catch (Exception e) {
                    this.logger.error(Utils.getStackTrace(e));
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.error.saving.bookmarks") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                }
            }
        }
    }

    public Bookmark bookmarkCreate(Item item, String name, boolean isPublisher) {
        String[] split;
        Bookmark bm = new Bookmark();
        bm.name = name;
        bm.panel = isPublisher ? "tableCollectionOne" : "tableCollectionTwo";
        Repository repo = isPublisher ? this.context.publisherRepo : this.context.subscriberRepo;
        String sep = Utils.getSeparatorFromPath(item.getFullPath());
        if (sep.equals("\\")) {
            sep = "\\\\";
        }
        if ((split = item.getItemPath().split(sep)) != null && split.length > 0) {
            bm.pathElements = new String[split.length + 2];
            bm.pathElements[0] = repo.getLibraryData().libraries.description;
            bm.pathElements[1] = item.getLibrary();
            for (int i = 0; i < split.length; ++i) {
                bm.pathElements[i + 2] = split[i];
            }
        }
        return bm;
    }

    public Bookmark bookmarkCreate(String bookmarkName, JTree tree, String repoName, String libraryName, String[] pathElements) {
        Bookmark bm = new Bookmark();
        bm.name = bookmarkName;
        NavTreeNode node = (NavTreeNode)tree.getModel().getRoot();
        bm.panel = node.getMyTree().getName();
        bm.pathElements = new String[pathElements.length + 2];
        bm.pathElements[0] = repoName;
        bm.pathElements[1] = libraryName;
        for (int i = 0; i < pathElements.length; ++i) {
            bm.pathElements[i + 2] = pathElements[i];
        }
        return bm;
    }

    public void bookmarkGoto(Bookmark bookmark) {
        String panelName = bookmark.panel.toLowerCase();
        JTree tree = panelName.endsWith("one") ? (panelName.contains("collection") ? this.context.mainFrame.treeCollectionOne : this.context.mainFrame.treeSystemOne) : (panelName.contains("collection") ? this.context.mainFrame.treeCollectionTwo : this.context.mainFrame.treeSystemTwo);
        NavTreeNode node = (NavTreeNode)tree.getModel().getRoot();
        if (node.getUserObject().name.equals(bookmark.pathElements[0])) {
            this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
            int panelNo = this.context.browser.getPanelNumber(bookmark.panel);
            this.context.browser.selectPanelNumber(panelNo);
            TreePath tp = this.scanTreePath(panelName, bookmark.pathElements, true, false, false);
            if (tp == null) {
                String pe = Utils.concatStringArray(bookmark.pathElements, "/");
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.bookmark.location.not.found") + pe, this.context.cfg.gs("Navigator.menu.Bookmarks.text"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.context.mainFrame, MessageFormat.format(this.context.cfg.gs("Browser.library.is.not.loaded"), bookmark.pathElements[0]), this.context.cfg.gs("Navigator.menu.Bookmarks.text"), 2);
        }
    }

    public void bookmarkSelected(JTable sourceTable) {
        int[] rows = sourceTable.getSelectedRows();
        if (rows != null && rows.length != 1) {
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.please.select.a.single.item.to.bookmark"), this.context.cfg.gs("Browser.add.bookmark"), 2);
            return;
        }
        NavTreeUserObject tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[0], 1);
        NavTreeNode node = tuo.node;
        String name = tuo.name;
        this.bookmarkCreate(node, name, sourceTable.getName());
    }

    public void bookmarkSelected(JTree sourceTree) {
        TreePath[] paths = sourceTree.getSelectionPaths();
        if (paths != null && paths.length != 1 || paths == null) {
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.please.select.a.single.item.to.bookmark"), this.context.cfg.gs("Browser.add.bookmark"), 2);
            return;
        }
        NavTreeNode node = (NavTreeNode)sourceTree.getLastSelectedPathComponent();
        String name = node.getUserObject().name;
        this.bookmarkCreate(node, name, sourceTree.getName());
    }

    public static ArrayList<TreePath> compressTreePaths(ArrayList<TreePath> list) {
        ArrayList<TreePath> compressedList = new ArrayList<TreePath>();
        for (int i = 0; i < list.size(); ++i) {
            TreePath tp1 = list.get(i);
            if (list.size() > i + 1) {
                TreePath tp2 = list.get(i + 1);
                String[] sa1 = Utils.getTreePathStringArray(tp1);
                String[] sa2 = Utils.getTreePathStringArray(tp2);
                int max = Integer.min(sa1.length, sa2.length);
                boolean match = true;
                for (int j = 0; j < max; ++j) {
                    if (sa1[j].compareTo(sa2[j]) == 0) continue;
                    match = false;
                    break;
                }
                if (match) continue;
                compressedList.add(tp1);
                continue;
            }
            compressedList.add(tp1);
        }
        return compressedList;
    }

    public void deepScanCollectionTree(JTree tree, Repository repo, boolean remote, boolean recursive) {
        if (!this.context.fault) {
            try {
                NavTreeNode root = this.setCollectionRoot(repo, tree, repo.getLibraryData().libraries.description, remote);
                if (repo.getLibraryData().libraries.bibliography != null) {
                    Arrays.sort(repo.getLibraryData().libraries.bibliography);
                    switch (styleOne) {
                        case 0: {
                            this.styleCollection(tree, repo, remote, true, recursive);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    ((NavTreeModel)tree.getModel()).reload();
                    root.loadTable();
                }
            }
            catch (Exception e) {
                this.logger.error(Utils.getStackTrace(e));
                this.context.fault = true;
            }
        }
    }

    public void deepScanSystemTree(JTree tree, Repository repo, boolean remote, boolean recursive) {
        if (!this.context.fault) {
            try {
                NavTreeNode root = null;
                switch (styleTwo) {
                    case 0: {
                        root = this.styleComputer(tree, repo, remote, true, recursive);
                        if (this.context.fault) break;
                        this.styleHome(tree, repo, remote, true, recursive);
                        break;
                    }
                }
                ((NavTreeModel)tree.getModel()).reload();
                root.loadTable();
            }
            catch (Exception e) {
                this.logger.error(Utils.getStackTrace(e));
                this.context.fault = true;
            }
        }
    }

    public void deleteSelected(JTable sourceTable) {
        int row = sourceTable.getSelectedRow();
        if (row > -1) {
            NavTreeUserObject tuo;
            int i;
            int dirCount = 0;
            int fileCount = 0;
            boolean isRemote = false;
            long size = 0L;
            int[] rows = sourceTable.getSelectedRows();
            for (i = 0; i < rows.length; ++i) {
                tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[i], 1);
                if (tuo.type != 6) {
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.menu.Delete.cannot") + tuo.name, this.context.cfg.getNavigatorName(), 2);
                    return;
                }
                isRemote = tuo.isRemote;
                if (tuo.isDir) {
                    ++dirCount;
                    tuo.node.deepScanChildren(true);
                    fileCount += tuo.node.deepGetFileCount();
                    size += tuo.node.deepGetFileSize();
                    continue;
                }
                ++fileCount;
                size += tuo.size;
            }
            for (i = 0; i < rows.length; ++i) {
                tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[i], 1);
                if (!this.context.navigator.checkForConflicts(tuo, this.context.cfg.gs("HintsUI.action.delete"))) continue;
                return;
            }
            boolean error = false;
            int reply = 0;
            if (this.context.preferences.isShowDeleteConfirmation()) {
                Object msg = MessageFormat.format(this.context.cfg.gs("Navigator.menu.Delete.are.you.sure1"), rows.length, isRemote ? 0 : 1, rows.length > 1 ? 0 : 1, fileCount, fileCount > 1 ? 0 : 1, Utils.formatLong(size, false, this.context.cfg.getLongScale()));
                msg = (String)msg + (dirCount > 0 ? MessageFormat.format(this.context.cfg.gs("Navigator.menu.Delete.are.you.sure2"), dirCount > 1 ? 0 : 1) : "");
                msg = (String)msg + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : "");
                reply = JOptionPane.showConfirmDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
            if (reply == 0) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    NavTreeUserObject tuo2 = (NavTreeUserObject)sourceTable.getValueAt(rows[i2], 1);
                    if (tuo2.type == 6) {
                        if (tuo2.isDir) {
                            if (this.navTransferHandler.removeDirectory(tuo2)) {
                                error = true;
                                break;
                            }
                        } else if (this.navTransferHandler.removeFile(tuo2)) {
                            error = true;
                            break;
                        }
                        if (error) continue;
                        try {
                            this.navTransferHandler.exportHint("rm", tuo2, null);
                        }
                        catch (Exception e) {
                            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                            this.logger.error(Utils.getStackTrace(e));
                            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.error.writing.hint") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                        }
                        continue;
                    }
                    this.logger.info(this.context.cfg.gs("Browser.skipping") + tuo2.name);
                }
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                if (!error) {
                    NavTreeNode parent = null;
                    BrowserTableModel btm = null;
                    JTable theTable = null;
                    int firstRow = -1;
                    for (int i3 = rows.length - 1; i3 > -1; --i3) {
                        NavTreeUserObject tuo3 = (NavTreeUserObject)sourceTable.getValueAt(rows[i3], 1);
                        if (tuo3.type != 6) continue;
                        if (firstRow == -1) {
                            theTable = tuo3.node.getMyTable();
                            firstRow = rows[i3] - 1;
                        }
                        parent = (NavTreeNode)tuo3.node.getParent();
                        btm = (BrowserTableModel)parent.getMyTable().getModel();
                        btm.setNode(parent);
                        parent.remove(tuo3.node);
                        btm.fireTableRowsDeleted(rows[i3], rows[i3]);
                    }
                    if (parent != null) {
                        this.refreshTree(parent.getMyTree());
                        if (btm.getRowCount() > 0) {
                            if (btm.getRowCount() - 1 < firstRow) {
                                firstRow = btm.getRowCount() - 1;
                            }
                            if (firstRow < btm.getRowCount()) {
                                theTable.setRowSelectionInterval(firstRow, firstRow);
                            } else {
                                parent.selectMe();
                            }
                        } else {
                            parent.selectMe();
                        }
                    }
                }
            }
        }
    }

    public void deleteSelected(JTree sourceTree) {
        int row = sourceTree.getLeadSelectionRow();
        if (row > -1) {
            NavTreeUserObject tuo;
            NavTreeNode ntn;
            TreePath[] paths;
            int dirCount = 0;
            int fileCount = 0;
            boolean isRemote = false;
            long size = 0L;
            for (TreePath path : paths = sourceTree.getSelectionPaths()) {
                ntn = (NavTreeNode)path.getLastPathComponent();
                tuo = ntn.getUserObject();
                if (tuo.type != 6) {
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.menu.Delete.cannot") + tuo.name, this.context.cfg.getNavigatorName(), 2);
                    return;
                }
                isRemote = tuo.isRemote;
                if (tuo.isDir) {
                    ++dirCount;
                    tuo.node.deepScanChildren(true);
                    fileCount += tuo.node.deepGetFileCount();
                    size += tuo.node.deepGetFileSize();
                    continue;
                }
                ++fileCount;
                size += tuo.size;
            }
            for (TreePath path : paths) {
                ntn = (NavTreeNode)path.getLastPathComponent();
                tuo = ntn.getUserObject();
                if (!this.context.navigator.checkForConflicts(tuo, this.context.cfg.gs("HintsUI.action.delete"))) continue;
                return;
            }
            int reply = 0;
            if (this.context.preferences.isShowDeleteConfirmation()) {
                Object msg = MessageFormat.format(this.context.cfg.gs("Navigator.menu.Delete.are.you.sure1"), paths.length, isRemote ? 0 : 1, paths.length > 1 ? 0 : 1, fileCount, fileCount > 1 ? 0 : 1, Utils.formatLong(size, false, this.context.cfg.getLongScale()));
                msg = (String)msg + (dirCount > 0 ? MessageFormat.format(this.context.cfg.gs("Navigator.menu.Delete.are.you.sure2"), dirCount > 1 ? 0 : 1) : "");
                msg = (String)msg + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : "");
                reply = JOptionPane.showConfirmDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
            boolean error = false;
            if (reply == 0) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                for (TreePath path : paths) {
                    NavTreeNode ntn2 = (NavTreeNode)path.getLastPathComponent();
                    NavTreeUserObject tuo2 = ntn2.getUserObject();
                    if (tuo2.type == 6) {
                        if (tuo2.isDir) {
                            if (this.navTransferHandler.removeDirectory(tuo2)) {
                                error = true;
                                break;
                            }
                        } else if (this.navTransferHandler.removeFile(tuo2)) {
                            error = true;
                            break;
                        }
                        if (error) continue;
                        try {
                            this.navTransferHandler.exportHint("rm", tuo2, null);
                        }
                        catch (Exception e) {
                            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                            this.logger.error(Utils.getStackTrace(e));
                            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.error.writing.hint") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                        }
                        continue;
                    }
                    this.logger.info(this.context.cfg.gs("Browser.skipping") + tuo2.name);
                }
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                if (!error) {
                    NavTreeNode parent = null;
                    BrowserTableModel btm = null;
                    int firstRow = -1;
                    for (int i = paths.length - 1; i > -1; --i) {
                        TreePath path = paths[i];
                        NavTreeNode ntn3 = (NavTreeNode)path.getLastPathComponent();
                        NavTreeUserObject tuo3 = ntn3.getUserObject();
                        if (tuo3.type != 6) continue;
                        parent = (NavTreeNode)tuo3.node.getParent();
                        if (firstRow == -1) {
                            firstRow = tuo3.node.getParent().getIndex(tuo3.node);
                        }
                        btm = (BrowserTableModel)parent.getMyTable().getModel();
                        btm.setNode(parent);
                        parent.remove(tuo3.node);
                    }
                    if (parent != null) {
                        this.refreshTree(parent.getMyTree());
                        if (parent.getChildCount() > 0) {
                            if (parent.getChildCount() - 1 < firstRow) {
                                firstRow = parent.getChildCount() - 1;
                            }
                            if (firstRow < parent.getChildCount()) {
                                ((NavTreeNode)parent.getChildAt(firstRow)).selectMe();
                            } else {
                                parent.selectMe();
                            }
                        } else {
                            parent.selectMe();
                        }
                    }
                }
            }
        }
    }

    public int findRowIndex(JTable table, String name) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            NavTreeUserObject rowTuo = (NavTreeUserObject)table.getValueAt(i, 1);
            if (!rowTuo.name.toLowerCase().startsWith(name.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public int findRowIndex(JTable table, NavTreeUserObject tuo) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            NavTreeUserObject rowTuo = (NavTreeUserObject)table.getValueAt(i, 1);
            if (!rowTuo.path.equals(tuo.path)) continue;
            return i;
        }
        return -1;
    }

    private int getActiveNavStack(Component comp) {
        int active = -1;
        if (comp == null) {
            comp = this.lastComponent;
        }
        if (comp != null) {
            if (comp.getName().endsWith("CollectionOne")) {
                active = 0;
            } else if (comp.getName().endsWith("SystemOne")) {
                active = 1;
            } else if (comp.getName().endsWith("CollectionTwo")) {
                active = 2;
            } else if (comp.getName().endsWith("SystemTwo")) {
                active = 3;
            }
        }
        assert (active > -1);
        return active;
    }

    public ArrayList<TreePath> getCombinedTreePaths(JTree sourceTree) {
        TreePath rootPath = ((NavTreeNode)sourceTree.getModel().getRoot()).getTreePath();
        Enumeration<TreePath> expandedDescendants = sourceTree.getExpandedDescendants(rootPath);
        TreePath[] treePaths = sourceTree.getSelectionPaths();
        ArrayList<TreePath> combinedPaths = new ArrayList<TreePath>();
        if (expandedDescendants != null) {
            while (expandedDescendants.hasMoreElements()) {
                TreePath tp = expandedDescendants.nextElement();
                combinedPaths.add(tp);
            }
        }
        if (treePaths != null && treePaths.length > 0) {
            for (TreePath tp : treePaths) {
                NavTreeNode ntn = (NavTreeNode)tp.getLastPathComponent();
                int type = ntn.getUserObject().type;
                if (!ntn.getUserObject().isDir || type == 1 || type == 7) continue;
                boolean duplicate = false;
                for (TreePath combined : combinedPaths) {
                    if (Utils.compareTreePaths(tp, combined) != 0) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                combinedPaths.add(tp);
            }
        }
        if (combinedPaths.size() > 0) {
            combinedPaths.sort(new Comparator<TreePath>(this){

                @Override
                public int compare(TreePath tp1, TreePath tp2) {
                    return Utils.compareTreePaths(tp1, tp2);
                }
            });
            combinedPaths = Browser.compressTreePaths(combinedPaths);
        }
        return combinedPaths;
    }

    public long getFreespace(NavTreeUserObject tuo) throws Exception {
        return this.getFreespace(tuo.path, tuo.isRemote);
    }

    public long getFreespace(String path, boolean isRemote) throws Exception {
        long space = 0L;
        if (isRemote && this.context.cfg.isRemoteOperation()) {
            try {
                space = this.context.clientStty.availableSpace(this.context.cfg.getFullPathSubscriber(path));
            }
            catch (Exception e) {
                if (e instanceof SocketException && e.toString().contains("broken pipe")) {
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.connection.lost"), this.context.cfg.getNavigatorName(), 0);
                } else {
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.exception") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                }
                throw e;
            }
        } else {
            space = Utils.availableSpace(Utils.getFullPathLocal(path));
        }
        return space;
    }

    public int getPanelNumber(String name) {
        int panelNo = -1;
        if (name.length() > 0) {
            switch (name = name.toLowerCase()) {
                case "treecollectionone": {
                    panelNo = 0;
                    break;
                }
                case "tablecollectionone": {
                    panelNo = 1;
                    break;
                }
                case "treesystemone": {
                    panelNo = 2;
                    break;
                }
                case "tablesystemone": {
                    panelNo = 3;
                    break;
                }
                case "treecollectiontwo": {
                    panelNo = 4;
                    break;
                }
                case "tablecollectiontwo": {
                    panelNo = 5;
                    break;
                }
                case "treesystemtwo": {
                    panelNo = 6;
                    break;
                }
                case "tablesystemtwo": {
                    panelNo = 7;
                }
            }
        }
        return panelNo;
    }

    public NavTreeUserObject getSelectedUserObject(Object object) {
        int[] rows = new int[]{0};
        JTree tree = null;
        NavTreeUserObject tuo = null;
        if (object instanceof JTable) {
            tree = this.navTransferHandler.getTargetTree((JTable)object);
            rows = ((JTable)object).getSelectedRows();
            if (rows.length > 0) {
                tuo = (NavTreeUserObject)((JTable)object).getValueAt(rows[0], 1);
            }
        }
        if (object instanceof JTree || tree != null && tuo == null) {
            TreePath[] paths;
            if (tree == null) {
                tree = (JTree)object;
            }
            if ((paths = tree.getSelectionPaths()) != null && paths.length > 0) {
                NavTreeNode ntn = (NavTreeNode)paths[0].getLastPathComponent();
                tuo = ntn.getUserObject();
            }
        }
        return tuo;
    }

    public JComponent getTabComponent(int index) {
        JComponent nextComponent = null;
        switch (index) {
            case 0: {
                nextComponent = this.context.mainFrame.treeCollectionOne;
                break;
            }
            case 1: {
                nextComponent = this.context.mainFrame.tableCollectionOne;
                break;
            }
            case 2: {
                nextComponent = this.context.mainFrame.treeSystemOne;
                break;
            }
            case 3: {
                nextComponent = this.context.mainFrame.tableSystemOne;
                break;
            }
            case 4: {
                nextComponent = this.context.mainFrame.treeCollectionTwo;
                break;
            }
            case 5: {
                nextComponent = this.context.mainFrame.tableCollectionTwo;
                break;
            }
            case 6: {
                nextComponent = this.context.mainFrame.treeSystemTwo;
                break;
            }
            case 7: {
                nextComponent = this.context.mainFrame.tableSystemTwo;
            }
        }
        assert (nextComponent != null);
        return nextComponent;
    }

    private boolean initialize() {
        this.navTransferHandler = new NavTransferHandler(this.context);
        for (int i = 0; i < this.navStack.length; ++i) {
            this.navStack[i] = new Stack();
        }
        this.initializeToolbar();
        this.initializeNavigation();
        this.initializeBrowserOne();
        this.initializeBrowserTwo();
        this.addKeyListener();
        if (Toolkit.getDefaultToolkit().areExtraMouseButtonsEnabled() && MouseInfo.getNumberOfButtons() > 3) {
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                if (this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0 && event instanceof MouseEvent && MouseInfo.getNumberOfButtons() > 3) {
                    int base;
                    MouseEvent mouseEvent = (MouseEvent)event;
                    int n = base = MouseInfo.getNumberOfButtons() > 5 ? 6 : 4;
                    if (mouseEvent.getID() == 502) {
                        if (mouseEvent.getButton() == base) {
                            this.navBack();
                        } else if (mouseEvent.getButton() == base + 1) {
                            this.navForward();
                        }
                    }
                }
            }, 16L);
        }
        this.context.mainFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                Browser.this.context.preferences.fixBrowserDivider(Browser.this.context, -1);
            }
        });
        this.context.mainFrame.tabbedPaneNavigatorBottom.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                Browser.this.context.preferences.setBrowserBottomSize(componentEvent.getComponent().getHeight());
            }
        });
        this.context.mainFrame.tabbedPaneNavigatorBottom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Browser.this.context.mainFrame.tabbedPaneNavigatorBottom.getSelectedIndex() == 1) {
                    NavTreeNode node;
                    JComponent object = Browser.this.lastComponent;
                    JTree tree = null;
                    if (object instanceof JTree) {
                        tree = (JTree)object;
                    } else if (object instanceof JTable) {
                        tree = Browser.this.navTransferHandler.getTargetTree((JTable)object);
                    }
                    if (tree != null && (node = (NavTreeNode)tree.getLastSelectedPathComponent()) != null) {
                        Browser.this.propertiesPrint(node.getUserObject());
                    }
                }
            }
        });
        this.initializeStatus(this.context.mainFrame.treeCollectionTwo);
        this.initializeStatus(this.context.mainFrame.treeCollectionOne);
        return true;
    }

    private void initializeBrowserOne() {
        this.context.mainFrame.tabbedPaneBrowserOne.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTabbedPane pane = (JTabbedPane)mouseEvent.getSource();
                int index = pane.getSelectedIndex();
                Browser.this.selectTabOne(index);
            }
        });
        this.context.mainFrame.tabbedPaneBrowserOne.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane pane = (JTabbedPane)changeEvent.getSource();
                int index = pane.getSelectedIndex();
                Browser.this.selectTabOne(index);
            }
        });
        this.context.mainFrame.treeCollectionOne.setName("treeCollectionOne");
        if (this.context.publisherRepo != null && this.context.publisherRepo.isInitialized() && !this.context.cfg.isLoggerView()) {
            this.loadCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false);
        } else {
            this.setCollectionRoot(null, this.context.mainFrame.treeCollectionOne, this.context.cfg.gs("Browser.open.a.publisher"), false);
        }
        this.context.mainFrame.treeCollectionOne.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                if (!Browser.this.inRescan) {
                    TreePath treePath = treeExpansionEvent.getPath();
                    NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                    Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                    node.loadChildren(true);
                    Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.context.mainFrame.treeCollectionOne.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (Browser.this.context.preferences.isLastPublisherIsOpen()) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                    Browser.this.navStackPush(node);
                    if (!node.isLoaded()) {
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        node.loadChildren(true);
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        if (node.getChildCount() > 3000) {
                            Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        }
                        node.loadTable();
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    Browser.this.propertiesClear();
                }
            }
        });
        this.context.mainFrame.treeCollectionOne.setTransferHandler(this.navTransferHandler);
        this.addGeneraListeners(this.context.mainFrame.treeCollectionOne);
        this.addHandlersToTable(this.context.mainFrame.tableCollectionOne);
        this.addGeneraListeners(this.context.mainFrame.tableCollectionOne);
        ToolTipManager.sharedInstance().registerComponent(this.context.mainFrame.treeCollectionOne);
        this.context.mainFrame.treeSystemOne.setName("treeSystemOne");
        if (this.context.publisherRepo != null && this.context.publisherRepo.isInitialized() && !this.context.cfg.isLoggerView()) {
            this.loadSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false);
        } else {
            this.setCollectionRoot(null, this.context.mainFrame.treeSystemOne, this.context.cfg.gs("Browser.open.a.publisher"), false);
        }
        this.context.mainFrame.treeSystemOne.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                node.loadChildren(true);
                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.context.mainFrame.treeSystemOne.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (Browser.this.context.preferences.isLastPublisherIsOpen()) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                    Browser.this.navStackPush(node);
                    if (!node.isLoaded()) {
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        node.loadChildren(true);
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                    } else {
                        if (node.getChildCount() > 3000) {
                            Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        }
                        node.loadTable();
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    Browser.this.propertiesClear();
                }
            }
        });
        this.context.mainFrame.treeSystemOne.setTransferHandler(this.navTransferHandler);
        this.addGeneraListeners(this.context.mainFrame.treeSystemOne);
        this.addHandlersToTable(this.context.mainFrame.tableSystemOne);
        this.addGeneraListeners(this.context.mainFrame.tableSystemOne);
        ToolTipManager.sharedInstance().registerComponent(this.context.mainFrame.treeSystemOne);
    }

    private void initializeBrowserTwo() {
        this.context.mainFrame.tabbedPaneBrowserTwo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTabbedPane pane = (JTabbedPane)mouseEvent.getSource();
                int index = pane.getSelectedIndex();
                Browser.this.selectTabTwo(index);
            }
        });
        this.context.mainFrame.tabbedPaneBrowserTwo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane pane = (JTabbedPane)changeEvent.getSource();
                int index = pane.getSelectedIndex();
                Browser.this.selectTabTwo(index);
            }
        });
        this.context.mainFrame.treeCollectionTwo.setName("treeCollectionTwo");
        if (this.context.subscriberRepo != null && this.context.subscriberRepo.isInitialized() && !this.context.cfg.isLoggerView()) {
            this.loadCollectionTree(this.context.mainFrame.treeCollectionTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation());
        } else {
            this.setCollectionRoot(null, this.context.mainFrame.treeCollectionTwo, this.context.cfg.gs("Browser.open.a.subscriber"), this.context.cfg.isRemoteOperation());
        }
        this.context.mainFrame.treeCollectionTwo.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                node.loadChildren(true);
                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.context.mainFrame.treeCollectionTwo.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (Browser.this.context.preferences.isLastSubscriberIsOpen()) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                    Browser.this.navStackPush(node);
                    if (!node.isLoaded()) {
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        node.loadChildren(true);
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        if (node.getChildCount() > 3000) {
                            Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        }
                        node.loadTable();
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    Browser.this.propertiesClear();
                }
            }
        });
        this.context.mainFrame.treeCollectionTwo.setTransferHandler(this.navTransferHandler);
        this.addGeneraListeners(this.context.mainFrame.treeCollectionTwo);
        this.addHandlersToTable(this.context.mainFrame.tableCollectionTwo);
        this.addGeneraListeners(this.context.mainFrame.tableCollectionTwo);
        ToolTipManager.sharedInstance().registerComponent(this.context.mainFrame.treeCollectionTwo);
        this.context.mainFrame.treeSystemTwo.setName("treeSystemTwo");
        if (this.context.subscriberRepo != null && this.context.subscriberRepo.isInitialized() && !this.context.cfg.isLoggerView()) {
            this.loadSystemTree(this.context.mainFrame.treeSystemTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation());
        } else {
            this.setCollectionRoot(null, this.context.mainFrame.treeSystemTwo, this.context.cfg.gs("Browser.open.a.subscriber"), this.context.cfg.isRemoteOperation());
        }
        this.context.mainFrame.treeSystemTwo.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                node.loadChildren(true);
                Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.context.mainFrame.treeSystemTwo.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (Browser.this.context.preferences.isLastSubscriberIsOpen()) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    NavTreeNode node = (NavTreeNode)treePath.getLastPathComponent();
                    Browser.this.navStackPush(node);
                    if (!node.isLoaded()) {
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        node.loadChildren(true);
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        if (node.getChildCount() > 3000) {
                            Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        }
                        node.loadTable();
                        Browser.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    Browser.this.propertiesClear();
                }
            }
        });
        this.context.mainFrame.treeSystemTwo.setTransferHandler(this.navTransferHandler);
        this.addGeneraListeners(this.context.mainFrame.treeSystemTwo);
        this.addHandlersToTable(this.context.mainFrame.tableSystemTwo);
        this.addGeneraListeners(this.context.mainFrame.tableSystemTwo);
        ToolTipManager.sharedInstance().registerComponent(this.context.mainFrame.treeSystemTwo);
    }

    private void initializeNavigation() {
        this.context.mainFrame.buttonBack.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.navBack();
            }
        });
        this.context.mainFrame.buttonForward.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.navForward();
            }
        });
        this.context.mainFrame.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.navUp();
            }
        });
    }

    private void initializeStatus(JTree tree) {
        if (tree != null) {
            NavTreeModel model = (NavTreeModel)tree.getModel();
            NavTreeNode root = (NavTreeNode)model.getRoot();
            root.loadProperties();
            root.selectMe();
        }
    }

    private void initializeToolbar() {
        this.context.mainFrame.buttonHintTracking.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equalsIgnoreCase("hints")) {
                    Browser.this.toggleHintTracking(!Browser.this.hintTrackingButtonEnabled);
                }
            }
        });
        this.setupHintTrackingButton();
    }

    public boolean isHintTrackingButtonEnabled() {
        return this.hintTrackingButtonEnabled;
    }

    public void loadCollectionTree(JTree tree, Repository repo, boolean remote) {
        try {
            NavTreeNode root = this.setCollectionRoot(repo, tree, repo.getLibraryData().libraries.description, remote);
            if (repo.getLibraryData().libraries.bibliography != null) {
                Arrays.sort(repo.getLibraryData().libraries.bibliography);
                switch (styleOne) {
                    case 0: {
                        this.styleCollection(tree, repo, remote, false, false);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                ((NavTreeModel)tree.getModel()).reload();
                root.loadTable();
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            this.context.fault = true;
        }
    }

    public void loadSystemTree(JTree tree, Repository repo, boolean remote) {
        try {
            NavTreeNode root = null;
            switch (styleTwo) {
                case 0: {
                    root = this.styleComputer(tree, repo, remote, false, false);
                    this.styleHome(tree, repo, remote, false, false);
                    break;
                }
            }
            ((NavTreeModel)tree.getModel()).reload();
            root.loadTable();
            root.selectMe();
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            this.context.fault = true;
        }
    }

    private void navBack() {
        NavItem ni = this.navStackPop();
        if (ni != null && ni.node != null) {
            ni.node.selectMyTab();
            ni.node.selectMe();
            ni.component.requestFocus();
        }
    }

    private void navForward() {
        int ans = this.getActiveNavStack(null);
        if (this.navStackIndex[ans] + 1 <= this.navStack[ans].lastIndexOf(this.navStack[ans].lastElement())) {
            int n = ans;
            this.navStackIndex[n] = this.navStackIndex[n] + 1;
        }
        NavItem ni = (NavItem)this.navStack[ans].get(this.navStackIndex[ans]);
        if (ni.node != null) {
            ni.node.selectMyTab();
            ni.node.selectMe();
            ni.component.requestFocus();
        }
    }

    private NavItem navStackPop() {
        NavItem ni;
        int ans = this.getActiveNavStack(null);
        if (this.navStackIndex[ans] > 0) {
            int n = ans;
            this.navStackIndex[n] = this.navStackIndex[n] - 1;
            ni = (NavItem)this.navStack[ans].get(this.navStackIndex[ans]);
        } else {
            ni = this.navStackIndex[ans] > -1 ? (NavItem)this.navStack[ans].get(0) : null;
        }
        return ni;
    }

    private void navStackPush(NavTreeNode node) {
        int ans = this.getActiveNavStack(node.getMyTree());
        if (this.navStackIndex[ans] < 0 || ((NavItem)this.navStack[ans].get((int)this.navStackIndex[ans])).node != node) {
            if (this.navStackIndex[ans] > -1) {
                this.navStack[ans].setSize(this.navStackIndex[ans] + 1);
            }
            NavItem ni = new NavItem(this, node, this.lastComponent);
            this.navStack[ans].push(ni);
            int n = ans;
            this.navStackIndex[n] = this.navStackIndex[n] + 1;
        }
    }

    private void navTabKey(boolean forward) {
        JComponent nextComponent = null;
        this.tabStopIndex = this.lastTabStopIndex;
        if (forward) {
            ++this.tabStopIndex;
            if (this.tabStopIndex >= this.tabStops.length) {
                this.tabStopIndex = 0;
            }
        } else {
            --this.tabStopIndex;
            if (this.tabStopIndex < 0) {
                this.tabStopIndex = this.tabStops.length - 1;
            }
        }
        int next = this.tabStops[this.tabStopIndex];
        nextComponent = this.getTabComponent(next);
        nextComponent.requestFocus();
    }

    private void navUp() {
        int ans = this.getActiveNavStack(null);
        NavItem ni = (NavItem)this.navStack[ans].get(this.navStackIndex[ans]);
        NavTreeNode node = (NavTreeNode)ni.node.getParent();
        if (node != null) {
            node.selectMyTab();
            node.selectMe();
            this.lastComponent = this.lastComponent;
            this.lastComponent.requestFocus();
            this.navStackPush(node);
        }
    }

    public void propertiesClear() {
        this.context.mainFrame.textAreaProperties.setText("");
    }

    public void propertiesPrint(NavTreeUserObject tuo) {
        if (tuo == null || tuo.node == null || !tuo.node.isLoaded() || this.context.mainFrame.tabbedPaneNavigatorBottom.getSelectedIndex() != 1) {
            return;
        }
        if (!printPropertiesInUse) {
            printPropertiesInUse = true;
            this.context.mainFrame.textAreaProperties.setText("");
            Object msg = "<html>";
            msg = (String)msg + "<style>table { margin:0; padding:0; }th { margin:0; padding:0; }td { text-align:left; }</style>";
            msg = (String)msg + "<body>";
            msg = (String)msg + this.context.cfg.gs("Properties.type") + tuo.getType() + "<br/>" + System.getProperty("line.separator");
            try {
                switch (tuo.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        msg = (String)msg + this.context.cfg.gs("Properties.libraries") + tuo.node.getChildCount(false, false) + "<br/>" + System.getProperty("line.separator") + this.context.cfg.gs("Properties.path") + tuo.node.getMyRepo().getJsonFilename() + "<br/>" + System.getProperty("line.separator");
                        break;
                    }
                    case 2: {
                        msg = (String)msg + this.context.cfg.gs("Properties.drives") + tuo.node.getChildCount(false, false) + "<br/>" + System.getProperty("line.separator");
                        break;
                    }
                    case 3: {
                        msg = (String)msg + this.context.cfg.gs("Properties.free") + Utils.formatLong(this.getFreespace(tuo), true, this.context.cfg.getLongScale()) + "<br/>" + System.getProperty("line.separator");
                        break;
                    }
                    case 4: {
                        msg = (String)msg + this.context.cfg.gs("Properties.free") + Utils.formatLong(this.getFreespace(tuo), true, this.context.cfg.getLongScale()) + "<br/>" + System.getProperty("line.separator");
                        break;
                    }
                    case 5: {
                        msg = (String)msg + "<table cellpadding=\"0\" cellspacing=\"0\"><tr><td>" + MessageFormat.format(this.context.cfg.gs("Properties.sources"), tuo.sources.length) + "</td> <td></td> <td>" + this.context.cfg.gs("Properties.free") + "</td></tr>";
                        if (tuo.isRemote) {
                            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                        }
                        for (String source : tuo.sources) {
                            String free = Utils.formatLong(this.getFreespace(source, tuo.isRemote), true, this.context.cfg.getLongScale());
                            msg = (String)msg + "<tr><td>" + source + "</td> <td><div>&nbsp;&nbsp;&nbsp;&nbsp;</div></td> <td>" + free + "</td></tr>";
                        }
                        this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                        msg = (String)msg + "</table>";
                        msg = (String)msg + System.getProperty("line.separator");
                        break;
                    }
                    case 6: {
                        msg = (String)msg + this.context.cfg.gs("Properties.path") + tuo.path + "<br/>" + System.getProperty("line.separator");
                        if (tuo.isDir) break;
                        msg = (String)msg + this.context.cfg.gs("Properties.size") + Utils.formatLong(tuo.size, true, this.context.cfg.getLongScale()) + "<br/>" + System.getProperty("line.separator");
                        msg = (String)msg + "<hr>" + System.getProperty("line.separator");
                        msg = (String)msg + "<br/>";
                        break;
                    }
                }
                msg = (String)msg + "</body></html>";
                this.context.mainFrame.textAreaProperties.setText((String)msg);
            }
            catch (Exception e) {
                this.context.fault = true;
                this.logger.error(Utils.getStackTrace(e));
            }
            printPropertiesInUse = false;
        }
    }

    public void refreshAll() {
        this.refreshTree(this.context.mainFrame.treeCollectionOne);
        this.refreshTree(this.context.mainFrame.treeSystemOne);
        this.refreshTree(this.context.mainFrame.treeCollectionTwo);
        this.refreshTree(this.context.mainFrame.treeSystemTwo);
    }

    public void refreshByObject(Object object) {
        JTable sourceTable;
        if (object instanceof JTree) {
            JTree sourceTree = (JTree)object;
            this.refreshTree(sourceTree);
        } else if (object instanceof JTable && (BrowserTableModel)(sourceTable = (JTable)object).getModel() != null && ((BrowserTableModel)sourceTable.getModel()).getNode() != null) {
            JTree sourceTree = ((BrowserTableModel)sourceTable.getModel()).getNode().getMyTree();
            this.refreshTree(sourceTree);
        }
    }

    public synchronized void refreshTree(JTree tree) {
        if (tree != null) {
            JTable table = null;
            int[] selectedRows = null;
            ArrayList<NavTreeNode> selectedNodes = null;
            tree.setEnabled(false);
            TreePath selectedPath = tree.getSelectionPath();
            if (selectedPath != null && (table = ((NavTreeNode)selectedPath.getLastPathComponent()).getMyTable()) != null) {
                selectedRows = table.getSelectedRows();
                selectedNodes = new ArrayList<NavTreeNode>();
                for (int i = 0; i < selectedRows.length; ++i) {
                    NavTreeUserObject tuo = (NavTreeUserObject)((BrowserTableModel)table.getModel()).getValueAt(selectedRows[i], 1);
                    if (tuo == null) continue;
                    selectedNodes.add(tuo.node);
                }
            }
            TreePath[] selectedPaths = tree.getSelectionPaths();
            ArrayList<TreePath> combinedPaths = this.getCombinedTreePaths(tree);
            ((NavTreeModel)tree.getModel()).reload();
            combinedPaths = this.resetTreePaths(tree, combinedPaths);
            tree.setScrollsOnExpand(true);
            tree.setExpandsSelectedPaths(true);
            if (combinedPaths != null) {
                for (TreePath tp : combinedPaths) {
                    tree.expandPath(tp);
                }
            }
            if (selectedPaths != null && selectedPaths.length > 0) {
                tree.setExpandsSelectedPaths(true);
                selectedPaths = this.resetTreePaths(tree, selectedPaths);
                if (selectedPaths != null && selectedPaths.length > 0) {
                    tree.setExpandsSelectedPaths(true);
                    tree.setSelectionPaths(selectedPaths);
                    tree.scrollPathToVisible(selectedPaths[selectedPaths.length - 1]);
                }
            }
            if (selectedPath != null && (selectedPath = this.resetTreePath(tree, selectedPath)) != null) {
                tree.scrollPathToVisible(selectedPath);
                NavTreeNode selectedNode = (NavTreeNode)selectedPath.getLastPathComponent();
                selectedNode.loadTable();
                if (selectedRows != null && selectedRows.length > 0 && selectedNodes != null) {
                    table.clearSelection();
                    selectedRows = this.resetTableSelections(table, selectedNodes);
                    for (int i = 0; i < selectedRows.length; ++i) {
                        if (selectedRows[i] >= table.getRowCount() || selectedRows[i] < 0) continue;
                        table.addRowSelectionInterval(selectedRows[i], selectedRows[i]);
                    }
                    if (selectedRows.length > 0) {
                        table.scrollRectToVisible(new Rectangle(table.getCellRect(selectedRows[0], 0, true)));
                    }
                }
            }
            tree.setEnabled(true);
        }
    }

    public void rescanByNode(NavTreeNode node) {
        JTree sourceTree = node.getMyTree();
        TreePath tp = node.getTreePath();
        for (int i = 0; i < tp.getPathCount(); ++i) {
            NavTreeNode ntn = (NavTreeNode)tp.getPathComponent(i);
            ntn.setForceReload(true);
        }
        this.scanTreePath(sourceTree.getName(), Utils.getTreePathStringArray(tp), false, true, false);
        this.inRescan = true;
        this.refreshTree(sourceTree);
        this.inRescan = false;
    }

    public void rescanByTreeOrTable(Object object) {
        JTree sourceTree = null;
        if (object instanceof JTree) {
            sourceTree = (JTree)object;
        } else if (object instanceof JTable) {
            JTable sourceTable = (JTable)object;
            sourceTree = ((BrowserTableModel)sourceTable.getModel()).getNode().getMyTree();
        }
        assert (sourceTree != null);
        ArrayList<TreePath> combinedPaths = this.getCombinedTreePaths(sourceTree);
        if (combinedPaths.size() > 0) {
            for (TreePath tp : combinedPaths) {
                for (int i = 0; i < tp.getPathCount(); ++i) {
                    NavTreeNode ntn = (NavTreeNode)tp.getPathComponent(i);
                    ntn.setForceReload(true);
                }
            }
            for (TreePath combined : combinedPaths) {
                this.scanTreePath(sourceTree.getName(), Utils.getTreePathStringArray(combined), false, true, false);
            }
        }
        this.refreshTree(sourceTree);
    }

    private int[] resetTableSelections(JTable table, ArrayList<NavTreeNode> selectedNodes) {
        int index = 0;
        int[] selections = new int[selectedNodes.size()];
        for (int i = 0; i < selectedNodes.size(); ++i) {
            selections[i] = -1;
        }
        for (NavTreeNode node : selectedNodes) {
            int row = this.findRowIndex(table, node.getUserObject().name);
            if (row <= 0) continue;
            selections[index++] = row;
        }
        return selections;
    }

    private TreePath resetTreePath(JTree tree, TreePath treePath) {
        ArrayList<TreePath> array = new ArrayList<TreePath>();
        array.add(treePath);
        array = this.resetTreePaths(tree, array);
        treePath = array != null && array.size() > 0 ? array.get(0) : null;
        return treePath;
    }

    public TreePath[] resetTreePaths(JTree tree, TreePath[] treePathArray) {
        if (treePathArray != null && treePathArray.length > 0) {
            int i;
            ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
            for (i = 0; i < treePathArray.length; ++i) {
                treePaths.add(treePathArray[i]);
            }
            if ((treePaths = this.resetTreePaths(tree, treePaths)) != null && treePaths.size() > 0) {
                treePathArray = new TreePath[treePaths.size()];
                for (i = 0; i < treePaths.size(); ++i) {
                    treePathArray[i] = treePaths.get(i);
                }
            }
        }
        return treePathArray;
    }

    public ArrayList<TreePath> resetTreePaths(JTree tree, ArrayList<TreePath> treePaths) {
        ArrayList<TreePath> reworkedPaths = null;
        if (tree != null && treePaths.size() > 0) {
            reworkedPaths = new ArrayList<TreePath>();
            for (int i = 0; i < treePaths.size(); ++i) {
                int nodeIndex = 0;
                TreePath treePath = null;
                TreePath tp = treePaths.get(i);
                Object[] objs = tp.getPath();
                Object[] nodes = new NavTreeNode[tp.getPathCount()];
                NavTreeNode node = (NavTreeNode)objs[0];
                nodes[nodeIndex++] = node;
                String[] pathElements = Utils.getTreePathStringArray(tp);
                int occurrence = 1;
                for (int j = 1; j < pathElements.length; ++j) {
                    NavTreeNode next = node.findChildName(pathElements[j], occurrence);
                    if (next == null) {
                        nodes = null;
                        break;
                    }
                    nodes[nodeIndex++] = next;
                    node = next;
                }
                if (nodes == null || (treePath = new TreePath(nodes)) == null) continue;
                reworkedPaths.add(treePath);
            }
        }
        return reworkedPaths;
    }

    public TreePath scanTreePath(String panelName, String[] pathElements, boolean doTable, boolean forceScan, boolean fullTreePath) {
        TreePath treePath = null;
        if (panelName != null && panelName.length() > 0 && pathElements != null && pathElements.length > 0 && !this.context.fault) {
            JTable table;
            JTree tree;
            Repository repo;
            boolean remote = false;
            if ((panelName = panelName.toLowerCase()).endsWith("one")) {
                repo = this.context.publisherRepo;
                tree = panelName.contains("collection") ? this.context.mainFrame.treeCollectionOne : this.context.mainFrame.treeSystemOne;
                table = panelName.contains("collection") ? this.context.mainFrame.tableCollectionOne : this.context.mainFrame.tableSystemOne;
            } else {
                remote = this.context.cfg.isRemoteOperation();
                repo = this.context.subscriberRepo;
                tree = panelName.contains("collection") ? this.context.mainFrame.treeCollectionTwo : this.context.mainFrame.treeSystemTwo;
                table = panelName.contains("collection") ? this.context.mainFrame.tableCollectionTwo : this.context.mainFrame.tableSystemTwo;
            }
            int nodeIndex = 0;
            Object[] nodes = new NavTreeNode[pathElements.length];
            Object node = (NavTreeNode)tree.getModel().getRoot();
            nodes[nodeIndex++] = node;
            int occurrence = 1;
            for (int i = 1; i < pathElements.length; ++i) {
                NavTreeNode next = ((NavTreeNode)node).findChildName(pathElements[i], occurrence);
                if (next != null && (!forceScan || forceScan && !next.isForceReload())) {
                    nodes[nodeIndex++] = next;
                    node = next;
                    continue;
                }
                if (next != null) {
                    if (next.getUserObject().isDir) {
                        if (next.getUserObject().type == 2 && forceScan) {
                            this.styleComputer(tree, repo, remote, false, false);
                        } else if (next.getUserObject().type == 4 && forceScan) {
                            this.styleHome(tree, repo, remote, false, false);
                        } else {
                            next.deepScanChildren(false);
                        }
                    }
                } else if (((NavTreeNode)node).getUserObject().isDir) {
                    ((NavTreeNode)node).deepScanChildren(false);
                }
                if ((next = ((NavTreeNode)node).findChildName(pathElements[i])) != null) {
                    nodes[nodeIndex++] = next;
                    node = next;
                    continue;
                }
                node = nodes[nodeIndex - 2];
                if ((next = ((NavTreeNode)node).findChildName(pathElements[i - 1], ++occurrence)) == null) break;
                node = next;
                --i;
                int n = --nodeIndex;
                ++nodeIndex;
                nodes[n] = next;
                occurrence = 1;
            }
            if (nodeIndex != pathElements.length) {
                int k;
                NavTreeNode[] shorter = new NavTreeNode[nodeIndex];
                for (k = 0; k < nodeIndex; ++k) {
                    shorter[k] = nodes[k];
                }
                nodes = new NavTreeNode[nodeIndex];
                for (k = 0; k < nodeIndex; ++k) {
                    nodes[k] = shorter[k];
                }
                for (k = nodeIndex; k < pathElements.length; ++k) {
                    this.logger.warn(this.context.cfg.gs("Browser.could.not.find") + pathElements[k]);
                }
            }
            if (!fullTreePath && !((NavTreeNode)nodes[nodeIndex - 1]).getUserObject().isDir && this.context.preferences.isHideFilesInTree()) {
                Object[] navNodes = new NavTreeNode[nodeIndex - 1];
                for (int j = 0; j < nodeIndex - 1; ++j) {
                    navNodes[j] = nodes[j];
                }
                treePath = new TreePath(navNodes);
            } else {
                treePath = new TreePath(nodes);
            }
            if (!((NavTreeNode)node).isLoaded()) {
                ((NavTreeNode)node).deepScanChildren(false);
            }
            if (doTable) {
                tree.setExpandsSelectedPaths(true);
                tree.setSelectionPath(treePath);
                tree.scrollPathToVisible(treePath);
                if (panelName.startsWith("table")) {
                    int panelNo = this.context.browser.getPanelNumber(panelName);
                    table = (JTable)this.context.browser.getTabComponent(panelNo);
                    if (table != null) {
                        table.requestFocus();
                        int index = this.context.browser.findRowIndex(table, pathElements[pathElements.length - 1]);
                        if (index > -1) {
                            table.setRowSelectionInterval(index, index);
                            table.scrollRectToVisible(new Rectangle(table.getCellRect(index, index, true)));
                            table.scrollRectToVisible(new Rectangle(table.getCellRect(index, index, true)));
                        }
                    }
                } else {
                    table.clearSelection();
                }
            }
        }
        return treePath;
    }

    public void selectPanelNumber(int panelNo) {
        if (panelNo >= 0) {
            this.lastPanelNumber = panelNo;
            switch (panelNo) {
                case 0: {
                    this.context.mainFrame.tabbedPaneBrowserOne.setSelectedIndex(0);
                    this.context.mainFrame.treeCollectionOne.requestFocus();
                    this.lastComponent = this.context.mainFrame.treeCollectionOne;
                    this.lastTabStopIndex = 0;
                    break;
                }
                case 1: {
                    this.context.mainFrame.tabbedPaneBrowserOne.setSelectedIndex(0);
                    this.context.mainFrame.tableCollectionOne.requestFocus();
                    this.lastComponent = this.context.mainFrame.tableCollectionOne;
                    this.lastTabStopIndex = 1;
                    break;
                }
                case 2: {
                    this.context.mainFrame.tabbedPaneBrowserOne.setSelectedIndex(1);
                    this.context.mainFrame.treeSystemOne.requestFocus();
                    this.lastComponent = this.context.mainFrame.treeSystemOne;
                    this.lastTabStopIndex = 0;
                    break;
                }
                case 3: {
                    this.context.mainFrame.tabbedPaneBrowserOne.setSelectedIndex(1);
                    this.context.mainFrame.tableSystemOne.requestFocus();
                    this.lastComponent = this.context.mainFrame.tableSystemOne;
                    this.lastTabStopIndex = 1;
                    break;
                }
                case 4: {
                    this.context.mainFrame.tabbedPaneBrowserTwo.setSelectedIndex(0);
                    this.context.mainFrame.treeCollectionTwo.requestFocus();
                    this.lastComponent = this.context.mainFrame.treeCollectionTwo;
                    this.lastTabStopIndex = 2;
                    break;
                }
                case 5: {
                    this.context.mainFrame.tabbedPaneBrowserTwo.setSelectedIndex(0);
                    this.context.mainFrame.tableCollectionTwo.requestFocus();
                    this.lastComponent = this.context.mainFrame.tableCollectionTwo;
                    this.lastTabStopIndex = 3;
                    break;
                }
                case 6: {
                    this.context.mainFrame.tabbedPaneBrowserTwo.setSelectedIndex(1);
                    this.context.mainFrame.treeSystemTwo.requestFocus();
                    this.lastComponent = this.context.mainFrame.treeSystemTwo;
                    this.lastTabStopIndex = 2;
                    break;
                }
                case 7: {
                    this.context.mainFrame.tabbedPaneBrowserTwo.setSelectedIndex(1);
                    this.context.mainFrame.tableSystemTwo.requestFocus();
                    this.lastComponent = this.context.mainFrame.tableSystemTwo;
                    this.lastTabStopIndex = 3;
                }
            }
        }
    }

    public void selectTabOne(int index) {
        TreeModel model = null;
        NavTreeNode node = null;
        int next = -1;
        switch (index) {
            case 0: {
                this.lastTabStopIndex = 0;
                this.lastComponent = this.context.mainFrame.treeCollectionOne;
                model = this.context.mainFrame.treeCollectionOne.getModel();
                node = (NavTreeNode)this.context.mainFrame.treeCollectionOne.getLastSelectedPathComponent();
                this.tabStops[0] = 0;
                this.tabStops[1] = 1;
                next = this.lastFocusedCollectionOne;
                break;
            }
            case 1: {
                this.lastTabStopIndex = 1;
                this.lastComponent = this.context.mainFrame.treeSystemOne;
                model = this.context.mainFrame.treeSystemOne.getModel();
                node = (NavTreeNode)this.context.mainFrame.treeSystemOne.getLastSelectedPathComponent();
                this.tabStops[0] = 2;
                this.tabStops[1] = 3;
                next = this.lastFocusedSystemOne;
            }
        }
        if (node == null) {
            node = (NavTreeNode)model.getRoot();
        }
        node.loadProperties();
        if (next >= 0) {
            this.selectPanelNumber(next);
        }
    }

    public void selectTabTwo(int index) {
        TreeModel model = null;
        NavTreeNode node = null;
        int next = -1;
        switch (index) {
            case 0: {
                this.lastTabStopIndex = 2;
                this.lastComponent = this.context.mainFrame.treeCollectionTwo;
                model = this.context.mainFrame.treeCollectionTwo.getModel();
                node = (NavTreeNode)this.context.mainFrame.treeCollectionTwo.getLastSelectedPathComponent();
                this.tabStops[2] = 4;
                this.tabStops[3] = 5;
                next = this.lastFocusedCollectionTwo;
                break;
            }
            case 1: {
                this.lastTabStopIndex = 3;
                this.lastComponent = this.context.mainFrame.treeSystemTwo;
                model = this.context.mainFrame.treeSystemTwo.getModel();
                node = (NavTreeNode)this.context.mainFrame.treeSystemTwo.getLastSelectedPathComponent();
                this.tabStops[2] = 6;
                this.tabStops[3] = 7;
                next = this.lastFocusedSystemTwo;
            }
        }
        if (node == null) {
            node = (NavTreeNode)model.getRoot();
        }
        node.loadProperties();
        if (next >= 0) {
            this.selectPanelNumber(next);
        }
    }

    public NavTreeNode setCollectionRoot(Repository repo, JTree tree, String title, boolean remote) {
        NavTreeNode root = new NavTreeNode(this.context, repo, tree);
        NavTreeUserObject tuo = new NavTreeUserObject(root, title, 1, remote);
        root.setNavTreeUserObject(tuo);
        NavTreeModel model = new NavTreeModel(root, true);
        model.activateFilter(this.context.preferences.isHideFilesInTree());
        tree.setCellRenderer(new NavTreeCellRenderer(this.context));
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        tree.setLargeModel(true);
        tree.setModel(model);
        return root;
    }

    public void setupHintTrackingButton() {
        String tt = "";
        String string = this.context.cfg.getHintsDaemonFilename().length() > 0 ? this.context.cfg.gs("Navigator.buttonHintServer.text") : (tt = this.context.cfg.getHintTrackerFilename().length() > 0 ? this.context.cfg.gs("Navigator.buttonHintTracking.text") : "");
        if (tt.length() > 0) {
            this.context.mainFrame.panelHintTracking.setVisible(true);
            this.hintTrackingButtonEnabled = true;
        } else {
            this.context.mainFrame.panelHintTracking.setVisible(false);
            this.hintTrackingButtonEnabled = false;
        }
        this.toggleHintTracking(this.hintTrackingButtonEnabled);
    }

    private void styleCollection(JTree tree, Repository repo, boolean remote, boolean deep, boolean recursive) {
        NavTreeModel model = (NavTreeModel)tree.getModel();
        NavTreeNode root = (NavTreeNode)model.getRoot();
        for (Library lib : repo.getLibraryData().libraries.bibliography) {
            if (this.context.fault) continue;
            NavTreeNode node = new NavTreeNode(this.context, repo, tree);
            NavTreeUserObject tuo = new NavTreeUserObject(node, lib.name, lib.sources, remote);
            node.setNavTreeUserObject(tuo);
            node.setRefresh(true);
            root.add(node);
            if (deep) {
                node.deepScanChildren(recursive);
                continue;
            }
            node.loadChildren(false);
        }
        root.setLoaded(true);
    }

    private NavTreeNode styleComputer(JTree tree, Repository repo, boolean remote, boolean deep, boolean recursive) {
        NavTreeNode computerNode;
        NavTreeUserObject tuo;
        NavTreeNode hiddenRoot;
        if (!(tree.getModel() instanceof NavTreeModel) || !((NavTreeNode)tree.getModel().getRoot()).isLoaded()) {
            hiddenRoot = new NavTreeNode(this.context, repo, tree);
            tuo = new NavTreeUserObject(hiddenRoot, this.context.cfg.gs("Browser.system"), 7, remote);
            hiddenRoot.setNavTreeUserObject(tuo);
            NavTreeModel model = new NavTreeModel(hiddenRoot, true);
            model.activateFilter(this.context.preferences.isHideFilesInTree());
            tree.setShowsRootHandles(true);
            tree.setRootVisible(false);
            tree.setLargeModel(true);
            tree.setCellRenderer(new NavTreeCellRenderer(this.context));
            tree.setModel(model);
            computerNode = new NavTreeNode(this.context, repo, tree);
            tuo = new NavTreeUserObject(computerNode, this.context.cfg.gs("Browser.computer"), 2, remote);
            computerNode.setNavTreeUserObject(tuo);
            hiddenRoot.add(computerNode);
        } else {
            hiddenRoot = (NavTreeNode)tree.getModel().getRoot();
            computerNode = hiddenRoot.findChildName(this.context.cfg.gs("Browser.computer"));
            computerNode.removeAllChildren();
            computerNode.setRefresh(true);
            tuo = computerNode.getUserObject();
            tuo.isRemote = remote;
        }
        if (repo.getLibraryData().libraries.flavor.toLowerCase().equals("windows")) {
            String driveList = null;
            if (remote) {
                try {
                    this.logger.info(this.context.cfg.gs("NavTreeNode.requesting.windows.drives.list"));
                    driveList = this.context.clientStty.roundTrip("drives", null, 5000);
                }
                catch (Exception e) {
                    this.logger.error(Utils.getStackTrace(e));
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.could.not.retrieve.list.of.remote.drives") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                    return null;
                }
            } else {
                driveList = Utils.getLocalHardDrives();
            }
            String[] roots = driveList.split("\\|");
            for (int i = 0; i < roots.length; ++i) {
                if (this.context.fault) continue;
                String drive = roots[i];
                String path = "/" + drive.replaceAll("\\\\", "/");
                driveNode = new NavTreeNode(this.context, repo, tree);
                tuo = new NavTreeUserObject(driveNode, drive, path, 3, remote);
                driveNode.setNavTreeUserObject(tuo);
                computerNode.add(driveNode);
                if (deep) {
                    driveNode.deepScanChildren(recursive);
                    continue;
                }
                driveNode.loadChildren(false);
            }
        } else {
            driveNode = new NavTreeNode(this.context, repo, tree);
            tuo = new NavTreeUserObject(driveNode, "/", "/", 3, remote);
            driveNode.setNavTreeUserObject(tuo);
            computerNode.add(driveNode);
            if (deep) {
                driveNode.deepScanChildren(recursive);
            } else {
                driveNode.loadChildren(false);
            }
        }
        computerNode.setLoaded(true);
        hiddenRoot.setLoaded(true);
        return computerNode;
    }

    private NavTreeNode styleHome(JTree tree, Repository repo, boolean remote, boolean deep, boolean recursive) {
        NavTreeNode homeNode = null;
        NavTreeNode hiddenRoot = (NavTreeNode)tree.getModel().getRoot();
        if (tree.getName().equalsIgnoreCase("treeSystemOne")) {
            homeNode = hiddenRoot.findChildName(this.context.cfg.gs("Browser.home"));
            if (homeNode == null) {
                homeNode = new NavTreeNode(this.context, repo, tree);
                NavTreeUserObject tuo = new NavTreeUserObject(homeNode, this.context.cfg.gs("Browser.home"), System.getProperty("user.home"), 4, remote);
                homeNode.setNavTreeUserObject(tuo);
                hiddenRoot.add(homeNode);
            } else {
                homeNode.removeAllChildren();
                homeNode.setRefresh(true);
            }
            if (deep) {
                homeNode.deepScanChildren(recursive);
            } else {
                homeNode.loadChildren(false);
            }
            homeNode.setLoaded(true);
        }
        return homeNode;
    }

    public void toggleHintTracking(boolean sense) {
        String tl;
        BufferedImage icon = null;
        String tt = "";
        String string = tl = this.context.cfg.getHintsDaemonFilename().length() > 0 ? this.context.cfg.gs("Navigator.buttonHintServer.text") : this.context.cfg.gs("Navigator.buttonHintTracking.text");
        if (sense) {
            try {
                this.hintTrackingButtonEnabled = true;
                tt = this.context.cfg.gs("Navigator.buttonHint.enabled.tooltip");
                URL url = Thread.currentThread().getContextClassLoader().getResource("hint-green.png");
                icon = ImageIO.read(url);
            }
            catch (Exception url) {}
        } else {
            try {
                this.hintTrackingButtonEnabled = false;
                tt = this.context.cfg.gs("Navigator.buttonHint.disabled.tooltip");
                URL url = Thread.currentThread().getContextClassLoader().getResource("hint-red.png");
                icon = ImageIO.read(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.context.mainFrame.buttonHintTracking.setText(tl);
        this.context.mainFrame.buttonHintTracking.setIcon(new ImageIcon(icon));
        this.context.mainFrame.buttonHintTracking.setToolTipText(tt);
    }

    public void toggleShowHiddenFiles() {
        NavTreeNode node;
        JComponent object = this.lastComponent;
        this.context.preferences.setHideHiddenFiles(!this.context.preferences.isHideHiddenFiles());
        if (this.context.preferences.isHideHiddenFiles()) {
            this.context.mainFrame.menuItemShowHidden.setSelected(false);
        } else {
            this.context.mainFrame.menuItemShowHidden.setSelected(true);
        }
        this.refreshAll();
        JTree tree = null;
        if (object instanceof JTree) {
            tree = (JTree)object;
        } else if (object instanceof JTable) {
            tree = this.navTransferHandler.getTargetTree((JTable)object);
        }
        if (tree != null && (node = (NavTreeNode)tree.getLastSelectedPathComponent()) != null) {
            node.loadTable();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void touchSelected(JTable sourceTable) {
        int row = sourceTable.getSelectedRow();
        if (row <= -1) return;
        int dirCount = 0;
        int fileCount = 0;
        boolean isRemote = false;
        long size = 0L;
        int[] rows = sourceTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            NavTreeUserObject tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[i], 1);
            if (tuo.type != 6) {
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.menu.Touch.cannot") + tuo.name, this.context.cfg.getNavigatorName(), 2);
                return;
            }
            isRemote = tuo.isRemote;
            if (tuo.isDir) {
                ++dirCount;
                tuo.node.deepScanChildren(true);
                fileCount += tuo.node.deepGetFileCount();
                size += tuo.node.deepGetFileSize();
                continue;
            }
            ++fileCount;
            size += tuo.size;
        }
        int reply = 0;
        if (this.context.preferences.isShowTouchConfirmation()) {
            Object msg = MessageFormat.format(this.context.cfg.gs("Navigator.menu.Touch.are.you.sure1"), rows.length, isRemote ? 0 : 1, rows.length > 1 ? 0 : 1, fileCount, fileCount > 1 ? 0 : 1, Utils.formatLong(size, false, this.context.cfg.getLongScale()));
            msg = (String)msg + (dirCount > 0 ? MessageFormat.format(this.context.cfg.gs("Navigator.menu.Touch.are.you.sure2"), dirCount > 1 ? 0 : 1) : "");
            msg = (String)msg + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : "");
            reply = JOptionPane.showConfirmDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
        }
        if (reply != 0) return;
        for (int i = 0; i < rows.length; ++i) {
            NavTreeUserObject tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[i], 1);
            if (tuo.type == 6) {
                try {
                    long seconds = this.context.transfer.touch(tuo.path, tuo.isRemote);
                    if (tuo.isRemote) {
                        tuo.mtime = (int)seconds;
                    }
                    tuo.fileTime = FileTime.from(seconds, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.error(Utils.getStackTrace(e));
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.menu.Touch.error") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                }
                NavTreeNode parent = (NavTreeNode)tuo.node.getParent();
                if (parent == null) continue;
                DefaultRowSorter sorter = (DefaultRowSorter)sourceTable.getRowSorter();
                sorter.sort();
                continue;
            }
            this.logger.info(this.context.cfg.gs("Browser.skipping") + tuo.name);
        }
    }

    public void touchSelected(JTree sourceTree) {
        int row = sourceTree.getLeadSelectionRow();
        if (row > -1) {
            TreePath[] paths;
            int dirCount = 0;
            int fileCount = 0;
            boolean isRemote = false;
            long size = 0L;
            for (TreePath path : paths = sourceTree.getSelectionPaths()) {
                NavTreeNode ntn = (NavTreeNode)path.getLastPathComponent();
                NavTreeUserObject tuo = ntn.getUserObject();
                if (tuo.type != 6) {
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.menu.Touch.cannot") + tuo.name, this.context.cfg.getNavigatorName(), 2);
                    return;
                }
                isRemote = tuo.isRemote;
                if (tuo.isDir) {
                    ++dirCount;
                    tuo.node.deepScanChildren(true);
                    fileCount += tuo.node.deepGetFileCount();
                    size += tuo.node.deepGetFileSize();
                    continue;
                }
                ++fileCount;
                size += tuo.size;
            }
            int reply = 0;
            if (this.context.preferences.isShowTouchConfirmation()) {
                Object msg = MessageFormat.format(this.context.cfg.gs("Navigator.menu.Touch.are.you.sure1"), paths.length, isRemote ? 0 : 1, paths.length > 1 ? 0 : 1, fileCount, fileCount > 1 ? 0 : 1, Utils.formatLong(size, false, this.context.cfg.getLongScale()));
                msg = (String)msg + (dirCount > 0 ? MessageFormat.format(this.context.cfg.gs("Navigator.menu.Touch.are.you.sure2"), dirCount > 1 ? 0 : 1) : "");
                msg = (String)msg + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : "");
                reply = JOptionPane.showConfirmDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
            if (reply == 0) {
                for (TreePath path : paths) {
                    NavTreeNode ntn = (NavTreeNode)path.getLastPathComponent();
                    NavTreeUserObject tuo = ntn.getUserObject();
                    if (tuo.type == 6) {
                        try {
                            long seconds = this.context.transfer.touch(tuo.path, tuo.isRemote);
                            if (tuo.isRemote) {
                                tuo.mtime = (int)seconds;
                            }
                            tuo.fileTime = FileTime.from(seconds, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            this.logger.error(Utils.getStackTrace(e));
                            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Navigator.menu.Touch.error") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                        }
                        NavTreeNode parent = (NavTreeNode)tuo.node.getParent();
                        if (parent == null) continue;
                        this.refreshTree(parent.getMyTree());
                        continue;
                    }
                    this.logger.info(this.context.cfg.gs("Browser.skipping") + tuo.name);
                }
            }
        }
    }

    public class NavItem {
        Component component;
        NavTreeNode node;

        public NavItem(Browser this$0, NavTreeNode node, Component component) {
            this.node = node;
            this.component = component != null ? component : node.getMyTree();
        }
    }
}

