/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.bookmarks.Bookmark;
import com.corionis.els.gui.browser.NavTransferWorker;
import com.corionis.els.gui.browser.NavTreeModel;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NavTransferHandler
extends TransferHandler {
    private final boolean traceActions = true;
    private Context context;
    public int fileNumber = 0;
    public int filesToCopy = 0;
    private int action = 0;
    private ArrayList<NavTreeUserObject> actionList = null;
    private boolean isDrop = false;
    private boolean isRemote = false;
    private Logger logger = LogManager.getLogger("applog");
    private JTable sourceTable;
    private JTree sourceTree;
    private JTable targetTable;
    private JTree targetTree;
    public static NavTransferWorker transferWorker = null;

    public NavTransferHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        JTable targetTable;
        JTree targetTree;
        JTable targetTable2;
        JTree targetTree2;
        NavTreeNode targetNode;
        this.context.fault = false;
        this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
        if (info.getComponent() instanceof JTable ? (targetNode = this.getTargetNode(info, targetTree2 = this.getTargetTree(targetTable2 = (JTable)info.getComponent()), targetTable2)) == null || targetNode.getUserObject().sources == null && targetNode.getUserObject().path.length() == 0 : info.getComponent() instanceof JTree && ((targetNode = this.getTargetNode(info, targetTree = (JTree)info.getComponent(), targetTable = this.getTargetTable(targetTree))) == null || targetNode.getUserObject().sources == null && targetNode.getUserObject().path.length() == 0)) {
            return false;
        }
        boolean supported = info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        return supported;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        this.reset();
        this.context.fault = false;
        ArrayList<File> rowList = new ArrayList<File>();
        this.actionList = new ArrayList();
        if (component instanceof JTable) {
            this.sourceTable = (JTable)component;
            this.sourceTree = this.getTargetTree(this.sourceTable);
            row = this.sourceTable.getSelectedRow();
            if (row < 0) {
                return null;
            }
            int[] rows = this.sourceTable.getSelectedRows();
            if (rows.length < 1) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                NavTreeUserObject tuo = (NavTreeUserObject)this.sourceTable.getValueAt(rows[i], 1);
                if (this.sourceTree == null) {
                    this.sourceTree = tuo.node.getMyTree();
                    this.sourceTable = tuo.node.getMyTable();
                    this.isRemote = tuo.isRemote;
                }
                this.actionList.add(tuo);
                if (this.isRemote) continue;
                File item = tuo.file;
                rowList.add(item);
            }
            this.logger.trace("Create transferable from " + this.sourceTable.getName() + " starting at row " + row + ", " + rows.length + " rows total");
        } else if (component instanceof JTree) {
            TreePath[] paths;
            this.sourceTree = (JTree)component;
            this.sourceTable = this.getTargetTable(this.sourceTree);
            row = this.sourceTree.getLeadSelectionRow();
            if (row < 0) {
                return null;
            }
            for (TreePath path : paths = this.sourceTree.getSelectionPaths()) {
                NavTreeNode ntn = (NavTreeNode)path.getLastPathComponent();
                NavTreeUserObject tuo = ntn.getUserObject();
                if (this.sourceTree == null) {
                    this.sourceTree = tuo.node.getMyTree();
                    this.sourceTable = tuo.node.getMyTable();
                    this.isRemote = tuo.isRemote;
                }
                this.actionList.add(tuo);
                if (this.isRemote) continue;
                File item = tuo.file;
                rowList.add(item);
            }
            this.logger.trace("Create transferable from " + this.sourceTree.getName() + " starting at row " + row + ", " + paths.length + " rows total");
        }
        FileTransferable ft = new FileTransferable(this, rowList);
        return ft;
    }

    @Override
    protected void exportDone(JComponent c, Transferable info, int act) {
        this.action = act;
        if (this.isDrop) {
            switch (this.action) {
                case 2: {
                    this.logger.trace("Done MOVE");
                    break;
                }
                case 1: {
                    this.logger.trace("Done COPY");
                    break;
                }
                case 3: {
                    this.logger.trace("Done COPY_OR_MOVE");
                    break;
                }
                case 0: {
                    this.logger.trace("Done NONE");
                }
            }
            this.logger.trace("end of exportDone");
        }
    }

    private boolean datasetsMatch(TransferHandler.TransferSupport info) {
        boolean sense = true;
        FileTransferable ftTest = new FileTransferable(this, null);
        DataFlavor[] flavors = info.getTransferable().getTransferDataFlavors();
        if (ftTest.getTransferDataFlavors().length == flavors.length) {
            Transferable data = info.getTransferable();
            boolean typeFound = false;
            for (int index = 0; index < flavors.length; ++index) {
                String subType = flavors[index].getSubType();
                if (subType.equals("x-java-file-list")) {
                    typeFound = true;
                    try {
                        ArrayList fileList = (ArrayList)data.getTransferData(flavors[index]);
                        for (int i = 0; i < fileList.size(); ++i) {
                            File file = (File)fileList.get(i);
                            if (file == null || file == this.actionList.get((int)i).file) continue;
                            sense = false;
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.actionList = null;
                        this.logger.error(Utils.getStackTrace(e));
                    }
                }
                if (typeFound) break;
            }
            if (!typeFound) {
                this.actionList = null;
                this.logger.error(this.context.cfg.gs("NavTransferHandler.unsupported.flavor"));
            }
        } else {
            sense = false;
        }
        return sense;
    }

    public synchronized void exportHint(String act, NavTreeUserObject sourceTuo, NavTreeUserObject targetTuo) throws Exception {
        if (this.context.browser.isHintTrackingButtonEnabled() && sourceTuo.node.getMyTree().getName().toLowerCase().contains("collection")) {
            this.context.hintsHandler.writeHint(act, this.context.preferences.isLastPublisherIsWorkstation(), sourceTuo, targetTuo);
        }
    }

    public NavTreeUserObject findSourceTuo(String path) {
        NavTreeUserObject tuo = null;
        String separator = Utils.getSeparatorFromPath(path);
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        String[] pathElements = path.split(separator);
        for (int i = 0; i < pathElements.length; ++i) {
            if (pathElements[i] == null || pathElements[i].length() == 0) {
                pathElements[i] = separator;
                continue;
            }
            if (!pathElements[i].matches("^[a-zA-Z]:.*")) continue;
            pathElements[i] = pathElements[i] + "\\";
        }
        if (pathElements != null && pathElements.length > 0) {
            JTree searchTree = this.context.mainFrame.treeSystemOne;
            String repoName = this.context.cfg.gs("Browser.system");
            String libName = this.context.cfg.gs("Browser.computer");
            Bookmark bm = this.context.browser.bookmarkCreate("find-tuo", searchTree, repoName, libName, pathElements);
            TreePath tp = this.context.browser.scanTreePath(searchTree.getName(), bm.pathElements, false, false, true);
            if (tp != null) {
                NavTreeNode ntn = (NavTreeNode)tp.getLastPathComponent();
                tuo = ntn.getUserObject();
            }
        }
        return tuo;
    }

    private String findPathInCollection(JTree currentTree, String[] pathElements) {
        String libName = null;
        NavTreeModel model = (NavTreeModel)currentTree.getModel();
        NavTreeNode node = (NavTreeNode)model.getRoot();
        Repository repo = node.getMyRepo();
        if (repo != null && repo.getLibraryData() != null && repo.getLibraryData().libraries != null && repo.getLibraryData().libraries.bibliography != null) {
            for (Library lib : repo.getLibraryData().libraries.bibliography) {
                int i = 0;
                if (i < lib.sources.length) {
                    libName = lib.name;
                }
                if (libName != null) break;
            }
        }
        return libName;
    }

    private boolean matchPathToLibrarySource(String[] pathElements, String libraryPath) {
        boolean sense = false;
        String[] libraryElements = libraryPath.split(Utils.getSeparatorFromPath(libraryPath));
        int max = Integer.min(pathElements.length, libraryElements.length);
        int i = 0;
        while (i < max && pathElements[i].equals(libraryElements[i])) {
            if (++i != libraryElements.length) continue;
            sense = true;
            int size = pathElements.length - i;
            String[] remaining = new String[size];
            for (int j = 0; j < size; ++j) {
                remaining[j] = pathElements[i + j];
            }
            pathElements = remaining;
            break;
        }
        return sense;
    }

    public synchronized String getOperationText(int actionValue, boolean currentTense) {
        String op = "";
        if (actionValue == 1) {
            op = currentTense ? this.context.cfg.gs("NavTransferHandler.copy") : this.context.cfg.gs("NavTransferHandler.copied");
        } else if (actionValue == 2) {
            op = currentTense ? this.context.cfg.gs("NavTransferHandler.move") : this.context.cfg.gs("NavTransferHandler.moved");
        } else if (actionValue == 3) {
            op = this.context.cfg.gs("NavTransferHandler.copy.or.move");
        }
        return op;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    private NavTreeNode getTargetNode(TransferHandler.TransferSupport info, JTree targetTree, JTable targetTable) {
        NavTreeNode targetNode = null;
        if (info.isDrop()) {
            if (info.getComponent() instanceof JTable) {
                dl = (JTable.DropLocation)info.getDropLocation();
                if (!((JTable.DropLocation)dl).isInsertRow()) {
                    NavTreeUserObject ttuo = (NavTreeUserObject)targetTable.getValueAt(((JTable.DropLocation)dl).getRow(), 1);
                    if (ttuo.isDir) {
                        targetNode = ((NavTreeUserObject)targetTable.getValueAt((int)((JTable.DropLocation)dl).getRow(), (int)1)).node;
                    }
                }
            } else if (info.getComponent() instanceof JTree) {
                dl = (JTree.DropLocation)info.getDropLocation();
                TreePath dlPath = ((JTree.DropLocation)dl).getPath();
                NavTreeNode dlNode = (NavTreeNode)dlPath.getLastPathComponent();
                NavTreeUserObject ttuo = dlNode.getUserObject();
                if (ttuo.isDir) {
                    targetNode = dlNode;
                }
            }
        }
        if (targetNode == null && info.getComponent() instanceof JTable && targetTable.getSelectedRow() >= 0) {
            NavTreeUserObject tuo = (NavTreeUserObject)targetTable.getValueAt(targetTable.getSelectedRow(), 1);
            targetNode = tuo.node;
            if (!targetNode.getUserObject().isDir) {
                targetNode = null;
            }
        }
        if (targetNode == null) {
            targetNode = (NavTreeNode)targetTree.getLastSelectedPathComponent();
        }
        if (targetNode == null) {
            targetNode = (NavTreeNode)targetTree.getModel().getRoot();
        }
        return targetNode;
    }

    private JTable getTargetTable(JTree tree) {
        JTable targetTable = null;
        switch (tree.getName()) {
            case "treeCollectionOne": {
                targetTable = this.context.mainFrame.tableCollectionOne;
                break;
            }
            case "treeSystemOne": {
                targetTable = this.context.mainFrame.tableSystemOne;
                break;
            }
            case "treeCollectionTwo": {
                targetTable = this.context.mainFrame.tableCollectionTwo;
                break;
            }
            case "treeSystemTwo": {
                targetTable = this.context.mainFrame.tableSystemTwo;
            }
        }
        assert (targetTable != null);
        return targetTable;
    }

    public JTree getTargetTree(JTable table) {
        JTree targetTree = null;
        switch (table.getName()) {
            case "tableCollectionOne": {
                targetTree = this.context.mainFrame.treeCollectionOne;
                break;
            }
            case "tableSystemOne": {
                targetTree = this.context.mainFrame.treeSystemOne;
                break;
            }
            case "tableCollectionTwo": {
                targetTree = this.context.mainFrame.treeCollectionTwo;
                break;
            }
            case "tableSystemTwo": {
                targetTree = this.context.mainFrame.treeSystemTwo;
            }
        }
        assert (targetTree != null);
        return targetTree;
    }

    public NavTransferWorker getTransferWorker() {
        return transferWorker;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        this.context.fault = false;
        this.context.mainFrame.toFront();
        this.isDrop = info.isDrop();
        if (this.isDrop) {
            this.action = info.getUserDropAction();
        }
        if (this.action == 0) {
            this.action = 1;
        }
        if (info.getComponent() instanceof JTable) {
            this.targetTable = (JTable)info.getComponent();
            this.targetTree = this.getTargetTree(this.targetTable);
            this.targetTable.requestFocus();
        } else {
            this.targetTree = (JTree)info.getComponent();
            this.targetTable = this.getTargetTable(this.targetTree);
            this.targetTree.requestFocus();
        }
        NavTreeNode targetNode = this.getTargetNode(info, this.targetTree, this.targetTable);
        NavTreeUserObject targetTuo = targetNode.getUserObject();
        if (targetNode.getUserObject().sources == null && targetNode.getUserObject().path.length() == 0) {
            this.reset();
            this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("NavTransferHandler.cannot.transfer.to.currently.selected.location"));
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("NavTransferHandler.cannot.transfer.to.currently.selected.location"), this.context.cfg.getNavigatorName(), 0);
            return false;
        }
        try {
            boolean confirm;
            this.fileNumber = 0;
            int count = 0;
            long size = 0L;
            if (this.actionList == null || !this.datasetsMatch(info)) {
                this.makeActionListFromPaths(info);
            }
            if (this.actionList == null || this.actionList.size() == 0) {
                this.reset();
                this.logger.warn(this.context.cfg.gs("NavTransferHandler.nothing.to.do"));
                this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("NavTransferHandler.nothing.to.do"));
                return false;
            }
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            for (NavTreeUserObject sourceTuo : this.actionList) {
                NavTreeNode sourceNode = sourceTuo.node;
                this.sourceTree = sourceNode.getMyTree();
                this.sourceTable = sourceNode.getMyTable();
                NavTreeNode parent = (NavTreeNode)sourceNode.getParent();
                if (parent == targetNode) {
                    this.reset();
                    this.logger.info(this.context.cfg.gs("NavTransferHandler.action.cancelled"));
                    this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("NavTransferHandler.action.cancelled"));
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("NavTransferHandler.source.target.are.the.same"), this.context.cfg.getNavigatorName(), 0);
                    return false;
                }
                if (sourceTuo.type == 6) {
                    if (sourceTuo.isDir) {
                        sourceNode.deepScanChildren(true);
                        count += sourceNode.deepGetFileCount();
                        size += sourceNode.deepGetFileSize();
                        continue;
                    }
                    ++count;
                    size += sourceTuo.size;
                    continue;
                }
                this.reset();
                this.logger.warn(this.context.cfg.gs("NavTransferHandler.action.cancelled"));
                this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("NavTransferHandler.action.cancelled"));
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("NavTransferHandler.cannot.transfer") + sourceTuo.getType(), this.context.cfg.getNavigatorName(), 0);
                return false;
            }
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            for (NavTreeUserObject tuo : this.actionList) {
                if (!this.context.navigator.checkForConflicts(tuo, this.getOperationText(this.action, true))) continue;
                this.reset();
                return false;
            }
            int reply = 0;
            boolean bl = confirm = this.isDrop ? this.context.preferences.isShowDnDConfirmation() : this.context.preferences.isShowCcpConfirmation();
            if (confirm) {
                Object msg = MessageFormat.format(this.context.cfg.gs("NavTransferHandler.are.you.sure.you.want.to"), this.getOperationText(this.action, true), Utils.formatLong(size, false, this.context.cfg.getLongScale()), Utils.formatInteger(count), count > 1 ? 0 : 1, targetTuo.name);
                msg = (String)msg + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : "");
                reply = JOptionPane.showConfirmDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
            if (reply == 0) {
                this.filesToCopy = count;
                this.process(this.action, count, size, this.actionList, this.targetTree, targetTuo);
            }
            this.logger.trace("end of importData");
            if (!this.isDrop) {
                switch (this.action) {
                    case 2: {
                        this.logger.trace("Done MOVE");
                        break;
                    }
                    case 1: {
                        this.logger.trace("Done COPY");
                        break;
                    }
                    case 3: {
                        this.logger.trace("Done COPY_OR_MOVE");
                        break;
                    }
                    case 0: {
                        this.logger.trace("Done NONE");
                    }
                }
            }
            boolean indicator = reply == 0 && !this.context.fault;
            this.logger.trace("NavTransferHandler returning " + indicator);
            this.reset();
            return indicator;
        }
        catch (Exception e) {
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            this.logger.error(Utils.getStackTrace(e));
            this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Browser.error") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
            this.reset();
            return false;
        }
    }

    public boolean isTransferWorkerRunning() {
        return transferWorker != null ? transferWorker.isRunning() : false;
    }

    private void makeActionListFromPaths(TransferHandler.TransferSupport info) {
        DataFlavor[] flavors = info.getTransferable().getTransferDataFlavors();
        Transferable data = info.getTransferable();
        boolean typeFound = false;
        ArrayList<String> skipped = new ArrayList<String>();
        for (int index = 0; index < flavors.length; ++index) {
            String subType = flavors[index].getSubType();
            if (subType.equals("x-java-file-list")) {
                typeFound = true;
                try {
                    this.actionList = new ArrayList();
                    List fileList = (List)data.getTransferData(flavors[index]);
                    for (int i = 0; i < fileList.size(); ++i) {
                        File file = (File)fileList.get(i);
                        if (file != null) {
                            Path dfp;
                            DosFileAttributes dattr;
                            if (Utils.getOS().toLowerCase().equals("windows") && (dattr = Files.readAttributes(dfp = Paths.get(file.getPath(), new String[0]), DosFileAttributes.class, new LinkOption[0])).isSystem()) {
                                skipped.add(file.getPath());
                                continue;
                            }
                            NavTreeUserObject tuo = this.findSourceTuo(file.getPath());
                            if (tuo != null) {
                                this.actionList.add(tuo);
                                continue;
                            }
                            this.logger.warn(this.context.cfg.gs("Z.cannot.find") + file.getPath());
                            continue;
                        }
                        this.logger.warn(this.context.cfg.gs("NavTransferHandler.empty.element") + i);
                    }
                }
                catch (Exception e) {
                    this.actionList = null;
                    this.logger.error(Utils.getStackTrace(e));
                }
            }
            if (!typeFound) continue;
            for (String skip : skipped) {
                this.logger.warn(this.context.cfg.gs("NavTransferHandler.skipping.system.item") + skip);
            }
            break;
        }
        if (!typeFound) {
            this.actionList = null;
            this.logger.error(this.context.cfg.gs("NavTransferHandler.unsupported.flavor"));
        }
    }

    private void process(int action, int count, long size, ArrayList<NavTreeUserObject> transferData, JTree targetTree, NavTreeUserObject targetTuo) throws Exception {
        if (transferWorker == null || transferWorker.isDone()) {
            transferWorker = null;
            transferWorker = new NavTransferWorker(this.context);
        }
        transferWorker.addBatch(action, count, size, transferData, targetTree, targetTuo);
        if (!this.isTransferWorkerRunning()) {
            transferWorker.execute();
        }
    }

    public synchronized boolean removeDirectory(NavTreeUserObject sourceTuo) {
        boolean error;
        block6: {
            error = false;
            try {
                int childCount = sourceTuo.node.getChildCount(false, false);
                for (int i = 0; i < childCount; ++i) {
                    NavTreeNode child = (NavTreeNode)sourceTuo.node.getChildAt(i, false, false);
                    NavTreeUserObject childTuo = child.getUserObject();
                    if (childTuo.isDir) {
                        if (!this.removeDirectory(childTuo)) continue;
                        error = true;
                        break;
                    }
                    if (!this.removeFile(childTuo)) continue;
                    error = true;
                    break;
                }
                if (!error) {
                    Object msg = sourceTuo.isRemote ? this.context.cfg.gs("Z.remote.uppercase") : this.context.cfg.gs("NavTreeNode.local");
                    msg = (String)msg + MessageFormat.format(this.context.cfg.gs("NavTransferHandler.delete.directory.message"), this.context.cfg.isDryRun() ? 0 : 1, sourceTuo.path);
                    this.logger.info((String)msg);
                    if (!this.context.cfg.isDryRun()) {
                        this.context.transfer.remove(sourceTuo.path, sourceTuo.isRemote);
                    }
                }
            }
            catch (Exception e) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                this.logger.error(Utils.getStackTrace(e));
                this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                int reply = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("NavTransferHandler.delete.directory.error") + e.toString() + "\n\n" + this.context.cfg.gs("NavTransferHandler.continue"), this.context.cfg.getNavigatorName(), 0, 0);
                if (reply != 1) break block6;
                this.reset();
                error = true;
            }
        }
        return error;
    }

    public synchronized boolean removeFile(NavTreeUserObject sourceTuo) {
        boolean error;
        block5: {
            error = false;
            try {
                Object msg = sourceTuo.isRemote ? this.context.cfg.gs("Z.remote.uppercase") : this.context.cfg.gs("NavTreeNode.local");
                msg = (String)msg + MessageFormat.format(this.context.cfg.gs("NavTransferHandler.delete.file.message"), this.context.cfg.isDryRun() ? 0 : 1, sourceTuo.path);
                if (!this.context.cfg.isDryRun()) {
                    this.context.transfer.remove(sourceTuo.path, sourceTuo.isRemote);
                    this.logger.info((String)msg);
                }
            }
            catch (Exception e) {
                boolean skip = false;
                String en = e.getClass().getName();
                if (en.equals("com.jcraft.jsch.SftpException") && e.getMessage().contains("java.nio.file.NoSuchFileException")) {
                    skip = true;
                }
                if (en.equals("java.nio.file.NoSuchFileException")) {
                    skip = true;
                }
                if (skip) break block5;
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                this.logger.error(Utils.getStackTrace(e), (Object)true);
                this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                int reply = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("NavTransferHandler.delete.file.error") + e.toString() + "\n\n" + this.context.cfg.gs("NavTransferHandler.continue"), this.context.cfg.getNavigatorName(), 0, 0);
                if (reply != 1) break block5;
                this.reset();
                error = true;
            }
        }
        return error;
    }

    private void reset() {
        this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        this.action = 0;
        this.actionList = null;
        this.isDrop = false;
        this.isRemote = false;
        this.sourceTree = null;
        this.sourceTable = null;
        this.targetTree = null;
        this.targetTable = null;
    }

    public class FileTransferable
    implements Transferable {
        private List listOfFiles;

        public FileTransferable(NavTransferHandler this$0, List listOfFiles) {
            this.listOfFiles = listOfFiles;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.listOfFiles;
            }
            return null;
        }
    }
}

