/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.jobs;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.Conflict;
import com.corionis.els.gui.util.DisableJListSelectionModel;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigModel
extends DefaultTableModel {
    private ArrayList<Conflict> conflicts = null;
    private Context context;
    private ConfigModel jobsConfigModel;
    private Logger logger = LogManager.getLogger("applog");
    private AbstractToolDialog theDialog;
    private ArrayList<AbstractTool> toolList = null;

    public ConfigModel(Context context, AbstractToolDialog toolDialog) {
        this.context = context;
        this.theDialog = toolDialog;
    }

    public int checkJobConflicts(String oldName, String newName, String internalName, boolean isRename) {
        int answer = 0;
        JList conflictJList = new JList();
        try {
            int count = this.getJobReferences(oldName, newName, internalName);
            if (count > 0) {
                answer = -1;
                ArrayList<String> conflictNames = new ArrayList<String>();
                for (Conflict conflict : this.conflicts) {
                    conflictNames.add(conflict.toString(this.context));
                }
                Collections.sort(conflictNames);
                DefaultListModel<String> dialogList = new DefaultListModel<String>();
                for (String name : conflictNames) {
                    dialogList.addElement(name);
                }
                conflictJList.setModel(dialogList);
                conflictJList.setSelectionModel(new DisableJListSelectionModel());
                String string = MessageFormat.format(this.context.cfg.gs("Jobs.references.for.found.in.jobs"), oldName);
                JScrollPane pane = new JScrollPane();
                pane.setViewportView(conflictJList);
                String question = this.context.cfg.gs(isRename ? "Rename" : "Delete") + this.context.cfg.gs("LibraryUI.the.listed.references");
                Object[] params = new Object[]{string, pane, question};
                int opt = JOptionPane.showConfirmDialog(this.theDialog, params, this.theDialog.getTitle(), 2);
                if (opt == 0) {
                    answer = 1;
                    this.processJobConflicts();
                }
            }
        }
        catch (Exception e) {
            answer = -1;
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this.theDialog, msg, this.theDialog.getTitle(), 0);
        }
        return answer;
    }

    public AbstractTool find(String configName, AbstractTool tool) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((AbstractTool)this.getValueAt(i, 0)).getConfigName().equalsIgnoreCase(configName)) continue;
            AbstractTool value = (AbstractTool)this.getValueAt(i, 0);
            if (tool != null && tool == value) continue;
            return value;
        }
        return null;
    }

    private String getFullJobPath(Job job) {
        String path = job.getDirectoryPath() + System.getProperty("file.separator") + Utils.scrubFilename(job.getConfigName()) + ".json";
        return path;
    }

    public ConfigModel getJobsConfigModel() {
        return this.jobsConfigModel;
    }

    private int getJobReferences(String oldName, String newName, String internalName) {
        int count = 0;
        this.conflicts = new ArrayList();
        for (int i = 0; i < this.jobsConfigModel.getRowCount(); ++i) {
            Job job = (Job)this.jobsConfigModel.getValueAt(i, 0);
            for (int j = 0; j < job.getTasks().size(); ++j) {
                Task task = job.getTasks().get(j);
                if (!task.getConfigName().equals(oldName) || !task.getInternalName().equals(internalName)) continue;
                Conflict conflict = new Conflict();
                conflict.job = job;
                conflict.newName = newName;
                conflict.taskNumber = j;
                this.conflicts.add(conflict);
                ++count;
            }
        }
        return count;
    }

    public ConfigModel loadJobsConfigurations(AbstractToolDialog theDialog, ConfigModel configJobsModel) {
        Job tmpJob;
        File jobsDir;
        if (configJobsModel == null) {
            configJobsModel = new ConfigModel(this.context, theDialog);
            configJobsModel.setColumnCount(1);
            this.jobsConfigModel = configJobsModel;
        }
        if ((jobsDir = new File((tmpJob = new Job(this.context, "temp")).getDirectoryPath())).exists()) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new Job(ConfigModel.this.context, "");
                }
            }
            builder.registerTypeAdapter((Type)((Object)Job.class), new ObjInstanceCreator());
            ArrayList<Job> jobsArray = new ArrayList<Job>();
            File[] files = FileSystemView.getFileSystemView().getFiles(jobsDir, true);
            for (File entry : files) {
                if (entry.isDirectory()) continue;
                try {
                    Job job;
                    String json = new String(Files.readAllBytes(Paths.get(entry.getCanonicalPath(), new String[0])));
                    if (json == null || json.length() <= 0 || (job = builder.create().fromJson(json, Job.class)) == null || this.toolList == null) continue;
                    ArrayList<Task> tasks = job.getTasks();
                    for (int i = 0; i < tasks.size(); ++i) {
                        Task task = tasks.get(i);
                        AbstractTool tool = this.context.tools.getTool(task.getInternalName(), task.getConfigName());
                        if (tool == null) continue;
                        task.setContext(this.context);
                        tasks.set(i, task);
                    }
                    jobsArray.add(job);
                }
                catch (Exception e) {
                    String msg = this.context.cfg.gs("Z.exception") + entry.getName() + " " + Utils.getStackTrace(e);
                    this.logger.error(msg);
                    JOptionPane.showMessageDialog(theDialog, msg, theDialog.getTitle(), 0);
                }
            }
            Collections.sort(jobsArray);
            for (Job job : jobsArray) {
                configJobsModel.addRow(new Object[]{job});
            }
        }
        return configJobsModel;
    }

    private void processJobConflicts() {
        for (Conflict conflict : this.conflicts) {
            Job job = (Job)conflict.job;
            if (conflict.newName == null) {
                job.getTasks().remove(conflict.taskNumber);
            } else {
                Task task = job.getTasks().get(conflict.taskNumber);
                task.setContext(this.context);
                task.setConfigName(conflict.newName);
            }
            job.setDataHasChanged();
        }
    }

    public boolean saveJobsConfigurations(ConfigModel configJobsModel) {
        boolean changed = false;
        Job job = null;
        try {
            if (configJobsModel == null) {
                configJobsModel = this.jobsConfigModel;
            }
            for (int i = 0; i < configJobsModel.getRowCount(); ++i) {
                job = (Job)configJobsModel.getValueAt(i, 0);
                if (!job.isDataChanged()) continue;
                String status = job.validate(this.context.cfg, false);
                if (status.length() > 0) {
                    JOptionPane.showMessageDialog(this.theDialog, status, this.theDialog.getTitle(), 2);
                }
                this.writeJob(job);
                changed = true;
                job.setDataHasChanged(false);
            }
            if (changed) {
                this.context.navigator.loadJobsMenu();
                this.context.libraries.loadJobs();
            }
        }
        catch (Exception e) {
            String name = job != null ? job.getConfigName() + " " : " ";
            this.logger.error(Utils.getStackTrace(e));
            JOptionPane.showMessageDialog(this.theDialog, this.context.cfg.gs("Z.error.writing") + name + e.getMessage(), this.theDialog.getTitle(), 0);
        }
        return true;
    }

    public void setJobsConfigModel(ConfigModel jobsConfigModel) {
        this.jobsConfigModel = jobsConfigModel;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        this.updateConfigName((String)object, row);
    }

    protected void updateConfigName(String newName, int index) {
        if (index >= 0) {
            String scrubbed = Utils.scrubFilename(newName);
            if (!newName.equals(scrubbed)) {
                JOptionPane.showMessageDialog(this.theDialog, this.context.cfg.gs(this.context.cfg.gs("JobsUI.job.name.may.not.contain.these.characters")), this.theDialog.getTitle(), 2);
                this.theDialog.getConfigItems().requestFocus();
                this.theDialog.getConfigItems().changeSelection(index, 0, false, false);
                return;
            }
            AbstractTool tool = (AbstractTool)this.getValueAt(index, 0);
            if (tool != null) {
                Job tmp = (Job)this.find(newName, tool);
                if (tmp != null) {
                    JOptionPane.showMessageDialog(this.theDialog, this.context.cfg.gs("Z.that.configuration.already.exists"), this.theDialog.getTitle(), 2);
                } else if (!tool.getConfigName().equals(newName)) {
                    int answer = this.checkJobConflicts(tool.getConfigName(), newName, tool.getInternalName(), true);
                    if (answer >= 0) {
                        File file;
                        boolean restored = false;
                        for (AbstractTool deletedTool : this.theDialog.getDeletedTools()) {
                            if (!deletedTool.getConfigName().equals(newName)) continue;
                            this.theDialog.getDeletedTools().remove(deletedTool);
                            restored = true;
                            break;
                        }
                        if (!restored && (file = new File(tool.getFullPath())).exists()) {
                            this.theDialog.getDeletedTools().add((AbstractTool)tool.clone());
                        }
                        tool.setConfigName(newName);
                        tool.setDataHasChanged();
                        this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                    } else {
                        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.rename") + this.context.cfg.gs("Z.cancelled"));
                    }
                }
            }
        }
        this.theDialog.getConfigItems().requestFocus();
        this.theDialog.getConfigItems().changeSelection(index, 0, false, false);
    }

    public void setToolList(ArrayList<AbstractTool> toolList) {
        this.toolList = toolList;
    }

    private void writeJob(Job job) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(job);
        try {
            File f = new File(this.getFullJobPath(job));
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullJobPath(job));
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.context.cfg.gs("Z.error.writing") + this.getFullJobPath(job) + ": " + Utils.getStackTrace(fnf));
        }
    }
}

