/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.libraries;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.jobs.Conflict;
import com.corionis.els.gui.libraries.LibrariesUI;
import com.corionis.els.gui.util.DisableJListSelectionModel;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Task;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigModel
extends DefaultTableModel {
    private ArrayList<Conflict> conflicts = null;
    private Context context;
    private String displayName;
    private LibrariesUI librariesUI;
    private Logger logger = LogManager.getLogger("applog");

    public ConfigModel(Context context, String displayName, LibrariesUI librariesUI) {
        this.context = context;
        this.displayName = displayName;
        this.librariesUI = librariesUI;
    }

    public int checkJobConflicts(String oldName, String newName, boolean isRename) {
        int answer = 0;
        JList conflictJList = new JList();
        try {
            int count = this.getJobPathReferences(oldName, newName);
            if (count > 0) {
                answer = -1;
                ArrayList<String> conflictNames = new ArrayList<String>();
                for (Conflict conflict : this.conflicts) {
                    conflictNames.add(conflict.toString(this.context));
                }
                Collections.sort(conflictNames);
                DefaultListModel<String> dialogList = new DefaultListModel<String>();
                for (String name : conflictNames) {
                    dialogList.addElement(name);
                }
                conflictJList.setModel(dialogList);
                conflictJList.setSelectionModel(new DisableJListSelectionModel());
                String string = MessageFormat.format(this.context.cfg.gs("LibraryUI.references.for.library.found.in.jobs"), oldName);
                JScrollPane pane = new JScrollPane();
                pane.setViewportView(conflictJList);
                String question = (isRename ? this.context.cfg.gs("LibraryUI.rename") : this.context.cfg.gs("LibraryUI.delete")) + this.context.cfg.gs("LibraryUI.the.listed.references");
                Object[] params = new Object[]{string, pane, question};
                int opt = JOptionPane.showConfirmDialog(this.context.mainFrame, params, this.librariesUI.displayName, 2);
                if (opt == 0) {
                    answer = 1;
                    this.processJobConflicts();
                }
            }
        }
        catch (Exception e) {
            answer = -1;
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.librariesUI.displayName, 0);
        }
        return answer;
    }

    public LibrariesUI.LibMeta findMeta(String configName, LibrariesUI.LibMeta myMeta) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            LibrariesUI.LibMeta libMeta = (LibrariesUI.LibMeta)this.getValueAt(i, 0);
            if (!libMeta.description.equalsIgnoreCase(configName) || libMeta != null && libMeta == myMeta) continue;
            return libMeta;
        }
        return null;
    }

    public int findIndex(LibrariesUI.LibMeta myMeta) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            LibrariesUI.LibMeta libMeta = (LibrariesUI.LibMeta)this.getValueAt(i, 0);
            if (!libMeta.path.equals(myMeta.path)) continue;
            return i;
        }
        return -1;
    }

    private int getJobPathReferences(String oldName, String newName) {
        int count = 0;
        this.conflicts = new ArrayList();
        String oldCompare = oldName + ".json";
        for (int i = 0; i < this.librariesUI.getJobsList().size(); ++i) {
            Job job = (Job)this.librariesUI.getJobsList().get(i);
            for (int j = 0; j < job.getTasks().size(); ++j) {
                Task task = job.getTasks().get(j);
                if (!task.getPublisherPath().endsWith(oldCompare) && !task.getSubscriberPath().endsWith(oldCompare) && !task.getHintsPath().endsWith(oldCompare)) continue;
                Conflict conflict = new Conflict();
                conflict.job = job;
                conflict.oldName = oldName;
                conflict.newName = newName;
                conflict.taskNumber = j;
                this.conflicts.add(conflict);
                ++count;
            }
        }
        return count;
    }

    private void processJobConflicts() {
        for (Conflict conflict : this.conflicts) {
            Job job = (Job)conflict.job;
            if (conflict.newName == null) {
                task = job.getTasks().get(conflict.taskNumber);
                task.setContext(this.context);
                oldCompare = conflict.oldName + ".json";
                if (task.getPublisherPath().endsWith(oldCompare)) {
                    task.setPublisherKey("");
                    task.setPublisherPath("");
                }
                if (task.getSubscriberPath().endsWith(oldCompare)) {
                    task.setSubscriberKey("");
                    task.setSubscriberPath("");
                    task.setSubscriberRemote(false);
                    task.setSubscriberOverride("");
                }
                if (task.getHintsPath().endsWith(oldCompare)) {
                    task.setHintsKey("");
                    task.setHintsPath("");
                    task.setHintsRemote(false);
                    task.setHintsOverrideHost(false);
                }
            } else {
                task = job.getTasks().get(conflict.taskNumber);
                task.setContext(this.context);
                oldCompare = conflict.oldName + ".json";
                if (task.getPublisherPath().endsWith(oldCompare)) {
                    task.setPublisherPath(this.swapNames(task.getPublisherPath(), oldCompare, conflict.newName));
                }
                if (task.getSubscriberPath().endsWith(oldCompare)) {
                    task.setSubscriberPath(this.swapNames(task.getSubscriberPath(), oldCompare, conflict.newName));
                }
                if (task.getHintsPath().endsWith(oldCompare)) {
                    task.setHintsPath(this.swapNames(task.getHintsPath(), oldCompare, conflict.newName));
                }
            }
            job.setDataHasChanged();
        }
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        this.updateListName((String)object, row);
    }

    private String swapNames(String path, String oldCompare, String newName) {
        int pos = ((String)path).length() - oldCompare.length();
        path = ((String)path).substring(0, pos) + newName + ".json";
        return path;
    }

    private void updateListName(String name, int index) {
        LibrariesUI.LibMeta libMeta;
        if (index >= 0 && index < this.getRowCount() && (libMeta = (LibrariesUI.LibMeta)this.getValueAt(index, 0)) != null) {
            LibrariesUI.LibMeta tmp = this.findMeta(name, libMeta);
            if (tmp != null && !tmp.repo.isDynamic()) {
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.that.configuration.already.exists"), this.displayName, 2);
            } else if (!libMeta.description.equals(name)) {
                int answer = this.checkJobConflicts(libMeta.description, name, true);
                if (answer >= 0) {
                    Object jfn;
                    File file;
                    boolean restored = false;
                    for (LibrariesUI.LibMeta deletedLib : this.librariesUI.getDeletedLibraries()) {
                        if (!deletedLib.description.equals(name)) continue;
                        this.librariesUI.getDeletedLibraries().remove(deletedLib);
                        restored = true;
                        break;
                    }
                    if (!restored && (file = new File(libMeta.path)).exists()) {
                        this.librariesUI.getDeletedLibraries().add(libMeta.clone());
                    }
                    libMeta.description = name;
                    libMeta.repo.getLibraryData().libraries.description = name;
                    if (libMeta.repo.getJsonFilename() != null && libMeta.repo.getJsonFilename().length() > 0) {
                        jfn = libMeta.repo.getJsonFilename();
                        int sepPos = ((String)jfn).lastIndexOf("/");
                        if (sepPos < 0) {
                            sepPos = ((String)jfn).lastIndexOf("\\");
                        }
                        jfn = sepPos >= 0 ? ((String)jfn).substring(0, sepPos + 1) + name + ".json" : this.librariesUI.getDirectoryPath() + System.getProperty("file.separator") + libMeta.description + ".json";
                    } else {
                        jfn = this.librariesUI.getDirectoryPath() + System.getProperty("file.separator") + libMeta.description + ".json";
                    }
                    libMeta.repo.setJsonFilename((String)jfn);
                    libMeta.path = jfn;
                    libMeta.setDataHasChanged();
                } else {
                    this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.rename") + this.context.cfg.gs("Z.cancelled"));
                }
            }
        }
        this.context.mainFrame.librariesConfigItems.requestFocus();
        this.context.mainFrame.librariesConfigItems.changeSelection(index, 0, false, false);
    }
}

