/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.cleanup;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.util.NumberFilter;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Origins;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.cleanup.CleanupTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.PlainDocument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanupUI
extends AbstractToolDialog {
    private ConfigModel configModel;
    private Context context;
    private CleanupTool currentTool = null;
    private NavHelp helpDialog;
    private boolean inUpdateOnChange = false;
    private boolean loading = false;
    private Logger logger = LogManager.getLogger("applog");
    private CleanupUI me;
    private SwingWorker<Void, Void> worker;
    private CleanupTool workerTool = null;
    private boolean workerRunning = false;
    private Task workerTask = null;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panelTop;
    private JPanel panelTopButtons;
    private JButton buttonNew;
    private JButton buttonCopy;
    private JButton buttonDelete;
    private JPanel hSpacerBeforeRun;
    private JButton buttonRun;
    private JPanel panelHelp;
    private JLabel labelHelp;
    private JSplitPane splitPaneContent;
    private JScrollPane scrollPaneConfig;
    private JTable configItems;
    private JPanel panelOptions;
    private JScrollPane scrollPaneOptions;
    private JPanel panelCleanup;
    private JLabel labelPanelTitle;
    private JLabel labelAge;
    private JTextField textFieldMaxAge;
    private JPanel panelOptionsButtons;
    private JPanel buttonBar;
    public JLabel labelStatus;
    private JButton saveButton;
    private JButton cancelButton;

    public CleanupUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.me = this;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsCleanupXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsCleanupXpos(), context.preferences.getToolsCleanupYpos())) {
            this.setLocation(context.preferences.getToolsCleanupXpos(), context.preferences.getToolsCleanupYpos());
            Dimension dim = new Dimension(context.preferences.getToolsCleanupWidth(), context.preferences.getToolsCleanupHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        this.splitPaneContent.setDividerLocation(context.preferences.getToolsCleanupDividerLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CleanupUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        PlainDocument pd = (PlainDocument)this.textFieldMaxAge.getDocument();
        pd.setDocumentFilter(new NumberFilter());
        this.configModel = new ConfigModel(context, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneConfig.setColumnHeaderView(null);
        this.loadConfigurations();
        context.navigator.enableDisableToolMenus(this, false);
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.workerRunning && this.workerTool != null) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Cleanup.stop.running"), "Z.cancel.run", 0);
            if (reply == 0) {
                this.workerTool.requestStop();
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Cleanup.config.cancelled"), this.workerTool.getConfigName()));
            }
        } else if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            CleanupTool origTool = (CleanupTool)this.configModel.getValueAt(index, 0);
            String rename = origTool.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                CleanupTool tool = origTool.clone();
                tool.setConfigName(rename);
                tool.setDataHasChanged();
                this.configModel.addRow(new Object[]{tool});
                this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
                this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.context.cfg.gs("CleanupUI.title"), 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            CleanupTool tool = (CleanupTool)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + tool.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(tool.getConfigName(), null, tool.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(tool.getFullPath());
                    if (file.exists()) {
                        this.deletedTools.add(tool);
                    }
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    this.configModel.fireTableDataChanged();
                    if (index >= 0) {
                        this.configItems.changeSelection(index, 0, false, false);
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("Cleanup.help"), "cleanup_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            CleanupTool tool = new CleanupTool(this.context);
            tool.setConfigName(this.context.cfg.gs("Z.untitled"));
            tool.setDataHasChanged();
            this.configModel.addRow(new Object[]{tool});
            if (this.configModel.getRowCount() > 0) {
                this.loadTool(this.configItems.getRowCount() - 1);
                this.buttonCopy.setEnabled(true);
                this.buttonDelete.setEnabled(true);
                this.buttonRun.setEnabled(true);
            }
            this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
            this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
            this.configItems.getEditorComponent().requestFocus();
            ((JTextField)this.configItems.getEditorComponent()).selectAll();
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.context.cfg.gs("CleanupUI.title"), 2);
        }
    }

    private void actionRunClicked(ActionEvent e) {
        block10: {
            int index = this.configItems.getSelectedRow();
            if (index >= 0) {
                try {
                    final ArrayList<Origin> origins = new ArrayList<Origin>();
                    boolean isSubscriber = Origins.makeOriginsFromSelected(this.context, this, origins);
                    if (isSubscriber) {
                        JOptionPane.showMessageDialog(this, this.context.cfg.gs(this.context.cfg.gs("Z.this.tool.is.for.the.local.publisher.only")), this.context.cfg.gs("CleanupUI.title"), 2);
                        return;
                    }
                    int count = origins.size();
                    if (origins != null && origins.size() > 0) {
                        final CleanupTool tool = (CleanupTool)this.configModel.getValueAt(index, 0);
                        if (tool.isDataChanged()) {
                            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.save.then.run"), this.context.cfg.gs("CleanupUI.title"), 2);
                            return;
                        }
                        String which = this.context.cfg.gs("Z.publisher");
                        String message = MessageFormat.format(this.context.cfg.gs("Cleanup.run.on.N.locations"), tool.getConfigName(), count, which);
                        Object[] params = new Object[]{message};
                        int reply = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("CleanupUI.title"), 0);
                        if (reply == 0) {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.setComponentEnabled(false);
                            this.cancelButton.setEnabled(true);
                            this.cancelButton.setCursor(Cursor.getPredefinedCursor(0));
                            this.labelHelp.setEnabled(true);
                            this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
                            this.worker = new SwingWorker<Void, Void>(){

                                @Override
                                protected Void doInBackground() throws Exception {
                                    block3: {
                                        try {
                                            CleanupUI.this.workerTool = tool.clone();
                                            CleanupUI.this.processSelected(CleanupUI.this.workerTool, origins);
                                        }
                                        catch (Exception e) {
                                            if (e.getMessage().equals("HANDLED_INTERNALLY")) break block3;
                                            String msg = CleanupUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                            if (CleanupUI.this.context != null) {
                                                CleanupUI.this.logger.error(msg);
                                                JOptionPane.showMessageDialog(CleanupUI.this.me, msg, CleanupUI.this.context.cfg.gs("CleanupUI.title"), 0);
                                            }
                                            CleanupUI.this.logger.error(msg);
                                        }
                                    }
                                    return null;
                                }
                            };
                            if (this.worker != null) {
                                this.workerRunning = true;
                                this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent e) {
                                        if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                            CleanupUI.this.processTerminated();
                                        }
                                    }
                                });
                                this.worker.execute();
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, this.context.cfg.gs("Cleanup.nothing.selected.in.browser"), this.context.cfg.gs("CleanupUI.title"), 2);
                    }
                }
                catch (Exception e1) {
                    if (e1.getMessage().equals("HANDLED_INTERNALLY")) break block10;
                    String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e1);
                    if (this.context != null) {
                        this.logger.error(msg);
                        JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("CleanupUI.title"), 0);
                    }
                    this.logger.error(msg);
                }
            }
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        if (this.saveConfigurations()) {
            this.savePreferences();
            this.setVisible(false);
        }
    }

    public void cancelChanges() {
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((CleanupTool)this.configModel.getValueAt(i, 0)).reset();
            ((CleanupTool)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((CleanupTool)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private void configItemsMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            int index = this.configItems.getSelectedRow();
            this.loadTool(index);
        }
    }

    public void genericAction(ActionEvent e) {
        this.updateOnChange(e.getSource());
    }

    public void genericTextFieldFocusLost(FocusEvent e) {
        this.updateOnChange(e.getSource());
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    private void loadConfigurations() {
        ArrayList<AbstractTool> toolList = null;
        try {
            toolList = this.context.tools.loadAllTools(this.context, "Cleanup");
            for (AbstractTool tool : toolList) {
                CleanupTool cleanupTool = (CleanupTool)tool;
                this.configModel.addRow(new Object[]{cleanupTool});
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("CleanupUI.title"), 0);
            }
            this.logger.error(msg);
        }
        this.configModel.setToolList(toolList);
        this.configModel.loadJobsConfigurations(this, null);
        if (this.configModel.getRowCount() == 0) {
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonRun.setEnabled(false);
        } else {
            this.loadTool(0);
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
        }
    }

    private void loadTool(int index) {
        if (index >= 0 && index < this.configModel.getRowCount()) {
            this.currentTool = (CleanupTool)this.configModel.getValueAt(index, 0);
            this.textFieldMaxAge.setText(String.valueOf(this.currentTool.getAge()));
            this.textFieldMaxAge.setEnabled(true);
            this.buttonCopy.setEnabled(true);
            this.buttonDelete.setEnabled(true);
            this.buttonRun.setEnabled(true);
        } else {
            this.currentTool = null;
            this.textFieldMaxAge.setEnabled(false);
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonRun.setEnabled(false);
            this.labelStatus.setText("  ");
        }
    }

    private void processSelected(CleanupTool tool, ArrayList<Origin> origins) throws Exception {
        if (tool != null && origins != null && origins.size() > 0) {
            this.workerTask = new Task(tool.getInternalName(), tool.getConfigName());
            this.workerTask.setContext(tool.getContext());
            this.workerTask.setOrigins(origins);
            this.workerTask.setPublisherKey("_ANY_SERVER_");
            this.workerTask.process(this.context);
        }
    }

    private void processTerminated() {
        Origins.setSelectedFromOrigins(this.context, this, this.workerTask.getOrigins());
        this.setComponentEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.workerTool.isRequestStop()) {
            this.logger.info(this.workerTool.getConfigName() + this.context.cfg.gs("Z.cancelled"));
            this.labelStatus.setText(this.workerTool.getConfigName() + this.context.cfg.gs("Z.cancelled"));
        }
        this.workerRunning = false;
        this.workerTool = null;
    }

    private boolean saveConfigurations() {
        CleanupTool tool = null;
        try {
            int i;
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (CleanupTool)this.configModel.getValueAt(i, 0);
                if (tool.getAge() >= 0) continue;
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("CleanupUI.bad.value"), this.context.cfg.gs("CleanupUI.title"), 2);
                this.configItems.setRowSelectionInterval(i, i);
                this.loadTool(i);
                return false;
            }
            for (i = 0; i < this.deletedTools.size(); ++i) {
                tool = (CleanupTool)this.deletedTools.get(i);
                File file = new File(tool.getFullPath());
                if (!file.exists()) continue;
                file.delete();
            }
            this.deletedTools = new ArrayList();
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (CleanupTool)this.configModel.getValueAt(i, 0);
                if (tool.isDataChanged()) {
                    tool.write();
                }
                tool.setDataHasChanged(false);
            }
            this.configModel.saveJobsConfigurations(null);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("CleanupUI.title"), 0);
            }
            this.logger.error(msg);
        }
        return true;
    }

    private void savePreferences() {
        this.context.preferences.setToolsCleanupHeight(this.getHeight());
        this.context.preferences.setToolsCleanupWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsCleanupXpos(location.x);
        this.context.preferences.setToolsCleanupYpos(location.y);
        this.context.preferences.setToolsCleanupDividerLocation(this.splitPaneContent.getDividerLocation());
    }

    public void setComponentEnabled(boolean enabled) {
        this.setComponentEnabled(enabled, this.getContentPane());
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        component.setEnabled(enabled);
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component comp : components) {
                this.setComponentEnabled(enabled, comp);
            }
        }
    }

    private void updateOnChange(Object source) {
        if (this.inUpdateOnChange || this.loading) {
            return;
        }
        this.inUpdateOnChange = true;
        String name = null;
        if (source != null && this.currentTool != null && !this.loading) {
            String current = "";
            String value = "";
            if (source instanceof JTextField) {
                JTextField tf = (JTextField)source;
                name = tf.getName();
                switch (name.toLowerCase()) {
                    case "age": {
                        current = String.valueOf(this.currentTool.getAge());
                        value = tf.getText();
                        this.currentTool.setAge(Integer.parseInt(value));
                    }
                }
            }
            if (!current.equals(value)) {
                this.currentTool.setDataHasChanged();
            }
        }
        this.inUpdateOnChange = false;
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void windowHidden(ComponentEvent e) {
        this.context.navigator.enableDisableToolMenus(this, true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.hSpacerBeforeRun = new JPanel(null);
        this.buttonRun = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.splitPaneContent = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.configItems = new JTable();
        this.panelOptions = new JPanel();
        this.scrollPaneOptions = new JScrollPane();
        this.panelCleanup = new JPanel();
        this.labelPanelTitle = new JLabel();
        this.labelAge = new JLabel();
        this.textFieldMaxAge = new JTextField();
        this.panelOptionsButtons = new JPanel();
        this.buttonBar = new JPanel();
        this.labelStatus = new JLabel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.context.cfg.gs("CleanupUI.title"));
        this.setName("cleanupUI");
        this.setMinimumSize(new Dimension(150, 126));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CleanupUI.this.windowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                CleanupUI.this.windowHidden(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNew.setText(this.context.cfg.gs("CleanupUI.buttonNew.text"));
        this.buttonNew.setMnemonic(this.context.cfg.gs("CleanupUI.buttonNew.mnemonic").charAt(0));
        this.buttonNew.setToolTipText(this.context.cfg.gs("CleanupUI.buttonNew.toolTipText"));
        this.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("CleanupUI.buttonCopy.text"));
        this.buttonCopy.setMnemonic(this.context.cfg.gs("CleanupUI.buttonCopy.mnemonic").charAt(0));
        this.buttonCopy.setToolTipText(this.context.cfg.gs("CleanupUI.buttonCopy.toolTipText"));
        this.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("CleanupUI.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("CleanupUI.buttonDelete.mnemonic").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("CleanupUI.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.hSpacerBeforeRun.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeRun.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeRun);
        this.buttonRun.setText(this.context.cfg.gs("CleanupUI.buttonRun.text"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("CleanupUI.buttonRun.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("CleanupUI.buttonRun.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("CleanupUI.labelHelp.toolTipText"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CleanupUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "East");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.splitPaneContent.setDividerLocation(142);
        this.splitPaneContent.setLastDividerLocation(142);
        this.splitPaneContent.setMinimumSize(new Dimension(140, 80));
        this.scrollPaneConfig.setMinimumSize(new Dimension(140, 16));
        this.scrollPaneConfig.setPreferredSize(new Dimension(142, 146));
        this.configItems.setSelectionMode(0);
        this.configItems.setShowVerticalLines(false);
        this.configItems.setFillsViewportHeight(true);
        this.configItems.setShowHorizontalLines(false);
        this.configItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CleanupUI.this.configItemsMouseClicked(e);
            }
        });
        this.scrollPaneConfig.setViewportView(this.configItems);
        this.splitPaneContent.setLeftComponent(this.scrollPaneConfig);
        this.panelOptions.setMinimumSize(new Dimension(0, 78));
        this.panelOptions.setLayout(new BorderLayout());
        this.panelCleanup.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelCleanup.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelCleanup.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.labelPanelTitle.setText(this.context.cfg.gs("CleanupUI.labelPanelTitle.text"));
        this.labelPanelTitle.setFont(this.labelPanelTitle.getFont().deriveFont(this.labelPanelTitle.getFont().getStyle() | 1, (float)this.labelPanelTitle.getFont().getSize() + 1.0f));
        this.panelCleanup.add((Component)this.labelPanelTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 0, 6, 4), 0, 0));
        this.labelAge.setText(this.context.cfg.gs("CleanupUI.labelAge.text"));
        this.panelCleanup.add((Component)this.labelAge, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 16), 0, 0));
        this.textFieldMaxAge.setPreferredSize(new Dimension(64, 34));
        this.textFieldMaxAge.setMinimumSize(new Dimension(64, 34));
        this.textFieldMaxAge.setName("age");
        this.textFieldMaxAge.addActionListener(e -> this.genericAction(e));
        this.textFieldMaxAge.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CleanupUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelCleanup.add((Component)this.textFieldMaxAge, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.scrollPaneOptions.setViewportView(this.panelCleanup);
        this.panelOptions.add((Component)this.scrollPaneOptions, "Center");
        this.panelOptionsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.panelOptions.add((Component)this.panelOptionsButtons, "South");
        this.splitPaneContent.setRightComponent(this.panelOptions);
        this.contentPanel.add((Component)this.splitPaneContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.buttonBar.add((Component)this.labelStatus, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.saveButton.setText(this.context.cfg.gs("CleanupUI.saveButton.text"));
        this.saveButton.setToolTipText(this.context.cfg.gs("CleanupUI.button.save.toolTipText"));
        this.saveButton.setMnemonic('S');
        this.saveButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("CleanupUI.cancelButton.text"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("CleanupUI.button.cancel.tooltip"));
        this.cancelButton.setMnemonic('L');
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

