/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.duplicateFinder;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.browser.DateColumn;
import com.corionis.els.gui.browser.SizeColumn;
import com.corionis.els.gui.tools.duplicateFinder.Dupe;
import com.corionis.els.repository.Item;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;

public class DupesTableModel
extends DefaultTableModel {
    private Context context;
    private ArrayList<Dupe> dupes;

    public DupesTableModel(Context context, ArrayList<Dupe> dupes) {
        this.context = context;
        this.dupes = dupes;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return SizeColumn.class;
            }
            case 2: {
                return DateColumn.class;
            }
            case 3: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Duplicates";
            }
            case 1: {
                return this.context.cfg.gs("BrowserTable.column.size");
            }
            case 2: {
                return this.context.cfg.gs("BrowserTable.column.modified");
            }
            case 3: {
                return this.context.cfg.gs("DuplicateFinder.action");
            }
        }
        return this.context.cfg.gs("NavTreeNode.unknown");
    }

    @Override
    public int getRowCount() {
        return this.dupes == null ? 0 : this.dupes.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.dupes != null && this.dupes.get((int)row).item != null) {
            Dupe dupe = this.dupes.get(row);
            Item item = dupe.item;
            if (column == 0) {
                if (dupe.isTop) {
                    String name = item.getItemShortName() == null || item.getItemShortName().length() == 0 ? Utils.getRightPath(item.getItemPath(), Utils.getSeparatorFromPath(item.getFullPath())) : item.getItemShortName();
                    return "<html><b>" + name + "</b></html>";
                }
                return "  " + item.getFullPath();
            }
            if (column == 1 && !dupe.isTop && !item.isDirectory()) {
                return new SizeColumn(item.getSize(), this.context.cfg.getLongScale());
            }
            if (column == 2 && !dupe.isTop) {
                return new DateColumn(this.context, item.getModifiedDate());
            }
            if (column == 3 && !dupe.isTop && dupe.item != null) {
                return dupe;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.dupes.get((int)row).item != null && col == 3;
    }

    public void setDupes(ArrayList<Dupe> dupes) {
        this.dupes = dupes;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        if (this.dupes != null) {
            // empty if block
        }
    }
}

