/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.renamer;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.tools.renamer.ChangesTableModel;
import com.corionis.els.gui.util.NumberFilter;
import com.corionis.els.gui.util.PathFilter;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Origins;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.renamer.RenamerTool;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.PlainDocument;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenamerUI
extends AbstractToolDialog {
    private String[] cardNames = new String[]{"cardCaseChange", "cardInsert", "cardNumbering", "cardRemove", "cardReplace"};
    private String caseChangeActions = "firstupper lower titlecase upper";
    private ChangesTableModel changeModel;
    private String[][] changeStrings;
    private ConfigModel configModel;
    private Context context;
    private JPanel currentCard = null;
    private int currentConfigIndex = -1;
    private RenamerTool currentRenamer = null;
    private String[] displayNames;
    private Logger logger = LogManager.getLogger("applog");
    private NavHelp helpDialog;
    private boolean isDryRun;
    private boolean isSubscriber;
    private boolean loading = false;
    private NumberFilter numberFilter;
    private PathFilter pathFilter;
    private SwingWorker<Void, Void> worker;
    private RenamerTool workerRenamer = null;
    private boolean workerRunning = false;
    private Task workerTask = null;
    public JPanel dialogPane;
    public JPanel contentPanel;
    public JPanel panelTop;
    public JPanel panelTopButtons;
    public JButton buttonNew;
    public JButton buttonCopy;
    public JButton buttonDelete;
    public JPanel hSpacerBeforeRun;
    public JButton buttonRun;
    public JPanel panelHelp;
    public JLabel labelHelp;
    public JSplitPane splitPaneContent;
    public JScrollPane scrollPaneConfig;
    public JTable configItems;
    public JPanel panelOptions;
    public JPanel panelControls;
    public JPanel topOptions;
    public JPanel vSpacer0;
    public JPanel panelRenameType;
    public JPanel hSpacer1;
    public JLabel labelRenameType;
    public JPanel panelCbOpts;
    public JCheckBox checkBoxRecursive;
    public JCheckBox checkBoxFilesOnly;
    public JPanel panelFilenameSegment;
    public JComboBox<String> comboBoxFilenameSegment;
    public JPanel hSpacer2;
    public JPanel panelCardBox;
    public JPanel vSpacer1;
    public JSeparator separator1;
    public JPanel vSpacer2;
    public JPanel panelOptionsCards;
    public JPanel panelGettingStarted;
    public JLabel labelOperationGettingStarted;
    public JPanel panelCaseChangeCard;
    public JRadioButton radioButtonFirstUpperCase;
    public JRadioButton radioButtonLowerCase;
    public JRadioButton radioButtonTitleCase;
    public JRadioButton radioButtonUpperCase;
    public JPanel panelInsertCard;
    public JLabel labelTextToInsert;
    public JTextField textFieldToInsert;
    public JLabel labelInsertPosition;
    public JPanel panelInsertPostion;
    public JTextField textFieldInsertPosition;
    public JPanel hSpacer3;
    public JCheckBox checkBoxInsertFromEnd;
    public JPanel hSpacer7;
    public JCheckBox checkBoxInsertAtEnd;
    public JPanel panelInsertOther;
    public JCheckBox checkBoxInsertOverwrite;
    public JPanel panelNumberingCard;
    public JLabel labelStart;
    public JPanel panelNums;
    public JTextField textFieldNumberingStart;
    public JPanel hSpacer5;
    public JLabel labelZeros;
    public JTextField textFieldNumberingZeros;
    public JLabel labelNumberingPosition;
    public JPanel panelNumberingPostion;
    public JTextField textFieldNumberingPosition;
    public JPanel hSpacer4;
    public JCheckBox checkBoxNumberingFromEnd;
    public JPanel hSpacer8;
    public JCheckBox checkBoxNumberingAtEnd;
    public JPanel panelNumberingOther;
    public JCheckBox checkBoxNumberingOverwrite;
    public JPanel panelRemoveCard;
    public JLabel labelFrom;
    public JPanel panelFrom;
    public JTextField textFieldFrom;
    public JPanel hSpacer6;
    public JLabel labelLength;
    public JPanel panelLength;
    public JTextField textFieldLength;
    public JPanel panelRemoveOther;
    public JCheckBox checkBoxRemoveFromEnd;
    public JPanel panelReplaceCard;
    public JLabel labelFind;
    public JTextField textFieldFind;
    public JLabel labeReplace;
    public JTextField textFieldReplace;
    public JPanel panelReplaceOther;
    public JCheckBox checkBoxRegularExpr;
    public JCheckBox checkBoxCase;
    public JScrollPane scrollPaneExamples;
    public JTable tableChanges;
    public JPanel panelOptionsButtons;
    public JButton buttonRefresh;
    public JPanel buttonBar;
    public JButton saveButton;
    public JButton cancelButton;
    public ButtonGroup buttonGroupChangeCase;

    public RenamerUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsRenamerXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsRenamerXpos(), context.preferences.getToolsRenamerYpos())) {
            this.setLocation(context.preferences.getToolsRenamerXpos(), context.preferences.getToolsRenamerYpos());
            Dimension dim = new Dimension(context.preferences.getToolsRenamerWidth(), context.preferences.getToolsRenamerHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        this.splitPaneContent.setDividerLocation(context.preferences.getToolsRenamerDividerLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenamerUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.configModel = new ConfigModel(context, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel sm;
                int index;
                if (!listSelectionEvent.getValueIsAdjusting() && (index = (sm = (ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex()) != RenamerUI.this.currentConfigIndex && RenamerUI.this.currentConfigIndex >= 0) {
                    RenamerUI.this.currentConfigIndex = index;
                    RenamerUI.this.loadOptions(RenamerUI.this.currentConfigIndex);
                    RenamerUI.this.updateState();
                    RenamerUI.this.processTable();
                }
            }
        });
        this.configItems.setTableHeader(null);
        this.panelControls.setBorder(this.scrollPaneExamples.getBorder());
        this.displayNames = new String[6];
        this.displayNames[0] = context.cfg.gs("RenameUI.type.combobox.0.case.change");
        this.displayNames[1] = context.cfg.gs("RenameUI.type.combobox.1.insert");
        this.displayNames[2] = context.cfg.gs("RenameUI.type.combobox.2.numbering");
        this.displayNames[3] = context.cfg.gs("RenameUI.type.combobox.3.remove");
        this.displayNames[4] = context.cfg.gs("RenameUI.type.combobox.4.replace");
        this.addHandlers();
        this.loadTable();
        this.loadConfigurations();
        this.numberFilter = new NumberFilter();
        this.pathFilter = new PathFilter();
        context.navigator.enableDisableToolMenus(this, false);
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.workerRunning && this.workerRenamer != null) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Renamer.stop.running.renamer"), "Z.cancel.run", 0);
            if (reply == 0) {
                this.workerRenamer.requestStop();
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Renamer.config.cancelled"), this.workerRenamer.getConfigName()));
            }
        } else if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void actionCaseChangeClicked(ActionEvent e) {
        if (e.getActionCommand() != null && this.currentRenamer != null && this.changeStrings != null && this.caseChangeActions.contains(e.getActionCommand())) {
            this.setRenamerOptions(this.currentRenamer);
            this.processTable();
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            RenamerTool origRenamer = (RenamerTool)this.configModel.getValueAt(index, 0);
            String rename = origRenamer.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                RenamerTool renamer = origRenamer.clone();
                renamer.setConfigName(rename);
                renamer.setDataHasChanged();
                this.configModel.addRow(new Object[]{renamer});
                this.currentConfigIndex = this.configModel.getRowCount() - 1;
                this.loadOptions(this.currentConfigIndex);
                this.configItems.editCellAt(this.currentConfigIndex, 0);
                this.configItems.changeSelection(this.currentConfigIndex, this.currentConfigIndex, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.context.cfg.gs("Renamer.title"), 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            RenamerTool tool = (RenamerTool)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + tool.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(tool.getConfigName(), null, tool.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(tool.getFullPath());
                    if (file.exists()) {
                        this.deletedTools.add(tool);
                        tool.setDataHasChanged(false);
                    }
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    this.currentConfigIndex = index;
                    this.configModel.fireTableDataChanged();
                    if (index >= 0) {
                        this.configItems.changeSelection(index, 0, false, false);
                        this.loadOptions(index);
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionFilenameSegmentClicked(ActionEvent e) {
        if (e.getActionCommand() != null && e.getActionCommand().equals("comboBoxChanged") && this.currentRenamer != null && this.currentRenamer.getSegment() != this.comboBoxFilenameSegment.getSelectedIndex()) {
            this.setRenamerOptions(this.currentRenamer);
            this.processTable();
        }
    }

    private void actionFilesOnlyClicked(ActionEvent e) {
        if (e.getActionCommand() != null && e.getActionCommand().equals("filesOnlyChanged") && this.currentRenamer != null && this.currentRenamer.isFilesOnly() != this.checkBoxFilesOnly.isSelected()) {
            this.setRenamerOptions(this.currentRenamer);
            this.processTable();
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("Renamer.help"), "renamer_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        this.saveConfigurations();
        this.savePreferences();
        this.setVisible(false);
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            JComboBox<String> comboBoxRenameType = new JComboBox<String>();
            comboBoxRenameType.setModel(new DefaultComboBoxModel<String>(new String[0]));
            String message = this.context.cfg.gs("RenameUI.type.combobox.select.type");
            comboBoxRenameType.removeAllItems();
            comboBoxRenameType.addItem(this.displayNames[0]);
            comboBoxRenameType.addItem(this.displayNames[1]);
            comboBoxRenameType.addItem(this.displayNames[2]);
            comboBoxRenameType.addItem(this.displayNames[3]);
            comboBoxRenameType.addItem(this.displayNames[4]);
            Object[] params = new Object[]{message, comboBoxRenameType};
            int opt = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("Renamer.title"), 2);
            if (opt == 0) {
                RenamerTool renamer = new RenamerTool(this.context);
                renamer.setConfigName(this.context.cfg.gs("Z.untitled"));
                renamer.setType(comboBoxRenameType.getSelectedIndex());
                this.currentRenamer = renamer;
                this.initNewCard(renamer.getType());
                this.labelRenameType.setText(this.displayNames[renamer.getType()]);
                this.buttonCopy.setEnabled(true);
                this.buttonDelete.setEnabled(true);
                this.buttonRun.setEnabled(true);
                this.buttonRefresh.setEnabled(true);
                this.configModel.addRow(new Object[]{renamer});
                this.currentConfigIndex = this.configModel.getRowCount() - 1;
                this.loadOptions(this.currentConfigIndex);
                this.configItems.editCellAt(this.currentConfigIndex, 0);
                this.configItems.changeSelection(this.currentConfigIndex, this.currentConfigIndex, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                this.configItems.requestFocus();
            }
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.context.cfg.gs("Renamer.title"), 2);
        }
    }

    private void actionRecursiveClicked(ActionEvent e) {
        if (e.getActionCommand() != null && e.getActionCommand().equals("recursiveChanged") && this.currentRenamer != null && this.currentRenamer.isRecursive() != this.checkBoxRecursive.isSelected()) {
            this.setRenamerOptions(this.currentRenamer);
            this.processTable();
        }
    }

    private void actionRunClicked(ActionEvent e) {
        block9: {
            int index = this.configItems.getSelectedRow();
            if (index >= 0) {
                this.currentConfigIndex = index;
                final RenamerTool tool = (RenamerTool)this.configModel.getValueAt(index, 0);
                if (tool.isDataChanged()) {
                    JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.save.then.run"), this.context.cfg.gs("Renamer.title"), 2);
                    return;
                }
                try {
                    final ArrayList<Origin> origins = new ArrayList<Origin>();
                    this.isSubscriber = Origins.makeOriginsFromSelected(this.context, this, origins);
                    if (origins != null && origins.size() > 0) {
                        int count = origins.size();
                        String which = this.isSubscriber ? this.context.cfg.gs("Z.subscriber") : this.context.cfg.gs("Z.publisher");
                        String message = MessageFormat.format(this.context.cfg.gs("Renamer.run.on.N.locations"), tool.getConfigName(), count, which);
                        JCheckBox checkbox = new JCheckBox(this.context.cfg.gs("Navigator.dryrun"));
                        checkbox.setToolTipText(this.context.cfg.gs("Navigator.dryrun.tooltip"));
                        checkbox.setSelected(this.context.preferences.isDefaultDryrun());
                        Object[] params = new Object[]{message, checkbox};
                        int reply = JOptionPane.showConfirmDialog(this, params, this.context.cfg.gs("Renamer.title"), 0);
                        this.isDryRun = checkbox.isSelected();
                        if (reply == 0) {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.setComponentEnabled(false);
                            this.cancelButton.setEnabled(true);
                            this.cancelButton.setCursor(Cursor.getPredefinedCursor(0));
                            this.labelHelp.setEnabled(true);
                            this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
                            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                                @Override
                                protected Void doInBackground() throws Exception {
                                    block3: {
                                        try {
                                            RenamerUI.this.workerRenamer = tool.clone();
                                            RenamerUI.this.processSelected(RenamerUI.this.workerRenamer, origins, RenamerUI.this.isSubscriber);
                                        }
                                        catch (Exception e) {
                                            if (e.getMessage().equals("HANDLED_INTERNALLY")) break block3;
                                            String msg = RenamerUI.this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                                            if (RenamerUI.this.context != null) {
                                                RenamerUI.this.logger.error(msg);
                                                JOptionPane.showMessageDialog(RenamerUI.this.context.mainFrame, msg, RenamerUI.this.context.cfg.gs("Renamer.title"), 0);
                                            }
                                            RenamerUI.this.logger.error(msg);
                                        }
                                    }
                                    return null;
                                }
                            };
                            if (worker != null) {
                                this.workerRunning = true;
                                worker.addPropertyChangeListener(new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent e) {
                                        if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                            RenamerUI.this.processTerminated();
                                        }
                                    }
                                });
                                worker.execute();
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, this.context.cfg.gs("Renamer.nothing.selected.in.browser"), this.context.cfg.gs("Renamer.title"), 2);
                    }
                }
                catch (Exception e1) {
                    if (e1.getMessage().equals("HANDLED_INTERNALLY")) break block9;
                    String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e1);
                    if (this.context.navigator != null) {
                        this.logger.error(msg);
                        JOptionPane.showMessageDialog(this.context.navigator.dialogRenamer, msg, this.context.cfg.gs("Renamer.title"), 0);
                    }
                    this.logger.error(msg);
                }
            }
        }
    }

    private void actionRefreshClicked(ActionEvent e) {
        this.loadTable();
        this.processTable();
    }

    private void addHandlers() {
        AbstractAction actTabKey = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenamerUI.this.setRenamerOptions(RenamerUI.this.currentRenamer);
                RenamerUI.this.processTable();
            }
        };
        this.addTabHandler(this.textFieldToInsert, (Action)actTabKey);
        this.addTabHandler(this.textFieldInsertPosition, (Action)actTabKey);
        this.addTabHandler(this.checkBoxInsertFromEnd, (Action)actTabKey);
        this.addTabHandler(this.checkBoxInsertOverwrite, (Action)actTabKey);
    }

    private void addTabHandler(JCheckBox box, Action action) {
        Set<AWTKeyStroke> forwardKeys = box.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.remove(KeyStroke.getKeyStroke(9, 0));
        box.setFocusTraversalKeys(0, newForwardKeys);
        box.getInputMap().put(KeyStroke.getKeyStroke("VK_TAB"), "doTab");
        box.getActionMap().put("doTab", action);
    }

    private void addTabHandler(JTextField field, Action action) {
        Set<AWTKeyStroke> forwardKeys = field.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.remove(KeyStroke.getKeyStroke(9, 0));
        field.setFocusTraversalKeys(0, newForwardKeys);
        field.getInputMap().put(KeyStroke.getKeyStroke("VK_TAB"), "doTab");
        field.getActionMap().put("doTab", action);
    }

    private void cardShown(ComponentEvent e) {
        this.loadTable();
        this.updateState();
        this.processTable();
    }

    public void cancelChanges() {
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((RenamerTool)this.configModel.getValueAt(i, 0)).reset();
            ((RenamerTool)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((RenamerTool)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private void configItemsMouseClicked(MouseEvent e) {
    }

    private void genericAction(ActionEvent e) {
        if (e.getActionCommand() != null) {
            this.updateOnChange(e.getSource());
        }
    }

    private void genericTextFieldFocusLost(FocusEvent e) {
        if (!(e.getOppositeComponent() instanceof JTable)) {
            this.updateOnChange(e.getSource());
        }
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    private void initNewCard(int type) {
        this.currentRenamer.setDataHasChanged();
        this.checkBoxRecursive.setSelected(false);
        this.checkBoxFilesOnly.setSelected(true);
        this.comboBoxFilenameSegment.setSelectedIndex(0);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                this.currentRenamer.setText1("");
                this.currentRenamer.setText2("0");
                this.currentRenamer.setOption1(false);
                this.currentRenamer.setOption2(false);
                this.currentRenamer.setOption3(false);
                break;
            }
            case 2: {
                this.currentRenamer.setText1("0");
                this.currentRenamer.setText2("0");
                this.currentRenamer.setText3("0");
                this.currentRenamer.setOption1(false);
                this.currentRenamer.setOption2(false);
                this.currentRenamer.setOption3(false);
                break;
            }
            case 3: {
                this.currentRenamer.setText1("0");
                this.currentRenamer.setText2("0");
                this.currentRenamer.setOption1(false);
                break;
            }
            case 4: {
                this.currentRenamer.setText1("");
                this.currentRenamer.setText2("");
                this.currentRenamer.setOption1(false);
                this.currentRenamer.setOption2(false);
            }
        }
    }

    private void loadConfigurations() {
        ArrayList<AbstractTool> toolList = null;
        try {
            toolList = this.context.tools.loadAllTools(this.context, "Renamer");
            for (AbstractTool tool : toolList) {
                RenamerTool renamer = (RenamerTool)tool;
                this.configModel.addRow(new Object[]{renamer});
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context.navigator != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogRenamer, msg, this.context.cfg.gs("Renamer.title"), 0);
            }
            this.logger.error(msg);
        }
        this.configModel.setToolList(toolList);
        this.configModel.loadJobsConfigurations(this, null);
        if (this.configModel.getRowCount() == 0) {
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonRun.setEnabled(false);
            this.buttonRefresh.setEnabled(false);
        } else {
            this.loadOptions(0);
            this.processTable();
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
        }
        this.currentConfigIndex = 0;
    }

    private void loadOptions(int index) {
        this.currentRenamer = null;
        if (index >= 0 && index < this.configModel.getRowCount()) {
            this.currentRenamer = (RenamerTool)this.configModel.getValueAt(index, 0);
        }
        if (index >= 0 && index < this.configModel.getRowCount() && this.currentRenamer != null) {
            this.loading = true;
            this.labelRenameType.setText(this.displayNames[this.currentRenamer.getType()]);
            this.checkBoxRecursive.setSelected(this.currentRenamer.isRecursive());
            this.checkBoxFilesOnly.setSelected(this.currentRenamer.isFilesOnly());
            this.comboBoxFilenameSegment.setSelectedIndex(this.currentRenamer.getSegment());
            ((CardLayout)this.panelOptionsCards.getLayout()).show(this.panelOptionsCards, this.cardNames[this.currentRenamer.getType()]);
            switch (this.currentRenamer.getType()) {
                case 0: {
                    this.currentCard = this.panelCaseChangeCard;
                    Enumeration<AbstractButton> elements = this.buttonGroupChangeCase.getElements();
                    if (this.currentRenamer.getText1().length() == 0) {
                        AbstractButton button = elements.nextElement();
                        button.setSelected(true);
                        break;
                    }
                    while (elements.hasMoreElements()) {
                        AbstractButton button = elements.nextElement();
                        if (button.getActionCommand().equals(this.currentRenamer.getText1())) {
                            button.setSelected(true);
                            continue;
                        }
                        button.setSelected(false);
                    }
                    break;
                }
                case 1: {
                    this.currentCard = this.panelInsertCard;
                    this.textFieldToInsert.setText(this.currentRenamer.getText1());
                    this.textFieldInsertPosition.setText(this.currentRenamer.getText2());
                    this.checkBoxInsertFromEnd.setSelected(this.currentRenamer.isOption1());
                    this.checkBoxInsertAtEnd.setSelected(this.currentRenamer.isOption2());
                    this.checkBoxInsertOverwrite.setSelected(this.currentRenamer.isOption3());
                    break;
                }
                case 2: {
                    this.currentCard = this.panelNumberingCard;
                    this.textFieldNumberingStart.setText(this.currentRenamer.getText1());
                    this.textFieldNumberingZeros.setText(this.currentRenamer.getText2());
                    this.textFieldNumberingPosition.setText(this.currentRenamer.getText3());
                    this.checkBoxNumberingFromEnd.setSelected(this.currentRenamer.isOption1());
                    this.checkBoxNumberingAtEnd.setSelected(this.currentRenamer.isOption2());
                    this.checkBoxNumberingOverwrite.setSelected(this.currentRenamer.isOption3());
                    break;
                }
                case 3: {
                    this.currentCard = this.panelRemoveCard;
                    this.textFieldFrom.setText(this.currentRenamer.getText1());
                    this.textFieldLength.setText(this.currentRenamer.getText2());
                    this.checkBoxRemoveFromEnd.setSelected(this.currentRenamer.isOption1());
                    break;
                }
                case 4: {
                    this.currentCard = this.panelReplaceCard;
                    this.textFieldFind.setText(this.currentRenamer.getText1());
                    this.textFieldReplace.setText(this.currentRenamer.getText2());
                    this.checkBoxRegularExpr.setSelected(this.currentRenamer.isOption1());
                    this.checkBoxCase.setSelected(this.currentRenamer.isOption2());
                }
            }
            this.buttonCopy.setEnabled(true);
            this.buttonDelete.setEnabled(true);
            this.buttonRun.setEnabled(true);
            this.buttonRefresh.setEnabled(true);
            this.loading = false;
        } else {
            this.currentCard = this.panelGettingStarted;
            ((CardLayout)this.panelOptionsCards.getLayout()).show(this.panelOptionsCards, "gettingStarted");
            this.labelRenameType.setText("");
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonRun.setEnabled(false);
            this.buttonRefresh.setEnabled(false);
        }
    }

    private void loadTable() {
        this.isSubscriber = this.makeChangeStringsFromSelected();
        this.refreshTable();
    }

    public boolean makeChangeStringsFromSelected() {
        boolean isSubscriber;
        block4: {
            JTable sourceTable;
            int row;
            JComponent object;
            int index;
            block3: {
                TreePath[] paths;
                index = 0;
                isSubscriber = false;
                object = this.context.browser.lastComponent;
                if (!(object instanceof JTree)) break block3;
                JTree sourceTree = (JTree)object;
                int row2 = sourceTree.getLeadSelectionRow();
                if (row2 <= -1) break block4;
                this.changeStrings = new String[sourceTree.getSelectionCount()][2];
                for (TreePath tp : paths = sourceTree.getSelectionPaths()) {
                    NavTreeNode ntn = (NavTreeNode)tp.getLastPathComponent();
                    NavTreeUserObject tuo = ntn.getUserObject();
                    isSubscriber = tuo.isSubscriber();
                    this.changeStrings[index][0] = tuo.name;
                    this.changeStrings[index][1] = tuo.name;
                    ++index;
                }
                break block4;
            }
            if (object instanceof JTable && (row = (sourceTable = (JTable)object).getSelectedRow()) > -1) {
                this.changeStrings = new String[sourceTable.getSelectedRowCount()][2];
                int[] rows = sourceTable.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    NavTreeUserObject tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[i], 1);
                    isSubscriber = tuo.isSubscriber();
                    this.changeStrings[index][0] = tuo.name;
                    this.changeStrings[index][1] = tuo.name;
                    ++index;
                }
            }
        }
        return isSubscriber;
    }

    public void processSelected(RenamerTool renamer, ArrayList<Origin> origins, boolean isSubscriber) throws Exception {
        if (renamer != null && origins != null && origins.size() > 0) {
            this.workerTask = new Task(renamer.getInternalName(), renamer.getConfigName());
            this.workerTask.setContext(renamer.getContext());
            this.workerTask.setDryRun(this.isDryRun);
            this.workerTask.setOrigins(origins);
            if (isSubscriber) {
                this.workerTask.setSubscriberKey("_ANY_SERVER_");
            } else {
                this.workerTask.setPublisherKey("_ANY_SERVER_");
            }
            if (this.context.cfg.isHintTrackingEnabled()) {
                this.workerTask.setHintsKey("_ANY_SERVER_");
            }
            this.workerTask.process(this.context);
        }
    }

    private void processTerminated() {
        if (!this.isDryRun) {
            if (!this.isSubscriber) {
                this.context.browser.deepScanCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false, false);
                this.context.browser.deepScanSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false, false);
            } else {
                this.context.browser.deepScanCollectionTree(this.context.mainFrame.treeCollectionTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation(), false);
                this.context.browser.deepScanSystemTree(this.context.mainFrame.treeSystemTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation(), false);
            }
        }
        if (this.context.progress != null) {
            this.context.progress.done();
            this.context.progress.dispose();
            this.context.progress = null;
        }
        Origins.setSelectedFromOrigins(this.context, this, this.workerTask.getOrigins());
        this.setComponentEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.loadTable();
        this.processTable();
        if (this.workerRenamer.isRequestStop()) {
            this.logger.info(this.workerRenamer.getConfigName() + this.context.cfg.gs("Z.cancelled"));
            this.context.mainFrame.labelStatusMiddle.setText(this.workerRenamer.getConfigName() + this.context.cfg.gs("Z.cancelled"));
        }
        this.workerRunning = false;
        this.workerRenamer = null;
    }

    private void processTable() {
        if (this.currentRenamer != null && this.changeStrings != null && this.changeStrings.length > 0) {
            this.currentRenamer.reset();
            for (int i = 0; i < this.changeStrings.length; ++i) {
                String right;
                String left = this.changeStrings[i][0];
                this.changeStrings[i][1] = right = this.currentRenamer.exec(left);
            }
        }
        this.refreshTable();
    }

    private void refreshTable() {
        this.changeModel = new ChangesTableModel(this.context);
        this.tableChanges.removeAll();
        if (this.changeStrings != null && this.changeStrings.length > 0) {
            for (int index = 0; index < this.changeStrings.length; ++index) {
                this.changeModel.addRow(new Object[]{this.changeStrings[index][0], this.changeStrings[index][1]});
            }
        }
        this.tableChanges.setModel(this.changeModel);
        this.changeModel.fireTableDataChanged();
    }

    private void saveConfigurations() {
        RenamerTool renamer = null;
        try {
            int i;
            for (i = 0; i < this.deletedTools.size(); ++i) {
                renamer = (RenamerTool)this.deletedTools.get(i);
                File file = new File(renamer.getFullPath());
                if (!file.exists()) continue;
                file.delete();
            }
            this.deletedTools = new ArrayList();
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                renamer = (RenamerTool)this.configModel.getValueAt(i, 0);
                if (renamer.isDataChanged()) {
                    renamer.write();
                }
                renamer.setDataHasChanged(false);
            }
            this.configModel.saveJobsConfigurations(null);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context.navigator != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogRenamer, msg, this.context.cfg.gs("Renamer.title"), 0);
            }
            this.logger.error(msg);
        }
    }

    private void savePreferences() {
        this.context.preferences.setToolsRenamerHeight(this.getHeight());
        this.context.preferences.setToolsRenamerWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsRenamerXpos(location.x);
        this.context.preferences.setToolsRenamerYpos(location.y);
        this.context.preferences.setToolsRenamerDividerLocation(this.splitPaneContent.getDividerLocation());
    }

    public void setComponentEnabled(boolean enabled) {
        this.setComponentEnabled(enabled, this.getContentPane());
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        component.setEnabled(enabled);
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component comp : components) {
                this.setComponentEnabled(enabled, comp);
            }
        }
    }

    private void setNumberFilter(JTextField field) {
        PlainDocument pd = (PlainDocument)field.getDocument();
        pd.setDocumentFilter(this.numberFilter);
    }

    private void setRenamerOptions(RenamerTool renamer) {
        if (renamer != null && !this.loading) {
            renamer.setDataHasChanged();
            renamer.setIsRecursive(this.checkBoxRecursive.isSelected());
            renamer.setIsFilesOnly(this.checkBoxFilesOnly.isSelected());
            renamer.setSegment(this.comboBoxFilenameSegment.getSelectedIndex());
            switch (renamer.getType()) {
                case 0: {
                    Enumeration<AbstractButton> elements = this.buttonGroupChangeCase.getElements();
                    while (elements.hasMoreElements()) {
                        AbstractButton button = elements.nextElement();
                        if (!button.isSelected()) continue;
                        String act = button.getActionCommand();
                        renamer.setText1(act);
                    }
                    renamer.setText2("");
                    renamer.setText3("");
                    renamer.setOption1(false);
                    renamer.setOption2(false);
                    renamer.setOption2(false);
                    break;
                }
                case 1: {
                    renamer.setText1(this.textFieldToInsert.getText());
                    renamer.setText2(this.setZeroEmpty(this.textFieldInsertPosition.getText()));
                    renamer.setText3("");
                    renamer.setOption1(this.checkBoxInsertFromEnd.isSelected());
                    renamer.setOption2(this.checkBoxInsertAtEnd.isSelected());
                    renamer.setOption3(this.checkBoxInsertOverwrite.isSelected());
                    break;
                }
                case 2: {
                    renamer.setText1(this.setZeroEmpty(this.textFieldNumberingStart.getText()));
                    renamer.setText2(this.setZeroEmpty(this.textFieldNumberingZeros.getText()));
                    renamer.setText3(this.setZeroEmpty(this.textFieldNumberingPosition.getText()));
                    renamer.setOption1(this.checkBoxNumberingFromEnd.isSelected());
                    renamer.setOption2(this.checkBoxNumberingAtEnd.isSelected());
                    renamer.setOption3(this.checkBoxNumberingOverwrite.isSelected());
                    break;
                }
                case 3: {
                    renamer.setText1(this.textFieldFrom.getText());
                    renamer.setText2(this.textFieldLength.getText());
                    renamer.setText3("");
                    renamer.setOption1(this.checkBoxRemoveFromEnd.isSelected());
                    renamer.setOption2(false);
                    renamer.setOption3(false);
                    break;
                }
                case 4: {
                    renamer.setText1(this.textFieldFind.getText());
                    renamer.setText2(this.textFieldReplace.getText());
                    renamer.setText3("");
                    renamer.setOption1(this.checkBoxRegularExpr.isSelected());
                    renamer.setOption2(this.checkBoxCase.isSelected());
                    renamer.setOption3(false);
                }
            }
        }
    }

    private String setZeroEmpty(String value) {
        return value.length() == 0 ? "0" : value;
    }

    private void tabKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            this.updateOnChange(e.getSource());
        }
    }

    private void updateOnChange(Object source) {
        String name = null;
        if (source instanceof JTextField) {
            String current = null;
            JTextField tf = (JTextField)source;
            switch (name = tf.getName()) {
                case "text1": {
                    current = this.currentRenamer.getText1();
                    break;
                }
                case "text2": {
                    current = this.currentRenamer.getText2();
                    break;
                }
                case "text3": {
                    current = this.currentRenamer.getText3();
                }
            }
            if (!current.equals(tf.getText())) {
                this.setRenamerOptions(this.currentRenamer);
                this.updateState();
                this.processTable();
            }
        } else if (source instanceof JCheckBox) {
            boolean state = false;
            JCheckBox cb = (JCheckBox)source;
            switch (name = cb.getName()) {
                case "option1": {
                    state = this.currentRenamer.isOption1();
                    break;
                }
                case "option2": {
                    state = this.currentRenamer.isOption2();
                    break;
                }
                case "option3": {
                    state = this.currentRenamer.isOption3();
                }
            }
            if (state != cb.isSelected()) {
                this.setRenamerOptions(this.currentRenamer);
                this.updateState();
                this.processTable();
            }
        }
    }

    private void updateState() {
        if (this.currentCard != this.panelCaseChangeCard) {
            if (this.currentCard == this.panelInsertCard) {
                if (this.currentRenamer.isOption1()) {
                    this.checkBoxInsertAtEnd.setEnabled(false);
                } else {
                    this.checkBoxInsertAtEnd.setEnabled(true);
                }
                if (this.currentRenamer.isOption2()) {
                    this.textFieldInsertPosition.setEnabled(false);
                    this.checkBoxInsertFromEnd.setEnabled(false);
                    this.checkBoxInsertOverwrite.setEnabled(false);
                } else {
                    this.textFieldInsertPosition.setEnabled(true);
                    this.checkBoxInsertFromEnd.setEnabled(true);
                    this.checkBoxInsertOverwrite.setEnabled(true);
                }
                this.setNumberFilter(this.textFieldInsertPosition);
            } else if (this.currentCard == this.panelNumberingCard) {
                if (this.currentRenamer.isOption1()) {
                    this.checkBoxNumberingAtEnd.setEnabled(false);
                } else {
                    this.checkBoxNumberingAtEnd.setEnabled(true);
                }
                if (this.currentRenamer.isOption2()) {
                    this.textFieldNumberingPosition.setEnabled(false);
                    this.checkBoxNumberingFromEnd.setEnabled(false);
                    this.checkBoxNumberingOverwrite.setEnabled(false);
                } else {
                    this.textFieldNumberingPosition.setEnabled(true);
                    this.checkBoxNumberingFromEnd.setEnabled(true);
                    this.checkBoxNumberingOverwrite.setEnabled(true);
                }
                this.setNumberFilter(this.textFieldNumberingStart);
                this.setNumberFilter(this.textFieldNumberingZeros);
                this.setNumberFilter(this.textFieldNumberingPosition);
            } else if (this.currentCard == this.panelRemoveCard) {
                if (this.currentRenamer.isOption1()) {
                    this.textFieldFrom.setEnabled(false);
                } else {
                    this.textFieldFrom.setEnabled(true);
                }
                this.setNumberFilter(this.textFieldFrom);
                this.setNumberFilter(this.textFieldLength);
            } else if (this.currentCard == this.panelReplaceCard) {
                if (this.currentRenamer.isOption1()) {
                    this.checkBoxRegularExpr.setEnabled(true);
                    this.checkBoxCase.setEnabled(false);
                } else if (this.currentRenamer.isOption2()) {
                    this.checkBoxRegularExpr.setEnabled(false);
                    this.checkBoxCase.setEnabled(true);
                } else {
                    this.checkBoxRegularExpr.setEnabled(true);
                    this.checkBoxCase.setEnabled(true);
                }
            }
        }
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void windowHidden(ComponentEvent e) {
        this.context.navigator.enableDisableToolMenus(this, true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.hSpacerBeforeRun = new JPanel(null);
        this.buttonRun = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.splitPaneContent = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.configItems = new JTable();
        this.panelOptions = new JPanel();
        this.panelControls = new JPanel();
        this.topOptions = new JPanel();
        this.vSpacer0 = new JPanel(null);
        this.panelRenameType = new JPanel();
        this.hSpacer1 = new JPanel(null);
        this.labelRenameType = new JLabel();
        this.panelCbOpts = new JPanel();
        this.checkBoxRecursive = new JCheckBox();
        this.checkBoxFilesOnly = new JCheckBox();
        this.panelFilenameSegment = new JPanel();
        this.comboBoxFilenameSegment = new JComboBox();
        this.hSpacer2 = new JPanel(null);
        this.panelCardBox = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.separator1 = new JSeparator();
        this.vSpacer2 = new JPanel(null);
        this.panelOptionsCards = new JPanel();
        this.panelGettingStarted = new JPanel();
        this.labelOperationGettingStarted = new JLabel();
        this.panelCaseChangeCard = new JPanel();
        this.radioButtonFirstUpperCase = new JRadioButton();
        this.radioButtonLowerCase = new JRadioButton();
        this.radioButtonTitleCase = new JRadioButton();
        this.radioButtonUpperCase = new JRadioButton();
        this.panelInsertCard = new JPanel();
        this.labelTextToInsert = new JLabel();
        this.textFieldToInsert = new JTextField();
        this.labelInsertPosition = new JLabel();
        this.panelInsertPostion = new JPanel();
        this.textFieldInsertPosition = new JTextField();
        this.hSpacer3 = new JPanel(null);
        this.checkBoxInsertFromEnd = new JCheckBox();
        this.hSpacer7 = new JPanel(null);
        this.checkBoxInsertAtEnd = new JCheckBox();
        this.panelInsertOther = new JPanel();
        this.checkBoxInsertOverwrite = new JCheckBox();
        this.panelNumberingCard = new JPanel();
        this.labelStart = new JLabel();
        this.panelNums = new JPanel();
        this.textFieldNumberingStart = new JTextField();
        this.hSpacer5 = new JPanel(null);
        this.labelZeros = new JLabel();
        this.textFieldNumberingZeros = new JTextField();
        this.labelNumberingPosition = new JLabel();
        this.panelNumberingPostion = new JPanel();
        this.textFieldNumberingPosition = new JTextField();
        this.hSpacer4 = new JPanel(null);
        this.checkBoxNumberingFromEnd = new JCheckBox();
        this.hSpacer8 = new JPanel(null);
        this.checkBoxNumberingAtEnd = new JCheckBox();
        this.panelNumberingOther = new JPanel();
        this.checkBoxNumberingOverwrite = new JCheckBox();
        this.panelRemoveCard = new JPanel();
        this.labelFrom = new JLabel();
        this.panelFrom = new JPanel();
        this.textFieldFrom = new JTextField();
        this.hSpacer6 = new JPanel(null);
        this.labelLength = new JLabel();
        this.panelLength = new JPanel();
        this.textFieldLength = new JTextField();
        this.panelRemoveOther = new JPanel();
        this.checkBoxRemoveFromEnd = new JCheckBox();
        this.panelReplaceCard = new JPanel();
        this.labelFind = new JLabel();
        this.textFieldFind = new JTextField();
        this.labeReplace = new JLabel();
        this.textFieldReplace = new JTextField();
        this.panelReplaceOther = new JPanel();
        this.checkBoxRegularExpr = new JCheckBox();
        this.checkBoxCase = new JCheckBox();
        this.scrollPaneExamples = new JScrollPane();
        this.tableChanges = new JTable();
        this.panelOptionsButtons = new JPanel();
        this.buttonRefresh = new JButton();
        this.buttonBar = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.buttonGroupChangeCase = new ButtonGroup();
        this.setTitle(this.context.cfg.gs("Renamer.title"));
        this.setName("renamerUI");
        this.setMinimumSize(new Dimension(150, 126));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RenamerUI.this.windowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                RenamerUI.this.windowHidden(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(630, 470));
        this.dialogPane.setMinimumSize(new Dimension(150, 80));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setPreferredSize(new Dimension(614, 470));
        this.contentPanel.setMinimumSize(new Dimension(140, 120));
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(614, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNew.setText(this.context.cfg.gs("Renamer.button.New.text"));
        this.buttonNew.setMnemonic(this.context.cfg.gs("Renamer.button.New.mnemonic").charAt(0));
        this.buttonNew.setToolTipText(this.context.cfg.gs("Renamer.button.New.toolTipText"));
        this.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("Navigator.buttonCopy.text"));
        this.buttonCopy.setMnemonic(this.context.cfg.gs("Renamer.button.Copy.mnemonic").charAt(0));
        this.buttonCopy.setToolTipText(this.context.cfg.gs("Navigator.buttonCopy.toolTipText"));
        this.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("Navigator.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("Renamer.button.Delete.mnemonic").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("Navigator.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.hSpacerBeforeRun.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeRun.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeRun);
        this.buttonRun.setText(this.context.cfg.gs("Z.run"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("Renamer.button.Run.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("Renamer.button.Run.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("Renamer.help"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RenamerUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "East");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.splitPaneContent.setDividerLocation(142);
        this.splitPaneContent.setLastDividerLocation(142);
        this.splitPaneContent.setMinimumSize(new Dimension(140, 80));
        this.scrollPaneConfig.setMinimumSize(new Dimension(140, 16));
        this.scrollPaneConfig.setPreferredSize(new Dimension(142, 146));
        this.configItems.setSelectionMode(0);
        this.configItems.setShowVerticalLines(false);
        this.configItems.setFillsViewportHeight(true);
        this.configItems.setShowHorizontalLines(false);
        this.configItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RenamerUI.this.configItemsMouseClicked(e);
            }
        });
        this.scrollPaneConfig.setViewportView(this.configItems);
        this.splitPaneContent.setLeftComponent(this.scrollPaneConfig);
        this.panelOptions.setMinimumSize(new Dimension(0, 78));
        this.panelOptions.setLayout(new BorderLayout());
        this.panelControls.setLayout(new BorderLayout());
        this.topOptions.setLayout(new BorderLayout());
        this.vSpacer0.setPreferredSize(new Dimension(10, 2));
        this.vSpacer0.setMinimumSize(new Dimension(10, 2));
        this.vSpacer0.setMaximumSize(new Dimension(10, 2));
        this.topOptions.add((Component)this.vSpacer0, "North");
        this.panelRenameType.setLayout(new BoxLayout(this.panelRenameType, 0));
        this.hSpacer1.setPreferredSize(new Dimension(4, 10));
        this.hSpacer1.setMinimumSize(new Dimension(4, 12));
        this.hSpacer1.setMaximumSize(new Dimension(4, Short.MAX_VALUE));
        this.panelRenameType.add(this.hSpacer1);
        this.labelRenameType.setText("Rename Type");
        this.labelRenameType.setMaximumSize(new Dimension(110, 16));
        this.labelRenameType.setFont(this.labelRenameType.getFont().deriveFont(this.labelRenameType.getFont().getStyle() | 1, (float)this.labelRenameType.getFont().getSize() + 1.0f));
        this.labelRenameType.setPreferredSize(new Dimension(110, 16));
        this.labelRenameType.setMinimumSize(new Dimension(110, 16));
        this.panelRenameType.add(this.labelRenameType);
        this.topOptions.add((Component)this.panelRenameType, "West");
        this.panelCbOpts.setMaximumSize(new Dimension(Short.MAX_VALUE, 21));
        this.panelCbOpts.setMinimumSize(new Dimension(120, 21));
        this.panelCbOpts.setPreferredSize(new Dimension(240, 21));
        this.panelCbOpts.setLayout(new BoxLayout(this.panelCbOpts, 0));
        this.checkBoxRecursive.setText(this.context.cfg.gs("Renamer.checkBoxRecursive.text"));
        this.checkBoxRecursive.setHorizontalAlignment(0);
        this.checkBoxRecursive.setToolTipText(this.context.cfg.gs("Renamer.checkBoxRecursive.toolTipText"));
        this.checkBoxRecursive.setActionCommand("recursiveChanged");
        this.checkBoxRecursive.setPreferredSize(new Dimension(120, 21));
        this.checkBoxRecursive.setMaximumSize(new Dimension(Short.MAX_VALUE, 21));
        this.checkBoxRecursive.setMinimumSize(new Dimension(80, 21));
        this.checkBoxRecursive.addActionListener(e -> this.actionRecursiveClicked(e));
        this.panelCbOpts.add(this.checkBoxRecursive);
        this.checkBoxFilesOnly.setText(this.context.cfg.gs("Renamer.checkBoxFilesOnly.text"));
        this.checkBoxFilesOnly.setHorizontalAlignment(0);
        this.checkBoxFilesOnly.setAlignmentX(0.5f);
        this.checkBoxFilesOnly.setPreferredSize(new Dimension(120, 21));
        this.checkBoxFilesOnly.setMaximumSize(new Dimension(Short.MAX_VALUE, 21));
        this.checkBoxFilesOnly.setActionCommand("filesOnlyChanged");
        this.checkBoxFilesOnly.setToolTipText(this.context.cfg.gs("Renamer.checkBoxFilesOnly.toolTipText"));
        this.checkBoxFilesOnly.addActionListener(e -> this.actionFilesOnlyClicked(e));
        this.panelCbOpts.add(this.checkBoxFilesOnly);
        this.topOptions.add((Component)this.panelCbOpts, "Center");
        this.panelFilenameSegment.setMaximumSize(new Dimension(144, 30));
        this.panelFilenameSegment.setLayout(new BoxLayout(this.panelFilenameSegment, 0));
        this.comboBoxFilenameSegment.setModel(new DefaultComboBoxModel<String>(new String[]{"Name only", "Extension only", "Whole filename"}));
        this.comboBoxFilenameSegment.addActionListener(e -> this.actionFilenameSegmentClicked(e));
        this.panelFilenameSegment.add(this.comboBoxFilenameSegment);
        this.hSpacer2.setPreferredSize(new Dimension(4, 10));
        this.hSpacer2.setMinimumSize(new Dimension(4, 10));
        this.hSpacer2.setMaximumSize(new Dimension(4, 10));
        this.panelFilenameSegment.add(this.hSpacer2);
        this.topOptions.add((Component)this.panelFilenameSegment, "East");
        this.panelCardBox.setLayout(new BoxLayout(this.panelCardBox, 1));
        this.vSpacer1.setMinimumSize(new Dimension(12, 2));
        this.vSpacer1.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.vSpacer1.setPreferredSize(new Dimension(10, 2));
        this.panelCardBox.add(this.vSpacer1);
        this.panelCardBox.add(this.separator1);
        this.vSpacer2.setMinimumSize(new Dimension(12, 2));
        this.vSpacer2.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.vSpacer2.setPreferredSize(new Dimension(10, 2));
        this.panelCardBox.add(this.vSpacer2);
        this.panelOptionsCards.setMaximumSize(new Dimension(32676, 92));
        this.panelOptionsCards.setLayout(new CardLayout());
        this.panelGettingStarted.setMaximumSize(null);
        this.panelGettingStarted.setLayout(new BorderLayout());
        this.labelOperationGettingStarted.setText(this.context.cfg.gs("Renamer.labelGettingStarted.text"));
        this.labelOperationGettingStarted.setFont(this.labelOperationGettingStarted.getFont().deriveFont(this.labelOperationGettingStarted.getFont().getStyle() | 1));
        this.labelOperationGettingStarted.setHorizontalAlignment(0);
        this.panelGettingStarted.add((Component)this.labelOperationGettingStarted, "Center");
        this.panelOptionsCards.add((Component)this.panelGettingStarted, "gettingStarted");
        this.panelCaseChangeCard.setPreferredSize(new Dimension(328, 92));
        this.panelCaseChangeCard.setMinimumSize(new Dimension(328, 92));
        this.panelCaseChangeCard.setMaximumSize(null);
        this.panelCaseChangeCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                RenamerUI.this.cardShown(e);
            }
        });
        this.panelCaseChangeCard.setLayout(new GridLayout(2, 2));
        this.radioButtonFirstUpperCase.setText(this.context.cfg.gs("Renamer.radioButtonFirstUpperCase.text"));
        this.radioButtonFirstUpperCase.setHorizontalAlignment(0);
        this.radioButtonFirstUpperCase.setActionCommand("firstupper");
        this.radioButtonFirstUpperCase.addActionListener(e -> this.actionCaseChangeClicked(e));
        this.panelCaseChangeCard.add(this.radioButtonFirstUpperCase);
        this.radioButtonLowerCase.setText(this.context.cfg.gs("Renamer.radioButtonLowerCase.text"));
        this.radioButtonLowerCase.setHorizontalAlignment(0);
        this.radioButtonLowerCase.addActionListener(e -> this.actionCaseChangeClicked(e));
        this.panelCaseChangeCard.add(this.radioButtonLowerCase);
        this.radioButtonTitleCase.setText(this.context.cfg.gs("Renamer.radioButtonTitleCase.text"));
        this.radioButtonTitleCase.setHorizontalAlignment(0);
        this.radioButtonTitleCase.setActionCommand("titlecase");
        this.radioButtonTitleCase.addActionListener(e -> this.actionCaseChangeClicked(e));
        this.panelCaseChangeCard.add(this.radioButtonTitleCase);
        this.radioButtonUpperCase.setText(this.context.cfg.gs("Renamer.radioButtonUpperCase.text"));
        this.radioButtonUpperCase.setHorizontalAlignment(0);
        this.radioButtonUpperCase.setActionCommand("upper");
        this.radioButtonUpperCase.addActionListener(e -> this.actionCaseChangeClicked(e));
        this.panelCaseChangeCard.add(this.radioButtonUpperCase);
        this.panelOptionsCards.add((Component)this.panelCaseChangeCard, "cardCaseChange");
        this.panelInsertCard.setMaximumSize(null);
        this.panelInsertCard.setMinimumSize(new Dimension(328, 92));
        this.panelInsertCard.setPreferredSize(new Dimension(328, 92));
        this.panelInsertCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                RenamerUI.this.cardShown(e);
            }
        });
        this.panelInsertCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelInsertCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelInsertCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.labelTextToInsert.setText(this.context.cfg.gs("Renamer.labelTextToInsert.text"));
        this.labelTextToInsert.setHorizontalAlignment(4);
        this.panelInsertCard.add((Component)this.labelTextToInsert, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.textFieldToInsert.setPreferredSize(new Dimension(320, 30));
        this.textFieldToInsert.setMinimumSize(new Dimension(50, 30));
        this.textFieldToInsert.setToolTipText(this.context.cfg.gs("Renamer.textFieldToInsert.toolTipText"));
        this.textFieldToInsert.setName("text1");
        this.textFieldToInsert.addActionListener(e -> this.genericAction(e));
        this.textFieldToInsert.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldToInsert.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelInsertCard.add((Component)this.textFieldToInsert, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelInsertPosition.setText(this.context.cfg.gs("Renamer.labelInsertPosition.text"));
        this.labelInsertPosition.setHorizontalAlignment(4);
        this.panelInsertCard.add((Component)this.labelInsertPosition, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelInsertPostion.setLayout(new BoxLayout(this.panelInsertPostion, 0));
        this.textFieldInsertPosition.setMinimumSize(new Dimension(96, 30));
        this.textFieldInsertPosition.setPreferredSize(new Dimension(96, 30));
        this.textFieldInsertPosition.setMaximumSize(new Dimension(96, 30));
        this.textFieldInsertPosition.setToolTipText(this.context.cfg.gs("Renamer.textFieldInsertPosition.toolTipText"));
        this.textFieldInsertPosition.setName("text2");
        this.textFieldInsertPosition.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldInsertPosition.addActionListener(e -> this.genericAction(e));
        this.textFieldInsertPosition.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelInsertPostion.add(this.textFieldInsertPosition);
        this.hSpacer3.setMinimumSize(new Dimension(10, 10));
        this.hSpacer3.setMaximumSize(new Dimension(10, 10));
        this.panelInsertPostion.add(this.hSpacer3);
        this.checkBoxInsertFromEnd.setText(this.context.cfg.gs("Renamer.checkBoxInsertFromEnd.text"));
        this.checkBoxInsertFromEnd.setToolTipText(this.context.cfg.gs("Renamer.checkBoxInsertFromEnd.toolTipText"));
        this.checkBoxInsertFromEnd.setName("option1");
        this.checkBoxInsertFromEnd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.checkBoxInsertFromEnd.addActionListener(e -> this.genericAction(e));
        this.panelInsertPostion.add(this.checkBoxInsertFromEnd);
        this.hSpacer7.setMinimumSize(new Dimension(10, 10));
        this.hSpacer7.setMaximumSize(new Dimension(10, 10));
        this.panelInsertPostion.add(this.hSpacer7);
        this.checkBoxInsertAtEnd.setText(this.context.cfg.gs("Renamer.checkBoxInsertAtEnd.text"));
        this.checkBoxInsertAtEnd.setToolTipText(this.context.cfg.gs("Renamer.checkBoxInsertAtEnd.toolTipText"));
        this.checkBoxInsertAtEnd.setName("option2");
        this.checkBoxInsertAtEnd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.checkBoxInsertAtEnd.addActionListener(e -> this.genericAction(e));
        this.panelInsertPostion.add(this.checkBoxInsertAtEnd);
        this.panelInsertCard.add((Component)this.panelInsertPostion, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelInsertOther.setPreferredSize(new Dimension(266, 30));
        this.panelInsertOther.setMinimumSize(new Dimension(266, 30));
        this.panelInsertOther.setLayout(new GridLayout(1, 0, 8, 0));
        this.checkBoxInsertOverwrite.setText(this.context.cfg.gs("Renamer.checkBoxInsertOverwrite.text"));
        this.checkBoxInsertOverwrite.setMargin(new Insets(2, 6, 2, 2));
        this.checkBoxInsertOverwrite.setName("option3");
        this.checkBoxInsertOverwrite.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.checkBoxInsertOverwrite.addActionListener(e -> this.genericAction(e));
        this.panelInsertOther.add(this.checkBoxInsertOverwrite);
        this.panelInsertCard.add((Component)this.panelInsertOther, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelOptionsCards.add((Component)this.panelInsertCard, "cardInsert");
        this.panelNumberingCard.setMinimumSize(new Dimension(328, 92));
        this.panelNumberingCard.setPreferredSize(new Dimension(328, 92));
        this.panelNumberingCard.setMaximumSize(null);
        this.panelNumberingCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                RenamerUI.this.cardShown(e);
            }
        });
        this.panelNumberingCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelNumberingCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelNumberingCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.labelStart.setText(this.context.cfg.gs("Renamer.labelStart.text"));
        this.labelStart.setHorizontalAlignment(4);
        this.panelNumberingCard.add((Component)this.labelStart, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelNums.setLayout(new BoxLayout(this.panelNums, 0));
        this.textFieldNumberingStart.setPreferredSize(new Dimension(96, 30));
        this.textFieldNumberingStart.setMinimumSize(new Dimension(96, 30));
        this.textFieldNumberingStart.setMaximumSize(new Dimension(96, 30));
        this.textFieldNumberingStart.setText("1");
        this.textFieldNumberingStart.setToolTipText(this.context.cfg.gs("Renamer.textFieldNumberingStart.toolTipText"));
        this.textFieldNumberingStart.setName("text1");
        this.textFieldNumberingStart.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldNumberingStart.addActionListener(e -> this.genericAction(e));
        this.textFieldNumberingStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelNums.add(this.textFieldNumberingStart);
        this.hSpacer5.setMinimumSize(new Dimension(10, 10));
        this.hSpacer5.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
        this.hSpacer5.setPreferredSize(new Dimension(88, 10));
        this.panelNums.add(this.hSpacer5);
        this.labelZeros.setText(this.context.cfg.gs("Renamer.labelZeros.text"));
        this.panelNums.add(this.labelZeros);
        this.textFieldNumberingZeros.setPreferredSize(new Dimension(96, 30));
        this.textFieldNumberingZeros.setMinimumSize(new Dimension(96, 30));
        this.textFieldNumberingZeros.setMaximumSize(new Dimension(96, 30));
        this.textFieldNumberingZeros.setText("1");
        this.textFieldNumberingZeros.setToolTipText(this.context.cfg.gs("Renamer.textFieldNumberingZeros.toolTipText"));
        this.textFieldNumberingZeros.setName("text2");
        this.textFieldNumberingZeros.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldNumberingZeros.addActionListener(e -> this.genericAction(e));
        this.textFieldNumberingZeros.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelNums.add(this.textFieldNumberingZeros);
        this.panelNumberingCard.add((Component)this.panelNums, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelNumberingPosition.setText(this.context.cfg.gs("Renamer.labelNumberingPosition.text_2"));
        this.labelNumberingPosition.setHorizontalAlignment(4);
        this.panelNumberingCard.add((Component)this.labelNumberingPosition, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelNumberingPostion.setLayout(new BoxLayout(this.panelNumberingPostion, 0));
        this.textFieldNumberingPosition.setMinimumSize(new Dimension(96, 30));
        this.textFieldNumberingPosition.setPreferredSize(new Dimension(96, 30));
        this.textFieldNumberingPosition.setMaximumSize(new Dimension(96, 30));
        this.textFieldNumberingPosition.setName("text3");
        this.textFieldNumberingPosition.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldNumberingPosition.addActionListener(e -> this.genericAction(e));
        this.textFieldNumberingPosition.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelNumberingPostion.add(this.textFieldNumberingPosition);
        this.hSpacer4.setMinimumSize(new Dimension(10, 10));
        this.hSpacer4.setMaximumSize(new Dimension(10, 10));
        this.panelNumberingPostion.add(this.hSpacer4);
        this.checkBoxNumberingFromEnd.setText(this.context.cfg.gs("Renamer.checkBoxNumberingFromEnd.text_2"));
        this.checkBoxNumberingFromEnd.setName("option1");
        this.checkBoxNumberingFromEnd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.checkBoxNumberingFromEnd.addActionListener(e -> this.genericAction(e));
        this.panelNumberingPostion.add(this.checkBoxNumberingFromEnd);
        this.hSpacer8.setMinimumSize(new Dimension(10, 10));
        this.hSpacer8.setMaximumSize(new Dimension(10, 10));
        this.panelNumberingPostion.add(this.hSpacer8);
        this.checkBoxNumberingAtEnd.setText(this.context.cfg.gs("Renamer.checkBoxNumberingAtEnd.text"));
        this.checkBoxNumberingAtEnd.setToolTipText(this.context.cfg.gs("Renamer.checkBoxNumberingAtEnd.toolTipText"));
        this.checkBoxNumberingAtEnd.setName("option2");
        this.checkBoxNumberingAtEnd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.checkBoxNumberingAtEnd.addActionListener(e -> this.genericAction(e));
        this.panelNumberingPostion.add(this.checkBoxNumberingAtEnd);
        this.panelNumberingCard.add((Component)this.panelNumberingPostion, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelNumberingOther.setPreferredSize(new Dimension(266, 30));
        this.panelNumberingOther.setMinimumSize(new Dimension(266, 30));
        this.panelNumberingOther.setLayout(new GridLayout(1, 0, 8, 0));
        this.checkBoxNumberingOverwrite.setText(this.context.cfg.gs("Renamer.checkBoxNumberingOverwrite.text_2"));
        this.checkBoxNumberingOverwrite.setMargin(new Insets(2, 6, 2, 2));
        this.checkBoxNumberingOverwrite.setName("option3");
        this.checkBoxNumberingOverwrite.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.checkBoxNumberingOverwrite.addActionListener(e -> this.genericAction(e));
        this.panelNumberingOther.add(this.checkBoxNumberingOverwrite);
        this.panelNumberingCard.add((Component)this.panelNumberingOther, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelOptionsCards.add((Component)this.panelNumberingCard, "cardNumbering");
        this.panelRemoveCard.setMaximumSize(null);
        this.panelRemoveCard.setMinimumSize(new Dimension(328, 92));
        this.panelRemoveCard.setPreferredSize(new Dimension(328, 92));
        this.panelRemoveCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                RenamerUI.this.cardShown(e);
            }
        });
        this.panelRemoveCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelRemoveCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelRemoveCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.labelFrom.setText(this.context.cfg.gs("Renamer.labelFrom.text"));
        this.labelFrom.setHorizontalAlignment(4);
        this.panelRemoveCard.add((Component)this.labelFrom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelFrom.setLayout(new BoxLayout(this.panelFrom, 0));
        this.textFieldFrom.setPreferredSize(new Dimension(96, 30));
        this.textFieldFrom.setMinimumSize(new Dimension(96, 30));
        this.textFieldFrom.setMaximumSize(new Dimension(96, 30));
        this.textFieldFrom.setText("1");
        this.textFieldFrom.setName("text1");
        this.textFieldFrom.addActionListener(e -> this.genericAction(e));
        this.textFieldFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.panelFrom.add(this.textFieldFrom);
        this.hSpacer6.setMinimumSize(new Dimension(10, 10));
        this.hSpacer6.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
        this.hSpacer6.setPreferredSize(new Dimension(217, 10));
        this.hSpacer6.setFocusable(false);
        this.panelFrom.add(this.hSpacer6);
        this.panelRemoveCard.add((Component)this.panelFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelLength.setText(this.context.cfg.gs("Renamer.labelLength.text"));
        this.labelLength.setHorizontalAlignment(4);
        this.panelRemoveCard.add((Component)this.labelLength, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelLength.setLayout(new BoxLayout(this.panelLength, 0));
        this.textFieldLength.setMinimumSize(new Dimension(96, 30));
        this.textFieldLength.setPreferredSize(new Dimension(96, 30));
        this.textFieldLength.setMaximumSize(new Dimension(96, 30));
        this.textFieldLength.setName("text2");
        this.textFieldLength.addActionListener(e -> this.genericAction(e));
        this.textFieldLength.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.panelLength.add(this.textFieldLength);
        this.panelRemoveCard.add((Component)this.panelLength, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelRemoveOther.setPreferredSize(new Dimension(98, 30));
        this.panelRemoveOther.setMinimumSize(new Dimension(98, 30));
        this.panelRemoveOther.setLayout(new GridLayout(1, 2, 8, 0));
        this.checkBoxRemoveFromEnd.setText(this.context.cfg.gs("Renamer.checkBoxRemoveFromEnd.text"));
        this.checkBoxRemoveFromEnd.setMargin(new Insets(2, 6, 2, 6));
        this.checkBoxRemoveFromEnd.setPreferredSize(new Dimension(98, 21));
        this.checkBoxRemoveFromEnd.setMinimumSize(new Dimension(98, 21));
        this.checkBoxRemoveFromEnd.setMaximumSize(new Dimension(98, 21));
        this.checkBoxRemoveFromEnd.setName("option1");
        this.checkBoxRemoveFromEnd.addActionListener(e -> this.genericAction(e));
        this.checkBoxRemoveFromEnd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.panelRemoveOther.add(this.checkBoxRemoveFromEnd);
        this.panelRemoveCard.add((Component)this.panelRemoveOther, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.panelOptionsCards.add((Component)this.panelRemoveCard, "cardRemove");
        this.panelReplaceCard.setMaximumSize(null);
        this.panelReplaceCard.setMinimumSize(new Dimension(328, 92));
        this.panelReplaceCard.setPreferredSize(new Dimension(328, 92));
        this.panelReplaceCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                RenamerUI.this.cardShown(e);
            }
        });
        this.panelReplaceCard.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelReplaceCard.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panelReplaceCard.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.labelFind.setText(this.context.cfg.gs("Renamer.labelFind.text"));
        this.labelFind.setHorizontalAlignment(4);
        this.panelReplaceCard.add((Component)this.labelFind, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.textFieldFind.setPreferredSize(new Dimension(320, 30));
        this.textFieldFind.setMinimumSize(new Dimension(50, 30));
        this.textFieldFind.setName("text1");
        this.textFieldFind.addActionListener(e -> this.genericAction(e));
        this.textFieldFind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldFind.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelReplaceCard.add((Component)this.textFieldFind, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labeReplace.setText(this.context.cfg.gs("Renamer.labelReplace.text"));
        this.labeReplace.setHorizontalAlignment(11);
        this.panelReplaceCard.add((Component)this.labeReplace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.textFieldReplace.setPreferredSize(new Dimension(320, 30));
        this.textFieldReplace.setMinimumSize(new Dimension(50, 30));
        this.textFieldReplace.setName("text2");
        this.textFieldReplace.addActionListener(e -> this.genericAction(e));
        this.textFieldReplace.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.textFieldReplace.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RenamerUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelReplaceCard.add((Component)this.textFieldReplace, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelReplaceOther.setPreferredSize(new Dimension(266, 30));
        this.panelReplaceOther.setMinimumSize(new Dimension(266, 30));
        this.panelReplaceOther.setLayout(new GridLayout(1, 0, 8, 0));
        this.checkBoxRegularExpr.setText(this.context.cfg.gs("Renamer.checkBoxRegularExpr.text"));
        this.checkBoxRegularExpr.setMargin(new Insets(2, 6, 2, 6));
        this.checkBoxRegularExpr.setName("option1");
        this.checkBoxRegularExpr.addActionListener(e -> this.genericAction(e));
        this.checkBoxRegularExpr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.panelReplaceOther.add(this.checkBoxRegularExpr);
        this.checkBoxCase.setText(this.context.cfg.gs("Renamer.checkBoxCase.text"));
        this.checkBoxCase.setMargin(new Insets(2, 6, 2, 2));
        this.checkBoxCase.setName("option2");
        this.checkBoxCase.addActionListener(e -> this.genericAction(e));
        this.checkBoxCase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RenamerUI.this.tabKeyPressed(e);
            }
        });
        this.panelReplaceOther.add(this.checkBoxCase);
        this.panelReplaceCard.add((Component)this.panelReplaceOther, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelOptionsCards.add((Component)this.panelReplaceCard, "cardReplace");
        this.panelCardBox.add(this.panelOptionsCards);
        this.topOptions.add((Component)this.panelCardBox, "South");
        this.panelControls.add((Component)this.topOptions, "North");
        this.panelOptions.add((Component)this.panelControls, "North");
        this.tableChanges.setSelectionMode(0);
        this.tableChanges.setRowSelectionAllowed(false);
        this.tableChanges.setFillsViewportHeight(true);
        this.tableChanges.setFocusable(false);
        this.tableChanges.setToolTipText(this.context.cfg.gs("Renamer.tableChanges.toolTipText"));
        this.tableChanges.setAutoResizeMode(4);
        this.tableChanges.setName("tableChanges");
        this.scrollPaneExamples.setViewportView(this.tableChanges);
        this.panelOptions.add((Component)this.scrollPaneExamples, "Center");
        this.panelOptionsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonRefresh.setText(this.context.cfg.gs("Z.refresh"));
        this.buttonRefresh.setFont(this.buttonRefresh.getFont().deriveFont((float)this.buttonRefresh.getFont().getSize() - 2.0f));
        this.buttonRefresh.setPreferredSize(new Dimension(78, 24));
        this.buttonRefresh.setMinimumSize(new Dimension(78, 24));
        this.buttonRefresh.setMaximumSize(new Dimension(78, 24));
        this.buttonRefresh.setMnemonic(this.context.cfg.gs("Renamer.buttonRefresh.mnemonic").charAt(0));
        this.buttonRefresh.setToolTipText(this.context.cfg.gs("Z.refresh.tooltip.text"));
        this.buttonRefresh.setMargin(new Insets(0, -10, 0, -10));
        this.buttonRefresh.addActionListener(e -> this.actionRefreshClicked(e));
        this.panelOptionsButtons.add(this.buttonRefresh);
        this.panelOptions.add((Component)this.panelOptionsButtons, "South");
        this.splitPaneContent.setRightComponent(this.panelOptions);
        this.contentPanel.add((Component)this.splitPaneContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 82, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.saveButton.setText(this.context.cfg.gs("Z.save"));
        this.saveButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.saveButton.setMnemonic(this.context.cfg.gs("Renamer.saveButton.mnemonic").charAt(0));
        this.saveButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("Z.cancel"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic(this.context.cfg.gs("Renamer.cancelButton.mnemonic_2").charAt(0));
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.buttonGroupChangeCase.add(this.radioButtonFirstUpperCase);
        this.buttonGroupChangeCase.add(this.radioButtonLowerCase);
        this.buttonGroupChangeCase.add(this.radioButtonTitleCase);
        this.buttonGroupChangeCase.add(this.radioButtonUpperCase);
    }
}

