/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.update;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.Navigator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadUpdater
extends JFrame {
    private Context context;
    private boolean fault = false;
    private String installedPath;
    private boolean launched = false;
    private transient Logger logger = LogManager.getLogger("applog");
    private String message;
    private Navigator navigator;
    private boolean mockMode;
    private String outPath;
    private String prefix;
    private boolean requestStop = false;
    private String updateArchive;
    private String updateFile;
    private String updaterJar;
    private URL url;
    private ArrayList<String> version = new ArrayList();
    private Worker worker;
    public JPanel panelTopSpacer;
    public JPanel panelBanner;
    public JLabel labelLogo;
    public JLabel labelVersion;
    public JPanel panelControls;
    public JPanel panelProgress;
    public JLabel labelStatus;
    public JProgressBar progressBar;
    public JPanel vSpacer1;
    public JButton buttonCancel;

    public DownloadUpdater(Context context, Navigator navigator, ArrayList<String> version, String prefix) {
        this.context = context;
        this.mockMode = context.main.mockMode;
        this.navigator = navigator;
        this.version = version;
        this.prefix = prefix;
        if (navigator != null) {
            this.initComponents();
        }
        this.process();
        this.logger.info("Download done");
    }

    private void actionCancel(ActionEvent e) {
        this.requestStop = true;
    }

    private void actionWindowClosed(WindowEvent e) {
        this.actionCancel(null);
    }

    private void process() {
        if (this.navigator != null) {
            this.setIconImage(new ImageIcon(this.getClass().getResource("/els-logo-48px.png")).getImage());
            int x = this.context.mainFrame.getX() + this.context.mainFrame.getWidth() / 2 - this.getWidth() / 2;
            int y = this.context.mainFrame.getY() + this.context.mainFrame.getHeight() / 2 - this.getHeight() / 2;
            this.setLocation(x, y);
            this.setVisible(true);
            this.buttonCancel.setSelected(false);
        }
        this.worker = new Worker();
        this.worker.execute();
        if (this.navigator == null) {
            try {
                while (!this.worker.isDone() || !this.launched) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                this.logger.info("THREAD INTERRUPTED");
            }
            System.exit(0);
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.corionis.els.locales.bundle");
        this.panelTopSpacer = new JPanel();
        this.panelBanner = new JPanel();
        this.labelLogo = new JLabel();
        this.labelVersion = new JLabel();
        this.panelControls = new JPanel();
        this.panelProgress = new JPanel();
        this.labelStatus = new JLabel();
        this.progressBar = new JProgressBar();
        this.vSpacer1 = new JPanel(null);
        this.buttonCancel = new JButton();
        this.setTitle(bundle.getString("Z.downloading"));
        this.setPreferredSize(new Dimension(400, 134));
        this.setMinimumSize(new Dimension(400, 134));
        this.setMaximumSize(new Dimension(400, 134));
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                DownloadUpdater.this.actionWindowClosed(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadUpdater.this.actionWindowClosed(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.panelTopSpacer.setPreferredSize(new Dimension(100, 8));
        this.panelTopSpacer.setMinimumSize(new Dimension(100, 8));
        this.panelTopSpacer.setMaximumSize(new Dimension(100, 8));
        this.panelTopSpacer.setLayout(new FlowLayout(1, 0, 0));
        contentPane.add((Component)this.panelTopSpacer, "North");
        this.panelBanner.setMaximumSize(new Dimension(376, 48));
        this.panelBanner.setMinimumSize(new Dimension(376, 48));
        this.panelBanner.setPreferredSize(new Dimension(376, 48));
        this.panelBanner.setLayout(new FlowLayout(1, 10, 0));
        this.labelLogo.setIcon(new ImageIcon(this.getClass().getResource("/els-logo-48px.png")));
        this.labelLogo.setPreferredSize(new Dimension(48, 48));
        this.labelLogo.setHorizontalAlignment(0);
        this.panelBanner.add(this.labelLogo);
        this.labelVersion.setText("Version 4.0.0-development");
        this.panelBanner.add(this.labelVersion);
        contentPane.add((Component)this.panelBanner, "Center");
        this.panelControls.setLayout(new FlowLayout(1, 0, 0));
        this.panelProgress.setMaximumSize(new Dimension(314, 36));
        this.panelProgress.setMinimumSize(new Dimension(314, 36));
        this.panelProgress.setPreferredSize(new Dimension(314, 36));
        this.panelProgress.setBorder(new EmptyBorder(0, 4, 4, 4));
        this.panelProgress.setLayout(new BorderLayout());
        this.labelStatus.setText("Status shown here");
        this.labelStatus.setHorizontalTextPosition(0);
        this.labelStatus.setHorizontalAlignment(2);
        this.labelStatus.setPreferredSize(new Dimension(314, 20));
        this.labelStatus.setMinimumSize(new Dimension(314, 20));
        this.labelStatus.setMaximumSize(new Dimension(314, 20));
        this.labelStatus.setVerticalAlignment(1);
        this.panelProgress.add((Component)this.labelStatus, "North");
        this.progressBar.setForeground(Color.lightGray);
        this.progressBar.setPreferredSize(new Dimension(314, 8));
        this.progressBar.setMinimumSize(new Dimension(314, 8));
        this.progressBar.setMaximumSize(new Dimension(314, 8));
        this.progressBar.setMaximum(1000);
        this.progressBar.setFocusable(false);
        this.progressBar.setAlignmentY(1.5f);
        this.panelProgress.add((Component)this.progressBar, "Center");
        this.vSpacer1.setPreferredSize(new Dimension(10, 3));
        this.vSpacer1.setMinimumSize(new Dimension(10, 3));
        this.vSpacer1.setMaximumSize(new Dimension(10, 3));
        this.panelProgress.add((Component)this.vSpacer1, "South");
        this.panelControls.add(this.panelProgress);
        this.buttonCancel.setText(bundle.getString("Z.cancel"));
        this.buttonCancel.setToolTipText(bundle.getString("Z.cancel.download"));
        this.buttonCancel.setMnemonic('L');
        this.buttonCancel.addActionListener(e -> this.actionCancel(e));
        this.panelControls.add(this.buttonCancel);
        contentPane.add((Component)this.panelControls, "South");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    class Worker
    extends SwingWorker<Void, Void> {
        Worker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (DownloadUpdater.this.navigator != null) {
                DownloadUpdater.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                DownloadUpdater.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                DownloadUpdater.this.progressBar.setMinimum(0);
            }
            DownloadUpdater.this.installedPath = DownloadUpdater.this.context.cfg.getInstalledPath();
            DownloadUpdater.this.outPath = Utils.getTempUpdaterDirectory();
            File out = new File(DownloadUpdater.this.outPath);
            if (out.exists()) {
                FileUtils.deleteDirectory(out);
            }
            out.mkdirs();
            DownloadUpdater.this.updaterJar = DownloadUpdater.this.outPath + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "ELS_Updater.jar";
            if (!DownloadUpdater.this.requestStop && this.download()) {
                Thread.sleep(2000L);
                if (!DownloadUpdater.this.requestStop && this.unpack()) {
                    if (!DownloadUpdater.this.requestStop) {
                        this.writeUpdaterInfo();
                        DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Navigator.download.and.unpack.of.els.updater.successful");
                        DownloadUpdater.this.logger.info(DownloadUpdater.this.message);
                        if (DownloadUpdater.this.navigator != null) {
                            DownloadUpdater.this.context.mainFrame.labelStatusMiddle.setText(DownloadUpdater.this.message);
                        } else {
                            System.out.println(DownloadUpdater.this.message);
                        }
                    } else {
                        DownloadUpdater.this.fault = true;
                    }
                } else {
                    DownloadUpdater.this.fault = true;
                }
            } else {
                DownloadUpdater.this.fault = true;
            }
            if (DownloadUpdater.this.fault) {
                DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Navigator.download.unpack.failed");
                DownloadUpdater.this.logger.info(DownloadUpdater.this.message);
                if (DownloadUpdater.this.navigator != null) {
                    DownloadUpdater.this.context.mainFrame.labelStatusMiddle.setText(DownloadUpdater.this.message);
                } else {
                    System.out.println(DownloadUpdater.this.message);
                }
            }
            return null;
        }

        @Override
        public void done() {
            if (DownloadUpdater.this.navigator != null && !DownloadUpdater.this.fault) {
                DownloadUpdater.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                DownloadUpdater.this.setVisible(false);
            }
            if (DownloadUpdater.this.requestStop) {
                DownloadUpdater.this.logger.warn(DownloadUpdater.this.context.cfg.gs("Navigator.els.update.process.cancelled"));
                if (DownloadUpdater.this.navigator != null) {
                    DownloadUpdater.this.context.mainFrame.labelStatusMiddle.setText(DownloadUpdater.this.context.cfg.gs("Navigator.els.update.process.cancelled"));
                }
            } else if (!DownloadUpdater.this.fault) {
                File els = new File(DownloadUpdater.this.updaterJar);
                if (!els.exists()) {
                    DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Navigator.cannot.find.executable") + DownloadUpdater.this.outPath;
                    if (DownloadUpdater.this.navigator != null) {
                        Object[] opts = new Object[]{DownloadUpdater.this.context.cfg.gs("Z.ok")};
                        JOptionPane.showOptionDialog(DownloadUpdater.this.context.mainFrame, DownloadUpdater.this.message, DownloadUpdater.this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                    } else {
                        System.out.println(DownloadUpdater.this.message);
                    }
                    return;
                }
                if (DownloadUpdater.this.navigator != null) {
                    DownloadUpdater.this.navigator.setUpdaterProcess(DownloadUpdater.this.updaterJar);
                    DownloadUpdater.this.navigator.stop();
                } else {
                    DownloadUpdater.this.context.main.execUpdater(DownloadUpdater.this.updaterJar, false);
                    DownloadUpdater.this.launched = true;
                }
            } else {
                DownloadUpdater.this.launched = true;
            }
        }

        private boolean download() {
            block22: {
                try {
                    if (DownloadUpdater.this.navigator != null) {
                        DownloadUpdater.this.labelVersion.setText(DownloadUpdater.this.version.get(0));
                    }
                    String ext = Utils.isOsWindows() ? ".zip" : (Utils.isOsMac() ? ".mac.tar.gz" : ".tar.gz");
                    DownloadUpdater.this.updateFile = DownloadUpdater.this.version.get(4) + ext;
                    DownloadUpdater.this.updateArchive = Utils.getTempUpdaterDirectory() + System.getProperty("file.separator") + DownloadUpdater.this.updateFile;
                    if (DownloadUpdater.this.navigator != null) {
                        DownloadUpdater.this.labelStatus.setText(DownloadUpdater.this.context.cfg.gs("Z.update") + DownloadUpdater.this.version.get(2));
                    }
                    if (!DownloadUpdater.this.mockMode) {
                        String downloadUrl = DownloadUpdater.this.prefix + "/" + DownloadUpdater.this.updateFile;
                        DownloadUpdater.this.url = new URL(downloadUrl);
                        URLConnection connection = DownloadUpdater.this.url.openConnection();
                        int contentLength = connection.getContentLength();
                        if (DownloadUpdater.this.navigator != null) {
                            DownloadUpdater.this.progressBar.setMaximum(contentLength);
                            DownloadUpdater.this.progressBar.setValue(0);
                        } else {
                            System.out.print(DownloadUpdater.this.context.cfg.gs("Navigator.install.downloading"));
                        }
                        InputStream raw = connection.getInputStream();
                        BufferedInputStream in = new BufferedInputStream(raw);
                        byte[] data = new byte[contentLength];
                        int count = 0;
                        int offset = 0;
                        int tickLast = 0;
                        int tickMax = contentLength / 43;
                        while (offset < contentLength && !DownloadUpdater.this.requestStop && (count = ((InputStream)in).read(data, offset, data.length - offset)) != -1) {
                            offset += count;
                            tickLast += count;
                            if (DownloadUpdater.this.navigator != null) {
                                DownloadUpdater.this.progressBar.setValue(offset);
                                continue;
                            }
                            if (tickLast < tickMax) continue;
                            System.out.print("#");
                            tickLast = 0;
                        }
                        ((InputStream)in).close();
                        if (DownloadUpdater.this.navigator == null) {
                            System.out.println();
                        }
                        if (!DownloadUpdater.this.requestStop) {
                            try {
                                FileOutputStream out = new FileOutputStream(DownloadUpdater.this.updateArchive);
                                out.write(data);
                                out.flush();
                                out.close();
                            }
                            catch (Exception e) {
                                DownloadUpdater.this.logger.error(Utils.getStackTrace(e));
                                DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Z.error.writing") + DownloadUpdater.this.updateArchive;
                                Object[] opts = new Object[]{DownloadUpdater.this.context.cfg.gs("Z.ok")};
                                if (DownloadUpdater.this.navigator != null) {
                                    DownloadUpdater.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                                    JOptionPane.showOptionDialog(DownloadUpdater.this.context.mainFrame, DownloadUpdater.this.message, DownloadUpdater.this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                                } else {
                                    System.out.println(DownloadUpdater.this.message);
                                }
                                return false;
                            }
                        }
                        if (DownloadUpdater.this.requestStop) {
                            File dl = new File(DownloadUpdater.this.updateArchive);
                            if (dl.exists()) {
                                dl.delete();
                            }
                            return false;
                        }
                        break block22;
                    }
                    File dl = new File(DownloadUpdater.this.updateArchive);
                    if (dl.exists()) break block22;
                    String copy = ".." + System.getProperty("file.separator") + "build" + System.getProperty("file.separator") + DownloadUpdater.this.updateFile;
                    File cp = new File(copy);
                    if (cp.exists()) {
                        if (DownloadUpdater.this.context.cfg.isInstallUpdate()) {
                            System.out.println(DownloadUpdater.this.context.cfg.gs("Updater.copying") + copy);
                        }
                        Files.copy(Paths.get(copy, new String[0]), Paths.get(DownloadUpdater.this.updateArchive, new String[0]), new CopyOption[0]);
                        break block22;
                    }
                    DownloadUpdater.this.message = MessageFormat.format(DownloadUpdater.this.context.cfg.gs("Navigator.update.not.found"), DownloadUpdater.this.updateArchive);
                    if (DownloadUpdater.this.navigator == null) {
                        System.out.println(DownloadUpdater.this.message);
                    }
                    return false;
                }
                catch (Exception e) {
                    DownloadUpdater.this.logger.error(Utils.getStackTrace(e));
                    DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Z.exception") + e.getCause().toString();
                    if (DownloadUpdater.this.navigator != null) {
                        DownloadUpdater.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                        Object[] opts = new Object[]{DownloadUpdater.this.context.cfg.gs("Z.ok")};
                        JOptionPane.showOptionDialog(DownloadUpdater.this.context.mainFrame, DownloadUpdater.this.message, DownloadUpdater.this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                    } else {
                        System.out.println(DownloadUpdater.this.message);
                    }
                    return false;
                }
            }
            return true;
        }

        private boolean removeDirectory(String directory) {
            try {
                File dir = new File(directory);
                if (dir.exists()) {
                    FileUtils.deleteDirectory(dir);
                }
            }
            catch (IOException e) {
                DownloadUpdater.this.logger.error(Utils.getStackTrace(e));
                DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Z.exception" + e.getMessage());
                Object[] opts = new Object[]{DownloadUpdater.this.context.cfg.gs("Z.ok")};
                JOptionPane.showOptionDialog(DownloadUpdater.this.context.mainFrame, DownloadUpdater.this.message, DownloadUpdater.this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                return false;
            }
            return true;
        }

        private boolean unpack() {
            boolean success = false;
            if (DownloadUpdater.this.navigator != null) {
                DownloadUpdater.this.setTitle(DownloadUpdater.this.context.cfg.gs("Navigator.unpacking"));
                DownloadUpdater.this.buttonCancel.setEnabled(false);
            }
            success = Utils.isOsWindows() ? this.unpackZip(DownloadUpdater.this.updateArchive, DownloadUpdater.this.outPath) : this.unpackTar(DownloadUpdater.this.updateArchive, DownloadUpdater.this.outPath);
            if (DownloadUpdater.this.navigator != null) {
                DownloadUpdater.this.buttonCancel.setEnabled(true);
            }
            return success;
        }

        private boolean unpackTar(String from, String to) {
            try {
                Path path = Paths.get(from, new String[0]);
                Path outPath = Paths.get(to, new String[0]);
                long size = Files.size(path);
                if (DownloadUpdater.this.navigator != null) {
                    DownloadUpdater.this.progressBar.setMaximum((int)size);
                    DownloadUpdater.this.progressBar.setValue(0);
                } else {
                    System.out.print(DownloadUpdater.this.context.cfg.gs("Navigator.install.unpacking"));
                }
                GzipCompressorInputStream gin = new GzipCompressorInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
                TarArchiveInputStream in = new TarArchiveInputStream(gin);
                TarArchiveEntry entry = null;
                long ticklast = 0L;
                long tickMax = size / 42L;
                while ((entry = in.getNextTarEntry()) != null) {
                    String name;
                    long bread;
                    long gread = gin.getBytesRead();
                    if (gread != (bread = in.getBytesRead())) {
                        DownloadUpdater.this.message = "Bytes read: " + gread + " and bytes decompressed: " + bread + " do not match, archive corrupted";
                        DownloadUpdater.this.logger.fatal(DownloadUpdater.this.message);
                        System.out.println(DownloadUpdater.this.message);
                        System.exit(1);
                    }
                    if ((name = entry.getName()).length() == 0) continue;
                    if (name.startsWith("ELS_Updater")) {
                        if (name.equals("ELS_Updater/")) continue;
                        name = name.substring(12, name.length());
                    }
                    Path entryPath = outPath.resolve(name);
                    DownloadUpdater.this.logger.info("  " + entryPath.toString());
                    if (entry.isDirectory()) {
                        if (!Files.exists(entryPath, new LinkOption[0])) {
                            Files.createDirectories(entryPath, new FileAttribute[0]);
                        }
                        Files.setLastModifiedTime(entryPath, entry.getLastModifiedTime());
                        continue;
                    }
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Files.copy(in, entryPath, StandardCopyOption.REPLACE_EXISTING);
                    Files.setLastModifiedTime(entryPath, entry.getLastModifiedTime());
                    int mode = entry.getMode();
                    Set<PosixFilePermission> perms = Utils.translateModeToPosix(mode);
                    Files.setPosixFilePermissions(entryPath, perms);
                    if (DownloadUpdater.this.navigator != null) {
                        DownloadUpdater.this.progressBar.setValue((int)gread);
                        continue;
                    }
                    if (gread - ticklast <= tickMax) continue;
                    System.out.print("#");
                    ticklast = gread;
                }
                in.close();
                if (DownloadUpdater.this.navigator == null) {
                    System.out.println();
                }
                return true;
            }
            catch (Exception e) {
                DownloadUpdater.this.logger.error(Utils.getStackTrace(e));
                return false;
            }
        }

        private boolean unpackZip(String from, String to) {
            try {
                Path path = Paths.get(from, new String[0]);
                Path outPath = Paths.get(to, new String[0]);
                long size = Files.size(path);
                if (DownloadUpdater.this.navigator != null) {
                    DownloadUpdater.this.progressBar.setMaximum((int)size);
                    DownloadUpdater.this.progressBar.setValue(0);
                } else {
                    System.out.print(DownloadUpdater.this.context.cfg.gs("Navigator.install.unpacking"));
                }
                ZipArchiveInputStream in = new ZipArchiveInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
                ZipArchiveEntry entry = null;
                long zcount = 0L;
                long ticklast = 0L;
                long tickMax = size / 42L;
                while ((entry = in.getNextZipEntry()) != null) {
                    zcount = in.getBytesRead();
                    String name = entry.getName();
                    if (name.length() == 0) continue;
                    if (name.startsWith("ELS_Updater")) {
                        if (name.equals("ELS_Updater/")) continue;
                        name = name.substring(12, name.length());
                    }
                    Path entryPath = outPath.resolve(name);
                    DownloadUpdater.this.logger.info("  " + entryPath.toString());
                    if (entry.isDirectory()) {
                        if (!Files.exists(entryPath, new LinkOption[0])) {
                            Files.createDirectories(entryPath, new FileAttribute[0]);
                        }
                        Files.setLastModifiedTime(entryPath, entry.getLastModifiedTime());
                        continue;
                    }
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Files.copy(in, entryPath, StandardCopyOption.REPLACE_EXISTING);
                    Files.setLastModifiedTime(entryPath, entry.getLastModifiedTime());
                    if (DownloadUpdater.this.navigator != null) {
                        DownloadUpdater.this.progressBar.setValue((int)zcount);
                        continue;
                    }
                    if (zcount - ticklast <= tickMax) continue;
                    System.out.print("#");
                    ticklast = zcount;
                }
                in.close();
                if (DownloadUpdater.this.navigator == null) {
                    System.out.println();
                }
                return true;
            }
            catch (Exception e) {
                DownloadUpdater.this.logger.error(Utils.getStackTrace(e));
                return false;
            }
        }

        private boolean writeUpdaterInfo() {
            try {
                String infoPath = Utils.getTempUpdaterDirectory() + System.getProperty("file.separator") + "ELS_Updater.info";
                String consoleLevel = DownloadUpdater.this.context.cfg.getConsoleLevel();
                String debugLevel = DownloadUpdater.this.context.cfg.getDebugLevel();
                boolean overwriteLog = DownloadUpdater.this.context.cfg.isLogOverwrite();
                String log = DownloadUpdater.this.context.cfg.getLogFileFullPath();
                String restartCommand = DownloadUpdater.this.context.cfg.generateCommandLine(consoleLevel, debugLevel, overwriteLog, log);
                FileWriter writer = new FileWriter(infoPath, false);
                writer.write(DownloadUpdater.this.installedPath + System.getProperty("line.separator"));
                writer.write(DownloadUpdater.this.context.cfg.getWorkingDirectory() + System.getProperty("line.separator"));
                writer.write(restartCommand + System.getProperty("line.separator"));
                writer.close();
            }
            catch (Exception e) {
                DownloadUpdater.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                DownloadUpdater.this.logger.error(Utils.getStackTrace(e));
                DownloadUpdater.this.message = DownloadUpdater.this.context.cfg.gs("Z.error.writing") + DownloadUpdater.this.updateArchive;
                Object[] opts = new Object[]{DownloadUpdater.this.context.cfg.gs("Z.ok")};
                JOptionPane.showOptionDialog(DownloadUpdater.this.context.mainFrame, DownloadUpdater.this.message, DownloadUpdater.this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                return false;
            }
            return true;
        }
    }
}

